/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui;

import com.compomics.util.parameters.peptide_shaker.ProjectType;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.export.MzIdentMLExportDialog;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class SaveDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private JPanel backgroundPanel;
    private JButton exportJButton;
    private JButton exportPrideJButton;
    private JLabel exportPrideLabel;
    private JLabel exportZipLabel;
    private JButton saveJButton;
    private JLabel saveLabel;

    public SaveDialog(PeptideShakerGUI peptideShakerGUI, boolean modal) {
        super((Frame)peptideShakerGUI, modal);
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        if (peptideShakerGUI.getProjectType() != ProjectType.protein) {
            this.exportPrideJButton.setEnabled(false);
            this.exportPrideLabel.setEnabled(false);
            this.exportPrideJButton.setToolTipText("Not available for your PeptideShaker project type");
        }
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.saveJButton = new JButton();
        this.exportJButton = new JButton();
        this.exportPrideJButton = new JButton();
        this.saveLabel = new JLabel();
        this.exportZipLabel = new JLabel();
        this.exportPrideLabel = new JLabel();
        this.setTitle("Save & Export");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.saveJButton.setFont(this.saveJButton.getFont().deriveFont(this.saveJButton.getFont().getStyle() | 1, this.saveJButton.getFont().getSize() + 3));
        this.saveJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/save_as.png")));
        this.saveJButton.setText("Save Project");
        this.saveJButton.setToolTipText("Save the PeptideShaker project locally.");
        this.saveJButton.setFocusPainted(false);
        this.saveJButton.setHorizontalAlignment(2);
        this.saveJButton.setIconTextGap(27);
        this.saveJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveDialog.this.saveJButtonActionPerformed(evt);
            }
        });
        this.exportJButton.setFont(this.exportJButton.getFont().deriveFont(this.exportJButton.getFont().getStyle() | 1, this.exportJButton.getFont().getSize() + 3));
        this.exportJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export.png")));
        this.exportJButton.setText("Export Project");
        this.exportJButton.setToolTipText("<html>\nExport the PeptideShaker project as a<br>\nzip file to open on another computer.\n</html>");
        this.exportJButton.setFocusPainted(false);
        this.exportJButton.setHorizontalAlignment(2);
        this.exportJButton.setIconTextGap(27);
        this.exportJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveDialog.this.exportJButtonActionPerformed(evt);
            }
        });
        this.exportPrideJButton.setFont(this.exportPrideJButton.getFont().deriveFont(this.exportPrideJButton.getFont().getStyle() | 1, this.exportPrideJButton.getFont().getSize() + 3));
        this.exportPrideJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_pride.png")));
        this.exportPrideJButton.setText("Export to PRIDE");
        this.exportPrideJButton.setToolTipText("Export the PeptideShaker project as mzIdentML.");
        this.exportPrideJButton.setFocusPainted(false);
        this.exportPrideJButton.setHorizontalAlignment(2);
        this.exportPrideJButton.setIconTextGap(25);
        this.exportPrideJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveDialog.this.exportPrideJButtonActionPerformed(evt);
            }
        });
        this.saveLabel.setFont(this.saveLabel.getFont().deriveFont(this.saveLabel.getFont().getStyle() | 2 | 1, this.saveLabel.getFont().getSize() + 1));
        this.saveLabel.setText("Save the project locally");
        this.exportZipLabel.setFont(this.exportZipLabel.getFont().deriveFont(this.exportZipLabel.getFont().getStyle() | 2 | 1, this.exportZipLabel.getFont().getSize() + 1));
        this.exportZipLabel.setText("Export the project as a zip file");
        this.exportPrideLabel.setFont(this.exportPrideLabel.getFont().deriveFont(this.exportPrideLabel.getFont().getStyle() | 2 | 1, this.exportPrideLabel.getFont().getSize() + 1));
        this.exportPrideLabel.setText("Export the project as mzIdentML");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(45, 45, 45).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.saveJButton, -1, -1, Short.MAX_VALUE).addComponent(this.exportJButton, -1, -1, Short.MAX_VALUE).addComponent(this.exportPrideJButton, -1, 323, Short.MAX_VALUE)).addGap(45, 45, 45).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.saveLabel, -2, 166, -2).addComponent(this.exportZipLabel, -2, 203, -2).addComponent(this.exportPrideLabel, -2, 220, -2)).addContainerGap(45, Short.MAX_VALUE)));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveJButton, -2, 75, -2).addComponent(this.saveLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportJButton, -2, 75, -2).addComponent(this.exportZipLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportPrideJButton).addComponent(this.exportPrideLabel)).addGap(25, 25, 25)));
        backgroundPanelLayout.linkSize(1, this.exportJButton, this.exportPrideJButton, this.saveJButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void exportJButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.peptideShakerGUI.exportProjectAsZip();
    }

    private void exportPrideJButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        new MzIdentMLExportDialog(this.peptideShakerGUI, true);
    }

    private void saveJButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.peptideShakerGUI.saveProjectAs(false, false);
        this.dispose();
    }
}

