/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.export;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.gui.utils.user_choice.list_choosers.ModificationChooser;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.export.UnipeptExport;
import eu.isas.peptideshaker.followup.FastaExport;
import eu.isas.peptideshaker.followup.InclusionListExport;
import eu.isas.peptideshaker.followup.PepXmlExport;
import eu.isas.peptideshaker.followup.ProgenesisExport;
import eu.isas.peptideshaker.followup.ProteoformExport;
import eu.isas.peptideshaker.followup.RecalibrationExporter;
import eu.isas.peptideshaker.followup.SpectrumExporter;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.export.InclusionListExportDialog;
import eu.isas.peptideshaker.gui.export.MzIdentMLExportDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;

public class FollowUpExportDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private static ProgressDialogX progressDialog;
    private JPanel backgroundPanel;
    private JLabel exportAllIdentifiedProteinAccessionsLabel;
    private JLabel exportAllIdentifiedProteinsAsFastaLabel;
    private JButton exportIdentifiedProteinAccessionNumbersAsCsvButton;
    private JButton exportIdentifiedProteinsAsFastaButton;
    private JButton exportMgfButton;
    private JButton exportProgenesisButton;
    private JButton exportProteformsAsTxtButton;
    private JLabel exportSpectraLabel;
    private JLabel exportToProgenesisLinkLabel;
    private JComboBox graphDatabaseFormat;
    private JLabel graphDatabasesLabel;
    private JPanel graphDatabasesPanel;
    private JButton graphDatabasetButton;
    private JLabel includeValidatedPsmsLabel;
    private JButton inclusionListButton;
    private JComboBox inclusionListFormat;
    private JPanel inclusionListPanel;
    private JPanel progenesisPanel;
    private JComboBox proteinExportCmb1;
    private JComboBox proteinExportCmb2;
    private JPanel proteinsPanel;
    private JComboBox proteoformsExportCmb;
    private JLabel proteoformsLabel;
    private JComboBox psmSelectionComboBox;
    private JButton recalibrateMgfButton;
    private JLabel recalibrateSpectraLabel;
    private JScrollPane scrollPane;
    private JPanel scrollPanel;
    private JButton skylineExportButton;
    private JComboBox skylineExportCmb;
    private JLabel skylineExportLabel;
    private JPanel skylinePanel;
    private JPanel spectraPanel;
    private JComboBox spectrumRecalibrationCmb;
    private JComboBox spectrumValidationCmb;
    private JButton tppExportButton;
    private JComboBox tppExportCmb;
    private JLabel tppLabel;
    private JPanel tppPanel;
    private JButton unipeptExportButton;
    private JLabel unipeptLabel;
    private JPanel unipeptPanel;
    private JComboBox unipeptiExportCmb;

    public FollowUpExportDialog(PeptideShakerGUI peptideShakerGUI) {
        super((Frame)peptideShakerGUI, true);
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.spectrumRecalibrationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.spectrumValidationCmb.setRenderer(new AlignedListCellRenderer(0));
        this.inclusionListFormat.setRenderer(new AlignedListCellRenderer(0));
        this.proteinExportCmb1.setRenderer(new AlignedListCellRenderer(0));
        this.proteinExportCmb2.setRenderer(new AlignedListCellRenderer(0));
        this.psmSelectionComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.graphDatabaseFormat.setRenderer(new AlignedListCellRenderer(0));
        this.skylineExportCmb.setRenderer(new AlignedListCellRenderer(0));
        this.tppExportCmb.setRenderer(new AlignedListCellRenderer(0));
        this.proteoformsExportCmb.setRenderer(new AlignedListCellRenderer(0));
        this.unipeptiExportCmb.setRenderer(new AlignedListCellRenderer(0));
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPanel = new JPanel();
        this.tppPanel = new JPanel();
        this.tppExportButton = new JButton();
        this.tppExportCmb = new JComboBox();
        this.tppLabel = new JLabel();
        this.progenesisPanel = new JPanel();
        this.exportProgenesisButton = new JButton();
        this.psmSelectionComboBox = new JComboBox();
        this.exportToProgenesisLinkLabel = new JLabel();
        this.proteinsPanel = new JPanel();
        this.exportAllIdentifiedProteinsAsFastaLabel = new JLabel();
        this.exportIdentifiedProteinsAsFastaButton = new JButton();
        this.exportAllIdentifiedProteinAccessionsLabel = new JLabel();
        this.exportIdentifiedProteinAccessionNumbersAsCsvButton = new JButton();
        this.proteinExportCmb1 = new JComboBox();
        this.proteinExportCmb2 = new JComboBox();
        this.proteoformsLabel = new JLabel();
        this.proteoformsExportCmb = new JComboBox();
        this.exportProteformsAsTxtButton = new JButton();
        this.inclusionListPanel = new JPanel();
        this.includeValidatedPsmsLabel = new JLabel();
        this.inclusionListFormat = new JComboBox();
        this.inclusionListButton = new JButton();
        this.graphDatabasesPanel = new JPanel();
        this.graphDatabasesLabel = new JLabel();
        this.graphDatabaseFormat = new JComboBox();
        this.graphDatabasetButton = new JButton();
        this.spectraPanel = new JPanel();
        this.exportSpectraLabel = new JLabel();
        this.spectrumValidationCmb = new JComboBox();
        this.exportMgfButton = new JButton();
        this.recalibrateSpectraLabel = new JLabel();
        this.spectrumRecalibrationCmb = new JComboBox();
        this.recalibrateMgfButton = new JButton();
        this.skylinePanel = new JPanel();
        this.skylineExportButton = new JButton();
        this.skylineExportCmb = new JComboBox();
        this.skylineExportLabel = new JLabel();
        this.unipeptPanel = new JPanel();
        this.unipeptExportButton = new JButton();
        this.unipeptiExportCmb = new JComboBox();
        this.unipeptLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export - Follow Up Analysis");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.tppPanel.setBorder(BorderFactory.createTitledBorder("TPP Export (beta)"));
        this.tppPanel.setOpaque(false);
        this.tppExportButton.setText("Export as pepXML");
        this.tppExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.tppExportButtonActionPerformed(evt);
            }
        });
        this.tppExportCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"(no filters yet supported)"}));
        this.tppExportCmb.setEnabled(false);
        this.tppLabel.setText("pepXML Format");
        this.tppLabel.setToolTipText("Click for Progenesis LC-MS export help");
        GroupLayout tppPanelLayout = new GroupLayout(this.tppPanel);
        this.tppPanel.setLayout(tppPanelLayout);
        tppPanelLayout.setHorizontalGroup(tppPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tppPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tppLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tppExportCmb, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.tppExportButton, -2, 180, -2).addContainerGap()));
        tppPanelLayout.setVerticalGroup(tppPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tppPanelLayout.createSequentialGroup().addContainerGap().addGroup(tppPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tppExportCmb, -2, -1, -2).addComponent(this.tppExportButton).addComponent(this.tppLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.progenesisPanel.setBorder(BorderFactory.createTitledBorder("Label Free Quantification"));
        this.progenesisPanel.setOpaque(false);
        this.exportProgenesisButton.setText("Export TXT");
        this.exportProgenesisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.exportProgenesisButtonActionPerformed(evt);
            }
        });
        this.psmSelectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Validated PSMs of Validated Peptides of Validated Proteins", "Validated PSMs of Validated Peptides", "Validated PSMs", "Validated PSMs Containing Confidently Localized PTMs"}));
        this.exportToProgenesisLinkLabel.setText("<html><a href=\\\"http://www.nonlinear.com/products/progenesis/lc-ms/overview/\\\">Progenesis LC-MS</a></html>");
        this.exportToProgenesisLinkLabel.setToolTipText("Click for Progenesis LC-MS export help");
        this.exportToProgenesisLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FollowUpExportDialog.this.exportToProgenesisLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                FollowUpExportDialog.this.exportToProgenesisLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                FollowUpExportDialog.this.exportToProgenesisLinkLabelMouseExited(evt);
            }
        });
        GroupLayout progenesisPanelLayout = new GroupLayout(this.progenesisPanel);
        this.progenesisPanel.setLayout(progenesisPanelLayout);
        progenesisPanelLayout.setHorizontalGroup(progenesisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, progenesisPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.exportToProgenesisLinkLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psmSelectionComboBox, 0, 434, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.exportProgenesisButton, -2, 180, -2).addContainerGap()));
        progenesisPanelLayout.setVerticalGroup(progenesisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(progenesisPanelLayout.createSequentialGroup().addContainerGap().addGroup(progenesisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psmSelectionComboBox, -2, -1, -2).addComponent(this.exportProgenesisButton).addComponent(this.exportToProgenesisLinkLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.proteinsPanel.setBorder(BorderFactory.createTitledBorder("Proteins"));
        this.proteinsPanel.setOpaque(false);
        this.exportAllIdentifiedProteinsAsFastaLabel.setText("Export Sequences");
        this.exportIdentifiedProteinsAsFastaButton.setText("Export as FASTA");
        this.exportIdentifiedProteinsAsFastaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.exportIdentifiedProteinsAsFastaButtonActionPerformed(evt);
            }
        });
        this.exportAllIdentifiedProteinAccessionsLabel.setText("Export Accession Numbers");
        this.exportIdentifiedProteinAccessionNumbersAsCsvButton.setText("Export as TXT");
        this.exportIdentifiedProteinAccessionNumbersAsCsvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.exportIdentifiedProteinAccessionNumbersAsCsvButtonActionPerformed(evt);
            }
        });
        this.proteinExportCmb1.setModel(new DefaultComboBoxModel<String>(FastaExport.ExportType.getPossibilities()));
        this.proteinExportCmb2.setModel(new DefaultComboBoxModel<String>(FastaExport.ExportType.getPossibilities()));
        this.proteoformsLabel.setText("Proteoforms");
        this.proteoformsExportCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"(no filters yet supported)"}));
        this.proteoformsExportCmb.setEnabled(false);
        this.exportProteformsAsTxtButton.setText("Export as TXT");
        this.exportProteformsAsTxtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.exportProteformsAsTxtButtonActionPerformed(evt);
            }
        });
        GroupLayout proteinsPanelLayout = new GroupLayout(this.proteinsPanel);
        this.proteinsPanel.setLayout(proteinsPanelLayout);
        proteinsPanelLayout.setHorizontalGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinsPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinsPanelLayout.createSequentialGroup().addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.exportAllIdentifiedProteinAccessionsLabel, -2, 160, -2).addComponent(this.exportAllIdentifiedProteinsAsFastaLabel, -2, 160, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinExportCmb2, 0, -1, Short.MAX_VALUE).addComponent(this.proteinExportCmb1, 0, -1, Short.MAX_VALUE))).addGroup(proteinsPanelLayout.createSequentialGroup().addComponent(this.proteoformsLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteoformsExportCmb, 0, -1, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.exportProteformsAsTxtButton, -1, -1, Short.MAX_VALUE).addComponent(this.exportIdentifiedProteinAccessionNumbersAsCsvButton, -1, -1, Short.MAX_VALUE).addComponent(this.exportIdentifiedProteinsAsFastaButton, -1, 180, Short.MAX_VALUE)).addContainerGap()));
        proteinsPanelLayout.setVerticalGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinsPanelLayout.createSequentialGroup().addContainerGap().addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportAllIdentifiedProteinAccessionsLabel).addComponent(this.exportIdentifiedProteinAccessionNumbersAsCsvButton).addComponent(this.proteinExportCmb1, -2, -1, -2)).addGap(0, 0, 0).addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportAllIdentifiedProteinsAsFastaLabel).addComponent(this.exportIdentifiedProteinsAsFastaButton).addComponent(this.proteinExportCmb2, -2, -1, -2)).addGap(0, 0, 0).addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteoformsLabel).addComponent(this.exportProteformsAsTxtButton).addComponent(this.proteoformsExportCmb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.inclusionListPanel.setBorder(BorderFactory.createTitledBorder("Inclusion/Exclusion List (beta)"));
        this.inclusionListPanel.setOpaque(false);
        this.includeValidatedPsmsLabel.setText("Instrument Format");
        this.inclusionListFormat.setModel(new DefaultComboBoxModel<String>(InclusionListExport.ExportFormat.getPossibilities()));
        this.inclusionListButton.setText("Export as List");
        this.inclusionListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.inclusionListButtonActionPerformed(evt);
            }
        });
        GroupLayout inclusionListPanelLayout = new GroupLayout(this.inclusionListPanel);
        this.inclusionListPanel.setLayout(inclusionListPanelLayout);
        inclusionListPanelLayout.setHorizontalGroup(inclusionListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inclusionListPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.includeValidatedPsmsLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inclusionListFormat, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.inclusionListButton, -2, 180, -2).addContainerGap()));
        inclusionListPanelLayout.setVerticalGroup(inclusionListPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inclusionListPanelLayout.createSequentialGroup().addContainerGap().addGroup(inclusionListPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inclusionListFormat, -2, -1, -2).addComponent(this.includeValidatedPsmsLabel).addComponent(this.inclusionListButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.graphDatabasesPanel.setBorder(BorderFactory.createTitledBorder("Graph Databases"));
        this.graphDatabasesPanel.setOpaque(false);
        this.graphDatabasesLabel.setText("Database Format");
        this.graphDatabaseFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"Cytoscape", "Gephi", "Neo4j"}));
        this.graphDatabasetButton.setText("Export Database");
        this.graphDatabasetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.graphDatabasetButtonActionPerformed(evt);
            }
        });
        GroupLayout graphDatabasesPanelLayout = new GroupLayout(this.graphDatabasesPanel);
        this.graphDatabasesPanel.setLayout(graphDatabasesPanelLayout);
        graphDatabasesPanelLayout.setHorizontalGroup(graphDatabasesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(graphDatabasesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.graphDatabasesLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphDatabaseFormat, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.graphDatabasetButton, -2, 180, -2).addContainerGap()));
        graphDatabasesPanelLayout.setVerticalGroup(graphDatabasesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(graphDatabasesPanelLayout.createSequentialGroup().addContainerGap().addGroup(graphDatabasesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.graphDatabaseFormat, -2, -1, -2).addComponent(this.graphDatabasesLabel).addComponent(this.graphDatabasetButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.spectraPanel.setBorder(BorderFactory.createTitledBorder("Spectra"));
        this.spectraPanel.setOpaque(false);
        this.exportSpectraLabel.setText("Export Spectra");
        this.spectrumValidationCmb.setModel(new DefaultComboBoxModel<String>(SpectrumExporter.ExportType.getPossibilities()));
        this.exportMgfButton.setText("Export as MGF");
        this.exportMgfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.exportMgfButtonActionPerformed(evt);
            }
        });
        this.recalibrateSpectraLabel.setText("Recalibrate Spectra (beta)");
        this.spectrumRecalibrationCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Precursor and Fragment Ions", "Precursor Ions", "Fragment Ions"}));
        this.recalibrateMgfButton.setText("Export as MGF");
        this.recalibrateMgfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.recalibrateMgfButtonActionPerformed(evt);
            }
        });
        GroupLayout spectraPanelLayout = new GroupLayout(this.spectraPanel);
        this.spectraPanel.setLayout(spectraPanelLayout);
        spectraPanelLayout.setHorizontalGroup(spectraPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectraPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectraPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectraPanelLayout.createSequentialGroup().addComponent(this.exportSpectraLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spectrumValidationCmb, 0, -1, Short.MAX_VALUE)).addGroup(spectraPanelLayout.createSequentialGroup().addComponent(this.recalibrateSpectraLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spectrumRecalibrationCmb, 0, -1, Short.MAX_VALUE))).addGroup(spectraPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectraPanelLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.recalibrateMgfButton, -2, 180, -2)).addGroup(GroupLayout.Alignment.TRAILING, spectraPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exportMgfButton, -2, 180, -2))).addContainerGap()));
        spectraPanelLayout.setVerticalGroup(spectraPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectraPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectraPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportSpectraLabel).addComponent(this.spectrumValidationCmb, -2, -1, -2).addComponent(this.exportMgfButton)).addGap(0, 0, 0).addGroup(spectraPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.recalibrateSpectraLabel).addComponent(this.spectrumRecalibrationCmb, -2, -1, -2).addComponent(this.recalibrateMgfButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.skylinePanel.setBorder(BorderFactory.createTitledBorder("Skyline Export (beta)"));
        this.skylinePanel.setOpaque(false);
        this.skylineExportButton.setText("Export as mzid");
        this.skylineExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.skylineExportButtonActionPerformed(evt);
            }
        });
        this.skylineExportCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"(no filters yet supported)"}));
        this.skylineExportCmb.setEnabled(false);
        this.skylineExportLabel.setText("mzIdentML Format");
        this.skylineExportLabel.setToolTipText("Click for Progenesis LC-MS export help");
        GroupLayout skylinePanelLayout = new GroupLayout(this.skylinePanel);
        this.skylinePanel.setLayout(skylinePanelLayout);
        skylinePanelLayout.setHorizontalGroup(skylinePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, skylinePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.skylineExportLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skylineExportCmb, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.skylineExportButton, -2, 180, -2).addContainerGap()));
        skylinePanelLayout.setVerticalGroup(skylinePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(skylinePanelLayout.createSequentialGroup().addContainerGap().addGroup(skylinePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.skylineExportCmb, -2, -1, -2).addComponent(this.skylineExportButton).addComponent(this.skylineExportLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.unipeptPanel.setBorder(BorderFactory.createTitledBorder("Unipept Export"));
        this.unipeptPanel.setOpaque(false);
        this.unipeptExportButton.setText("Export to Unipept");
        this.unipeptExportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FollowUpExportDialog.this.unipeptExportButtonActionPerformed(evt);
            }
        });
        this.unipeptiExportCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Validated Peptides", "All Peptides", "Validated PSMs", "All PSMs"}));
        this.unipeptLabel.setText("Peptide Sequences");
        GroupLayout unipeptPanelLayout = new GroupLayout(this.unipeptPanel);
        this.unipeptPanel.setLayout(unipeptPanelLayout);
        unipeptPanelLayout.setHorizontalGroup(unipeptPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, unipeptPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.unipeptLabel, -2, 160, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unipeptiExportCmb, 0, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.unipeptExportButton, -2, 180, -2).addContainerGap()));
        unipeptPanelLayout.setVerticalGroup(unipeptPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(unipeptPanelLayout.createSequentialGroup().addContainerGap().addGroup(unipeptPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.unipeptiExportCmb, -2, -1, -2).addComponent(this.unipeptExportButton).addComponent(this.unipeptLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout scrollPanelLayout = new GroupLayout(this.scrollPanel);
        this.scrollPanel.setLayout(scrollPanelLayout);
        scrollPanelLayout.setHorizontalGroup(scrollPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scrollPanelLayout.createSequentialGroup().addContainerGap().addGroup(scrollPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.unipeptPanel, -1, -1, Short.MAX_VALUE).addComponent(this.tppPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.skylinePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.inclusionListPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.graphDatabasesPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.progenesisPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.proteinsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.spectraPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        scrollPanelLayout.setVerticalGroup(scrollPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scrollPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectraPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.proteinsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progenesisPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.graphDatabasesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inclusionListPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.skylinePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tppPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unipeptPanel, -2, -1, -2).addContainerGap()));
        this.scrollPane.setViewportView(this.scrollPanel);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.scrollPane).addGap(0, 0, 0)));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void tppExportButtonActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "PepXML does not allow the storage of all PeptideShaker results and should thus be used carefully." + System.getProperty("line.separator") + "For third party tools we recommend using mzIdentML, the standard format of proteomics identification results.", "Warning", 2);
        final File finalOutputFile = this.peptideShakerGUI.getUserSelectedFile("tpp_psm_export.pep.xml", ".pep.xml", "PepXML (*.pep.xml)", "Select Destination File", false);
        if (finalOutputFile != null) {
            progressDialog = new ProgressDialogX(this, this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting PepXML. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("PepXmlThread"){

                @Override
                public void run() {
                    try {
                        PepXmlExport pepXmlExport = new PepXmlExport();
                        pepXmlExport.writePepXmlFile(FollowUpExportDialog.this.peptideShakerGUI.getIdentification(), FollowUpExportDialog.this.peptideShakerGUI.getIdentificationParameters(), FollowUpExportDialog.this.peptideShakerGUI.getSpectrumProvider(), finalOutputFile, PeptideShaker.getVersion(), progressDialog, FollowUpExportDialog.this.peptideShakerGUI.getExceptionHandler());
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "Results exported to '" + finalOutputFile.getName() + "'.", "Export Complete", 1);
                        }
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        FollowUpExportDialog.this.peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }

    private void skylineExportButtonActionPerformed(ActionEvent evt) {
        this.skylineExport();
    }

    private void graphDatabasetButtonActionPerformed(ActionEvent evt) {
        final File selectedFolder = FileChooserUtil.getUserSelectedFolder(this, "Select Result Folder", this.getLastSelectedFolder(), "Database Folder", "Save", false);
        if (selectedFolder != null) {
            this.setLastSelectedFolder(selectedFolder.getAbsolutePath());
            progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ExportThread"){

                @Override
                public void run() {
                    boolean exported = false;
                    HashSet<Long> proteinsAdded = new HashSet<Long>();
                    try (SimpleFileWriter nodeWriter = new SimpleFileWriter(new File(selectedFolder, "nodes.txt"), false);
                         SimpleFileWriter edgeWriter = new SimpleFileWriter(new File(selectedFolder, "edges.txt"), false);){
                        PeptideMatch peptideMatch;
                        if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Cytoscape")) {
                            nodeWriter.writeLine("id\tlabel\ttype\tvalidated\tdecoy");
                            edgeWriter.writeLine("source\ttarget\tinteraction");
                        } else if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Gephi")) {
                            nodeWriter.writeLine("id\tlabel\ttype\tvalidated\tdecoy");
                            edgeWriter.writeLine("source\ttarget\tlabel");
                        } else if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                            nodeWriter.writeLine("BEGIN");
                            edgeWriter.writeLine("BEGIN");
                        }
                        progressDialog.setTitle("Writing Peptide Details. Please Wait...");
                        progressDialog.resetPrimaryProgressCounter();
                        progressDialog.setMaxPrimaryProgressCounter(FollowUpExportDialog.this.peptideShakerGUI.getIdentification().getPeptideIdentification().size());
                        PeptideMatchesIterator peptideMatchesIterator = FollowUpExportDialog.this.peptideShakerGUI.getIdentification().getPeptideMatchesIterator(progressDialog);
                        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
                            long peptideKey = peptideMatch.getKey();
                            PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                            IdentificationParameters identificationParameters = FollowUpExportDialog.this.peptideShakerGUI.getIdentificationParameters();
                            ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                            SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                            String modifiedSequence = peptideMatch.getPeptide().getTaggedModifiedSequence(modificationParameters, FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider(), modificationSequenceMatchingParameters, false, false, true, FollowUpExportDialog.this.peptideShakerGUI.getDisplayParameters().getDisplayedModifications());
                            if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                                String node = String.join((CharSequence)"", "create n={id:'", Long.toString(peptideKey), "', name:'", modifiedSequence, "', type:'Peptide'};");
                                nodeWriter.writeLine(node);
                            } else {
                                nodeWriter.writeLine(Long.toString(peptideKey), modifiedSequence, "peptide", psParameter.getMatchValidationLevel().getName(), Boolean.toString(PeptideUtils.isDecoy(peptideMatch.getPeptide(), FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider())));
                            }
                            for (String proteinAccession : peptideMatch.getPeptide().getProteinMapping().keySet()) {
                                long proteinKey = ExperimentObject.asLong(proteinAccession);
                                if (!proteinsAdded.contains(proteinKey)) {
                                    proteinsAdded.add(proteinKey);
                                    ProteinMatch proteinMatch = (ProteinMatch)FollowUpExportDialog.this.peptideShakerGUI.getIdentification().retrieveObject(proteinKey);
                                    if (proteinMatch != null) {
                                        psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                                        if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                                            nodeWriter.writeLine("create n={id:'" + proteinKey + "', name:'" + proteinAccession + "', type:'Protein'};");
                                        } else {
                                            nodeWriter.writeLine(proteinAccession, Long.toString(proteinKey), "protein", psParameter.getMatchValidationLevel().getName(), Boolean.toString(proteinMatch.isDecoy()));
                                        }
                                    } else if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                                        nodeWriter.writeLine("create n={id:'" + proteinAccession + "', name:'" + proteinAccession + "', type:'Protein'};");
                                    } else {
                                        nodeWriter.writeLine(proteinAccession, proteinAccession, "protein", "shared", Boolean.toString(ProteinUtils.isDecoy(proteinAccession, FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider())));
                                    }
                                }
                                if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                                    edgeWriter.writeLine("start n1=node:node_auto_index(id='" + peptideKey + "'),n2=node:node_auto_index(id='" + proteinAccession + "') create unique n1-[:MAPS_TO]->n2;");
                                    continue;
                                }
                                edgeWriter.writeLine(Long.toString(peptideKey), proteinAccession, "peptide_to_protein");
                            }
                            progressDialog.increasePrimaryProgressCounter();
                        }
                        if (((String)FollowUpExportDialog.this.graphDatabaseFormat.getSelectedItem()).equalsIgnoreCase("Neo4j")) {
                            nodeWriter.writeLine("COMMIT");
                            edgeWriter.writeLine("COMMIT");
                        }
                        proteinsAdded.clear();
                        exported = true;
                    }
                    catch (Exception e) {
                        progressDialog.setRunCanceled();
                        FollowUpExportDialog.this.peptideShakerGUI.catchException(e);
                    }
                    boolean processCancelled = progressDialog.isRunCanceled();
                    progressDialog.setRunFinished();
                    if (!processCancelled) {
                        if (exported) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "Graph database saved to folder '" + selectedFolder.getAbsolutePath() + "'.", "Save Complete", 1);
                        } else {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "An error occurred during exporting. See resources/PeptideShaker.log for details.", "Export Error", 0);
                        }
                    }
                }
            }.start();
        }
    }

    private void exportIdentifiedProteinAccessionNumbersAsCsvButtonActionPerformed(ActionEvent evt) {
        this.exportFasta(true);
    }

    private void exportIdentifiedProteinsAsFastaButtonActionPerformed(ActionEvent evt) {
        this.exportFasta(false);
    }

    private void exportToProgenesisLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportToProgenesisLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportToProgenesisLinkLabelMouseClicked(MouseEvent evt) {
        JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("<a href=\"http://www.nonlinear.com/products/progenesis/lc-ms/overview/\">Progenesis</a> does not yet have a specific PeptideShaker import. In order to get the<br>identifications back into Progenesis one therefore has to rely on the Phenyx import<br>format, i.e., select 'Phenyx' when importing the results back into Progenesis.<br><br>Note that converting to the 'Phenyx' format simplifies the identification results.<br><br>If you would like to see a proper PeptideShaker import please contact <a href=\"http://www.nonlinear.com/products/progenesis/lc-ms/overview/\">Progenesis</a>."), "Progenesis Help", 2);
    }

    private void exportProgenesisButtonActionPerformed(ActionEvent evt) {
        final File finalOutputFile = this.peptideShakerGUI.getUserSelectedFile("progenesis_psm_export.txt", ".txt", "Tab Separated Text File (*.txt)", "Select Destination File", false);
        if (finalOutputFile != null) {
            progressDialog = new ProgressDialogX(this, this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting PSMs. Please Wait...");
            final int userChoice = this.psmSelectionComboBox.getSelectedIndex();
            HashSet<Object> modifications = new HashSet(0);
            if (userChoice == 3) {
                ModificationChooser modificationChooser = new ModificationChooser((Frame)this.peptideShakerGUI, this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getAllNotFixedModifications(), true);
                if (modificationChooser.isCanceled()) {
                    return;
                }
                modifications = modificationChooser.getSelectedItems();
            }
            final HashSet modificationSelection = modifications;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ProgenesisPsmThread"){

                @Override
                public void run() {
                    try {
                        ProgenesisExport.writeProgenesisExport(finalOutputFile, FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider(), FollowUpExportDialog.this.peptideShakerGUI.getProteinDetailsProvider(), FollowUpExportDialog.this.peptideShakerGUI.getIdentification(), ProgenesisExport.ExportType.getTypeFromIndex(userChoice), progressDialog, modificationSelection, FollowUpExportDialog.this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "Results exported to '" + finalOutputFile.getName() + "'.", "Export Complete", 1);
                        }
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        FollowUpExportDialog.this.peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }

    private void inclusionListButtonActionPerformed(ActionEvent evt) {
        new InclusionListExportDialog(this, InclusionListExport.ExportFormat.getTypeFromIndex(this.inclusionListFormat.getSelectedIndex()), true);
    }

    private void recalibrateMgfButtonActionPerformed(ActionEvent evt) {
        this.recalibrateSpectra();
    }

    private void exportMgfButtonActionPerformed(ActionEvent evt) {
        final File selectedFolder = FileChooserUtil.getUserSelectedFolder(this, "Select Output Folder", this.getLastSelectedFolder(), "Output Folder", "Select", false);
        if (selectedFolder != null) {
            this.setLastSelectedFolder(selectedFolder.getAbsolutePath());
            progressDialog = new ProgressDialogX(this, this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting Spectra. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("SaveThread"){

                @Override
                public void run() {
                    try {
                        SpectrumExporter spectrumExporter = new SpectrumExporter(FollowUpExportDialog.this.peptideShakerGUI.getIdentification(), FollowUpExportDialog.this.peptideShakerGUI.getSpectrumProvider());
                        spectrumExporter.exportSpectra(selectedFolder, progressDialog, SpectrumExporter.ExportType.getTypeFromIndex(FollowUpExportDialog.this.spectrumValidationCmb.getSelectedIndex()), FollowUpExportDialog.this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "Spectra saved to " + selectedFolder.getAbsolutePath() + ".", "Save Complete", 1);
                        }
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(FollowUpExportDialog.this, "An error occurred when saving the file.", "Saving Failed", 0);
                    }
                }
            }.start();
        }
    }

    private void exportProteformsAsTxtButtonActionPerformed(ActionEvent evt) {
        final File finalOutputFile = this.peptideShakerGUI.getUserSelectedFile("proteoforms.txt", ".txt", "Tab Separated Text File (*.txt)", "Select Destination File", false);
        if (finalOutputFile != null) {
            progressDialog = new ProgressDialogX(this, this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting Proteoforms. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ProteoformsThread"){

                @Override
                public void run() {
                    try {
                        ProteoformExport.writeProteoforms(finalOutputFile, FollowUpExportDialog.this.peptideShakerGUI.getIdentification(), progressDialog);
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "Results exported to '" + finalOutputFile.getName() + "'.", "Export Complete", 1);
                        }
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        FollowUpExportDialog.this.peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }

    private void unipeptExportButtonActionPerformed(ActionEvent evt) {
        progressDialog = new ProgressDialogX(this, this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Exporting Peptide Sequences. Please Wait...");
        final int PEPTIDE_EXPORT_TYPE = this.unipeptiExportCmb.getSelectedIndex();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("UnipeptExportThread"){

            @Override
            public void run() {
                try {
                    ArrayList<String> peptideSequences = new ArrayList<String>();
                    PSParameter psParameter = new PSParameter();
                    ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
                    parameters.add(psParameter);
                    if (PEPTIDE_EXPORT_TYPE == 0 || PEPTIDE_EXPORT_TYPE == 1) {
                        PeptideMatch peptideMatch;
                        progressDialog.resetPrimaryProgressCounter();
                        progressDialog.setMaxPrimaryProgressCounter(FollowUpExportDialog.this.peptideShakerGUI.getIdentification().getPeptideIdentification().size());
                        PeptideMatchesIterator peptideMatchesIterator = FollowUpExportDialog.this.peptideShakerGUI.getIdentification().getPeptideMatchesIterator(progressDialog);
                        while ((peptideMatch = peptideMatchesIterator.next()) != null && !progressDialog.isRunCanceled()) {
                            Peptide peptide = peptideMatch.getPeptide();
                            psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                            if (!PeptideUtils.isDecoy(peptide, FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider()) && (PEPTIDE_EXPORT_TYPE == 1 || psParameter.getMatchValidationLevel().isValidated())) {
                                peptideSequences.add(peptide.getSequence());
                            }
                            progressDialog.increasePrimaryProgressCounter();
                        }
                    } else {
                        SpectrumMatch spectrumMatch;
                        progressDialog.resetPrimaryProgressCounter();
                        progressDialog.setMaxPrimaryProgressCounter(FollowUpExportDialog.this.peptideShakerGUI.getIdentification().getPeptideIdentification().size());
                        SpectrumMatchesIterator spectrumMatchIerator = FollowUpExportDialog.this.peptideShakerGUI.getIdentification().getSpectrumMatchesIterator(progressDialog);
                        while ((spectrumMatch = spectrumMatchIerator.next()) != null && !progressDialog.isRunCanceled()) {
                            PeptideAssumption bestAssumption;
                            psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                            if ((PEPTIDE_EXPORT_TYPE == 3 || psParameter.getMatchValidationLevel().isValidated()) && !PeptideUtils.isDecoy((bestAssumption = spectrumMatch.getBestPeptideAssumption()).getPeptide(), FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider())) {
                                peptideSequences.add(bestAssumption.getPeptide().getSequence());
                            }
                            progressDialog.increasePrimaryProgressCounter();
                        }
                    }
                    if (!progressDialog.isRunCanceled()) {
                        UnipeptExport.analyzeInUnipept(peptideSequences, true, true, false, new File(PSExportFactory.getJsonFolder(), "UnipeptExport.html"), progressDialog);
                    }
                    progressDialog.setRunFinished();
                }
                catch (Exception e) {
                    progressDialog.setRunCanceled();
                    FollowUpExportDialog.this.peptideShakerGUI.catchException(e);
                }
            }
        }.start();
    }

    private void skylineExport() {
        new MzIdentMLExportDialog(this.peptideShakerGUI, true);
    }

    private void exportFasta(boolean accessionsOnly) {
        final File selectedFile = accessionsOnly ? this.peptideShakerGUI.getUserSelectedFile("proteins.txt", ".txt", "Supported formats: text format (.txt)", "Select Destination File", false) : this.peptideShakerGUI.getUserSelectedFile("proteins.fasta", ".fasta", "Supported formats: FASTA format (.fasta)", "Select Destination File", false);
        final boolean finalAccessionsOnly = accessionsOnly;
        if (selectedFile != null) {
            progressDialog = new ProgressDialogX(this, this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ExportThread"){

                @Override
                public void run() {
                    try {
                        SequenceProvider sequenceProvider = FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider();
                        FastaExport.ExportType exportType = finalAccessionsOnly ? FastaExport.ExportType.getTypeFromIndex(FollowUpExportDialog.this.proteinExportCmb1.getSelectedIndex()) : FastaExport.ExportType.getTypeFromIndex(FollowUpExportDialog.this.proteinExportCmb2.getSelectedIndex());
                        IdentificationFeaturesGenerator identificationFeaturesGenerator = FollowUpExportDialog.this.peptideShakerGUI.getIdentificationFeaturesGenerator();
                        progressDialog.setPrimaryProgressCounterIndeterminate(false);
                        if (exportType == FastaExport.ExportType.non_validated) {
                            progressDialog.setMaxPrimaryProgressCounter(sequenceProvider.getAccessions().size());
                        } else {
                            progressDialog.setMaxPrimaryProgressCounter(identificationFeaturesGenerator.getNValidatedProteins());
                        }
                        FastaExport.export(selectedFile, sequenceProvider, FollowUpExportDialog.this.peptideShakerGUI.getIdentification(), exportType, progressDialog, finalAccessionsOnly);
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "Identified proteins exported to " + selectedFile.getPath() + ".", "Export Complete", 1);
                        }
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(FollowUpExportDialog.this, "An error occurred when exporting the data.", "Export Failed", 0);
                    }
                }
            }.start();
        }
    }

    public void recalibrateSpectra() {
        final File selectedFolder = FileChooserUtil.getUserSelectedFolder(this, "Select Output Folder", this.getLastSelectedFolder(), "Output Folder", "Select", false);
        if (selectedFolder != null) {
            this.setLastSelectedFolder(selectedFolder.getAbsolutePath());
            for (String fileName : this.peptideShakerGUI.getSpectrumProvider().getOrderedFileNamesWithoutExtensions()) {
                String newName = RecalibrationExporter.getRecalibratedFileName(fileName);
                File testFile = new File(selectedFolder, newName);
                if (!testFile.exists()) continue;
                int outcome = JOptionPane.showConfirmDialog(this, "File(s) already exist, shall it be overwritten?", "Selected File(s) Already Exists", 0, 2);
                if (outcome == 0) break;
                return;
            }
            progressDialog = new ProgressDialogX(this, this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Exporting. Please Wait...");
            int selection = this.spectrumRecalibrationCmb.getSelectedIndex();
            final boolean precursors = selection == 0 || selection == 1;
            final boolean fragments = selection == 0 || selection == 2;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("SaveThread"){

                @Override
                public void run() {
                    try {
                        RecalibrationExporter.writeRecalibratedSpectra(precursors, fragments, selectedFolder, FollowUpExportDialog.this.peptideShakerGUI.getIdentification(), FollowUpExportDialog.this.peptideShakerGUI.getSequenceProvider(), FollowUpExportDialog.this.peptideShakerGUI.getSpectrumProvider(), FollowUpExportDialog.this.peptideShakerGUI.getIdentificationParameters(), progressDialog);
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(FollowUpExportDialog.this, "Recalibrated spectra saved to " + selectedFolder.getAbsolutePath() + ".", "Save Complete", 1);
                        }
                    }
                    catch (Exception e) {
                        FollowUpExportDialog.this.peptideShakerGUI.catchException(e);
                    }
                    finally {
                        progressDialog.setRunFinished();
                    }
                }
            }.start();
        }
    }

    private String getLastSelectedFolder() {
        LastSelectedFolder lastSelectedFolder = this.peptideShakerGUI.getLastSelectedFolder();
        String folder = lastSelectedFolder.getLastSelectedFolder("export");
        if (folder == null) {
            folder = lastSelectedFolder.getLastSelectedFolder();
        }
        return folder;
    }

    private void setLastSelectedFolder(String folder) {
        this.peptideShakerGUI.getLastSelectedFolder().setLastSelectedFolder("export", folder);
    }

    public PeptideShakerGUI getPeptideShakerGUI() {
        return this.peptideShakerGUI;
    }
}

