/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.export;

import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.identification.MzIdentMLVersion;
import com.compomics.util.experiment.io.parameters.SdrfExport;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.identification.IdentificationParameters;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.export.MzIdentMLExport;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.xml.sax.SAXException;
import uk.ac.ebi.pride.tools.ErrorHandlerIface;
import uk.ac.ebi.pride.tools.GenericSchemaValidator;
import uk.ac.ebi.pride.tools.ValidationErrorHandler;

public class MzIdentMLExportDialog
extends JDialog {
    private static ProgressDialogX progressDialog;
    private final PeptideShakerGUI peptideShakerGUI;
    private final boolean validateMzIdentML = false;
    private MzIdentMLVersion mzIdentMLVersion = MzIdentMLVersion.v1_1;
    private boolean exportSdrf = true;
    private JPanel backgroundJPanel;
    private JButton browseOutputFolderJButton;
    private JTextField contactAddressJTextField;
    private JLabel contactAddressLabel;
    private JTextField contactEmailJTextField;
    private JLabel contactEmailLabel;
    private JTextField contactFirstNameJTextField;
    private JLabel contactFirstNameLabel;
    private JTextField contactLastNameJTextField;
    private JLabel contactLastNameLabel;
    private JPanel contactPanel;
    private JTextField contactUrlJTextField;
    private JLabel contactUrlLabel;
    private JButton convertJButton;
    private JLabel helpLabel;
    private JCheckBox includeSequencesCheckBox;
    private JButton openDialogHelpJButton;
    private JTextField organizationAddressJTextField;
    private JLabel organizationAddressLabel;
    private JTextField organizationEmailJTextField;
    private JLabel organizationEmailLabel;
    private JTextField organizationNameJTextField;
    private JLabel organizationNameLabel;
    private JPanel organizationPanel;
    private JTextField organizationUrlJTextField;
    private JLabel organizationUrlLabel;
    private JTextField outputFolderJTextField;
    private JLabel outputFolderLabel;
    private JPanel outputPanel;

    public MzIdentMLExportDialog(PeptideShakerGUI peptideShakerGUI, boolean modal) {
        super((Frame)peptideShakerGUI, modal);
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.setGuiProperties();
        this.insertProjectData();
        this.validateInput();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void setGuiProperties() {
    }

    private void insertProjectData() {
        ProjectDetails projectDetails = this.peptideShakerGUI.getProjectDetails();
        this.contactFirstNameJTextField.setText(projectDetails.getContactFirstName());
        this.contactLastNameJTextField.setText(projectDetails.getContactLastName());
        this.contactEmailJTextField.setText(projectDetails.getContactEmail());
        this.contactAddressJTextField.setText(projectDetails.getContactAddress());
        this.contactUrlJTextField.setText(projectDetails.getContactUrl());
        this.organizationNameJTextField.setText(projectDetails.getOrganizationName());
        this.organizationEmailJTextField.setText(projectDetails.getOrganizationEmail());
        this.organizationAddressJTextField.setText(projectDetails.getOrganizationAddress());
        this.organizationUrlJTextField.setText(projectDetails.getOrganizationUrl());
        this.includeSequencesCheckBox.setSelected(projectDetails.getIncludeProteinSequences());
        if (projectDetails.getMzIdentMLOutputFile() != null && new File(projectDetails.getMzIdentMLOutputFile()).exists()) {
            this.outputFolderJTextField.setText(projectDetails.getMzIdentMLOutputFile());
        }
    }

    private void initComponents() {
        this.backgroundJPanel = new JPanel();
        this.contactPanel = new JPanel();
        this.contactFirstNameLabel = new JLabel();
        this.contactFirstNameJTextField = new JTextField();
        this.contactLastNameLabel = new JLabel();
        this.contactLastNameJTextField = new JTextField();
        this.contactEmailLabel = new JLabel();
        this.contactEmailJTextField = new JTextField();
        this.contactAddressLabel = new JLabel();
        this.contactAddressJTextField = new JTextField();
        this.contactUrlLabel = new JLabel();
        this.contactUrlJTextField = new JTextField();
        this.organizationPanel = new JPanel();
        this.organizationNameLabel = new JLabel();
        this.organizationNameJTextField = new JTextField();
        this.organizationEmailLabel = new JLabel();
        this.organizationEmailJTextField = new JTextField();
        this.organizationAddressLabel = new JLabel();
        this.organizationAddressJTextField = new JTextField();
        this.organizationUrlLabel = new JLabel();
        this.organizationUrlJTextField = new JTextField();
        this.outputPanel = new JPanel();
        this.outputFolderLabel = new JLabel();
        this.outputFolderJTextField = new JTextField();
        this.browseOutputFolderJButton = new JButton();
        this.includeSequencesCheckBox = new JCheckBox();
        this.helpLabel = new JLabel();
        this.openDialogHelpJButton = new JButton();
        this.convertJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Export mzIdentML");
        this.setResizable(false);
        this.backgroundJPanel.setBackground(new Color(230, 230, 230));
        this.contactPanel.setBorder(BorderFactory.createTitledBorder("Contact"));
        this.contactPanel.setOpaque(false);
        this.contactFirstNameLabel.setForeground(new Color(255, 0, 0));
        this.contactFirstNameLabel.setText("First Name");
        this.contactFirstNameJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.contactFirstNameJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.contactFirstNameJTextFieldKeyReleased(evt);
            }
        });
        this.contactLastNameLabel.setForeground(new Color(255, 0, 0));
        this.contactLastNameLabel.setHorizontalAlignment(0);
        this.contactLastNameLabel.setText("Last Name");
        this.contactLastNameJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.contactLastNameJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.contactLastNameJTextFieldKeyReleased(evt);
            }
        });
        this.contactEmailLabel.setForeground(new Color(255, 0, 0));
        this.contactEmailLabel.setText("E-mail");
        this.contactEmailJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.contactEmailJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.contactEmailJTextFieldKeyReleased(evt);
            }
        });
        this.contactAddressLabel.setForeground(new Color(255, 0, 0));
        this.contactAddressLabel.setText("Address");
        this.contactAddressJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.contactAddressJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.contactAddressJTextFieldKeyReleased(evt);
            }
        });
        this.contactUrlLabel.setText("URL");
        this.contactUrlJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.contactUrlJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.contactUrlJTextFieldKeyReleased(evt);
            }
        });
        GroupLayout contactPanelLayout = new GroupLayout(this.contactPanel);
        this.contactPanel.setLayout(contactPanelLayout);
        contactPanelLayout.setHorizontalGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contactPanelLayout.createSequentialGroup().addContainerGap().addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(contactPanelLayout.createSequentialGroup().addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.contactFirstNameLabel, -2, 75, -2).addComponent(this.contactEmailLabel, -2, 75, -2).addComponent(this.contactAddressLabel, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.contactEmailJTextField, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, contactPanelLayout.createSequentialGroup().addComponent(this.contactFirstNameJTextField, -1, 276, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.contactLastNameLabel, -2, 39, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contactLastNameJTextField, -1, 171, Short.MAX_VALUE)).addComponent(this.contactAddressJTextField))).addGroup(contactPanelLayout.createSequentialGroup().addComponent(this.contactUrlLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contactUrlJTextField))).addContainerGap(-1, Short.MAX_VALUE)));
        contactPanelLayout.linkSize(0, this.contactFirstNameJTextField, this.contactLastNameJTextField);
        contactPanelLayout.linkSize(0, this.contactFirstNameLabel, this.contactLastNameLabel);
        contactPanelLayout.setVerticalGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(contactPanelLayout.createSequentialGroup().addContainerGap().addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contactFirstNameLabel).addComponent(this.contactFirstNameJTextField, -2, -1, -2).addComponent(this.contactLastNameLabel).addComponent(this.contactLastNameJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contactEmailLabel).addComponent(this.contactEmailJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contactAddressLabel).addComponent(this.contactAddressJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(contactPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contactUrlLabel).addComponent(this.contactUrlJTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.organizationPanel.setBorder(BorderFactory.createTitledBorder("Organization"));
        this.organizationPanel.setOpaque(false);
        this.organizationNameLabel.setForeground(new Color(255, 0, 0));
        this.organizationNameLabel.setText("Name");
        this.organizationNameJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.organizationNameJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.organizationNameJTextFieldKeyReleased(evt);
            }
        });
        this.organizationEmailLabel.setForeground(new Color(255, 0, 0));
        this.organizationEmailLabel.setText("E-mail");
        this.organizationEmailJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.organizationEmailJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.organizationEmailJTextFieldKeyReleased(evt);
            }
        });
        this.organizationAddressLabel.setForeground(new Color(255, 0, 0));
        this.organizationAddressLabel.setText("Address");
        this.organizationAddressJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.organizationAddressJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.organizationAddressJTextFieldKeyReleased(evt);
            }
        });
        this.organizationUrlLabel.setText("URL");
        this.organizationUrlJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.organizationUrlJTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MzIdentMLExportDialog.this.organizationUrlJTextFieldKeyReleased(evt);
            }
        });
        GroupLayout organizationPanelLayout = new GroupLayout(this.organizationPanel);
        this.organizationPanel.setLayout(organizationPanelLayout);
        organizationPanelLayout.setHorizontalGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(organizationPanelLayout.createSequentialGroup().addContainerGap().addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(organizationPanelLayout.createSequentialGroup().addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.organizationNameLabel, -2, 75, -2).addComponent(this.organizationEmailLabel, -2, 75, -2).addComponent(this.organizationAddressLabel, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.organizationEmailJTextField).addComponent(this.organizationNameJTextField).addComponent(this.organizationAddressJTextField))).addGroup(GroupLayout.Alignment.TRAILING, organizationPanelLayout.createSequentialGroup().addComponent(this.organizationUrlLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.organizationUrlJTextField))).addContainerGap()));
        organizationPanelLayout.setVerticalGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(organizationPanelLayout.createSequentialGroup().addContainerGap().addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.organizationNameLabel).addComponent(this.organizationNameJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.organizationEmailLabel).addComponent(this.organizationEmailJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.organizationAddressLabel).addComponent(this.organizationAddressJTextField, -2, -1, -2)).addGap(0, 0, 0).addGroup(organizationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.organizationUrlLabel).addComponent(this.organizationUrlJTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output File"));
        this.outputPanel.setOpaque(false);
        this.outputFolderLabel.setForeground(new Color(255, 0, 0));
        this.outputFolderLabel.setText("File");
        this.outputFolderLabel.setToolTipText("The file where the mzIdentML export will be saved");
        this.outputFolderJTextField.setEditable(false);
        this.outputFolderJTextField.setToolTipText("The folder where the mzIdentML file will be saved");
        this.outputFolderJTextField.setMargin(new Insets(2, 4, 2, 2));
        this.browseOutputFolderJButton.setText("Browse");
        this.browseOutputFolderJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MzIdentMLExportDialog.this.browseOutputFolderJButtonActionPerformed(evt);
            }
        });
        this.includeSequencesCheckBox.setText("Include Protein Sequences");
        this.includeSequencesCheckBox.setToolTipText("Select to include the protein sequences in the mzIdentML file");
        this.includeSequencesCheckBox.setIconTextGap(10);
        GroupLayout outputPanelLayout = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outputPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.outputFolderLabel, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputFolderJTextField).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseOutputFolderJButton, -2, 80, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, outputPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.includeSequencesCheckBox).addGap(106, 106, 106)));
        outputPanelLayout.setVerticalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addContainerGap().addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputFolderLabel).addComponent(this.outputFolderJTextField, -2, -1, -2).addComponent(this.browseOutputFolderJButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.includeSequencesCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() | 2));
        this.helpLabel.setText("Insert the required information and click Convert to export the project to mzIdentML.");
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MzIdentMLExportDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MzIdentMLExportDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MzIdentMLExportDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.convertJButton.setBackground(new Color(0, 153, 0));
        this.convertJButton.setFont(this.convertJButton.getFont().deriveFont(this.convertJButton.getFont().getStyle() | 1));
        this.convertJButton.setForeground(new Color(255, 255, 255));
        this.convertJButton.setText("Convert!");
        this.convertJButton.setToolTipText("Click here to start the conversion!");
        this.convertJButton.setEnabled(false);
        this.convertJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MzIdentMLExportDialog.this.convertJButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundJPanelLayout = new GroupLayout(this.backgroundJPanel);
        this.backgroundJPanel.setLayout(backgroundJPanelLayout);
        backgroundJPanelLayout.setHorizontalGroup(backgroundJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundJPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.helpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.convertJButton, -2, 154, -2).addGap(15, 15, 15)).addComponent(this.outputPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundJPanelLayout.createSequentialGroup().addGroup(backgroundJPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.organizationPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.contactPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        backgroundJPanelLayout.setVerticalGroup(backgroundJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.contactPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.organizationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outputPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundJPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.openDialogHelpJButton).addComponent(this.helpLabel).addComponent(this.convertJButton, -2, 53, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundJPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundJPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.peptideShakerGUI, this.getClass().getResource("/helpFiles/mzIdentMLExportDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Export mzIdentML - Help");
        this.setCursor(new Cursor(0));
    }

    private void browseOutputFolderJButtonActionPerformed(ActionEvent evt) {
        int defaultFilterIndex;
        this.setCursor(new Cursor(3));
        LastSelectedFolder lastSelectedFolder = this.peptideShakerGUI.getLastSelectedFolder();
        String folder = lastSelectedFolder.getLastSelectedFolder("export");
        if (folder == null) {
            folder = lastSelectedFolder.getLastSelectedFolder();
        }
        if (!this.outputFolderJTextField.getText().isEmpty()) {
            if (new File(this.outputFolderJTextField.getText()).exists()) {
                folder = this.outputFolderJTextField.getText();
            } else if (new File(this.outputFolderJTextField.getText()).getParentFile().exists()) {
                folder = new File(this.outputFolderJTextField.getText()).getParent();
            }
        }
        MzIdentMLVersion[] mzIdentMLVersions = MzIdentMLVersion.values();
        String[] versionsDescriptions = new String[mzIdentMLVersions.length];
        for (int i = 0; i < mzIdentMLVersions.length; ++i) {
            MzIdentMLVersion tempVersion = mzIdentMLVersions[i];
            StringBuilder stringBuilder = new StringBuilder(23);
            stringBuilder.append("mzIdentML ").append(tempVersion.name).append(" (*.mzid.gzip)");
            versionsDescriptions[i] = stringBuilder.toString();
        }
        switch (this.mzIdentMLVersion) {
            case v1_1: {
                defaultFilterIndex = 0;
                break;
            }
            case v1_2: {
                defaultFilterIndex = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("mzIdentML version " + this.mzIdentMLVersion.name + " not supported.");
            }
        }
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile(this, new String[]{".mzid.gzip", ".mzid.gzip"}, versionsDescriptions, "Select Export File", folder, this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), false, true, false, defaultFilterIndex);
        if (selectedFileAndFilter != null) {
            String path = selectedFileAndFilter.getFile().getAbsolutePath();
            if (!path.endsWith(".mzid.gzip")) {
                path = path + ".mzid.gzip";
            }
            int index = -1;
            String selectedVersionDescription = selectedFileAndFilter.getFileFilter().getDescription();
            for (int i = 0; i < versionsDescriptions.length; ++i) {
                String versionDescription = versionsDescriptions[i];
                if (!versionDescription.equals(selectedVersionDescription)) continue;
                index = i;
                break;
            }
            this.mzIdentMLVersion = MzIdentMLVersion.getMzIdentMLVersion(index);
            lastSelectedFolder.setLastSelectedFolder("export", folder);
            this.outputFolderJTextField.setText(path);
        }
        this.validateInput();
        this.setCursor(new Cursor(0));
    }

    private void contactFirstNameJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void contactLastNameJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void contactEmailJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void convertJButtonActionPerformed(ActionEvent evt) {
        final File finalOutputFile = new File(this.outputFolderJTextField.getText());
        progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Exporting mzIdentML. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ConvertThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IdentificationParameters identificationParameters = MzIdentMLExportDialog.this.peptideShakerGUI.getIdentificationParameters();
                AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
                ProjectDetails projectDetails = MzIdentMLExportDialog.this.peptideShakerGUI.getProjectDetails();
                projectDetails.setContactFirstName(MzIdentMLExportDialog.this.contactFirstNameJTextField.getText().trim());
                projectDetails.setContactLastName(MzIdentMLExportDialog.this.contactLastNameJTextField.getText().trim());
                projectDetails.setContactEmail(MzIdentMLExportDialog.this.contactEmailJTextField.getText().trim());
                projectDetails.setContactAddress(MzIdentMLExportDialog.this.contactAddressJTextField.getText().trim());
                if (!MzIdentMLExportDialog.this.contactUrlJTextField.getText().trim().isEmpty()) {
                    projectDetails.setContactUrl(MzIdentMLExportDialog.this.contactUrlJTextField.getText().trim());
                } else {
                    projectDetails.setContactUrl(null);
                }
                projectDetails.setOrganizationName(MzIdentMLExportDialog.this.organizationNameJTextField.getText().trim());
                projectDetails.setOrganizationEmail(MzIdentMLExportDialog.this.organizationEmailJTextField.getText().trim());
                projectDetails.setOrganizationAddress(MzIdentMLExportDialog.this.organizationAddressJTextField.getText().trim());
                if (!MzIdentMLExportDialog.this.organizationUrlJTextField.getText().trim().isEmpty()) {
                    projectDetails.setOrganizationUrl(MzIdentMLExportDialog.this.organizationUrlJTextField.getText().trim());
                } else {
                    projectDetails.setOrganizationUrl(null);
                }
                projectDetails.setIncludeProteinSequences(MzIdentMLExportDialog.this.includeSequencesCheckBox.isSelected());
                projectDetails.setMzIdentOutputFile(MzIdentMLExportDialog.this.outputFolderJTextField.getText());
                MzIdentMLExportDialog.this.peptideShakerGUI.setDataSaved(false);
                boolean conversionCompleted = false;
                double currentIntensityLimit = annotationParameters.getAnnotationIntensityLimit();
                annotationParameters.setIntensityLimit(0.0);
                try {
                    FastaSummary fastaSummary = FastaSummary.getSummary(projectDetails.getFastaFile(), identificationParameters.getFastaParameters(), progressDialog);
                    MzIdentMLExport mzIdentMLExport = new MzIdentMLExport(PeptideShaker.getVersion(), MzIdentMLExportDialog.this.peptideShakerGUI.getIdentification(), projectDetails, identificationParameters, MzIdentMLExportDialog.this.peptideShakerGUI.getSequenceProvider(), MzIdentMLExportDialog.this.peptideShakerGUI.getProteinDetailsProvider(), MzIdentMLExportDialog.this.peptideShakerGUI.getSpectrumProvider(), ModificationFactory.getInstance(), fastaSummary, MzIdentMLExportDialog.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), finalOutputFile, MzIdentMLExportDialog.this.includeSequencesCheckBox.isSelected(), progressDialog, true);
                    mzIdentMLExport.createMzIdentMLFile(MzIdentMLExportDialog.this.mzIdentMLVersion);
                    conversionCompleted = true;
                }
                catch (Exception e) {
                    MzIdentMLExportDialog.this.peptideShakerGUI.catchException(e);
                    progressDialog.setRunCanceled();
                    progressDialog.dispose();
                    return;
                }
                finally {
                    annotationParameters.setIntensityLimit(currentIntensityLimit);
                }
                if (MzIdentMLExportDialog.this.exportSdrf) {
                    progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    progressDialog.setTitle("Exporting sdrf draft. Please Wait...");
                    File sdrfFile = new File(IoUtil.removeExtension(finalOutputFile.getAbsolutePath()) + ".sdrf");
                    SdrfExport.writeSdrf(sdrfFile, MzIdentMLExportDialog.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters(), MzIdentMLExportDialog.this.peptideShakerGUI.getIdentification().getFractions(), ModificationFactory.getInstance());
                }
                boolean processCancelled = progressDialog.isRunCanceled();
                progressDialog.setRunFinished();
                if (conversionCompleted && !processCancelled) {
                    JOptionPane.showMessageDialog(MzIdentMLExportDialog.this, JOptionEditorPane.getJOptionEditorPane("mzIdentML file '" + new File(MzIdentMLExportDialog.this.outputFolderJTextField.getText()).getAbsolutePath() + "' created.<br><br>Review your mzIdentML files with <a href=\"https://github.com/PRIDE-Toolsuite/pride-inspector\">PRIDE Inspector</a>.<br>Publish your mzIdentML files via <a href=\"http://www.proteomexchange.org/submission\">ProteomeXchange</a>."), "File Created", 1);
                    MzIdentMLExportDialog.this.dispose();
                }
                if (processCancelled) {
                    JOptionPane.showMessageDialog(MzIdentMLExportDialog.this.peptideShakerGUI, "mzIdentML conversion cancelled by the user.", "mzIdentML Conversion Cancelled", 2);
                }
            }
        }.start();
    }

    private void contactUrlJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void organizationNameJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void organizationEmailJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void organizationUrlJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void contactAddressJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void organizationAddressJTextFieldKeyReleased(KeyEvent evt) {
        this.validateInput();
    }

    private void validateInput() {
        boolean inputValid = true;
        if (this.contactFirstNameJTextField.getText().length() == 0 || this.contactLastNameJTextField.getText().length() == 0 || this.contactEmailJTextField.getText().length() == 0 || this.contactAddressJTextField.getText().length() == 0 || this.organizationNameJTextField.getText().length() == 0 || this.organizationEmailJTextField.getText().length() == 0 || this.organizationAddressJTextField.getText().length() == 0 || this.outputFolderJTextField.getText().length() == 0) {
            inputValid = false;
        }
        this.convertJButton.setEnabled(inputValid);
        if (this.contactFirstNameJTextField.getText().length() > 0) {
            this.contactFirstNameLabel.setForeground(Color.BLACK);
        } else {
            this.contactFirstNameLabel.setForeground(Color.RED);
        }
        if (this.contactLastNameJTextField.getText().length() > 0) {
            this.contactLastNameLabel.setForeground(Color.BLACK);
        } else {
            this.contactLastNameLabel.setForeground(Color.RED);
        }
        if (this.contactEmailJTextField.getText().length() > 0) {
            this.contactEmailLabel.setForeground(Color.BLACK);
        } else {
            this.contactEmailLabel.setForeground(Color.RED);
        }
        if (this.contactAddressJTextField.getText().length() > 0) {
            this.contactAddressLabel.setForeground(Color.BLACK);
        } else {
            this.contactAddressLabel.setForeground(Color.RED);
        }
        if (this.organizationNameJTextField.getText().length() > 0) {
            this.organizationNameLabel.setForeground(Color.BLACK);
        } else {
            this.organizationNameLabel.setForeground(Color.RED);
        }
        if (this.organizationEmailJTextField.getText().length() > 0) {
            this.organizationEmailLabel.setForeground(Color.BLACK);
        } else {
            this.organizationEmailLabel.setForeground(Color.RED);
        }
        if (this.organizationAddressJTextField.getText().length() > 0) {
            this.organizationAddressLabel.setForeground(Color.BLACK);
        } else {
            this.organizationAddressLabel.setForeground(Color.RED);
        }
        if (this.outputFolderJTextField.getText().length() > 0) {
            this.outputFolderLabel.setForeground(Color.BLACK);
        } else {
            this.outputFolderLabel.setForeground(Color.RED);
        }
    }

    public boolean progressCancelled() {
        return progressDialog.isRunCanceled();
    }

    private String validateMzIdentML(File mzidFile) throws SAXException, MalformedURLException, FileNotFoundException, URISyntaxException {
        String errors = "";
        GenericSchemaValidator genericValidator = new GenericSchemaValidator();
        genericValidator.setSchema(new URI("http://www.psidev.info/files/mzIdentML1.1.0.xsd"));
        ValidationErrorHandler handler = new ValidationErrorHandler();
        genericValidator.setErrorHandler((ErrorHandlerIface)handler);
        BufferedReader br = new BufferedReader(new FileReader(mzidFile));
        genericValidator.validate((Reader)br);
        List errorMsgs = handler.getErrorMessages();
        if (!errorMsgs.isEmpty()) {
            int errorCount = 0;
            for (String error : errorMsgs) {
                errors = errors + ++errorCount + ": " + error + "\n\n";
                System.out.println(errorCount + ": " + error);
            }
        }
        return errors;
    }
}

