/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.export;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;

public class PtmSelectionDialog
extends JDialog {
    private ArrayList<String> searchedModifications = null;
    private ArrayList<String> selectedModifications;
    private boolean canceled = false;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JCheckBox confidentCheck;
    private JTable modificationTable;
    private JScrollPane modificationTableScrollPane;
    private JButton okButton;

    public PtmSelectionDialog(Frame parent, ArrayList<String> searchedModifications) {
        super(parent, true);
        this.searchedModifications = searchedModifications;
        this.selectedModifications = new ArrayList();
        for (String ptm : searchedModifications) {
            if (!ptm.contains("phospho") && !ptm.contains("glyco")) continue;
            this.selectedModifications.add(ptm);
        }
        this.initComponents();
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.modificationTable.getTableHeader().setReorderingAllowed(false);
        this.modificationTableScrollPane.getViewport().setOpaque(false);
        this.modificationTable.getColumn(" ").setMaxWidth(50);
        this.modificationTable.getColumn(" ").setMinWidth(50);
        this.modificationTable.getColumn("  ").setMaxWidth(30);
        this.modificationTable.getColumn("  ").setMinWidth(30);
        this.modificationTable.getColumn("  ").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
    }

    public boolean confidentOnly() {
        return this.confidentCheck.isSelected();
    }

    public ArrayList<String> selectedModifications() {
        if (!this.canceled) {
            return this.selectedModifications;
        }
        return null;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.confidentCheck = new JCheckBox();
        this.modificationTableScrollPane = new JScrollPane();
        this.modificationTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle("PTM Selection");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PtmSelectionDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmSelectionDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PtmSelectionDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.confidentCheck.setText("Confidently localized only");
        this.confidentCheck.setIconTextGap(10);
        this.confidentCheck.setOpaque(false);
        this.modificationTable.setModel(new PTMTableModel());
        this.modificationTableScrollPane.setViewportView(this.modificationTable);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.confidentCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.modificationTableScrollPane, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationTableScrollPane, -1, 244, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.confidentCheck)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedModifications = null;
        this.canceled = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.selectedModifications = null;
        this.canceled = true;
    }

    private class PTMTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (PtmSelectionDialog.this.searchedModifications == null) {
                return 0;
            }
            return PtmSelectionDialog.this.searchedModifications.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Modification";
                }
                case 2: {
                    return "  ";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String ptm = (String)PtmSelectionDialog.this.searchedModifications.get(row);
            if (ptm == null) {
                return "";
            }
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ptm;
                }
                case 2: {
                    return PtmSelectionDialog.this.selectedModifications.contains(ptm);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String ptm;
            if (columnIndex == 2 && (ptm = (String)PtmSelectionDialog.this.searchedModifications.get(rowIndex)) != null) {
                if (PtmSelectionDialog.this.selectedModifications.contains(ptm)) {
                    PtmSelectionDialog.this.selectedModifications.remove(ptm);
                } else {
                    PtmSelectionDialog.this.selectedModifications.add(ptm);
                }
            }
        }
    }
}

