/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.parameters;

import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;

public class DisplayPreferencesDialog
extends JDialog {
    private boolean canceled = false;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox<String> lowResolutionChartsComboBox;
    private JLabel lowResolutionChartsLabel;
    private JSpinner nAASpinner;
    private JButton okButton;
    private JPanel optionsPanel;
    private JLabel surroundingAminoAcidsLabel;

    public DisplayPreferencesDialog(Frame parentFrame, DisplayParameters displayPreferences) {
        super(parentFrame, true);
        this.initComponents();
        this.setUpGui();
        this.populateGUI(displayPreferences);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    private void setUpGui() {
        ((JSpinner.NumberEditor)this.nAASpinner.getEditor()).getTextField().setHorizontalAlignment(0);
        this.lowResolutionChartsComboBox.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(DisplayParameters displayPreferences) {
        this.nAASpinner.setValue(displayPreferences.getnAASurroundingPeptides());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean validateInput() {
        return true;
    }

    public DisplayParameters getDisplayPreferences() {
        DisplayParameters displayPreferences = new DisplayParameters();
        int selection = (Integer)this.nAASpinner.getValue();
        displayPreferences.setnAASurroundingPeptides(selection);
        return displayPreferences;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.optionsPanel = new JPanel();
        this.surroundingAminoAcidsLabel = new JLabel();
        this.nAASpinner = new JSpinner();
        this.lowResolutionChartsLabel = new JLabel();
        this.lowResolutionChartsComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Display Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DisplayPreferencesDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayPreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.optionsPanel.setBorder(BorderFactory.createTitledBorder("Display Settings"));
        this.optionsPanel.setOpaque(false);
        this.surroundingAminoAcidsLabel.setText("Surrounding Amino Acids");
        this.nAASpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(0), null, (Number)1));
        this.lowResolutionChartsLabel.setText("Low Resolution Charts");
        this.lowResolutionChartsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.lowResolutionChartsComboBox.setSelectedIndex(1);
        this.lowResolutionChartsComboBox.setEnabled(false);
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lowResolutionChartsLabel, -1, -1, Short.MAX_VALUE).addComponent(this.surroundingAminoAcidsLabel, -1, 150, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nAASpinner, -1, 123, Short.MAX_VALUE).addComponent(this.lowResolutionChartsComboBox, 0, -1, Short.MAX_VALUE)).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.surroundingAminoAcidsLabel).addComponent(this.nAASpinner, -2, -1, -2)).addGap(0, 0, 0).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lowResolutionChartsLabel).addComponent(this.lowResolutionChartsComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.optionsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.optionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }
}

