/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.parameters;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import eu.isas.peptideshaker.gui.parameters.DisplayPreferencesDialog;
import eu.isas.peptideshaker.gui.parameters.SpectrumCountingSettingsDialog;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class ProjectParametersDialog
extends JDialog {
    private Frame parentFrame;
    private SpectrumCountingParameters spectrumCountingPreferences;
    private DisplayParameters displayPreferences;
    private boolean canceled = false;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel displayLbl;
    private JButton editDisplayPreferencesButton;
    private JButton editSpectrumQuantificationButton;
    private JButton helpJButton;
    private JButton okButton;
    private JPanel preferencesPanel;
    private JLabel spectrumQuantificationLbl;

    public ProjectParametersDialog(Frame parentFrame, Dialog owner, SpectrumCountingParameters spectrumCountingPreferences, DisplayParameters displayPreferences) {
        super(owner, true);
        this.initComponents();
        this.parentFrame = parentFrame;
        this.spectrumCountingPreferences = spectrumCountingPreferences;
        this.displayPreferences = displayPreferences;
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    public ProjectParametersDialog(Frame parentFrame, SpectrumCountingParameters spectrumCountingPreferences, DisplayParameters displayPreferences) {
        super(parentFrame, true);
        this.initComponents();
        this.parentFrame = parentFrame;
        this.spectrumCountingPreferences = spectrumCountingPreferences;
        this.displayPreferences = displayPreferences;
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    public DisplayParameters getDisplayParameters() {
        return this.displayPreferences;
    }

    public SpectrumCountingParameters getSpectrumCountingParameters() {
        return this.spectrumCountingPreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.helpJButton = new JButton();
        this.preferencesPanel = new JPanel();
        this.spectrumQuantificationLbl = new JLabel();
        this.editSpectrumQuantificationButton = new JButton();
        this.editDisplayPreferencesButton = new JButton();
        this.displayLbl = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Preferences");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorder(null);
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProjectParametersDialog.this.helpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProjectParametersDialog.this.helpJButtonMouseExited(evt);
            }
        });
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectParametersDialog.this.helpJButtonActionPerformed(evt);
            }
        });
        this.preferencesPanel.setBorder(BorderFactory.createTitledBorder("Project Preferences"));
        this.preferencesPanel.setOpaque(false);
        this.spectrumQuantificationLbl.setText("Spectrum Quantification");
        this.editSpectrumQuantificationButton.setText("Edit");
        this.editSpectrumQuantificationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectParametersDialog.this.editSpectrumQuantificationButtonActionPerformed(evt);
            }
        });
        this.editDisplayPreferencesButton.setText("Edit");
        this.editDisplayPreferencesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectParametersDialog.this.editDisplayPreferencesButtonActionPerformed(evt);
            }
        });
        this.displayLbl.setText("Display");
        GroupLayout preferencesPanelLayout = new GroupLayout(this.preferencesPanel);
        this.preferencesPanel.setLayout(preferencesPanelLayout);
        preferencesPanelLayout.setHorizontalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumQuantificationLbl).addComponent(this.displayLbl)).addGap(18, 18, 18).addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editSpectrumQuantificationButton, -1, 155, Short.MAX_VALUE).addComponent(this.editDisplayPreferencesButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        preferencesPanelLayout.setVerticalGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preferencesPanelLayout.createSequentialGroup().addContainerGap().addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectrumQuantificationLbl).addComponent(this.editSpectrumQuantificationButton)).addGap(0, 0, 0).addGroup(preferencesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.editDisplayPreferencesButton).addComponent(this.displayLbl)).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.preferencesPanel, -1, -1, Short.MAX_VALUE).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.helpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.preferencesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.helpJButton).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void helpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentFrame, this.getClass().getResource("/helpFiles/PreferencesDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Preferences - Help");
        this.setCursor(new Cursor(0));
    }

    private void editSpectrumQuantificationButtonActionPerformed(ActionEvent evt) {
        SpectrumCountingSettingsDialog spectrumCountingPreferencesDialog = new SpectrumCountingSettingsDialog(this.parentFrame, this.spectrumCountingPreferences);
        if (!spectrumCountingPreferencesDialog.isCanceled()) {
            this.spectrumCountingPreferences = spectrumCountingPreferencesDialog.getSpectrumCountingPreferences();
        }
    }

    private void editDisplayPreferencesButtonActionPerformed(ActionEvent evt) {
        DisplayPreferencesDialog displayPreferencesDialog = new DisplayPreferencesDialog(this.parentFrame, this.displayPreferences);
        if (!displayPreferencesDialog.isCanceled()) {
            this.displayPreferences = displayPreferencesDialog.getDisplayPreferences();
        }
    }
}

