/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.pride;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.converters.DecoyConverter;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.UtilitiesUserParameters;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class DatabaseHelpDialog
extends JDialog {
    private String species;
    private static ProgressDialogX progressDialog;
    private String selectedFastaFile = null;
    private LastSelectedFolder lastSelectedFolder;
    private UtilitiesUserParameters utilitiesUserParameters;
    private FastaParameters fastaParameters;
    private JPanel backgroundPanel;
    private JButton browseDatabaseSettings;
    private JButton cancelButton;
    private JPanel dataBasePanelSettings;
    private JLabel databaseHelpSettingsJLabel;
    private JLabel databaseSettingsLbl;
    private JTextField databaseSettingsTxt;
    private JLabel downloadUniProtJLabel;
    private JButton okButton;
    private JPanel speciesAndTaxonomyJPanel;
    private JTextField speciesJTextField;
    private JLabel speciesLabel;
    private JButton targetDecoySettingsButton;
    private JTextField taxonomyJTextField;
    private JLabel taxonomyLabel;

    public DatabaseHelpDialog(PeptideShakerGUI peptideShakerGUI, FastaParameters fastaParameters, LastSelectedFolder lastSelectedFolder, boolean modal, String species) {
        super((Frame)peptideShakerGUI, modal);
        this.initComponents();
        this.species = species;
        this.fastaParameters = fastaParameters;
        this.lastSelectedFolder = lastSelectedFolder;
        this.utilitiesUserParameters = UtilitiesUserParameters.loadUserParameters();
        boolean speciesOrTaxonomySet = false;
        if (species != null && species.length() > 0) {
            this.speciesJTextField.setText(species);
            speciesOrTaxonomySet = true;
        } else {
            this.speciesJTextField.setText("(unknown)");
            this.species = null;
        }
        if (!speciesOrTaxonomySet) {
            this.downloadUniProtJLabel.setEnabled(false);
        }
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.speciesAndTaxonomyJPanel = new JPanel();
        this.speciesLabel = new JLabel();
        this.taxonomyLabel = new JLabel();
        this.speciesJTextField = new JTextField();
        this.taxonomyJTextField = new JTextField();
        this.downloadUniProtJLabel = new JLabel();
        this.dataBasePanelSettings = new JPanel();
        this.databaseSettingsLbl = new JLabel();
        this.databaseSettingsTxt = new JTextField();
        this.browseDatabaseSettings = new JButton();
        this.targetDecoySettingsButton = new JButton();
        this.databaseHelpSettingsJLabel = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Protein Sequence Database");
        this.setMinimumSize(new Dimension(600, 270));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.speciesAndTaxonomyJPanel.setBorder(BorderFactory.createTitledBorder("Species & Taxonomy"));
        this.speciesAndTaxonomyJPanel.setOpaque(false);
        this.speciesLabel.setText("Species");
        this.taxonomyLabel.setText("Taxonomy");
        this.speciesJTextField.setEditable(false);
        this.speciesJTextField.setHorizontalAlignment(0);
        this.taxonomyJTextField.setEditable(false);
        this.taxonomyJTextField.setHorizontalAlignment(0);
        this.downloadUniProtJLabel.setForeground(new Color(0, 0, 255));
        this.downloadUniProtJLabel.setHorizontalAlignment(11);
        this.downloadUniProtJLabel.setText("<html><u><i>Click here to download species database from UniProt.</i></u></html>");
        this.downloadUniProtJLabel.setToolTipText("Download UniProt Database");
        this.downloadUniProtJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DatabaseHelpDialog.this.downloadUniProtJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DatabaseHelpDialog.this.downloadUniProtJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DatabaseHelpDialog.this.downloadUniProtJLabelMouseExited(evt);
            }
        });
        GroupLayout speciesAndTaxonomyJPanelLayout = new GroupLayout(this.speciesAndTaxonomyJPanel);
        this.speciesAndTaxonomyJPanel.setLayout(speciesAndTaxonomyJPanelLayout);
        speciesAndTaxonomyJPanelLayout.setHorizontalGroup(speciesAndTaxonomyJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(speciesAndTaxonomyJPanelLayout.createSequentialGroup().addContainerGap().addGroup(speciesAndTaxonomyJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.speciesLabel, -2, 70, -2).addComponent(this.taxonomyLabel, -2, 70, -2)).addGap(18, 18, 18).addGroup(speciesAndTaxonomyJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taxonomyJTextField).addComponent(this.speciesJTextField).addGroup(speciesAndTaxonomyJPanelLayout.createSequentialGroup().addComponent(this.downloadUniProtJLabel, -2, 660, -2).addGap(0, 20, Short.MAX_VALUE))).addContainerGap()));
        speciesAndTaxonomyJPanelLayout.setVerticalGroup(speciesAndTaxonomyJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(speciesAndTaxonomyJPanelLayout.createSequentialGroup().addContainerGap().addGroup(speciesAndTaxonomyJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesLabel).addComponent(this.speciesJTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(speciesAndTaxonomyJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taxonomyJTextField, -2, -1, -2).addComponent(this.taxonomyLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadUniProtJLabel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.dataBasePanelSettings.setBorder(BorderFactory.createTitledBorder("Database Selection"));
        this.dataBasePanelSettings.setOpaque(false);
        this.databaseSettingsLbl.setText("Database");
        this.databaseSettingsTxt.setEditable(false);
        this.browseDatabaseSettings.setText("Browse");
        this.browseDatabaseSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseHelpDialog.this.browseDatabaseSettingsActionPerformed(evt);
            }
        });
        this.targetDecoySettingsButton.setText("Decoy");
        this.targetDecoySettingsButton.setToolTipText("Generate a concatenated Target/Decoy database");
        this.targetDecoySettingsButton.setEnabled(false);
        this.targetDecoySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseHelpDialog.this.targetDecoySettingsButtonActionPerformed(evt);
            }
        });
        GroupLayout dataBasePanelSettingsLayout = new GroupLayout(this.dataBasePanelSettings);
        this.dataBasePanelSettings.setLayout(dataBasePanelSettingsLayout);
        dataBasePanelSettingsLayout.setHorizontalGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, dataBasePanelSettingsLayout.createSequentialGroup().addContainerGap().addComponent(this.databaseSettingsLbl, -2, 70, -2).addGap(18, 18, 18).addComponent(this.databaseSettingsTxt).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browseDatabaseSettings, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetDecoySettingsButton, -2, 73, -2).addContainerGap()));
        dataBasePanelSettingsLayout.linkSize(0, this.browseDatabaseSettings, this.targetDecoySettingsButton);
        dataBasePanelSettingsLayout.setVerticalGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dataBasePanelSettingsLayout.createSequentialGroup().addContainerGap().addGroup(dataBasePanelSettingsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseSettingsLbl).addComponent(this.browseDatabaseSettings).addComponent(this.databaseSettingsTxt, -2, -1, -2).addComponent(this.targetDecoySettingsButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.databaseHelpSettingsJLabel.setForeground(new Color(0, 0, 255));
        this.databaseHelpSettingsJLabel.setText("<html><u><i>Click here for help on setting up the database.</i></u></html>");
        this.databaseHelpSettingsJLabel.setToolTipText("Open Database Help");
        this.databaseHelpSettingsJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DatabaseHelpDialog.this.databaseHelpSettingsJLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DatabaseHelpDialog.this.databaseHelpSettingsJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DatabaseHelpDialog.this.databaseHelpSettingsJLabelMouseExited(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseHelpDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseHelpDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.databaseHelpSettingsJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.speciesAndTaxonomyJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.dataBasePanelSettings, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.speciesAndTaxonomyJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataBasePanelSettings, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.databaseHelpSettingsJLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void browseDatabaseSettingsActionPerformed(ActionEvent evt) {
        File fastaFile;
        UtilitiesUserParameters utilitiesUserPreferences;
        File startLocation = null;
        File utilitiesDbFolder = this.utilitiesUserParameters.getDbFolder();
        if (utilitiesDbFolder != null && utilitiesDbFolder.exists()) {
            startLocation = utilitiesDbFolder;
        }
        if (startLocation == null) {
            startLocation = new File(this.getLastSelectedFolder(this.lastSelectedFolder));
        }
        if ((utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters()).getDbFolder() != null && utilitiesUserPreferences.getDbFolder().exists()) {
            startLocation = utilitiesUserPreferences.getDbFolder();
        }
        if (this.selectedFastaFile != null && (fastaFile = new File(this.selectedFastaFile)).exists()) {
            startLocation = fastaFile.getParentFile();
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Supported formats: FASTA (.fasta)";
            }
        };
        fc.setFileFilter(filter);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            int value;
            File selectedFile = fc.getSelectedFile();
            this.selectedFastaFile = selectedFile.getAbsolutePath();
            if (selectedFile.getName().contains(" ")) {
                this.renameFastaFileName();
            } else {
                this.databaseSettingsTxt.setText(this.selectedFastaFile);
            }
            this.lastSelectedFolder.setLastSelectedFolder("fastaFile", this.selectedFastaFile);
            this.targetDecoySettingsButton.setEnabled(true);
            if (!this.selectedFastaFile.endsWith(this.fastaParameters.getTargetDecoyFileNameSuffix() + ".fasta") && (value = JOptionPane.showConfirmDialog(this, "The selected FASTA file does not seem to contain decoy sequences.\nDecoys are required by PeptideShaker. Add decoys?", "Add Decoy Sequences?", 0)) == 0) {
                this.targetDecoySettingsButtonActionPerformed(null);
            }
            this.validateParametersInput(false);
        }
    }

    private void databaseHelpSettingsJLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://compomics.github.io/projects/searchgui/wiki/DatabaseHelp.html");
        this.setCursor(new Cursor(0));
    }

    private void databaseHelpSettingsJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void databaseHelpSettingsJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void downloadUniProtJLabelMouseClicked(MouseEvent evt) {
        if (this.downloadUniProtJLabel.isEnabled()) {
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL("https://www.uniprot.org/uniprot/?query=%28organism%3A%22" + this.species + "%22%29&sort=score");
            this.setCursor(new Cursor(0));
        }
    }

    private void downloadUniProtJLabelMouseEntered(MouseEvent evt) {
        if (this.downloadUniProtJLabel.isEnabled()) {
            this.setCursor(new Cursor(12));
        }
    }

    private void downloadUniProtJLabelMouseExited(MouseEvent evt) {
        if (this.downloadUniProtJLabel.isEnabled()) {
            this.setCursor(new Cursor(0));
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.selectedFastaFile != null) {
            // empty if block
        }
        UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void targetDecoySettingsButtonActionPerformed(ActionEvent evt) {
        this.generateTargetDecoyDatabase();
    }

    public void renameFastaFileName() {
        File fastaFile = new File(this.selectedFastaFile);
        String tempName = fastaFile.getName();
        tempName = tempName.replaceAll(" ", "_");
        File renamedFile = new File(fastaFile.getParentFile().getAbsolutePath() + File.separator + tempName);
        boolean success = false;
        try {
            success = renamedFile.createNewFile();
            if (success) {
                IoUtil.copyFile(fastaFile, renamedFile, true);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (success) {
            JOptionPane.showMessageDialog(this, "Your FASTA file name contained white space and has been renamed to:\n" + fastaFile.getParentFile().getAbsolutePath() + File.separator + tempName, "Renamed File", 2);
            this.selectedFastaFile = renamedFile.getAbsolutePath();
            this.databaseSettingsTxt.setText(this.selectedFastaFile);
            this.targetDecoySettingsButton.setEnabled(true);
        } else {
            JOptionPane.showMessageDialog(this, "Your FASTA file name contains white space and has to been renamed.", "Please Rename File", 2);
        }
    }

    private void generateTargetDecoyDatabase() {
        String newFasta = this.selectedFastaFile;
        IoUtil.removeExtension(newFasta);
        newFasta = String.join((CharSequence)"", newFasta, this.fastaParameters.getTargetDecoyFileNameSuffix(), ".fasta");
        try {
            File newFile = new File(newFasta);
            progressDialog.setTitle("Appending Decoy Sequences. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            DecoyConverter.appendDecoySequences(new File(this.selectedFastaFile), newFile, this.fastaParameters, progressDialog);
            progressDialog.setTitle("Getting Database Details. Please Wait...");
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.selectedFastaFile = newFasta;
        }
        catch (OutOfMemoryError error) {
            Runtime.getRuntime().gc();
            JOptionPane.showMessageDialog(this, "The tool used up all the available memory and had to be stopped.\nMemory boundaries are set in the Edit menu (Edit > Java Options).", "Out Of Memory Error", 0);
            System.out.println("Ran out of memory!");
            error.printStackTrace();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this, new String[]{"FASTA Import Error.", "File " + this.selectedFastaFile + " not found."}, "FASTA Import Error", 2);
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, new String[]{"FASTA Import Error.", "File " + this.selectedFastaFile + " could not be imported."}, "FASTA Import Error", 2);
            e.printStackTrace();
        }
    }

    public boolean validateParametersInput(boolean showMessage) {
        boolean valid = true;
        this.databaseSettingsLbl.setForeground(Color.BLACK);
        this.databaseSettingsLbl.setToolTipText(null);
        if (this.databaseSettingsTxt.getText() == null || this.databaseSettingsTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify a search database.", "Search Database Not Found", 2);
            }
            this.databaseSettingsLbl.setForeground(Color.RED);
            this.databaseSettingsLbl.setToolTipText("Please select a valid '.fasta' or '.fas' database file");
            valid = false;
        } else {
            File fastaFile = new File(this.selectedFastaFile);
            if (!fastaFile.exists()) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The database file could not be found.", "Search Database Not Found", 2);
                }
                this.databaseSettingsLbl.setForeground(Color.RED);
                this.databaseSettingsLbl.setToolTipText("Database file could not be found!");
                valid = false;
            }
        }
        this.okButton.setEnabled(valid);
        return valid;
    }

    public String getLastSelectedFolder(LastSelectedFolder lastSelectedFolder) {
        Object result = null;
        if (result == null) {
            return null;
        }
        String folder = lastSelectedFolder.getLastSelectedFolder("fastaFile");
        if (folder == null) {
            folder = lastSelectedFolder.getLastSelectedFolder();
        }
        return folder;
    }
}

