/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.pride;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PridePrivateDataDialog
extends JDialog {
    private String projectAccession = null;
    private String userName = null;
    private String password = null;
    private JLabel accessionLabel;
    private JTextField accessionTextField;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton okButton;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JPanel projectPanel;
    private JPanel userDetailsPanel;
    private JLabel userNameLabel;
    private JTextField userNameTextField;

    public PridePrivateDataDialog(Frame parent, boolean modal, String pxAccesion) {
        super(parent, modal);
        this.initComponents();
        if (pxAccesion != null) {
            this.accessionTextField.setText(pxAccesion);
            this.userNameTextField.requestFocus();
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public String getProjectAccession() {
        return this.projectAccession;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.projectPanel = new JPanel();
        this.accessionTextField = new JTextField();
        this.accessionLabel = new JLabel();
        this.userDetailsPanel = new JPanel();
        this.userNameLabel = new JLabel();
        this.userNameTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Private Data");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PridePrivateDataDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PridePrivateDataDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.projectPanel.setBorder(BorderFactory.createTitledBorder("Project Details"));
        this.projectPanel.setOpaque(false);
        this.accessionTextField.setHorizontalAlignment(0);
        this.accessionTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PridePrivateDataDialog.this.accessionTextFieldKeyReleased(evt);
            }
        });
        this.accessionLabel.setText("Accession");
        GroupLayout projectPanelLayout = new GroupLayout(this.projectPanel);
        this.projectPanel.setLayout(projectPanelLayout);
        projectPanelLayout.setHorizontalGroup(projectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, projectPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.accessionLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.accessionTextField).addContainerGap()));
        projectPanelLayout.setVerticalGroup(projectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectPanelLayout.createSequentialGroup().addContainerGap().addGroup(projectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accessionTextField, -2, -1, -2).addComponent(this.accessionLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.userDetailsPanel.setBorder(BorderFactory.createTitledBorder("User Details"));
        this.userDetailsPanel.setOpaque(false);
        this.userNameLabel.setText("User Name");
        this.userNameTextField.setHorizontalAlignment(0);
        this.userNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PridePrivateDataDialog.this.userNameTextFieldKeyReleased(evt);
            }
        });
        this.passwordLabel.setText("Password");
        this.passwordField.setHorizontalAlignment(0);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PridePrivateDataDialog.this.passwordFieldKeyReleased(evt);
            }
        });
        GroupLayout userDetailsPanelLayout = new GroupLayout(this.userDetailsPanel);
        this.userDetailsPanel.setLayout(userDetailsPanelLayout);
        userDetailsPanelLayout.setHorizontalGroup(userDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userDetailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(userDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userDetailsPanelLayout.createSequentialGroup().addComponent(this.userNameLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.userNameTextField, -1, 363, Short.MAX_VALUE)).addGroup(userDetailsPanelLayout.createSequentialGroup().addComponent(this.passwordLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.passwordField))).addContainerGap()));
        userDetailsPanelLayout.setVerticalGroup(userDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userDetailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(userDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userNameLabel).addComponent(this.userNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(userDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.userDetailsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.projectPanel, -1, -1, Short.MAX_VALUE))).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(111, 111, 111).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap(-1, Short.MAX_VALUE)));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userDetailsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.projectAccession = null;
        this.userName = null;
        this.password = null;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.projectAccession = this.accessionTextField.getText().trim();
        this.userName = this.userNameTextField.getText().trim();
        this.password = "";
        for (int i = 0; i < this.passwordField.getPassword().length; ++i) {
            this.password = this.password + this.passwordField.getPassword()[i];
        }
        this.password = this.password.trim();
        this.dispose();
    }

    private void accessionTextFieldKeyReleased(KeyEvent evt) {
        if (this.validateInput() && evt.getKeyCode() == 10) {
            this.okButtonActionPerformed(null);
        }
    }

    private void userNameTextFieldKeyReleased(KeyEvent evt) {
        this.accessionTextFieldKeyReleased(evt);
    }

    private void passwordFieldKeyReleased(KeyEvent evt) {
        this.accessionTextFieldKeyReleased(evt);
    }

    private boolean validateInput() {
        boolean validated = !this.accessionTextField.getText().isEmpty() && !this.userNameTextField.getText().isEmpty() && this.passwordField.getPassword().length > 0;
        this.okButton.setEnabled(validated);
        return validated;
    }
}

