/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.pride;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.enzymes.EnzymeFactory;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.io.identification.MzIdentMLIdfileSearchParametersConverter;
import com.compomics.util.experiment.mass_spectrometry.proteowizard.ProteoWizardMsFormat;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.parameters.identification.pride.EnzymeParametersDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.WelcomeDialog;
import eu.isas.peptideshaker.gui.pride.PrideDataTypeSelectionDialog;
import eu.isas.peptideshaker.gui.pride.PridePrivateDataDialog;
import eu.isas.peptideshaker.gui.pride.PrideReshakeSetupDialog;
import eu.isas.peptideshaker.gui.pride.PrideSearchParametersDialog;
import eu.isas.peptideshaker.gui.pride.ProjectsFilterDialog;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.plot.PlotOrientation;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;
import uk.ac.ebi.pride.archive.web.service.model.assay.AssayDetail;
import uk.ac.ebi.pride.archive.web.service.model.assay.AssayDetailList;
import uk.ac.ebi.pride.archive.web.service.model.file.FileDetail;
import uk.ac.ebi.pride.archive.web.service.model.file.FileDetailList;
import uk.ac.ebi.pride.archive.web.service.model.project.ProjectDetail;
import uk.ac.ebi.pride.archive.web.service.model.project.ProjectDetailList;
import uk.ac.ebi.pride.jaxb.model.CvParam;
import uk.ac.ebi.pride.jaxb.model.DataProcessing;
import uk.ac.ebi.pride.jaxb.model.Description;
import uk.ac.ebi.pride.jaxb.model.FragmentIon;
import uk.ac.ebi.pride.jaxb.model.Identification;
import uk.ac.ebi.pride.jaxb.model.Param;
import uk.ac.ebi.pride.jaxb.model.PeptideItem;
import uk.ac.ebi.pride.jaxb.model.Precursor;
import uk.ac.ebi.pride.jaxb.model.Spectrum;
import uk.ac.ebi.pride.jaxb.xml.PrideXmlReader;

public class PrideReshakeGUI
extends JFrame {
    private final PeptideShakerGUI peptideShakerGUI;
    private String currentSpecies;
    private ArrayList<String> projectsTableToolTips;
    private ArrayList<String> assaysTableToolTips;
    private ArrayList<String> filesTableToolTips;
    private ProgressDialogX progressDialog;
    private URL currentPrideDataFileUrl;
    private File currentZippedPrideDataFile;
    private File currentPrideDataFile;
    private File currentMgfFile;
    private String outputFolder = "user.home";
    private Integer maxPrecursorCharge = null;
    private Integer minPrecursorCharge = null;
    private WelcomeDialog welcomeDialog;
    private ModificationFactory ptmFactory = ModificationFactory.getInstance();
    private String prideParametersReport = "";
    private ArrayList<String> speciesAll;
    private ArrayList<String> instrumentsAll;
    private ArrayList<String> tissuesAll;
    private ArrayList<String> projectTagsAll;
    private ArrayList<String> ptmsAll;
    private String[] currentFilterValues = new String[10];
    private boolean assaysGreaterThanFiler = true;
    private HashMap<String, ArrayList<String>> reshakeableFiles;
    private HashMap<String, ArrayList<String>> searchSettingsFiles;
    private static final String PROJECT_SERVICE_URL = "https://www.ebi.ac.uk/pride/ws/archive/";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String userName = null;
    private String password = null;
    private PrideReshakeSetupDialog prideReshakeSetupDialog;
    private IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();
    private HashMap<String, Integer> projectClusterAnnotation;
    private HashMap<String, Integer> assayClusterAnnotation;
    private JButton aboutButton;
    private JLabel accessPrivateDataLabel;
    private JLabel assayHelpLabel;
    private JScrollPane assayTableScrollPane;
    private JPanel assaysPanel;
    private JTable assaysTable;
    private JPanel backgroundPanel;
    private JLabel browsePublicDataLabel;
    private JLabel clearProjectFiltersLabel;
    private JLabel dataTypeSeparatorLabel;
    private JLabel downloadAllLabel;
    private JLabel downloadSelectedLabel;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JLabel filesHelpLabel;
    private JPanel filesPanel;
    private JTable filesTable;
    private JScrollPane filesTableScrollPane;
    private JMenuItem findMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JMenuBar menuBar;
    private JLabel peptideShakerPublicationLabel;
    private JLabel projectHelpLabel;
    private JLabel projectSearchLabel;
    private JPanel projectsPanel;
    private JScrollPane projectsScrollPane;
    private JTable projectsTable;
    private JCheckBox reshakableCheckBox;
    private JButton reshakeButton;

    public PrideReshakeGUI(PeptideShakerGUI peptideShakerGUI) {
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.setUpGui();
        this.setExtendedState(6);
        this.setVisible(true);
        PrideDataTypeSelectionDialog dataTypeSelectionDialog = new PrideDataTypeSelectionDialog(this, true);
        if (!dataTypeSelectionDialog.isCanceled()) {
            if (dataTypeSelectionDialog.isPublic()) {
                this.loadPublicProjects();
            } else {
                this.getPrivateProjectDetails(null);
            }
        }
    }

    public PrideReshakeGUI(PeptideShakerGUI peptideShakerGUI, String pxAccession, boolean privateData) {
        this.peptideShakerGUI = peptideShakerGUI;
        this.initComponents();
        this.setUpGui();
        this.setExtendedState(6);
        this.setVisible(true);
        if (privateData) {
            this.getPrivateProjectDetails(pxAccession);
        } else {
            this.loadSpecificProject(pxAccession);
        }
    }

    private void setUpGui() {
        this.clearProjectFiltersLabel.setVisible(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.reshakeableFiles = new HashMap();
        this.reshakeableFiles.put("RESULT", new ArrayList());
        this.reshakeableFiles.get("RESULT").add(".xml");
        this.reshakeableFiles.get("RESULT").add(".xml.gz");
        this.reshakeableFiles.get("RESULT").add(".xml.zip");
        this.reshakeableFiles.put("PEAK", new ArrayList());
        this.reshakeableFiles.get("PEAK").add(ProteoWizardMsFormat.mgf.fileNameEnding);
        this.reshakeableFiles.get("PEAK").add(ProteoWizardMsFormat.mgf.fileNameEnding + ".gz");
        this.reshakeableFiles.get("PEAK").add(ProteoWizardMsFormat.mgf.fileNameEnding + ".zip");
        this.reshakeableFiles.put("RAW", new ArrayList());
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.raw.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.raw.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.raw.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mzML.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mzML.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mzML.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mzXML.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mzXML.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mzXML.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.baf.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.baf.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.baf.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.fid.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.fid.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.fid.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.yep.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.yep.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.yep.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.d.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.d.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.d.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mz5.fileNameEnding);
        this.reshakeableFiles.put("OTHER", new ArrayList());
        this.reshakeableFiles.get("OTHER").add(ProteoWizardMsFormat.mgf.fileNameEnding);
        this.reshakeableFiles.get("OTHER").add(ProteoWizardMsFormat.mgf.fileNameEnding + ".gz");
        this.reshakeableFiles.get("OTHER").add(ProteoWizardMsFormat.mgf.fileNameEnding + ".zip");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mgf.fileNameEnding);
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mgf.fileNameEnding + ".gz");
        this.reshakeableFiles.get("RAW").add(ProteoWizardMsFormat.mgf.fileNameEnding + ".zip");
        this.searchSettingsFiles = new HashMap();
        this.searchSettingsFiles.put("RESULT", new ArrayList());
        this.searchSettingsFiles.get("RESULT").add(".xml");
        this.searchSettingsFiles.get("RESULT").add(".xml.gz");
        this.searchSettingsFiles.get("RESULT").add(".xml.zip");
        this.searchSettingsFiles.get("RESULT").add(".mzid");
        this.searchSettingsFiles.get("RESULT").add(".mzid.gz");
        this.searchSettingsFiles.get("RESULT").add(".mzid.zip");
        int fixedColumnWidth = 110;
        this.projectsTable.getColumn("Accession").setMaxWidth(fixedColumnWidth);
        this.projectsTable.getColumn("Accession").setMinWidth(fixedColumnWidth);
        this.projectsTable.getColumn(" ").setMaxWidth(50);
        this.projectsTable.getColumn(" ").setMinWidth(50);
        this.projectsTable.getColumn("#Assays").setMaxWidth(fixedColumnWidth);
        this.projectsTable.getColumn("#Assays").setMinWidth(fixedColumnWidth);
        this.projectsTable.getColumn("Date").setMaxWidth(fixedColumnWidth);
        this.projectsTable.getColumn("Date").setMinWidth(fixedColumnWidth);
        this.projectsTable.getColumn("Type").setMaxWidth(fixedColumnWidth);
        this.projectsTable.getColumn("Type").setMinWidth(fixedColumnWidth);
        this.projectsTable.getColumn("  ").setMaxWidth(30);
        this.projectsTable.getColumn("  ").setMinWidth(30);
        this.assaysTable.getColumn("Accession").setMaxWidth(fixedColumnWidth);
        this.assaysTable.getColumn("Accession").setMinWidth(fixedColumnWidth);
        this.assaysTable.getColumn(" ").setMaxWidth(50);
        this.assaysTable.getColumn(" ").setMinWidth(50);
        this.assaysTable.getColumn("#Proteins").setMaxWidth(fixedColumnWidth);
        this.assaysTable.getColumn("#Proteins").setMinWidth(fixedColumnWidth);
        this.assaysTable.getColumn("#Peptides").setMaxWidth(fixedColumnWidth);
        this.assaysTable.getColumn("#Peptides").setMinWidth(fixedColumnWidth);
        this.assaysTable.getColumn("#Spectra").setMaxWidth(fixedColumnWidth);
        this.assaysTable.getColumn("#Spectra").setMinWidth(fixedColumnWidth);
        this.assaysTable.getColumn("  ").setMaxWidth(30);
        this.assaysTable.getColumn("  ").setMinWidth(30);
        this.filesTable.getColumn("Assay").setMaxWidth(fixedColumnWidth);
        this.filesTable.getColumn("Assay").setMinWidth(fixedColumnWidth);
        this.filesTable.getColumn(" ").setMaxWidth(50);
        this.filesTable.getColumn(" ").setMinWidth(50);
        this.filesTable.getColumn("  ").setMaxWidth(30);
        this.filesTable.getColumn("  ").setMinWidth(30);
        this.filesTable.getColumn("Download").setMaxWidth(fixedColumnWidth);
        this.filesTable.getColumn("Download").setMinWidth(fixedColumnWidth);
        this.filesTable.getColumn("Type").setMaxWidth(fixedColumnWidth);
        this.filesTable.getColumn("Type").setMinWidth(fixedColumnWidth);
        this.filesTable.getColumn("Size (MB)").setMaxWidth(fixedColumnWidth);
        this.filesTable.getColumn("Size (MB)").setMinWidth(fixedColumnWidth);
        this.projectsScrollPane.getViewport().setOpaque(false);
        this.assayTableScrollPane.getViewport().setOpaque(false);
        this.filesTableScrollPane.getViewport().setOpaque(false);
        this.projectsTable.setAutoCreateRowSorter(true);
        this.assaysTable.setAutoCreateRowSorter(true);
        this.filesTable.setAutoCreateRowSorter(true);
        this.projectsTable.getTableHeader().setReorderingAllowed(false);
        this.assaysTable.getTableHeader().setReorderingAllowed(false);
        this.filesTable.getTableHeader().setReorderingAllowed(false);
        JPanel projectsCorner = new JPanel();
        projectsCorner.setBackground(this.projectsTable.getTableHeader().getBackground());
        this.projectsScrollPane.setCorner("UPPER_RIGHT_CORNER", projectsCorner);
        JPanel assayCorner = new JPanel();
        assayCorner.setBackground(this.assaysTable.getTableHeader().getBackground());
        this.assayTableScrollPane.setCorner("UPPER_RIGHT_CORNER", assayCorner);
        JPanel filesCorner = new JPanel();
        filesCorner.setBackground(this.filesTable.getTableHeader().getBackground());
        this.filesTableScrollPane.setCorner("UPPER_RIGHT_CORNER", filesCorner);
        this.projectsTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.assaysTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.filesTable.getColumn("Assay").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.filesTable.getColumn("Download").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.filesTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/accept-new.png")), null, "Reshakeable", null));
        HashMap<Integer, Color> clusterScoringColorMap = new HashMap<Integer, Color>();
        clusterScoringColorMap.put(0, this.peptideShakerGUI.getSparklineColorNotFound());
        clusterScoringColorMap.put(1, this.peptideShakerGUI.getSparklineColor());
        clusterScoringColorMap.put(2, this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorPossible());
        clusterScoringColorMap.put(3, this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful());
        clusterScoringColorMap.put(4, this.peptideShakerGUI.getSparklineColorNonValidated());
        HashMap<Integer, String> clusterScoringTooltipMap = new HashMap<Integer, String>();
        clusterScoringTooltipMap.put(0, "Not yet classified");
        clusterScoringTooltipMap.put(1, "High confidence");
        clusterScoringTooltipMap.put(2, "Good confidence");
        clusterScoringTooltipMap.put(3, "Moderate confidence");
        clusterScoringTooltipMap.put(4, "Low confidence");
        this.projectsTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(this.peptideShakerGUI.getSparklineColorNotFound(), clusterScoringColorMap, clusterScoringTooltipMap));
        this.assaysTable.getColumn("  ").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(this.peptideShakerGUI.getSparklineColorNotFound(), clusterScoringColorMap, clusterScoringTooltipMap));
        this.projectsTableToolTips = new ArrayList();
        this.projectsTableToolTips.add(null);
        this.projectsTableToolTips.add("Project Accession Number");
        this.projectsTableToolTips.add("Project Title");
        this.projectsTableToolTips.add("Project Tags");
        this.projectsTableToolTips.add("Species");
        this.projectsTableToolTips.add("Tissue Types");
        this.projectsTableToolTips.add("Post Translational Modifications");
        this.projectsTableToolTips.add("Instruments");
        this.projectsTableToolTips.add("Number of Assays");
        this.projectsTableToolTips.add("Publication Date (yyyy-mm-dd)");
        this.projectsTableToolTips.add("Project Type");
        this.projectsTableToolTips.add("Confidence Category");
        this.assaysTableToolTips = new ArrayList();
        this.assaysTableToolTips.add(null);
        this.assaysTableToolTips.add("Assay Accession Number");
        this.assaysTableToolTips.add("Assay Title");
        this.assaysTableToolTips.add("Diseases");
        this.assaysTableToolTips.add("Species");
        this.assaysTableToolTips.add("Tissues");
        this.assaysTableToolTips.add("Post Translational Modifications");
        this.assaysTableToolTips.add("Instruments");
        this.assaysTableToolTips.add("Number of Proteins");
        this.assaysTableToolTips.add("Number of Peptides");
        this.assaysTableToolTips.add("Number of Spectra");
        this.assaysTableToolTips.add("Confidence Category");
        this.filesTableToolTips = new ArrayList();
        this.filesTableToolTips.add(null);
        this.filesTableToolTips.add("Assay Accession Numbers");
        this.filesTableToolTips.add("File Type");
        this.filesTableToolTips.add("File");
        this.filesTableToolTips.add("Download File");
        this.filesTableToolTips.add("File Size (MB)");
        this.filesTableToolTips.add("Reshakeable");
        ((TitledBorder)this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Projects");
        ((TitledBorder)this.assaysPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Assays");
        ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files");
        this.getClusterAnnotations();
        this.reshakableCheckBoxActionPerformed(null);
    }

    private void getClusterAnnotations() {
        File assayAnnotationsFile;
        this.projectClusterAnnotation = new HashMap();
        this.assayClusterAnnotation = new HashMap();
        File projectAnnotationsFile = new File(PeptideShaker.getJarFilePath() + "/resources/conf/pride/project-annotation.tsv");
        if (projectAnnotationsFile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(projectAnnotationsFile));
                br.readLine();
                String line = br.readLine();
                while (line != null) {
                    String[] elements = line.split("\\t");
                    this.projectClusterAnnotation.put(elements[1], Integer.valueOf(elements[10]));
                    line = br.readLine();
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                System.out.println("An error occurred reading the project cluster annotation:");
                ex.printStackTrace();
            }
        }
        if ((assayAnnotationsFile = new File(PeptideShaker.getJarFilePath() + "/resources/conf/pride/assay-annotation.tsv")).exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(assayAnnotationsFile));
                br.readLine();
                String line = br.readLine();
                while (line != null) {
                    String[] elements = line.split("\\t");
                    this.assayClusterAnnotation.put(elements[2], Integer.parseInt(elements[11]));
                    line = br.readLine();
                }
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException ex) {
                System.out.println("An error occurred reading the sassay cluster annotation:");
                ex.printStackTrace();
            }
        }
    }

    public JTable getProjectsTable() {
        return this.projectsTable;
    }

    public PeptideShakerGUI getPeptideShakerGUI() {
        return this.peptideShakerGUI;
    }

    private void getPrivateProjectDetails(String pxAccession) {
        PridePrivateDataDialog pridePrivateDataDialog = new PridePrivateDataDialog((Frame)this, true, pxAccession);
        if (pridePrivateDataDialog.getProjectAccession() != null) {
            this.userName = pridePrivateDataDialog.getUserName();
            if (this.userName.lastIndexOf("@") == -1) {
                this.userName = this.userName + "@ebi.ac.uk";
            }
            this.password = pridePrivateDataDialog.getPassword();
            this.loadPrivateProject(pridePrivateDataDialog.getProjectAccession());
        }
    }

    private void loadPrivateProject(String projectAccession) {
        String url = "https://www.ebi.ac.uk/pride/ws/archive/project/" + projectAccession;
        try {
            this.setCursor(new Cursor(3));
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
            DefaultTableModel projectsTableModel = (DefaultTableModel)this.projectsTable.getModel();
            projectsTableModel.getDataVector().removeAllElements();
            projectsTableModel.fireTableDataChanged();
            DefaultTableModel assaysTableModel = (DefaultTableModel)this.assaysTable.getModel();
            assaysTableModel.getDataVector().removeAllElements();
            assaysTableModel.fireTableDataChanged();
            DefaultTableModel filesTableModel = (DefaultTableModel)this.filesTable.getModel();
            filesTableModel.getDataVector().removeAllElements();
            filesTableModel.fireTableDataChanged();
            ((TitledBorder)this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Projects");
            this.projectsPanel.repaint();
            ((TitledBorder)this.assaysPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Assays");
            this.projectsPanel.repaint();
            ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files");
            this.projectsPanel.repaint();
            RestTemplate template = new RestTemplate();
            ResponseEntity entity = template.exchange(url, HttpMethod.GET, this.getHttpEntity(), ProjectDetail.class, new Object[0]);
            if (entity.getStatusCode() != null && entity.getStatusCode().equals((Object)HttpStatus.OK)) {
                ProjectDetail projectDetail = (ProjectDetail)entity.getBody();
                ((DefaultTableModel)this.projectsTable.getModel()).addRow(new Object[]{this.projectsTable.getRowCount() + 1, projectDetail.getAccession(), projectDetail.getTitle(), this.setToString(projectDetail.getProjectTags(), ", "), this.setToString(projectDetail.getSpecies(), ", "), this.setToString(projectDetail.getTissues(), ", "), this.setToString(projectDetail.getPtmNames(), "; "), this.setToString(projectDetail.getInstrumentNames(), ", "), projectDetail.getNumAssays(), null, projectDetail.getSubmissionType(), 0});
                ((TitledBorder)this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Projects (" + this.projectsTable.getRowCount() + ")");
                this.projectsPanel.repaint();
                this.projectsTable.getColumn("#Assays").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(projectDetail.getNumAssays()), this.peptideShakerGUI.getSparklineColor()));
                ((JSparklinesBarChartTableCellRenderer)this.projectsTable.getColumn("#Assays").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
                ((JSparklinesBarChartTableCellRenderer)this.projectsTable.getColumn("#Assays").getCellRenderer()).setLogScale(true);
                ((JSparklinesBarChartTableCellRenderer)this.projectsTable.getColumn("#Assays").getCellRenderer()).setMinimumChartValue(2.0);
                this.projectsTable.repaint();
                if (this.projectsTable.getRowCount() > 0) {
                    this.projectsTable.setRowSelectionInterval(0, 0);
                    this.projectsTableMouseReleased(null);
                }
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                this.setCursor(new Cursor(0));
            } else {
                JOptionPane.showMessageDialog(this, "Cannot access " + projectAccession + " with the given user details.", "Access Denied", 2);
            }
        }
        catch (HttpClientErrorException e) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
            this.setCursor(new Cursor(0));
            if (e.getMessage().trim().equalsIgnoreCase("401 Unauthorized")) {
                JOptionPane.showMessageDialog(this, "Cannot access " + projectAccession + " with the given user details.", "Access Denied", 2);
            } else {
                JOptionPane.showMessageDialog(this, "Cannot access " + projectAccession + ": \n" + e.getMessage() + ".", "Access Denied", 2);
            }
        }
        catch (ResourceAccessException e) {
            JOptionPane.showMessageDialog(this, "PRIDE web service could not be reached.\n Please make sure that you are online.", "Network Error", 2);
        }
        catch (HttpMessageNotReadableException e) {
            System.out.println(url);
            e.printStackTrace();
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
            JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
        }
        catch (Exception e) {
            System.out.println(url);
            e.printStackTrace();
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
            JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://groups.google.com/group/peptide-shaker\">PeptideShaker developers</a>."), "PRIDE Access Error", 2);
        }
        this.enableReshake();
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.projectsPanel = new JPanel();
        this.projectsScrollPane = new JScrollPane();
        this.projectsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PrideReshakeGUI.this.projectsTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.accessPrivateDataLabel = new JLabel();
        this.projectHelpLabel = new JLabel();
        this.browsePublicDataLabel = new JLabel();
        this.dataTypeSeparatorLabel = new JLabel();
        this.clearProjectFiltersLabel = new JLabel();
        this.projectSearchLabel = new JLabel();
        this.assaysPanel = new JPanel();
        this.assayTableScrollPane = new JScrollPane();
        this.assaysTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PrideReshakeGUI.this.assaysTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.assayHelpLabel = new JLabel();
        this.reshakeButton = new JButton();
        this.filesPanel = new JPanel();
        this.filesTableScrollPane = new JScrollPane();
        this.filesTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)PrideReshakeGUI.this.filesTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.filesHelpLabel = new JLabel();
        this.reshakableCheckBox = new JCheckBox();
        this.downloadAllLabel = new JLabel();
        this.downloadSelectedLabel = new JLabel();
        this.aboutButton = new JButton();
        this.peptideShakerPublicationLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.findMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("PRIDE Reshake");
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.projectsPanel.setBorder(BorderFactory.createTitledBorder("PRIDE Projects"));
        this.projectsPanel.setOpaque(false);
        this.projectsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Accession", "Title", "Tags", "Species", "Tissues", "PTMs", "Instruments", "#Assays", "Date", "Type", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, String.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.projectsTable.setSelectionMode(0);
        this.projectsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PrideReshakeGUI.this.projectsTableMouseMoved(evt);
            }
        });
        this.projectsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.projectsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeGUI.this.projectsTableMouseReleased(evt);
            }
        });
        this.projectsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PrideReshakeGUI.this.projectsTableKeyReleased(evt);
            }
        });
        this.projectsScrollPane.setViewportView(this.projectsTable);
        this.accessPrivateDataLabel.setText("<html><a href=\"dummy\">Access Private Data</a></html>\n\n");
        this.accessPrivateDataLabel.setToolTipText("Access private data");
        this.accessPrivateDataLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeGUI.this.accessPrivateDataLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.accessPrivateDataLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.accessPrivateDataLabelMouseExited(evt);
            }
        });
        this.projectHelpLabel.setFont(new Font("Tahoma", 2, 11));
        this.projectHelpLabel.setText("Select a project to see the project details. For more details click the Accession links.");
        this.browsePublicDataLabel.setText("<html><a href=\"dummy\">Browse Public Data</a></html>  ");
        this.browsePublicDataLabel.setToolTipText("Browse all public data");
        this.browsePublicDataLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeGUI.this.browsePublicDataLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.browsePublicDataLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.browsePublicDataLabelMouseExited(evt);
            }
        });
        this.dataTypeSeparatorLabel.setText("/");
        this.clearProjectFiltersLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/error-new.png")));
        this.clearProjectFiltersLabel.setText("<html><a href=\"dummy\">Clear Project Filters</a></html>  ");
        this.clearProjectFiltersLabel.setToolTipText("Clear all project filters");
        this.clearProjectFiltersLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeGUI.this.clearProjectFiltersLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.clearProjectFiltersLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.clearProjectFiltersLabelMouseExited(evt);
            }
        });
        this.projectSearchLabel.setText("<html><a href=\\\"dummy\\\">Project Search</a></html>");
        this.projectSearchLabel.setToolTipText("Open Project Search Dialog");
        this.projectSearchLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.projectSearchLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.projectSearchLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeGUI.this.projectSearchLabelMouseReleased(evt);
            }
        });
        GroupLayout projectsPanelLayout = new GroupLayout(this.projectsPanel);
        this.projectsPanel.setLayout(projectsPanelLayout);
        projectsPanelLayout.setHorizontalGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectsPanelLayout.createSequentialGroup().addContainerGap().addGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectsScrollPane).addGroup(projectsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.projectHelpLabel).addGap(18, 18, 18).addComponent(this.projectSearchLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clearProjectFiltersLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 203, Short.MAX_VALUE).addComponent(this.browsePublicDataLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dataTypeSeparatorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accessPrivateDataLabel, -2, -1, -2).addGap(10, 10, 10))).addContainerGap()));
        projectsPanelLayout.setVerticalGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(projectsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectsScrollPane, -1, 110, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.accessPrivateDataLabel, -2, -1, -2).addComponent(this.projectHelpLabel).addComponent(this.browsePublicDataLabel, -2, -1, -2).addComponent(this.dataTypeSeparatorLabel).addComponent(this.clearProjectFiltersLabel, -2, -1, -2).addComponent(this.projectSearchLabel, -2, -1, -2)).addContainerGap()));
        this.assaysPanel.setBorder(BorderFactory.createTitledBorder("Assays"));
        this.assaysPanel.setOpaque(false);
        this.assaysTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Accession", "Title", "Diseases", "Species", "Tissues", "PTMs", "Instruments", "#Proteins", "#Peptides", "#Spectra", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.assaysTable.setOpaque(false);
        this.assaysTable.setSelectionMode(0);
        this.assaysTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PrideReshakeGUI.this.assaysTableMouseMoved(evt);
            }
        });
        this.assaysTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.assaysTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeGUI.this.assaysTableMouseReleased(evt);
            }
        });
        this.assaysTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PrideReshakeGUI.this.assaysTableKeyReleased(evt);
            }
        });
        this.assayTableScrollPane.setViewportView(this.assaysTable);
        this.assayHelpLabel.setFont(new Font("Tahoma", 2, 11));
        this.assayHelpLabel.setText("Select an assay to see the corresponding files. For more details click the Assay links.");
        GroupLayout assaysPanelLayout = new GroupLayout(this.assaysPanel);
        this.assaysPanel.setLayout(assaysPanelLayout);
        assaysPanelLayout.setHorizontalGroup(assaysPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(assaysPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(assaysPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.assayTableScrollPane).addGroup(assaysPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.assayHelpLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        assaysPanelLayout.setVerticalGroup(assaysPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(assaysPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.assayTableScrollPane, -1, 111, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assayHelpLabel).addContainerGap()));
        this.reshakeButton.setBackground(new Color(0, 153, 0));
        this.reshakeButton.setFont(this.reshakeButton.getFont().deriveFont(this.reshakeButton.getFont().getStyle() | 1));
        this.reshakeButton.setForeground(new Color(255, 255, 255));
        this.reshakeButton.setText("Reshake PRIDE Data");
        this.reshakeButton.setEnabled(false);
        this.reshakeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeGUI.this.reshakeButtonActionPerformed(evt);
            }
        });
        this.filesPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        this.filesPanel.setOpaque(false);
        this.filesTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Assay", "Type", "File", "Download", "Size (MB)", "  "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, String.class, Long.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.filesTable.setOpaque(false);
        this.filesTable.setSelectionMode(2);
        this.filesTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PrideReshakeGUI.this.filesTableMouseMoved(evt);
            }
        });
        this.filesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.filesTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeGUI.this.filesTableMouseReleased(evt);
            }
        });
        this.filesTableScrollPane.setViewportView(this.filesTable);
        this.filesHelpLabel.setFont(new Font("Tahoma", 2, 11));
        this.filesHelpLabel.setText("Click Reshake PRIDE Data to start re-analyzing. Supported formats: peak lists, raw data and PRIDE XML.");
        this.reshakableCheckBox.setSelected(true);
        this.reshakableCheckBox.setText("Reshakeable Files Only");
        this.reshakableCheckBox.setToolTipText("Show only files that can be re-analyzed");
        this.reshakableCheckBox.setIconTextGap(10);
        this.reshakableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeGUI.this.reshakableCheckBoxActionPerformed(evt);
            }
        });
        this.downloadAllLabel.setText("<html><a href=\\\"dummy\\\">Download All</a></html>");
        this.downloadAllLabel.setToolTipText("Download all files in the table");
        this.downloadAllLabel.setEnabled(false);
        this.downloadAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.downloadAllLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.downloadAllLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeGUI.this.downloadAllLabelMouseReleased(evt);
            }
        });
        this.downloadSelectedLabel.setText("<html><a href=\\\"dummy\\\">Download Selected</a></html>");
        this.downloadSelectedLabel.setToolTipText("Download the selected files in the table");
        this.downloadSelectedLabel.setEnabled(false);
        this.downloadSelectedLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.downloadSelectedLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.downloadSelectedLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PrideReshakeGUI.this.downloadSelectedLabelMouseReleased(evt);
            }
        });
        GroupLayout filesPanelLayout = new GroupLayout(this.filesPanel);
        this.filesPanel.setLayout(filesPanelLayout);
        filesPanelLayout.setHorizontalGroup(filesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filesPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.filesHelpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.downloadSelectedLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.downloadAllLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.reshakableCheckBox).addGap(20, 20, 20)).addGroup(filesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filesTableScrollPane).addContainerGap()));
        filesPanelLayout.setVerticalGroup(filesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.filesTableScrollPane, -1, 123, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filesHelpLabel).addComponent(this.reshakableCheckBox).addComponent(this.downloadAllLabel, -2, -1, -2).addComponent(this.downloadSelectedLabel, -2, -1, -2)).addContainerGap()));
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptide-shaker-medium-orange-shadow.png")));
        this.aboutButton.setToolTipText("Open the PeptideShaker web page");
        this.aboutButton.setBorder(null);
        this.aboutButton.setBorderPainted(false);
        this.aboutButton.setContentAreaFilled(false);
        this.aboutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.aboutButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.aboutButtonMouseExited(evt);
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeGUI.this.aboutButtonActionPerformed(evt);
            }
        });
        this.peptideShakerPublicationLabel.setText("<html>Please cite PeptideShaker as <a href=\"https://www.nature.com/nbt/journal/v33/n1/full/nbt.3109.html\">Vaudel <i>et al.</i>: Nature Biotechnol. 2015 Jan;33(1):22\u201324</a>.</html>\n\n");
        this.peptideShakerPublicationLabel.setToolTipText("Open the PeptideShaker publication");
        this.peptideShakerPublicationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PrideReshakeGUI.this.peptideShakerPublicationLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                PrideReshakeGUI.this.peptideShakerPublicationLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PrideReshakeGUI.this.peptideShakerPublicationLabelMouseExited(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.aboutButton).addGap(48, 48, 48).addComponent(this.peptideShakerPublicationLabel, -2, 564, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reshakeButton).addGap(14, 14, 14)).addComponent(this.assaysPanel, -1, -1, Short.MAX_VALUE).addComponent(this.projectsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.filesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.projectsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assaysPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filesPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reshakeButton, -2, 53, -2).addComponent(this.peptideShakerPublicationLabel, -2, 45, -2)).addComponent(this.aboutButton)).addContainerGap()));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeGUI.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('E');
        this.editMenu.setText("Edit");
        this.findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.findMenuItem.setMnemonic('F');
        this.findMenuItem.setText("Find...");
        this.findMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeGUI.this.findMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.findMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setMnemonic('H');
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideReshakeGUI.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void projectsTableMouseReleased(MouseEvent evt) {
        this.updateAssayList();
        this.updateProjectFileList();
        if (evt != null) {
            int row = this.projectsTable.getSelectedRow();
            int column = this.projectsTable.getSelectedColumn();
            if (column == this.projectsTable.getColumn("Accession").getModelIndex() && evt.getButton() == 1 && ((String)this.projectsTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String link = (String)this.projectsTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(link);
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void projectsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void projectsTableMouseMoved(MouseEvent evt) {
        int row = this.projectsTable.rowAtPoint(evt.getPoint());
        int column = this.projectsTable.columnAtPoint(evt.getPoint());
        this.projectsTable.setToolTipText(null);
        if (row != -1 && column != -1 && column == this.projectsTable.getColumn("Accession").getModelIndex() && this.projectsTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.projectsTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void projectsTableKeyReleased(KeyEvent evt) {
        if (evt.getModifiers() != 2) {
            this.updateProjectFileList();
            this.updateAssayList();
        }
    }

    private void assaysTableMouseReleased(MouseEvent evt) {
        this.updateAssayFileList();
        if (evt != null) {
            int row = this.assaysTable.getSelectedRow();
            int column = this.assaysTable.getSelectedColumn();
            if (column == this.assaysTable.getColumn("Accession").getModelIndex() && evt.getButton() == 1 && ((String)this.assaysTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String link = (String)this.assaysTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(link);
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void assaysTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void assaysTableMouseMoved(MouseEvent evt) {
        int row = this.assaysTable.rowAtPoint(evt.getPoint());
        int column = this.assaysTable.columnAtPoint(evt.getPoint());
        this.assaysTable.setToolTipText(null);
        if (row != -1 && column != -1 && column == this.assaysTable.getColumn("Accession").getModelIndex() && this.assaysTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.assaysTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void assaysTableKeyReleased(KeyEvent evt) {
        this.updateAssayFileList();
    }

    private void reshakeButtonActionPerformed(ActionEvent evt) {
        this.prideReshakeSetupDialog = new PrideReshakeSetupDialog(this, true);
    }

    private void filesTableMouseReleased(MouseEvent evt) {
        if (evt != null) {
            int row = this.filesTable.getSelectedRow();
            int column = this.filesTable.getSelectedColumn();
            if (column == this.filesTable.getColumn("Assay").getModelIndex() && evt.getButton() == 1 && ((String)this.filesTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String link = (String)this.filesTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(link);
                this.setCursor(new Cursor(0));
            } else if (column == this.filesTable.getColumn("Download").getModelIndex() && evt.getButton() == 1 && ((String)this.filesTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                ArrayList<Integer> fileRowIndexes = new ArrayList<Integer>();
                fileRowIndexes.add(row);
                this.downloadFiles(fileRowIndexes);
            }
        }
    }

    private void filesTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void filesTableMouseMoved(MouseEvent evt) {
        int row = this.filesTable.rowAtPoint(evt.getPoint());
        int column = this.filesTable.columnAtPoint(evt.getPoint());
        this.filesTable.setToolTipText(null);
        if (row != -1 && column != -1 && (column == this.filesTable.getColumn("Assay").getModelIndex() || column == this.filesTable.getColumn("Download").getModelIndex()) && this.filesTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.filesTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void aboutButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void aboutButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://compomics.github.io/projects/peptide-shaker.html");
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerPublicationLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.nature.com/nbt/journal/v33/n1/full/nbt.3109.html");
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerPublicationLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerPublicationLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void findMenuItemActionPerformed(ActionEvent evt) {
        new ProjectsFilterDialog(this, false, this.currentFilterValues, this.assaysGreaterThanFiler, true, this.speciesAll, this.tissuesAll, this.instrumentsAll, this.ptmsAll, this.projectTagsAll);
    }

    private void accessPrivateDataLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void accessPrivateDataLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void accessPrivateDataLabelMouseClicked(MouseEvent evt) {
        this.getPrivateProjectDetails(null);
        this.clearProjectFiltersLabelMouseClicked(null);
    }

    private void browsePublicDataLabelMouseClicked(MouseEvent evt) {
        this.userName = null;
        this.password = null;
        this.loadPublicProjects();
        this.clearProjectFiltersLabelMouseClicked(null);
    }

    private void browsePublicDataLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void browsePublicDataLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void reshakableCheckBoxActionPerformed(ActionEvent evt) {
        ArrayList<29> filters = new ArrayList<29>();
        RowFilter<Object, Object> reshakeableFilter = new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                if (!PrideReshakeGUI.this.reshakableCheckBox.isSelected()) {
                    return true;
                }
                return (Boolean)entry.getValue(PrideReshakeGUI.this.filesTable.getColumn("  ").getModelIndex());
            }
        };
        filters.add(reshakeableFilter);
        RowFilter allFilters = RowFilter.andFilter(filters);
        if (this.filesTable.getRowSorter() != null) {
            ((TableRowSorter)this.filesTable.getRowSorter()).setRowFilter(allFilters);
            if (this.filesTable.getRowCount() > 0) {
                this.filesTable.setRowSelectionInterval(0, 0);
            }
        }
        this.downloadAllLabel.setEnabled(this.filesTable.getRowCount() > 0);
        this.downloadSelectedLabel.setEnabled(this.filesTable.getRowCount() > 0);
        for (int i = 0; i < this.filesTable.getRowCount(); ++i) {
            this.filesTable.setValueAt(i + 1, i, 0);
        }
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog(this, this.getClass().getResource("/helpFiles/PrideReshake.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "PRIDE Reshake - Help");
    }

    private void clearProjectFiltersLabelMouseClicked(MouseEvent evt) {
        ((TableRowSorter)this.projectsTable.getRowSorter()).setRowFilter(null);
        this.showProjectFilterRemovalOption(false);
        this.clearProjectFiltersLabel.setVisible(false);
        this.updateProjectTableSelection();
        String[] tempFilterValues = new String[10];
        this.setCurrentFilterValues(tempFilterValues, true);
    }

    private void clearProjectFiltersLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void clearProjectFiltersLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void projectSearchLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void projectSearchLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void projectSearchLabelMouseReleased(MouseEvent evt) {
        this.findMenuItemActionPerformed(null);
    }

    private void downloadAllLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void downloadAllLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void downloadAllLabelMouseReleased(MouseEvent evt) {
        ArrayList<Integer> fileRowIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.filesTable.getRowCount(); ++i) {
            fileRowIndexes.add(i);
        }
        this.downloadFiles(fileRowIndexes);
    }

    private void downloadSelectedLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void downloadSelectedLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void downloadSelectedLabelMouseReleased(MouseEvent evt) {
        ArrayList<Integer> fileRowIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.filesTable.getSelectedRows().length; ++i) {
            fileRowIndexes.add(this.filesTable.getSelectedRows()[i]);
        }
        this.downloadFiles(fileRowIndexes);
    }

    private void updateProjectFileList() {
        this.setCursor(new Cursor(3));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
        DefaultTableModel filesTableModel = (DefaultTableModel)this.filesTable.getModel();
        filesTableModel.getDataVector().removeAllElements();
        filesTableModel.fireTableDataChanged();
        this.reshakeButton.setEnabled(false);
        this.downloadAllLabel.setEnabled(false);
        this.downloadSelectedLabel.setEnabled(false);
        String projectAccession = null;
        int selectedRow = this.projectsTable.getSelectedRow();
        double maxFileSize = 0.0;
        if (selectedRow != -1) {
            projectAccession = (String)this.projectsTable.getValueAt(selectedRow, 1);
            if (this.password == null) {
                projectAccession = projectAccession.substring(projectAccession.lastIndexOf("\">") + 2, projectAccession.lastIndexOf("</font"));
            }
            RestTemplate template = new RestTemplate();
            String url = "https://www.ebi.ac.uk/pride/ws/archive/file/list/project/" + projectAccession;
            try {
                ResponseEntity fileDetailListResult = this.password != null ? template.exchange(url, HttpMethod.GET, this.getHttpEntity(), FileDetailList.class, new Object[0]) : template.getForEntity(url, FileDetailList.class, new Object[0]);
                int reshakeableCounter = 0;
                int prideMissingFiles = 0;
                for (FileDetail fileDetail : ((FileDetailList)fileDetailListResult.getBody()).getList()) {
                    String fileDownloadLink = null;
                    if (fileDetail.getDownloadLink() != null) {
                        fileDownloadLink = "<html><a href=\"" + fileDetail.getDownloadLink().toExternalForm() + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">Download</font></a><html>";
                    } else if (this.password != null) {
                        fileDownloadLink = "<html><a href=\"https://www.ebi.ac.uk/pride/ws/archive/file/" + projectAccession + "/" + fileDetail.getFileName() + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">Download</font></a><html>";
                    }
                    String assayAccession = fileDetail.getAssayAccession();
                    if (this.password == null) {
                        assayAccession = "<html><a href=\"" + DisplayFeaturesGenerator.getPrideAssayArchiveLink(fileDetail.getProjectAccession(), fileDetail.getAssayAccession()) + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">" + fileDetail.getAssayAccession() + "</font></a><html>";
                    }
                    boolean reshakeable = false;
                    if (this.reshakeableFiles.containsKey(fileDetail.getFileType().getName())) {
                        for (String fileEnding : this.reshakeableFiles.get(fileDetail.getFileType().getName())) {
                            if (fileDetail.getFileName().toLowerCase().endsWith(".pride.mgf.gz") || fileDetail.getFileName().toLowerCase().endsWith(".pride.mztab.gz")) {
                                ++prideMissingFiles;
                                reshakeable = false;
                                break;
                            }
                            if (!fileDetail.getFileName().toLowerCase().endsWith(fileEnding)) continue;
                            reshakeable = true;
                            ++reshakeableCounter;
                            break;
                        }
                    }
                    if (fileDetail.getFileName().toLowerCase().endsWith(".pride.mgf.gz") || fileDetail.getFileName().toLowerCase().endsWith(".pride.mztab.gz")) continue;
                    float fileSize = (float)fileDetail.getFileSize() / 1048576.0f;
                    ((DefaultTableModel)this.filesTable.getModel()).addRow(new Object[]{this.filesTable.getRowCount() + 1, assayAccession, fileDetail.getFileType().getName(), fileDetail.getFileName(), fileDownloadLink, Util.roundDouble(fileSize, 2), reshakeable});
                    if (!((double)fileSize > maxFileSize)) continue;
                    maxFileSize = fileSize;
                }
                if (projectAccession != null) {
                    ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files for " + projectAccession + " (" + reshakeableCounter + "/" + (((FileDetailList)fileDetailListResult.getBody()).getList().size() - prideMissingFiles) + ")");
                } else {
                    ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files (" + reshakeableCounter + "/" + (((FileDetailList)fileDetailListResult.getBody()).getList().size() - prideMissingFiles) + ")");
                }
                this.filesPanel.repaint();
            }
            catch (HttpServerErrorException e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
            }
            catch (ResourceAccessException e) {
                JOptionPane.showMessageDialog(this, "PRIDE web service could not be reached.\n Please make sure that you are online.", "Network Error", 2);
            }
            catch (HttpMessageNotReadableException e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
            }
            catch (Exception e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://groups.google.com/group/peptide-shaker\">PeptideShaker developers</a>."), "PRIDE Access Error", 2);
            }
            if (maxFileSize < 1.0) {
                maxFileSize = 1.0;
            }
            this.filesTable.getColumn("Size (MB)").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxFileSize), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.filesTable.getColumn("Size (MB)").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
            ((JSparklinesBarChartTableCellRenderer)this.filesTable.getColumn("Size (MB)").getCellRenderer()).setLogScale(true);
            ((JSparklinesBarChartTableCellRenderer)this.filesTable.getColumn("Size (MB)").getCellRenderer()).setMinimumChartValue(1.0);
        } else {
            if (projectAccession != null) {
                ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files for " + projectAccession + " (0)");
            } else {
                ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files (0)");
            }
            this.filesPanel.repaint();
        }
        if (this.filesTable.getRowCount() > 0) {
            this.filesTable.scrollRectToVisible(this.filesTable.getCellRect(0, 0, false));
        }
        this.downloadAllLabel.setEnabled(this.filesTable.getRowCount() > 0);
        this.downloadSelectedLabel.setEnabled(this.filesTable.getRowCount() > 0);
        this.enableReshake();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.setCursor(new Cursor(0));
    }

    private void updateAssayFileList() {
        this.setCursor(new Cursor(3));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
        DefaultTableModel filesTableModel = (DefaultTableModel)this.filesTable.getModel();
        filesTableModel.getDataVector().removeAllElements();
        filesTableModel.fireTableDataChanged();
        this.reshakeButton.setEnabled(false);
        this.downloadAllLabel.setEnabled(false);
        this.downloadSelectedLabel.setEnabled(false);
        String assayAccession = null;
        int selectedRow = this.assaysTable.getSelectedRow();
        if (selectedRow != -1) {
            assayAccession = (String)this.assaysTable.getValueAt(selectedRow, 1);
            if (this.password == null) {
                assayAccession = assayAccession.substring(assayAccession.lastIndexOf("\">") + 2, assayAccession.lastIndexOf("</font"));
            }
            RestTemplate template = new RestTemplate();
            String url = "https://www.ebi.ac.uk/pride/ws/archive/file/list/assay/" + assayAccession;
            try {
                ResponseEntity fileDetailListResult = this.password != null ? template.exchange(url, HttpMethod.GET, this.getHttpEntity(), FileDetailList.class, new Object[0]) : template.getForEntity(url, FileDetailList.class, new Object[0]);
                int reshakeableCounter = 0;
                int prideMissingFiles = 0;
                for (FileDetail fileDetail : ((FileDetailList)fileDetailListResult.getBody()).getList()) {
                    String fileDownloadLink = null;
                    if (fileDetail.getDownloadLink() != null) {
                        fileDownloadLink = "<html><a href=\"" + fileDetail.getDownloadLink().toExternalForm() + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">Download</font></a><html>";
                    } else if (this.password != null) {
                        fileDownloadLink = "<html><a href=\"https://www.ebi.ac.uk/pride/ws/archive/file/" + fileDetail.getProjectAccession() + "/" + fileDetail.getFileName() + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">Download</font></a><html>";
                    }
                    String assayAccessionLink = fileDetail.getAssayAccession();
                    if (this.password == null) {
                        assayAccessionLink = "<html><a href=\"" + DisplayFeaturesGenerator.getPrideAssayArchiveLink(fileDetail.getProjectAccession(), fileDetail.getAssayAccession()) + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">" + fileDetail.getAssayAccession() + "</font></a><html>";
                    }
                    boolean reshakeable = false;
                    if (this.reshakeableFiles.containsKey(fileDetail.getFileType().getName())) {
                        for (String fileEnding : this.reshakeableFiles.get(fileDetail.getFileType().getName())) {
                            if (fileDetail.getFileName().toLowerCase().endsWith(".pride.mgf.gz") || fileDetail.getFileName().toLowerCase().endsWith(".pride.mztab.gz")) {
                                ++prideMissingFiles;
                                reshakeable = false;
                                break;
                            }
                            if (!fileDetail.getFileName().toLowerCase().endsWith(fileEnding)) continue;
                            reshakeable = true;
                            ++reshakeableCounter;
                            break;
                        }
                    }
                    if (fileDetail.getFileName().toLowerCase().endsWith(".pride.mgf.gz") || fileDetail.getFileName().toLowerCase().endsWith(".pride.mztab.gz")) continue;
                    ((DefaultTableModel)this.filesTable.getModel()).addRow(new Object[]{this.filesTable.getRowCount() + 1, assayAccessionLink, fileDetail.getFileType().getName(), fileDetail.getFileName(), fileDownloadLink, Util.roundDouble((float)fileDetail.getFileSize() / 1048576.0f, 2), reshakeable});
                }
                if (assayAccession != null) {
                    ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files for Assay " + assayAccession + " (" + reshakeableCounter + "/" + (((FileDetailList)fileDetailListResult.getBody()).getList().size() - prideMissingFiles) + ")");
                } else {
                    ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files (" + reshakeableCounter + "/" + (((FileDetailList)fileDetailListResult.getBody()).getList().size() - prideMissingFiles) + ")");
                }
                this.filesPanel.repaint();
            }
            catch (HttpServerErrorException e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
            }
            catch (ResourceAccessException e) {
                JOptionPane.showMessageDialog(this, "PRIDE web service could not be reached.\n Please make sure that you are online.", "Network Error", 2);
            }
            catch (HttpMessageNotReadableException e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
            }
            catch (Exception e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://groups.google.com/group/peptide-shaker\">PeptideShaker developers</a>."), "PRIDE Access Error", 2);
            }
        } else {
            if (assayAccession != null) {
                ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files for Assay " + assayAccession + " (0)");
            } else {
                ((TitledBorder)this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files (0)");
            }
            this.filesPanel.repaint();
        }
        if (this.filesTable.getRowCount() > 0) {
            this.filesTable.scrollRectToVisible(this.filesTable.getCellRect(0, 0, false));
        }
        this.downloadAllLabel.setEnabled(this.filesTable.getRowCount() > 0);
        this.downloadSelectedLabel.setEnabled(this.filesTable.getRowCount() > 0);
        this.enableReshake();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.setCursor(new Cursor(0));
    }

    private void updateAssayList() {
        this.setCursor(new Cursor(3));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
        DefaultTableModel assaysTableModel = (DefaultTableModel)this.assaysTable.getModel();
        assaysTableModel.getDataVector().removeAllElements();
        assaysTableModel.fireTableDataChanged();
        String projectAccession = null;
        int selectedRow = this.projectsTable.getSelectedRow();
        if (selectedRow != -1) {
            projectAccession = (String)this.projectsTable.getValueAt(selectedRow, 1);
            if (this.password == null) {
                projectAccession = projectAccession.substring(projectAccession.lastIndexOf("\">") + 2, projectAccession.lastIndexOf("</font"));
            }
            double maxNumProteins = 0.0;
            double maxNumPeptides = 0.0;
            double maxNumSpectra = 0.0;
            RestTemplate template = new RestTemplate();
            String url = "https://www.ebi.ac.uk/pride/ws/archive/assay/list/project/" + projectAccession;
            try {
                ResponseEntity assayDetailList = this.password != null ? template.exchange(url, HttpMethod.GET, this.getHttpEntity(), AssayDetailList.class, new Object[0]) : template.getForEntity(url, AssayDetailList.class, new Object[0]);
                for (AssayDetail assayDetail : ((AssayDetailList)assayDetailList.getBody()).getList()) {
                    String assayAccession = assayDetail.getAssayAccession();
                    int assayCategory = 0;
                    if (this.assayClusterAnnotation.containsKey(assayAccession)) {
                        assayCategory = this.assayClusterAnnotation.get(assayAccession);
                    }
                    if (this.password == null) {
                        assayAccession = "<html><a href=\"" + DisplayFeaturesGenerator.getPrideAssayArchiveLink(assayDetail.getProjectAccession(), assayDetail.getAssayAccession()) + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">" + assayDetail.getAssayAccession() + "</font></a><html>";
                    }
                    ((DefaultTableModel)this.assaysTable.getModel()).addRow(new Object[]{this.assaysTable.getRowCount() + 1, assayAccession, assayDetail.getTitle(), this.setToString(assayDetail.getDiseases(), ", "), this.setToString(assayDetail.getSpecies(), ", "), this.setToString(assayDetail.getSampleDetails(), ", "), this.setToString(assayDetail.getPtmNames(), "; "), this.setToString(assayDetail.getInstrumentNames(), ", "), assayDetail.getProteinCount(), assayDetail.getPeptideCount(), assayDetail.getTotalSpectrumCount(), assayCategory});
                    if ((double)assayDetail.getProteinCount() > maxNumProteins) {
                        maxNumProteins = assayDetail.getProteinCount();
                    }
                    if ((double)assayDetail.getPeptideCount() > maxNumPeptides) {
                        maxNumPeptides = assayDetail.getPeptideCount();
                    }
                    if (!((double)assayDetail.getTotalSpectrumCount() > maxNumSpectra)) continue;
                    maxNumSpectra = assayDetail.getTotalSpectrumCount();
                }
            }
            catch (HttpServerErrorException e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
            }
            catch (ResourceAccessException e) {
                JOptionPane.showMessageDialog(this, "PRIDE web service could not be reached.\n Please make sure that you are online.", "Network Error", 2);
            }
            catch (HttpMessageNotReadableException e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
            }
            catch (Exception e) {
                System.out.println(url);
                e.printStackTrace();
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://groups.google.com/group/peptide-shaker\">PeptideShaker developers</a>."), "PRIDE Access Error", 2);
            }
            this.assaysTable.getColumn("#Proteins").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxNumProteins), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Proteins").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Proteins").getCellRenderer()).setLogScale(true);
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Proteins").getCellRenderer()).setMinimumChartValue(2.0);
            this.assaysTable.getColumn("#Peptides").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxNumPeptides), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Peptides").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Peptides").getCellRenderer()).setLogScale(true);
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Peptides").getCellRenderer()).setMinimumChartValue(2.0);
            this.assaysTable.getColumn("#Spectra").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxNumSpectra), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Spectra").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Spectra").getCellRenderer()).setLogScale(true);
            ((JSparklinesBarChartTableCellRenderer)this.assaysTable.getColumn("#Spectra").getCellRenderer()).setMinimumChartValue(2.0);
        }
        if (this.assaysTable.getRowCount() > 0) {
            this.assaysTable.scrollRectToVisible(this.assaysTable.getCellRect(0, 0, false));
        }
        if (projectAccession != null) {
            ((TitledBorder)this.assaysPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Assays for " + projectAccession + " (" + this.assaysTable.getRowCount() + ")");
        } else {
            ((TitledBorder)this.assaysPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Assays (" + this.assaysTable.getRowCount() + ")");
        }
        this.assaysPanel.repaint();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
        this.setCursor(new Cursor(0));
    }

    private void loadSpecificProject(final String pxAccession) {
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading PRIDE Project. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PrideReshakeGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                DefaultTableModel projectsTableModel = (DefaultTableModel)PrideReshakeGUI.this.projectsTable.getModel();
                projectsTableModel.getDataVector().removeAllElements();
                projectsTableModel.fireTableDataChanged();
                DefaultTableModel assayTableModel = (DefaultTableModel)PrideReshakeGUI.this.assaysTable.getModel();
                assayTableModel.getDataVector().removeAllElements();
                assayTableModel.fireTableDataChanged();
                DefaultTableModel filesTableModel = (DefaultTableModel)PrideReshakeGUI.this.filesTable.getModel();
                filesTableModel.getDataVector().removeAllElements();
                filesTableModel.fireTableDataChanged();
                double maxNumAssays = 0.0;
                String url = "https://www.ebi.ac.uk/pride/ws/archive/project/" + pxAccession;
                RestTemplate template = new RestTemplate();
                try {
                    PrideReshakeGUI.this.speciesAll = new ArrayList();
                    PrideReshakeGUI.this.instrumentsAll = new ArrayList();
                    PrideReshakeGUI.this.ptmsAll = new ArrayList();
                    PrideReshakeGUI.this.tissuesAll = new ArrayList();
                    PrideReshakeGUI.this.projectTagsAll = new ArrayList();
                    ResponseEntity projectDetail = template.getForEntity(url, ProjectDetail.class, new Object[0]);
                    String projectAccession = ((ProjectDetail)projectDetail.getBody()).getAccession();
                    int projectCategory = 0;
                    if (PrideReshakeGUI.this.projectClusterAnnotation.containsKey(projectAccession)) {
                        projectCategory = (Integer)PrideReshakeGUI.this.projectClusterAnnotation.get(projectAccession);
                    }
                    ((DefaultTableModel)PrideReshakeGUI.this.projectsTable.getModel()).addRow(new Object[]{PrideReshakeGUI.this.projectsTable.getRowCount() + 1, "<html><a href=\"" + DisplayFeaturesGenerator.getPrideProjectArchiveLink("" + ((ProjectDetail)projectDetail.getBody()).getAccession()) + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">" + ((ProjectDetail)projectDetail.getBody()).getAccession() + "</font></a><html>", ((ProjectDetail)projectDetail.getBody()).getTitle(), PrideReshakeGUI.this.setToString(((ProjectDetail)projectDetail.getBody()).getProjectTags(), ", "), PrideReshakeGUI.this.setToString(((ProjectDetail)projectDetail.getBody()).getSpecies(), ", "), PrideReshakeGUI.this.setToString(((ProjectDetail)projectDetail.getBody()).getTissues(), ", "), PrideReshakeGUI.this.setToString(((ProjectDetail)projectDetail.getBody()).getPtmNames(), "; "), PrideReshakeGUI.this.setToString(((ProjectDetail)projectDetail.getBody()).getInstrumentNames(), ", "), ((ProjectDetail)projectDetail.getBody()).getNumAssays(), PrideReshakeGUI.this.dateFormat.format(((ProjectDetail)projectDetail.getBody()).getPublicationDate()), ((ProjectDetail)projectDetail.getBody()).getSubmissionType(), projectCategory});
                    if ((double)((ProjectDetail)projectDetail.getBody()).getNumAssays() > maxNumAssays) {
                        maxNumAssays = ((ProjectDetail)projectDetail.getBody()).getNumAssays();
                    }
                    for (String species : ((ProjectDetail)projectDetail.getBody()).getSpecies()) {
                        if (PrideReshakeGUI.this.speciesAll.contains(species)) continue;
                        PrideReshakeGUI.this.speciesAll.add(species);
                    }
                    for (String instrument : ((ProjectDetail)projectDetail.getBody()).getInstrumentNames()) {
                        if (PrideReshakeGUI.this.instrumentsAll.contains(instrument)) continue;
                        PrideReshakeGUI.this.instrumentsAll.add(instrument);
                    }
                    for (String tissue : ((ProjectDetail)projectDetail.getBody()).getTissues()) {
                        if (PrideReshakeGUI.this.tissuesAll.contains(tissue)) continue;
                        PrideReshakeGUI.this.tissuesAll.add(tissue);
                    }
                    for (String ptm : ((ProjectDetail)projectDetail.getBody()).getPtmNames()) {
                        if (PrideReshakeGUI.this.ptmsAll.contains(ptm)) continue;
                        PrideReshakeGUI.this.ptmsAll.add(ptm);
                    }
                    for (String tag : ((ProjectDetail)projectDetail.getBody()).getProjectTags()) {
                        if (PrideReshakeGUI.this.projectTagsAll.contains(tag)) continue;
                        PrideReshakeGUI.this.projectTagsAll.add(tag);
                    }
                    ((TitledBorder)PrideReshakeGUI.this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Projects (" + PrideReshakeGUI.this.projectsTable.getRowCount() + ")");
                    PrideReshakeGUI.this.projectsPanel.repaint();
                    Collections.sort(PrideReshakeGUI.this.speciesAll);
                    Collections.sort(PrideReshakeGUI.this.instrumentsAll);
                    Collections.sort(PrideReshakeGUI.this.tissuesAll);
                    Collections.sort(PrideReshakeGUI.this.ptmsAll);
                    Collections.sort(PrideReshakeGUI.this.projectTagsAll);
                    PrideReshakeGUI.this.speciesAll.add(0, "");
                    PrideReshakeGUI.this.tissuesAll.add(0, "");
                    PrideReshakeGUI.this.instrumentsAll.add(0, "");
                    PrideReshakeGUI.this.ptmsAll.add(0, "");
                    PrideReshakeGUI.this.projectTagsAll.add(0, "");
                    if (PrideReshakeGUI.this.projectsTable.getRowCount() > 0) {
                        PrideReshakeGUI.this.projectsTable.setRowSelectionInterval(0, 0);
                        PrideReshakeGUI.this.projectsTableMouseReleased(null);
                    }
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                }
                catch (HttpServerErrorException e) {
                    System.out.println("project");
                    e.printStackTrace();
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>project " + pxAccession + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
                }
                catch (ResourceAccessException e) {
                    JOptionPane.showMessageDialog(null, "PRIDE web service could not be reached.\n Please make sure that you are online.", "Network Error", 2);
                }
                catch (HttpMessageNotReadableException e) {
                    System.out.println(url);
                    e.printStackTrace();
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
                }
                catch (Exception e) {
                    System.out.println(url);
                    e.printStackTrace();
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://groups.google.com/group/peptide-shaker\">PeptideShaker developers</a>."), "PRIDE Access Error", 2);
                }
                ((TitledBorder)PrideReshakeGUI.this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Project (" + pxAccession + ")");
                PrideReshakeGUI.this.projectsPanel.repaint();
                ((TitledBorder)PrideReshakeGUI.this.assaysPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Assays");
                PrideReshakeGUI.this.projectsPanel.repaint();
                ((TitledBorder)PrideReshakeGUI.this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files");
                PrideReshakeGUI.this.projectsPanel.repaint();
                PrideReshakeGUI.this.projectsTable.getColumn("#Assays").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxNumAssays), PrideReshakeGUI.this.peptideShakerGUI.getSparklineColor()));
                ((JSparklinesBarChartTableCellRenderer)PrideReshakeGUI.this.projectsTable.getColumn("#Assays").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
                ((JSparklinesBarChartTableCellRenderer)PrideReshakeGUI.this.projectsTable.getColumn("#Assays").getCellRenderer()).setLogScale(true);
                ((JSparklinesBarChartTableCellRenderer)PrideReshakeGUI.this.projectsTable.getColumn("#Assays").getCellRenderer()).setMinimumChartValue(2.0);
                PrideReshakeGUI.this.projectsTable.repaint();
            }
        }.start();
    }

    private void loadPublicProjects() {
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading PRIDE Projects. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PrideReshakeGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                DefaultTableModel projectsTableModel = (DefaultTableModel)PrideReshakeGUI.this.projectsTable.getModel();
                projectsTableModel.getDataVector().removeAllElements();
                projectsTableModel.fireTableDataChanged();
                DefaultTableModel assayTableModel = (DefaultTableModel)PrideReshakeGUI.this.assaysTable.getModel();
                assayTableModel.getDataVector().removeAllElements();
                assayTableModel.fireTableDataChanged();
                DefaultTableModel filesTableModel = (DefaultTableModel)PrideReshakeGUI.this.filesTable.getModel();
                filesTableModel.getDataVector().removeAllElements();
                filesTableModel.fireTableDataChanged();
                double maxNumAssays = 0.0;
                String url = "https://www.ebi.ac.uk/pride/ws/archive/project/count";
                RestTemplate template = new RestTemplate();
                try {
                    ResponseEntity projectCountResult = template.getForEntity(url, Integer.class, new Object[0]);
                    Integer numberOfProjects = (Integer)projectCountResult.getBody();
                    int projectBatchSize = 200;
                    int numberOfPages = (int)Math.ceil((double)numberOfProjects.intValue() / (double)projectBatchSize);
                    PrideReshakeGUI.this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
                    PrideReshakeGUI.this.progressDialog.setMaxPrimaryProgressCounter(numberOfPages + 1);
                    PrideReshakeGUI.this.progressDialog.increasePrimaryProgressCounter();
                    PrideReshakeGUI.this.speciesAll = new ArrayList();
                    PrideReshakeGUI.this.instrumentsAll = new ArrayList();
                    PrideReshakeGUI.this.ptmsAll = new ArrayList();
                    PrideReshakeGUI.this.tissuesAll = new ArrayList();
                    PrideReshakeGUI.this.projectTagsAll = new ArrayList();
                    for (int currentPage = 0; currentPage < numberOfPages; ++currentPage) {
                        ResponseEntity projectList = template.getForEntity("https://www.ebi.ac.uk/pride/ws/archive/project/list?show=" + projectBatchSize + "&page=" + currentPage + "&sort=publication_date&order=desc", ProjectDetailList.class, new Object[0]);
                        for (ProjectDetail projectDetail : ((ProjectDetailList)projectList.getBody()).getList()) {
                            String projectAccession = projectDetail.getAccession();
                            int projectCategory = 0;
                            if (PrideReshakeGUI.this.projectClusterAnnotation.containsKey(projectAccession)) {
                                projectCategory = (Integer)PrideReshakeGUI.this.projectClusterAnnotation.get(projectAccession);
                            }
                            ((DefaultTableModel)PrideReshakeGUI.this.projectsTable.getModel()).addRow(new Object[]{PrideReshakeGUI.this.projectsTable.getRowCount() + 1, "<html><a href=\"" + DisplayFeaturesGenerator.getPrideProjectArchiveLink("" + projectAccession) + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">" + projectAccession + "</font></a><html>", projectDetail.getTitle(), PrideReshakeGUI.this.setToString(projectDetail.getProjectTags(), ", "), PrideReshakeGUI.this.setToString(projectDetail.getSpecies(), ", "), PrideReshakeGUI.this.setToString(projectDetail.getTissues(), ", "), PrideReshakeGUI.this.setToString(projectDetail.getPtmNames(), "; "), PrideReshakeGUI.this.setToString(projectDetail.getInstrumentNames(), ", "), projectDetail.getNumAssays(), PrideReshakeGUI.this.dateFormat.format(projectDetail.getPublicationDate()), projectDetail.getSubmissionType(), projectCategory});
                            if ((double)projectDetail.getNumAssays() > maxNumAssays) {
                                maxNumAssays = projectDetail.getNumAssays();
                            }
                            for (String species : projectDetail.getSpecies()) {
                                if (PrideReshakeGUI.this.speciesAll.contains(species)) continue;
                                PrideReshakeGUI.this.speciesAll.add(species);
                            }
                            for (String instrument : projectDetail.getInstrumentNames()) {
                                if (PrideReshakeGUI.this.instrumentsAll.contains(instrument)) continue;
                                PrideReshakeGUI.this.instrumentsAll.add(instrument);
                            }
                            for (String tissue : projectDetail.getTissues()) {
                                if (PrideReshakeGUI.this.tissuesAll.contains(tissue)) continue;
                                PrideReshakeGUI.this.tissuesAll.add(tissue);
                            }
                            for (String ptm : projectDetail.getPtmNames()) {
                                if (PrideReshakeGUI.this.ptmsAll.contains(ptm)) continue;
                                PrideReshakeGUI.this.ptmsAll.add(ptm);
                            }
                            for (String tag : projectDetail.getProjectTags()) {
                                if (PrideReshakeGUI.this.projectTagsAll.contains(tag)) continue;
                                PrideReshakeGUI.this.projectTagsAll.add(tag);
                            }
                            if (!PrideReshakeGUI.this.progressDialog.isRunCanceled()) continue;
                            break;
                        }
                        PrideReshakeGUI.this.progressDialog.increasePrimaryProgressCounter();
                        if (PrideReshakeGUI.this.progressDialog.isRunCanceled()) break;
                        ((TitledBorder)PrideReshakeGUI.this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Projects (" + PrideReshakeGUI.this.projectsTable.getRowCount() + ")");
                        PrideReshakeGUI.this.projectsPanel.repaint();
                    }
                    Collections.sort(PrideReshakeGUI.this.speciesAll);
                    Collections.sort(PrideReshakeGUI.this.instrumentsAll);
                    Collections.sort(PrideReshakeGUI.this.tissuesAll);
                    Collections.sort(PrideReshakeGUI.this.ptmsAll);
                    Collections.sort(PrideReshakeGUI.this.projectTagsAll);
                    PrideReshakeGUI.this.speciesAll.add(0, "");
                    PrideReshakeGUI.this.tissuesAll.add(0, "");
                    PrideReshakeGUI.this.instrumentsAll.add(0, "");
                    PrideReshakeGUI.this.ptmsAll.add(0, "");
                    PrideReshakeGUI.this.projectTagsAll.add(0, "");
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                }
                catch (HttpServerErrorException e) {
                    System.out.println("project/count or project/list");
                    e.printStackTrace();
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>project/count or project/list<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
                }
                catch (ResourceAccessException e) {
                    JOptionPane.showMessageDialog(null, "PRIDE web service could not be reached.\n Please make sure that you are online.", "Network Error", 2);
                }
                catch (HttpMessageNotReadableException e) {
                    System.out.println(url);
                    e.printStackTrace();
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://www.ebi.ac.uk/support/index.php?query=pride\">PRIDE team</a>."), "PRIDE Access Error", 2);
                }
                catch (Exception e) {
                    System.out.println(url);
                    e.printStackTrace();
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane("PRIDE web service access error. Cannot open:<br>" + url + "<br>Please contact the <a href=\"https://groups.google.com/group/peptide-shaker\">PeptideShaker developers</a>."), "PRIDE Access Error", 2);
                }
                ((TitledBorder)PrideReshakeGUI.this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Projects (" + PrideReshakeGUI.this.projectsTable.getRowCount() + ")");
                PrideReshakeGUI.this.projectsPanel.repaint();
                ((TitledBorder)PrideReshakeGUI.this.assaysPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Assays");
                PrideReshakeGUI.this.projectsPanel.repaint();
                ((TitledBorder)PrideReshakeGUI.this.filesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Files");
                PrideReshakeGUI.this.projectsPanel.repaint();
                PrideReshakeGUI.this.projectsTable.getColumn("#Assays").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxNumAssays), PrideReshakeGUI.this.peptideShakerGUI.getSparklineColor()));
                ((JSparklinesBarChartTableCellRenderer)PrideReshakeGUI.this.projectsTable.getColumn("#Assays").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
                ((JSparklinesBarChartTableCellRenderer)PrideReshakeGUI.this.projectsTable.getColumn("#Assays").getCellRenderer()).setLogScale(true);
                ((JSparklinesBarChartTableCellRenderer)PrideReshakeGUI.this.projectsTable.getColumn("#Assays").getCellRenderer()).setMinimumChartValue(2.0);
                PrideReshakeGUI.this.projectsTable.repaint();
            }
        }.start();
    }

    private String setToString(Set<String> set, String separator) {
        Object[] elements = set.toArray();
        String result = "";
        for (Object object : elements) {
            if (!result.isEmpty()) {
                result = result + separator;
            }
            result = result + object.toString();
        }
        return result;
    }

    public void downloadPrideDatasets(String aWorkingFolder, final ArrayList<String> selectedSpectrumFileLinks, final ArrayList<String> selectedFileNames, final String selectedSearchSettingsFileLink, final String database, String aSpecies, final ArrayList<Integer> fileSizes) {
        this.outputFolder = aWorkingFolder;
        this.currentSpecies = aSpecies;
        ArrayList<String> tempLinks = new ArrayList<String>();
        tempLinks.addAll(selectedSpectrumFileLinks);
        if (selectedSearchSettingsFileLink != null && !tempLinks.contains(selectedSearchSettingsFileLink)) {
            tempLinks.add(selectedSearchSettingsFileLink);
        }
        final ArrayList<String> allFileLinks = tempLinks;
        this.maxPrecursorCharge = null;
        this.minPrecursorCharge = null;
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
        this.progressDialog.setTitle("Downloading Files. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PrideReshakeGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DownloadThread"){

            @Override
            public void run() {
                try {
                    SearchParameters prideSearchParameters = new SearchParameters();
                    prideSearchParameters.setDigestionParameters(DigestionParameters.getDefaultParameters());
                    String prideSearchParametersReport = null;
                    ArrayList<File> mgfFiles = new ArrayList<File>();
                    ArrayList<File> rawFiles = new ArrayList<File>();
                    boolean mgfConversionOk = true;
                    Boolean useLocalFiles = null;
                    for (int i = 0; i < allFileLinks.size() && mgfConversionOk; ++i) {
                        int n;
                        String currentDownloadLink = (String)allFileLinks.get(i);
                        String currentFileNameOriginal = (String)selectedFileNames.get(i);
                        String currentFileName = (String)selectedFileNames.get(i);
                        boolean unzipped = true;
                        if (currentFileNameOriginal.endsWith(".gz")) {
                            currentFileNameOriginal = currentFileNameOriginal.substring(0, currentFileNameOriginal.lastIndexOf(".gz"));
                            unzipped = false;
                        } else if (currentFileNameOriginal.endsWith(".zip")) {
                            currentFileNameOriginal = currentFileNameOriginal.substring(0, currentFileNameOriginal.lastIndexOf(".zip"));
                            unzipped = false;
                        }
                        if (PrideReshakeGUI.this.progressDialog.isRunCanceled()) {
                            PrideReshakeGUI.this.progressDialog.setRunFinished();
                            PrideReshakeGUI.this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                            return;
                        }
                        PrideReshakeGUI.this.progressDialog.setTitle("Downloading Files (" + (i + 1) + "/" + allFileLinks.size() + "). Please Wait...");
                        try {
                            PrideReshakeGUI.this.currentPrideDataFileUrl = new URL(currentDownloadLink);
                            PrideReshakeGUI.this.currentZippedPrideDataFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName);
                            boolean nonMgfSpectrumFile = false;
                            ProteoWizardMsFormat[] proteoWizardMsFormatArray = ProteoWizardMsFormat.values();
                            int n2 = proteoWizardMsFormatArray.length;
                            for (n = 0; n < n2; ++n) {
                                ProteoWizardMsFormat tempFormat = proteoWizardMsFormatArray[n];
                                if (tempFormat == ProteoWizardMsFormat.mgf || !currentFileName.toLowerCase().endsWith(tempFormat.fileNameEnding) && !currentFileName.toLowerCase().endsWith(tempFormat.fileNameEnding + ".gz") && !currentFileName.toLowerCase().endsWith(tempFormat.fileNameEnding + ".zip")) continue;
                                nonMgfSpectrumFile = true;
                            }
                            if (nonMgfSpectrumFile) {
                                if (currentFileName.toLowerCase().endsWith(".gz")) {
                                    PrideReshakeGUI.this.currentPrideDataFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(".gz")));
                                } else if (currentFileName.toLowerCase().endsWith(".zip")) {
                                    PrideReshakeGUI.this.currentPrideDataFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(".zip")));
                                } else {
                                    PrideReshakeGUI.this.currentPrideDataFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName);
                                }
                            } else if (unzipped) {
                                PrideReshakeGUI.this.currentPrideDataFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName);
                                if (i < selectedSpectrumFileLinks.size()) {
                                    if (currentFileName.toLowerCase().endsWith(ProteoWizardMsFormat.mgf.fileNameEnding)) {
                                        PrideReshakeGUI.this.currentMgfFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName);
                                    } else {
                                        PrideReshakeGUI.this.currentMgfFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(".xml")) + ProteoWizardMsFormat.mgf.fileNameEnding);
                                    }
                                }
                            } else {
                                if (currentFileName.toLowerCase().endsWith(".gz")) {
                                    PrideReshakeGUI.this.currentPrideDataFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(".gz")));
                                } else {
                                    PrideReshakeGUI.this.currentPrideDataFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(".zip")));
                                }
                                if (i < selectedSpectrumFileLinks.size()) {
                                    if (currentFileName.toLowerCase().endsWith(ProteoWizardMsFormat.mgf.fileNameEnding + ".gz")) {
                                        PrideReshakeGUI.this.currentMgfFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(ProteoWizardMsFormat.mgf.fileNameEnding + ".gz")) + ProteoWizardMsFormat.mgf.fileNameEnding);
                                    } else if (currentFileName.toLowerCase().endsWith(ProteoWizardMsFormat.mgf.fileNameEnding + ".zip")) {
                                        PrideReshakeGUI.this.currentMgfFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(ProteoWizardMsFormat.mgf.fileNameEnding + ".zip")) + ProteoWizardMsFormat.mgf.fileNameEnding);
                                    } else if (currentFileName.toLowerCase().endsWith(".xml.gz")) {
                                        PrideReshakeGUI.this.currentMgfFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(".xml.gz")) + ProteoWizardMsFormat.mgf.fileNameEnding);
                                    } else if (currentFileName.toLowerCase().endsWith(".xml.zip")) {
                                        PrideReshakeGUI.this.currentMgfFile = new File(PrideReshakeGUI.this.outputFolder, currentFileName.substring(0, currentFileName.lastIndexOf(".xml.zip")) + ProteoWizardMsFormat.mgf.fileNameEnding);
                                    }
                                }
                            }
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(PrideReshakeGUI.this, JOptionEditorPane.getJOptionEditorPane("The file could not be downloaded:<br>" + ex.getMessage() + ".<br>Please <a href=\"https://github.com/compomics/peptide-shaker/issues\">contact the developers</a>."), "Download Error", 0);
                            ex.printStackTrace();
                            PrideReshakeGUI.this.currentPrideDataFileUrl = null;
                        }
                        if (PrideReshakeGUI.this.progressDialog.isRunCanceled()) {
                            PrideReshakeGUI.this.progressDialog.setRunFinished();
                            PrideReshakeGUI.this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                            return;
                        }
                        if (PrideReshakeGUI.this.currentPrideDataFileUrl != null) {
                            int option2;
                            if (!new File(PrideReshakeGUI.this.peptideShakerGUI.getUtilitiesUserParameters().getLocalPrideFolder(), currentFileNameOriginal).exists()) {
                                boolean downloadFile = true;
                                if (PrideReshakeGUI.this.currentPrideDataFile.exists()) {
                                    if (useLocalFiles == null) {
                                        int option = JOptionPane.showConfirmDialog(PrideReshakeGUI.this, "The file '" + PrideReshakeGUI.this.currentPrideDataFile.getName() + "' already exists locally.\nUse local copy?", "Use Local File?", 0);
                                        if (allFileLinks.size() > 1 && (option2 = JOptionPane.showConfirmDialog(PrideReshakeGUI.this, "Do this for all following files?", "Use Local Files?", 0)) == 0) {
                                            useLocalFiles = option == 0;
                                        }
                                        downloadFile = option == 1;
                                    } else {
                                        boolean bl = downloadFile = useLocalFiles == false;
                                    }
                                }
                                if (downloadFile) {
                                    IoUtil.saveUrl(PrideReshakeGUI.this.currentZippedPrideDataFile, currentDownloadLink, (Integer)fileSizes.get(i), PrideReshakeGUI.this.getUserName(), PrideReshakeGUI.this.getPassword(), PrideReshakeGUI.this.progressDialog);
                                    PrideReshakeGUI.this.progressDialog.setTitle("Unzipping Files (" + (i + 1) + "/" + allFileLinks.size() + "). Please Wait...");
                                    PrideReshakeGUI.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                                    if (!unzipped) {
                                        PrideReshakeGUI.this.unzipProject();
                                    }
                                }
                            } else {
                                PrideReshakeGUI.this.currentPrideDataFile = new File(PrideReshakeGUI.this.peptideShakerGUI.getUtilitiesUserParameters().getLocalPrideFolder(), currentFileNameOriginal);
                            }
                            if (PrideReshakeGUI.this.progressDialog.isRunCanceled()) {
                                PrideReshakeGUI.this.progressDialog.setRunFinished();
                                PrideReshakeGUI.this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                                return;
                            }
                            if (i < selectedSpectrumFileLinks.size()) {
                                File[] tempFiles = PrideReshakeGUI.this.currentPrideDataFile.isDirectory() ? PrideReshakeGUI.this.currentPrideDataFile.listFiles() : new File[]{PrideReshakeGUI.this.currentPrideDataFile};
                                File[] option = tempFiles;
                                option2 = option.length;
                                for (n = 0; n < option2; ++n) {
                                    File tempFile = option[n];
                                    boolean nonMgfSpectrumFile = false;
                                    for (ProteoWizardMsFormat tempFormat : ProteoWizardMsFormat.values()) {
                                        if (tempFormat == ProteoWizardMsFormat.mgf || !tempFile.getAbsolutePath().toLowerCase().endsWith(tempFormat.fileNameEnding)) continue;
                                        nonMgfSpectrumFile = true;
                                    }
                                    if (nonMgfSpectrumFile) {
                                        rawFiles.add(tempFile);
                                        continue;
                                    }
                                    if (tempFile.getAbsolutePath().toLowerCase().endsWith(".mgf")) {
                                        mgfFiles.add(tempFile);
                                        continue;
                                    }
                                    PrideReshakeGUI.this.progressDialog.setTitle("Converting Spectrum Data (" + (i + 1) + "/" + allFileLinks.size() + "). Please Wait...");
                                    String tempPath = tempFile.getAbsolutePath();
                                    tempPath = tempPath.substring(0, tempPath.lastIndexOf(".")) + ProteoWizardMsFormat.mgf.fileNameEnding;
                                    File tempMgfFile = new File(tempPath);
                                    mgfConversionOk = PrideReshakeGUI.this.convertPrideXmlToMgf(tempFile, tempMgfFile);
                                    mgfFiles.add(tempMgfFile);
                                }
                            }
                            if (PrideReshakeGUI.this.progressDialog.isRunCanceled()) {
                                PrideReshakeGUI.this.progressDialog.setRunFinished();
                                PrideReshakeGUI.this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                                return;
                            }
                            if (!mgfConversionOk) continue;
                            if (selectedSearchSettingsFileLink != null && currentDownloadLink.equalsIgnoreCase(selectedSearchSettingsFileLink)) {
                                PrideReshakeGUI.this.progressDialog.setTitle("Extracting Search Settings. Please Wait...");
                                if (currentFileName.toLowerCase().endsWith(".xml") || currentFileName.toLowerCase().endsWith(".xml.gz") || currentFileName.toLowerCase().endsWith(".xml.zip")) {
                                    prideSearchParametersReport = PrideReshakeGUI.this.getSearchParams(prideSearchParameters);
                                } else {
                                    PrideReshakeGUI.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                                    MzIdentMLIdfileSearchParametersConverter mzIdentMLIdfileSearchParametersConverter = new MzIdentMLIdfileSearchParametersConverter(PrideReshakeGUI.this.currentPrideDataFile, prideSearchParameters, PrideReshakeGUI.this.currentSpecies, PrideReshakeGUI.this.progressDialog);
                                    prideSearchParametersReport = mzIdentMLIdfileSearchParametersConverter.getSearchParameters();
                                    String allPtms = PrideReshakeGUI.this.assaysTable.getSelectedRow() != -1 ? (String)PrideReshakeGUI.this.assaysTable.getValueAt(PrideReshakeGUI.this.assaysTable.getSelectedRow(), PrideReshakeGUI.this.assaysTable.getColumn("PTMs").getModelIndex()) : (String)PrideReshakeGUI.this.projectsTable.getValueAt(PrideReshakeGUI.this.projectsTable.getSelectedRow(), PrideReshakeGUI.this.projectsTable.getColumn("PTMs").getModelIndex());
                                    prideSearchParametersReport = prideSearchParametersReport + PrideReshakeGUI.this.convertPtms(allPtms, prideSearchParameters.getModificationParameters());
                                }
                            } else {
                                prideSearchParametersReport = "<html><br><b><u>Extracted Search Parameters</u></b><br><br>(No search parameters extracted)<br>";
                            }
                            prideSearchParametersReport = prideSearchParametersReport + "<br><b>Files used:</b><br>";
                            for (String tempFile : allFileLinks) {
                                prideSearchParametersReport = prideSearchParametersReport + tempFile + "<br>";
                            }
                            File searchSettingsReportFile = new File(PrideReshakeGUI.this.outputFolder, "search_settings_report.html");
                            String tempReport = "<html>" + prideSearchParametersReport;
                            tempReport = tempReport + "<br></html>";
                            FileWriter fw = new FileWriter(searchSettingsReportFile);
                            BufferedWriter bw = new BufferedWriter(fw);
                            bw.write(tempReport);
                            bw.close();
                            fw.close();
                            prideSearchParametersReport = prideSearchParametersReport + "<br><br>Report saved to <a href=\"" + searchSettingsReportFile.getAbsolutePath() + "\">" + searchSettingsReportFile.getAbsolutePath() + "</a><br>";
                            prideSearchParametersReport = prideSearchParametersReport + "<br></html>";
                            prideSearchParametersReport = "<html>" + prideSearchParametersReport;
                            continue;
                        }
                        mgfConversionOk = false;
                    }
                    if (mgfConversionOk) {
                        File parametersFile = new File(PrideReshakeGUI.this.outputFolder, PrideReshakeGUI.this.getIdentificationSettingsFileName(prideSearchParameters) + ".par");
                        SearchParameters.saveIdentificationParameters(prideSearchParameters, parametersFile);
                    }
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    PrideReshakeGUI.this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                    if (mgfConversionOk) {
                        String selectedSpecies = null;
                        String selectedSpeciesType = null;
                        if (PrideReshakeGUI.this.currentSpecies.equalsIgnoreCase("Homo sapiens (Human)")) {
                            selectedSpecies = "Human (Homo sapiens)";
                            selectedSpeciesType = "Vertebrates";
                        }
                        if (PrideReshakeGUI.this.welcomeDialog != null) {
                            PrideReshakeGUI.this.welcomeDialog.setVisible(false);
                        }
                        if (PrideReshakeGUI.this.prideReshakeSetupDialog != null) {
                            PrideReshakeGUI.this.prideReshakeSetupDialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                        }
                        if (prideSearchParametersReport == null) {
                            prideSearchParametersReport = "<html><br><b><u>Extracted Search Parameters</u></b><br><br>(No search parameters extracted)<br></html>";
                        }
                        String projectName = PrideReshakeGUI.this.getCurrentPxAccession();
                        new PrideSearchParametersDialog(PrideReshakeGUI.this, new File(PrideReshakeGUI.this.outputFolder, PrideReshakeGUI.this.getIdentificationSettingsFileName(prideSearchParameters) + ".par"), prideSearchParametersReport, mgfFiles, rawFiles, new File(database), selectedSpecies, selectedSpeciesType, projectName, true);
                    }
                }
                catch (Exception e) {
                    PrideReshakeGUI.this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                    PrideReshakeGUI.this.progressDialog.setRunFinished();
                    JOptionPane.showMessageDialog(PrideReshakeGUI.this, "An error occurred when processing the PRIDE project: \n" + e.getMessage() + ".\nSee resources/PeptideShaker.log for details.", "PRIDE Error", 1);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private String getIdentificationSettingsFileName(SearchParameters prideSearchParameters) {
        String name = this.getCurrentPxAccession();
        int counter = 2;
        String currentName = name;
        IdentificationParameters newParameters = new IdentificationParameters(prideSearchParameters);
        newParameters.setName(currentName);
        while (this.identificationParametersFactory.getParametersList().contains(currentName) && !this.identificationParametersFactory.getIdentificationParameters(currentName).equals(newParameters)) {
            currentName = name + "_" + counter++;
        }
        return currentName;
    }

    private String getSearchParams(SearchParameters prideSearchParameters) {
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        Double fragmentIonMassTolerance = null;
        Double peptideIonMassTolerance = null;
        Integer maxMissedCleavages = null;
        ArrayList<String> enzymes = new ArrayList<String>();
        PrideXmlReader prideXmlReader = new PrideXmlReader(this.currentPrideDataFile);
        Description description = prideXmlReader.getDescription();
        DataProcessing dataProcessing = description.getDataProcessing();
        if (dataProcessing != null && dataProcessing.getProcessingMethod() != null) {
            List processingMethods = dataProcessing.getProcessingMethod().getCvParam();
            for (CvParam cvParam : processingMethods) {
                String value;
                if (cvParam.getAccession().equalsIgnoreCase("PRIDE:0000161")) {
                    value = cvParam.getValue().trim();
                    if (value.contains(" ")) {
                        if (value.trim().toLowerCase().endsWith("da") || value.trim().toLowerCase().endsWith("dalton")) {
                            prideSearchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
                        } else if (value.trim().toLowerCase().endsWith("ppm")) {
                            prideSearchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
                        }
                        value = value.substring(0, value.indexOf(" "));
                    }
                    if ((value = value.trim()).toLowerCase().endsWith("ppm")) {
                        prideSearchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
                        value = value.substring(0, value.length() - 3);
                    } else if (value.toLowerCase().endsWith("da")) {
                        prideSearchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
                        value = value.substring(0, value.length() - 2);
                    }
                    fragmentIonMassTolerance = Double.valueOf(value);
                    continue;
                }
                if (cvParam.getAccession().equalsIgnoreCase("PRIDE:0000078")) {
                    value = cvParam.getValue().trim();
                    if (value.contains(" ")) {
                        if (value.trim().toLowerCase().endsWith("da") || value.trim().toLowerCase().endsWith("dalton")) {
                            prideSearchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
                        } else if (value.trim().toLowerCase().endsWith("ppm")) {
                            prideSearchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
                        }
                        value = value.substring(0, value.indexOf(" "));
                    }
                    if ((value = value.trim()).toLowerCase().endsWith("ppm")) {
                        prideSearchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
                        value = value.substring(0, value.length() - 3);
                    } else if (value.toLowerCase().endsWith("da")) {
                        prideSearchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
                        value = value.substring(0, value.length() - 2);
                    }
                    peptideIonMassTolerance = Double.valueOf(value);
                    continue;
                }
                if (!cvParam.getAccession().equalsIgnoreCase("PRIDE:0000162")) continue;
                maxMissedCleavages = Integer.valueOf(cvParam.getValue());
            }
        }
        if (prideXmlReader.getProtocol() != null && prideXmlReader.getProtocol().getProtocolSteps() != null) {
            List protocolStepDescription = prideXmlReader.getProtocol().getProtocolSteps().getStepDescription();
            for (Param stepDescription : protocolStepDescription) {
                List stepCvParams = stepDescription.getCvParam();
                Iterator iterator = stepCvParams.iterator();
                while (iterator.hasNext()) {
                    CvParam stepCvParam = (CvParam)iterator.next();
                    if (!stepCvParam.getAccession().equalsIgnoreCase("PRIDE:0000160") && !stepCvParam.getAccession().equalsIgnoreCase("PRIDE:0000024") || stepCvParam.getValue() == null) continue;
                    enzymes.add(stepCvParam.getValue());
                }
            }
        }
        HashMap<String, Integer> ionTypes = new HashMap<String, Integer>();
        HashMap<String, Integer> peptideLastResidues = new HashMap<String, Integer>();
        List ids = prideXmlReader.getIdentIds();
        this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
        this.progressDialog.setMaxPrimaryProgressCounter(ids.size());
        this.progressDialog.setValue(0);
        for (String id : ids) {
            this.progressDialog.increasePrimaryProgressCounter();
            Identification identification = prideXmlReader.getIdentById(id);
            List peptides = identification.getPeptideItem();
            for (PeptideItem peptide : peptides) {
                String residue = peptide.getSequence().substring(peptide.getSequence().length() - 1);
                if (!peptideLastResidues.containsKey(residue)) {
                    peptideLastResidues.put(residue, 1);
                } else {
                    peptideLastResidues.put(residue, (Integer)peptideLastResidues.get(residue) + 1);
                }
                List fragmentIons = peptide.getFragmentIon();
                for (FragmentIon fragmentIon : fragmentIons) {
                    List stepCvParams = fragmentIon.getCvParam();
                    for (CvParam stepCvParam : stepCvParams) {
                        if (stepCvParam.getName().lastIndexOf("a ion") != -1) {
                            if (!ionTypes.containsKey("a-ion")) {
                                ionTypes.put("a-ion", 1);
                                continue;
                            }
                            ionTypes.put("a-ion", (Integer)ionTypes.get("a-ion") + 1);
                            continue;
                        }
                        if (stepCvParam.getName().lastIndexOf("b ion") != -1) {
                            if (!ionTypes.containsKey("b-ion")) {
                                ionTypes.put("b-ion", 1);
                                continue;
                            }
                            ionTypes.put("b-ion", (Integer)ionTypes.get("b-ion") + 1);
                            continue;
                        }
                        if (stepCvParam.getName().lastIndexOf("c ion") != -1) {
                            if (!ionTypes.containsKey("c-ion")) {
                                ionTypes.put("c-ion", 1);
                                continue;
                            }
                            ionTypes.put("c-ion", (Integer)ionTypes.get("c-ion") + 1);
                            continue;
                        }
                        if (stepCvParam.getName().lastIndexOf("x ion") != -1) {
                            if (!ionTypes.containsKey("x-ion")) {
                                ionTypes.put("x-ion", 1);
                                continue;
                            }
                            ionTypes.put("x-ion", (Integer)ionTypes.get("x-ion") + 1);
                            continue;
                        }
                        if (stepCvParam.getName().lastIndexOf("y ion") != -1) {
                            if (!ionTypes.containsKey("y-ion")) {
                                ionTypes.put("y-ion", 1);
                                continue;
                            }
                            ionTypes.put("y-ion", (Integer)ionTypes.get("y-ion") + 1);
                            continue;
                        }
                        if (stepCvParam.getName().lastIndexOf("z ion") == -1) continue;
                        if (!ionTypes.containsKey("z-ion")) {
                            ionTypes.put("z-ion", 1);
                            continue;
                        }
                        ionTypes.put("z-ion", (Integer)ionTypes.get("z-ion") + 1);
                    }
                }
            }
        }
        this.prideParametersReport = "<html><br><b><u>Extracted Search Parameters</u></b><br>";
        this.prideParametersReport = this.prideParametersReport + "<br><b>Fragment Ion Mass Tolerance:</b> ";
        if (fragmentIonMassTolerance != null) {
            prideSearchParameters.setFragmentIonAccuracy(fragmentIonMassTolerance);
            this.prideParametersReport = this.prideParametersReport + fragmentIonMassTolerance + " " + (Object)((Object)prideSearchParameters.getFragmentAccuracyType());
        } else {
            this.prideParametersReport = this.prideParametersReport + prideSearchParameters.getFragmentIonAccuracy() + " " + (Object)((Object)prideSearchParameters.getFragmentAccuracyType()) + " (default)";
        }
        this.prideParametersReport = this.prideParametersReport + "<br><b>Precursor Ion Mass Tolerance:</b> ";
        if (peptideIonMassTolerance != null) {
            prideSearchParameters.setPrecursorAccuracy(peptideIonMassTolerance);
            this.prideParametersReport = this.prideParametersReport + peptideIonMassTolerance + " " + (Object)((Object)prideSearchParameters.getPrecursorAccuracyType());
        } else {
            this.prideParametersReport = this.prideParametersReport + prideSearchParameters.getPrecursorAccuracy() + " " + (Object)((Object)prideSearchParameters.getPrecursorAccuracyType()) + " (default)";
        }
        this.prideParametersReport = this.prideParametersReport + "<br><br><b>Enzyme:</b> ";
        DigestionParameters prideDigestionPreferences = DigestionParameters.getDefaultParameters();
        prideSearchParameters.setDigestionParameters(prideDigestionPreferences);
        if (!enzymes.isEmpty()) {
            Enzyme selectedEnzyme;
            EnzymeParametersDialog enzymeSelectionDialog;
            if (enzymes.size() == 1) {
                Enzyme mappedEnzyme = EnzymeFactory.getInstance().getEnzyme((String)enzymes.get(0));
                if (mappedEnzyme == null) {
                    this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                    enzymeSelectionDialog = new EnzymeParametersDialog((Frame)this, true, (String)enzymes.get(0), true);
                    selectedEnzyme = enzymeSelectionDialog.getEnzyme();
                    if (selectedEnzyme != null) {
                        mappedEnzyme = selectedEnzyme;
                        this.prideParametersReport = this.prideParametersReport + selectedEnzyme.getName() + "<br>";
                    } else {
                        this.prideParametersReport = this.prideParametersReport + (String)enzymes.get(0) + " (unknown)<br>";
                    }
                } else {
                    this.prideParametersReport = this.prideParametersReport + mappedEnzyme.getName() + "<br>";
                }
                if (mappedEnzyme != null) {
                    prideDigestionPreferences.clearEnzymes();
                    prideDigestionPreferences.addEnzyme(mappedEnzyme);
                }
            } else {
                Object enzymesAsText = "";
                for (int i = 0; i < enzymes.size(); ++i) {
                    if (i > 0) {
                        enzymesAsText = (String)enzymesAsText + " + ";
                    }
                    enzymesAsText = (String)enzymesAsText + (String)enzymes.get(i);
                }
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                enzymeSelectionDialog = new EnzymeParametersDialog((Frame)this, true, (String)enzymesAsText, true);
                selectedEnzyme = enzymeSelectionDialog.getEnzyme();
                if (selectedEnzyme != null) {
                    this.prideParametersReport = this.prideParametersReport + selectedEnzyme.getName() + "<br>";
                    prideDigestionPreferences.clearEnzymes();
                    prideDigestionPreferences.addEnzyme(selectedEnzyme);
                } else {
                    prideDigestionPreferences.clearEnzymes();
                    this.prideParametersReport = this.prideParametersReport + (String)enzymesAsText + " (unknown)<br>";
                }
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
            }
        } else {
            this.prideParametersReport = this.prideParametersReport + "Trypsin (assumed)<br>";
        }
        if (prideDigestionPreferences.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            this.prideParametersReport = this.prideParametersReport + "<b>Maximum Missed Cleavages:</b> ";
            if (maxMissedCleavages != null) {
                for (Enzyme enzyme : prideDigestionPreferences.getEnzymes()) {
                    prideDigestionPreferences.setnMissedCleavages(enzyme.getName(), maxMissedCleavages);
                }
                this.prideParametersReport = this.prideParametersReport + maxMissedCleavages;
            } else {
                this.prideParametersReport = this.prideParametersReport + prideDigestionPreferences.getnMissedCleavages(prideDigestionPreferences.getEnzymes().get(0).getName()) + " (default)";
            }
        }
        this.prideParametersReport = this.prideParametersReport + "<br><br><b>Min Precusor Charge:</b> ";
        if (this.minPrecursorCharge != null) {
            prideSearchParameters.setMinChargeSearched(this.minPrecursorCharge);
            this.prideParametersReport = this.prideParametersReport + this.minPrecursorCharge;
        } else {
            this.prideParametersReport = this.prideParametersReport + prideSearchParameters.getMinChargeSearched() + " (default)";
        }
        this.prideParametersReport = this.prideParametersReport + "<br><b>Max Precusor Charge:</b> ";
        if (this.maxPrecursorCharge != null) {
            prideSearchParameters.setMaxChargeSearched(this.maxPrecursorCharge);
            this.prideParametersReport = this.prideParametersReport + this.maxPrecursorCharge;
        } else {
            this.prideParametersReport = this.prideParametersReport + prideSearchParameters.getMaxChargeSearched() + " (default)";
        }
        this.prideParametersReport = this.prideParametersReport + "<br><br><b>Species:</b> ";
        String species = (String)this.projectsTable.getValueAt(this.projectsTable.getSelectedRow(), this.projectsTable.getColumn("Species").getModelIndex());
        if (species == null || species.length() == 0) {
            this.prideParametersReport = this.prideParametersReport + "unknown";
            this.currentSpecies = species;
        } else {
            this.prideParametersReport = this.prideParametersReport + species;
            this.currentSpecies = species;
        }
        String allPtms = (String)this.projectsTable.getValueAt(this.projectsTable.getSelectedRow(), this.projectsTable.getColumn("PTMs").getModelIndex());
        this.prideParametersReport = this.prideParametersReport + this.convertPtms(allPtms, prideSearchParameters.getModificationParameters());
        boolean debugOutput = false;
        if (debugOutput) {
            System.out.println("\nfragmentIonMassTolerance: " + fragmentIonMassTolerance);
            System.out.println("peptideIonMassTolerance: " + peptideIonMassTolerance);
            System.out.println("maxMissedCleavages: " + maxMissedCleavages);
            System.out.println("species: " + species);
            System.out.println("ptms: " + allPtms);
            System.out.print("enzyme(s): ");
            String enzymesAsText = "";
            for (int i = 0; i < enzymes.size(); ++i) {
                if (i > 0) {
                    enzymesAsText = enzymesAsText + " + ";
                }
                enzymesAsText = enzymesAsText + (String)enzymes.get(i);
            }
            System.out.println(enzymesAsText);
            System.out.println("minPrecursorCharge: " + this.minPrecursorCharge);
            System.out.println("maxPrecursorCharge: " + this.maxPrecursorCharge);
            System.out.print("ion types: ");
            for (String ionType : ionTypes.keySet()) {
                System.out.print(ionType + ": " + ionTypes.get(ionType) + ", ");
            }
            System.out.println();
            System.out.print("peptide endings: ");
            for (String residues : peptideLastResidues.keySet()) {
                System.out.print(residues + ": " + peptideLastResidues.get(residues) + ", ");
            }
            System.out.println();
        }
        return this.prideParametersReport;
    }

    private boolean isFixedPtm(String pridePtmName) {
        boolean fixedPtm = false;
        if (pridePtmName.equalsIgnoreCase("Carbamidomethylation") || pridePtmName.equalsIgnoreCase("Carbamidomethylation of C") || pridePtmName.equalsIgnoreCase("Carbamidomethyl") || pridePtmName.equalsIgnoreCase("S-carboxamidomethyl-L-cysteine") || pridePtmName.equalsIgnoreCase("iodoacetamide - site C") || pridePtmName.equalsIgnoreCase("iodoacetamide derivatized residue") || pridePtmName.equalsIgnoreCase("Iodoacetamide derivative") || pridePtmName.equalsIgnoreCase("Carboxymethyl") || pridePtmName.equalsIgnoreCase("S-carboxymethyl-L-cysteine") || pridePtmName.equalsIgnoreCase("iodoacetic acid derivatized residue")) {
            fixedPtm = true;
        }
        return fixedPtm;
    }

    private void unzipProject() throws IOException {
        if (this.currentZippedPrideDataFile.getAbsolutePath().endsWith(".gz")) {
            int len;
            FileInputStream instream = new FileInputStream(this.currentZippedPrideDataFile);
            GZIPInputStream ginstream = new GZIPInputStream(instream);
            FileOutputStream outstream = new FileOutputStream(this.currentPrideDataFile);
            byte[] buf = new byte[1024];
            while ((len = ginstream.read(buf)) > 0) {
                if (this.progressDialog.isRunCanceled()) {
                    ginstream.close();
                    outstream.close();
                    instream.close();
                    this.progressDialog.setRunFinished();
                    return;
                }
                outstream.write(buf, 0, len);
            }
            ginstream.close();
            outstream.close();
            instream.close();
        } else {
            ZipUtils.unzip(this.currentZippedPrideDataFile, this.currentPrideDataFile.getParentFile(), null);
        }
    }

    private boolean convertPrideXmlToMgf(File prideXmlFile, File mgfFile) {
        boolean conversionOk = true;
        try {
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            PrideXmlReader prideXmlReader = new PrideXmlReader(prideXmlFile);
            FileWriter w = new FileWriter(mgfFile);
            BufferedWriter bw = new BufferedWriter(w);
            List spectra = prideXmlReader.getSpectrumIds();
            int spectraCount = spectra.size();
            if (spectraCount == 0) {
                bw.close();
                w.close();
                this.progressDialog.setRunFinished();
                JOptionPane.showMessageDialog(this, "The file " + prideXmlFile.getName() + " contains no valid spectra!\nConversion canceled.", "No Spectra Found", 2);
                return false;
            }
            this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
            this.progressDialog.setMaxPrimaryProgressCounter(spectraCount);
            this.progressDialog.setValue(0);
            int validSpectrumCount = 0;
            for (String spectrumId : spectra) {
                if (this.progressDialog.isRunCanceled()) {
                    bw.close();
                    w.close();
                    this.progressDialog.setRunFinished();
                    return false;
                }
                Spectrum spectrum = prideXmlReader.getSpectrumById(spectrumId);
                boolean valid = this.asMgf(spectrum, bw);
                if (valid) {
                    ++validSpectrumCount;
                }
                this.progressDialog.increasePrimaryProgressCounter();
            }
            if (validSpectrumCount == 0) {
                this.progressDialog.setRunFinished();
                JOptionPane.showMessageDialog(this, "The file " + prideXmlFile.getName() + " contains no valid spectra!\nConversion canceled.", "No Spectra Found", 2);
                return false;
            }
            bw.close();
            w.close();
        }
        catch (IOException ex) {
            this.progressDialog.setRunFinished();
            JOptionPane.showMessageDialog(this, "The file " + prideXmlFile.getName() + " could not be converted!", "Conversion Canceled", 2);
            ex.printStackTrace();
            return false;
        }
        return conversionOk;
    }

    public boolean asMgf(Spectrum spectrum, BufferedWriter bw) throws IOException {
        String lineBreak = System.getProperty("line.separator");
        boolean valid = true;
        int msLevel = spectrum.getSpectrumDesc().getSpectrumSettings().getSpectrumInstrument().getMsLevel();
        if (msLevel == 2) {
            if (spectrum.getSpectrumDesc().getPrecursorList() != null && spectrum.getSpectrumDesc().getPrecursorList().getPrecursor() != null && spectrum.getSpectrumDesc().getPrecursorList().getPrecursor().size() > 0) {
                bw.write("BEGIN IONS" + lineBreak);
                bw.write("TITLE=" + spectrum.getId() + lineBreak);
                Precursor precursor = (Precursor)spectrum.getSpectrumDesc().getPrecursorList().getPrecursor().get(0);
                List precursorCvParams = precursor.getIonSelection().getCvParam();
                Double precursorMz = null;
                Double precursorIntensity = null;
                String precursorRt = null;
                Integer precursorCharge = null;
                for (CvParam cvParam : precursorCvParams) {
                    if (cvParam.getAccession().equalsIgnoreCase("MS:1000744") || cvParam.getAccession().equalsIgnoreCase("PSI:1000040")) {
                        precursorMz = Double.valueOf(cvParam.getValue());
                        continue;
                    }
                    if (cvParam.getAccession().equalsIgnoreCase("MS:1000042") || cvParam.getAccession().equalsIgnoreCase("PSI:1000042")) {
                        precursorIntensity = Double.valueOf(cvParam.getValue());
                        continue;
                    }
                    if (cvParam.getAccession().equalsIgnoreCase("MS:1000041") || cvParam.getAccession().equalsIgnoreCase("PSI:1000041")) {
                        precursorCharge = Integer.valueOf(cvParam.getValue());
                        continue;
                    }
                    if (!cvParam.getAccession().equalsIgnoreCase("PRIDE:0000203") && !cvParam.getAccession().equalsIgnoreCase("MS:1000894")) continue;
                    precursorRt = cvParam.getValue();
                }
                if (precursorMz != null) {
                    bw.write("PEPMASS=" + precursorMz);
                } else {
                    valid = false;
                }
                if (precursorIntensity != null) {
                    bw.write("\t" + precursorIntensity);
                }
                bw.write(lineBreak);
                if (precursorRt != null) {
                    bw.write("RTINSECONDS=" + precursorRt + lineBreak);
                }
                if (precursorCharge != null) {
                    bw.write("CHARGE=" + precursorCharge + lineBreak);
                    if (this.maxPrecursorCharge == null || precursorCharge > this.maxPrecursorCharge) {
                        this.maxPrecursorCharge = precursorCharge;
                    }
                    if (this.minPrecursorCharge == null || precursorCharge < this.minPrecursorCharge) {
                        this.minPrecursorCharge = precursorCharge;
                    }
                }
                Number[] mzBinaryArray = spectrum.getMzNumberArray();
                Number[] intensityArray = spectrum.getIntentArray();
                for (int i = 0; i < mzBinaryArray.length; ++i) {
                    bw.write(mzBinaryArray[i].toString());
                    bw.write(" ");
                    bw.write(intensityArray[i] + lineBreak);
                }
                bw.write("END IONS" + lineBreak + lineBreak);
            } else {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    public void showProjectFilterRemovalOption(boolean show) {
        this.clearProjectFiltersLabel.setVisible(show);
    }

    public void updateProjectTableSelection() {
        if (this.projectsTable.getRowCount() > 0) {
            this.projectsTableMouseReleased(null);
        }
        ((TitledBorder)this.projectsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PRIDE Projects (" + this.projectsTable.getRowCount() + ")");
        this.projectsPanel.repaint();
    }

    public void setCurrentFilterValues(String[] currentFilterValues, boolean assaysGreaterThanFiler) {
        this.currentFilterValues = currentFilterValues;
        this.assaysGreaterThanFiler = assaysGreaterThanFiler;
    }

    private void enableReshake() {
        boolean filesSelected = false;
        for (int i = 0; i < this.filesTable.getRowCount() && !filesSelected; ++i) {
            if (!((Boolean)this.filesTable.getValueAt(i, this.filesTable.getColumn("  ").getModelIndex())).booleanValue()) continue;
            filesSelected = true;
        }
        this.reshakeButton.setEnabled(filesSelected);
    }

    private HttpEntity<String> getHttpEntity() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        String authString = this.userName + ":" + this.password;
        byte[] encodedAuthorisation = Base64.encodeBase64((byte[])authString.getBytes());
        headers.add("Authorization", "Basic " + new String(encodedAuthorisation));
        return new HttpEntity((MultiValueMap)headers);
    }

    public JTable getFilesTable() {
        return this.filesTable;
    }

    public String getCurrentPxAccession() {
        int selectedRow = this.projectsTable.getSelectedRow();
        if (selectedRow != -1) {
            String projectAccession = (String)this.projectsTable.getValueAt(selectedRow, 1);
            if (this.password == null) {
                projectAccession = projectAccession.substring(projectAccession.lastIndexOf("\">") + 2, projectAccession.lastIndexOf("</font"));
            }
            return projectAccession;
        }
        return null;
    }

    public HashMap<String, ArrayList<String>> getReshakeableFiles() {
        return this.reshakeableFiles;
    }

    public HashMap<String, ArrayList<String>> getSearchSettingsFiles() {
        return this.searchSettingsFiles;
    }

    public String getCurrentSpeciesList() {
        int assayRow = this.assaysTable.getSelectedRow();
        if (assayRow != -1 && this.assaysTable.getValueAt(assayRow, this.assaysTable.getColumn("Species").getModelIndex()) != null) {
            return (String)this.assaysTable.getValueAt(assayRow, this.assaysTable.getColumn("Species").getModelIndex());
        }
        int projectRow = this.projectsTable.getSelectedRow();
        if (projectRow != -1) {
            return (String)this.projectsTable.getValueAt(projectRow, this.projectsTable.getColumn("Species").getModelIndex());
        }
        return null;
    }

    private String convertPtms(String allPtms, ModificationParameters modProfile) {
        ArrayList<String> unknownPtms = new ArrayList<String>();
        String report = "<br><br><b>Post-Translational Modifications:</b>";
        if (allPtms != null) {
            if (allPtms.trim().length() > 0) {
                String[] tempPtms;
                for (String pridePtmName : tempPtms = allPtms.split("; ")) {
                    report = report + this.ptmFactory.convertPridePtm(pridePtmName, modProfile, unknownPtms, this.isFixedPtm(pridePtmName));
                }
            } else {
                report = report + "<br>(none detected)";
            }
        } else {
            report = report + "<br>(none detected)";
        }
        if (!unknownPtms.isEmpty()) {
            for (String unknownPtm : unknownPtms) {
                report = report + "<br>" + unknownPtm + " (unknown ptm) *";
            }
            this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
        }
        report = report + "<br>";
        if (!unknownPtms.isEmpty()) {
            report = report + "<br>* Remember to add these PTMs manually in SearchGUI.";
        }
        return report;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    private void downloadFiles(final ArrayList<Integer> fileRowIndexes) {
        LastSelectedFolder lastSelectedFolder = this.peptideShakerGUI.getLastSelectedFolder();
        final File downloadFolder = FileChooserUtil.getUserSelectedFolder(this, "Select Download Folder", lastSelectedFolder.getLastSelectedFolder(), "Download Folder", "Select", false);
        if (downloadFolder != null) {
            lastSelectedFolder.setLastSelectedFolder(downloadFolder.getAbsolutePath());
            this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Downloading File. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        PrideReshakeGUI.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("DownloadThread"){

                @Override
                public void run() {
                    try {
                        File savedFile = null;
                        File downLoadLocation = null;
                        for (int i = 0; i < fileRowIndexes.size() && !PrideReshakeGUI.this.progressDialog.isRunCanceled(); ++i) {
                            if (fileRowIndexes.size() > 1) {
                                PrideReshakeGUI.this.progressDialog.setTitle("Downloading Files (" + (i + 1) + "/" + fileRowIndexes.size() + "). Please Wait...");
                            }
                            int rowIndex = (Integer)fileRowIndexes.get(i);
                            String tempLink = (String)PrideReshakeGUI.this.filesTable.getValueAt(rowIndex, PrideReshakeGUI.this.filesTable.getColumn("Download").getModelIndex());
                            tempLink = tempLink.substring(tempLink.indexOf("\"") + 1);
                            String link = tempLink.substring(0, tempLink.indexOf("\""));
                            Double fileSizeInMB = (Double)PrideReshakeGUI.this.filesTable.getValueAt(rowIndex, PrideReshakeGUI.this.filesTable.getColumn("Size (MB)").getModelIndex());
                            int fileSizeInBytes = fileSizeInMB != null ? Double.valueOf(fileSizeInMB * 1024.0 * 1024.0).intValue() : -1;
                            String fileName = (String)PrideReshakeGUI.this.filesTable.getValueAt(rowIndex, PrideReshakeGUI.this.filesTable.getColumn("File").getModelIndex());
                            downLoadLocation = new File(downloadFolder, fileName);
                            savedFile = IoUtil.saveUrl(downLoadLocation, link, fileSizeInBytes, PrideReshakeGUI.this.getUserName(), PrideReshakeGUI.this.getPassword(), PrideReshakeGUI.this.progressDialog);
                            PrideReshakeGUI.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                        }
                        boolean canceled = PrideReshakeGUI.this.progressDialog.isRunCanceled();
                        PrideReshakeGUI.this.progressDialog.setRunFinished();
                        if (fileRowIndexes.size() == 1) {
                            if (!canceled) {
                                JOptionPane.showMessageDialog(PrideReshakeGUI.this, savedFile.getName() + " downloaded to " + savedFile + ".", "Download Complete", 1);
                            } else if (downLoadLocation.exists()) {
                                downLoadLocation.delete();
                            }
                        } else if (!canceled) {
                            JOptionPane.showMessageDialog(PrideReshakeGUI.this, "Files downloaded to " + downloadFolder.getAbsolutePath() + ".", "Download Complete", 1);
                        }
                    }
                    catch (MalformedURLException e) {
                        PrideReshakeGUI.this.progressDialog.setRunFinished();
                        PrideReshakeGUI.this.peptideShakerGUI.catchException(e);
                    }
                    catch (IOException e) {
                        PrideReshakeGUI.this.progressDialog.setRunFinished();
                        PrideReshakeGUI.this.peptideShakerGUI.catchException(e);
                    }
                }
            }.start();
        }
    }
}

