/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.pride;

import com.compomics.software.ToolFactory;
import com.compomics.software.dialogs.SearchGuiSetupDialog;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.parameters.UtilitiesUserParameters;
import eu.isas.peptideshaker.gui.pride.PrideReshakeGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PrideSearchParametersDialog
extends JDialog {
    private final PrideReshakeGUI prideReShakeGUI;
    private final File prideSearchParametersFile;
    private final ArrayList<File> spectrumFiles;
    private final ArrayList<File> rawFiles;
    private final File fastaFile;
    private final String species;
    private final String speciesType;
    private final String psProjectName;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JLabel infoLabel;
    private JSeparator jSeparator1;
    private JButton okButton;
    private JEditorPane searchParametersReportEditorPane;
    private JScrollPane searchParametersReportScrollPane;

    public PrideSearchParametersDialog(PrideReshakeGUI prideReShakeGUI, File prideSearchParametersFile, String prideSearchParametersReport, ArrayList<File> spectrumFiles, ArrayList<File> rawFiles, File fastaFile, String species, String speciesType, String psProjectName, boolean modal) {
        super((Frame)prideReShakeGUI, modal);
        this.initComponents();
        this.prideReShakeGUI = prideReShakeGUI;
        this.prideSearchParametersFile = prideSearchParametersFile;
        this.spectrumFiles = spectrumFiles;
        this.rawFiles = rawFiles;
        this.fastaFile = fastaFile;
        this.species = species;
        this.speciesType = speciesType;
        this.psProjectName = psProjectName;
        this.searchParametersReportEditorPane.setText(prideSearchParametersReport);
        this.setLocationRelativeTo(prideReShakeGUI);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.searchParametersReportScrollPane = new JScrollPane();
        this.searchParametersReportEditorPane = new JEditorPane();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.infoLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(0);
        this.setTitle("PRIDE Search Settings");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PrideSearchParametersDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.searchParametersReportScrollPane.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255), 10));
        this.searchParametersReportEditorPane.setEditable(false);
        this.searchParametersReportEditorPane.setBorder(null);
        this.searchParametersReportEditorPane.setContentType("text/html");
        this.searchParametersReportEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                PrideSearchParametersDialog.this.searchParametersReportEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.searchParametersReportScrollPane.setViewportView(this.searchParametersReportEditorPane);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideSearchParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrideSearchParametersDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.infoLabel.setFont(this.infoLabel.getFont().deriveFont(this.infoLabel.getFont().getStyle() | 2));
        this.infoLabel.setText("Click OK to open the data in SearchGUI and start the re-analysis!");
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.searchParametersReportScrollPane).addGroup(backgroundPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 203, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.searchParametersReportScrollPane, -1, 417, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.infoLabel)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.prideReShakeGUI.setVisible(false);
        this.setVisible(false);
        boolean openSearchGUI = true;
        try {
            UtilitiesUserParameters utilitiesUserPreferences = UtilitiesUserParameters.loadUserParameters();
            if (utilitiesUserPreferences.getSearchGuiPath() == null || !new File(utilitiesUserPreferences.getSearchGuiPath()).exists()) {
                SearchGuiSetupDialog searchGuiSetupDialog = new SearchGuiSetupDialog(this.prideReShakeGUI, true);
                openSearchGUI = !searchGuiSetupDialog.isDialogCanceled();
            }
        }
        catch (Exception e) {
            this.prideReShakeGUI.getPeptideShakerGUI().catchException(e);
        }
        if (openSearchGUI) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean success;
                        File outputFolder = null;
                        if (!(PrideSearchParametersDialog.this.spectrumFiles.isEmpty() && PrideSearchParametersDialog.this.rawFiles.isEmpty() || (outputFolder = !PrideSearchParametersDialog.this.spectrumFiles.isEmpty() ? new File(((File)PrideSearchParametersDialog.this.spectrumFiles.get(0)).getParentFile(), "search_results") : new File(((File)PrideSearchParametersDialog.this.rawFiles.get(0)).getParentFile(), "search_results")).exists() || (success = outputFolder.mkdir()))) {
                            outputFolder = null;
                        }
                        ToolFactory.startSearchGUI(PrideSearchParametersDialog.this.prideReShakeGUI, PrideSearchParametersDialog.this.spectrumFiles, PrideSearchParametersDialog.this.rawFiles, PrideSearchParametersDialog.this.fastaFile, PrideSearchParametersDialog.this.prideSearchParametersFile, outputFolder, null, PrideSearchParametersDialog.this.species, PrideSearchParametersDialog.this.speciesType, PrideSearchParametersDialog.this.psProjectName);
                        PrideSearchParametersDialog.this.prideReShakeGUI.getPeptideShakerGUI().close();
                    }
                    catch (Exception e) {
                        PrideSearchParametersDialog.this.prideReShakeGUI.getPeptideShakerGUI().catchException(e);
                    }
                }
            }, "StartSearchGUI").start();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelButtonActionPerformed(null);
    }

    private void searchParametersReportEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ENTERED.toString())) {
            this.setCursor(new Cursor(12));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.EXITED.toString())) {
            this.setCursor(new Cursor(0));
        } else if (evt.getEventType().toString().equalsIgnoreCase(HyperlinkEvent.EventType.ACTIVATED.toString())) {
            if (evt.getDescription().startsWith("#")) {
                this.searchParametersReportEditorPane.scrollToReference(evt.getDescription());
            } else {
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(evt.getDescription());
                this.setCursor(new Cursor(0));
            }
        }
    }
}

