/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.protein_inference;

import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.io.file.LastSelectedFolder;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferenceGraphLegendDialog;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferenceGraphSelectionDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.apache.commons.collections15.Transformer;

public class ProteinInferenceGraphPanel
extends JPanel {
    private final ArrayList<String> nodes;
    private final HashMap<String, ArrayList<String>> edges;
    private ArrayList<String> selectedNodes = new ArrayList();
    private ArrayList<String> selectedNeighborNodes = new ArrayList();
    private ArrayList<String> selectedEdges = new ArrayList();
    private boolean showPeptideLabels = false;
    private boolean showProteinLabels = false;
    private HashMap<String, String> edgeProperties;
    private final HashMap<String, String> nodeProperties;
    private final HashMap<String, String> nodeToolTips;
    private UndirectedSparseGraph<String, String> graph;
    private VisualizationViewer visualizationViewer;
    private final JDialog parentDialog;
    private final JPanel parentPanel;
    private final Image normalIcon;
    private final Image waitingIcon;
    private final LastSelectedFolder lastSelectedFolder;
    private Transformer<String, Paint> edgePaint = new Transformer<String, Paint>(){

        public Paint transform(String s) {
            if (ProteinInferenceGraphPanel.this.selectedEdges.isEmpty()) {
                return new Color(100, 100, 100, 100);
            }
            if (ProteinInferenceGraphPanel.this.selectedEdges.contains(s)) {
                return new Color(100, 100, 100, 255);
            }
            return new Color(100, 100, 100, 100);
        }
    };
    private final Transformer<String, Stroke> edgeStroke = new Transformer<String, Stroke>(){
        float[] dash = new float[]{10.0f};

        public Stroke transform(String s) {
            String edgeProperty = (String)ProteinInferenceGraphPanel.this.edgeProperties.get(s);
            if (edgeProperty != null) {
                if (Boolean.parseBoolean(edgeProperty)) {
                    return new BasicStroke(1.0f, 0, 0, 10.0f);
                }
                return new BasicStroke(1.0f, 0, 0, 10.0f, this.dash, 0.0f);
            }
            return new BasicStroke(1.0f, 0, 0, 10.0f, this.dash, 0.0f);
        }
    };
    private JRadioButton allRadioButton;
    private ButtonGroup annotationButtonGroup;
    private JRadioButton evidenceRadioButton;
    private JLabel exportLabel;
    private JPanel graphPanel;
    private JLabel helpLabel;
    private JCheckBox highlightCheckBox;
    private JLabel layoutLabel;
    private JLabel legendLabel;
    private JRadioButton nodeTypeRadioButton;
    private JLabel peptideCountLabel;
    private JLabel peptideCountValueLabel;
    private JLabel proteinCountLabel;
    private JLabel proteinCountValueLabel;
    private JLabel selectAllLabel;
    private ButtonGroup selectionButtonGroup;
    private JPanel selectionPanel;
    private JPanel settingsPanel;
    private JLabel showPeptideLabelsLabel;
    private JLabel showProteinLabelsLabel;
    private JRadioButton uniqueRadioButton;
    private JRadioButton validationStatusRadioButton;

    public ProteinInferenceGraphPanel(JDialog parentDialog, JPanel parentPanel, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder, ArrayList<String> nodes, HashMap<String, ArrayList<String>> edges, HashMap<String, String> nodeProperties, HashMap<String, String> edgeProperties, HashMap<String, String> nodeToolTips, ArrayList<String> selectedNodes) {
        this.initComponents();
        this.parentDialog = parentDialog;
        this.parentPanel = parentPanel;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.lastSelectedFolder = lastSelectedFolder;
        this.nodes = nodes;
        this.edges = edges;
        this.nodeProperties = nodeProperties;
        this.edgeProperties = edgeProperties;
        this.nodeToolTips = nodeToolTips;
        this.visualizationViewer = this.setUpGraph(parentPanel);
        for (String tempNode : nodes) {
            if (selectedNodes == null || !selectedNodes.contains(tempNode)) continue;
            this.visualizationViewer.getPickedVertexState().pick((Object)tempNode, true);
        }
        this.graphPanel.add((Component)this.visualizationViewer);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        scaler.scale((VisualizationServer)this.visualizationViewer, 0.9f, this.visualizationViewer.getCenter());
    }

    private void updateGraphLayout() {
        this.visualizationViewer = this.setUpGraph(this.parentPanel);
        this.graphPanel.removeAll();
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        scaler.scale((VisualizationServer)this.visualizationViewer, 0.9f, this.visualizationViewer.getCenter());
        for (String tempNode : this.nodes) {
            if (this.selectedNodes != null && this.selectedNodes.contains(tempNode)) {
                this.visualizationViewer.getPickedVertexState().pick((Object)tempNode, true);
                continue;
            }
            this.visualizationViewer.getPickedVertexState().pick((Object)tempNode, false);
        }
        this.graphPanel.add((Component)this.visualizationViewer);
        this.graphPanel.revalidate();
        this.graphPanel.repaint();
    }

    private VisualizationViewer setUpGraph(JPanel parentPanel) {
        this.graph = new UndirectedSparseGraph();
        for (String node : this.nodes) {
            this.graph.addVertex((Object)node);
        }
        for (String startNode : this.edges.keySet()) {
            for (String endNode : this.edges.get(startNode)) {
                this.graph.addEdge((Object)(startNode + "|" + endNode), (Object)startNode, (Object)endNode);
            }
        }
        VisualizationViewer vv = new VisualizationViewer((Layout)new FRLayout(this.graph), new Dimension(parentPanel.getWidth() - 20, parentPanel.getHeight() - 100));
        vv.setBackground(Color.WHITE);
        vv.getRenderContext().setVertexLabelTransformer((Transformer)new Transformer<String, String>(){

            public String transform(String arg0) {
                return arg0;
            }
        });
        vv.getRenderContext().setEdgeLabelTransformer((Transformer)new Transformer<String, String>(){

            public String transform(String arg0) {
                return arg0;
            }
        });
        vv.getRenderer().setVertexRenderer((Renderer.Vertex)new ProteinInferenceVertexRenderer());
        vv.getRenderer().setEdgeLabelRenderer((Renderer.EdgeLabel)new BasicEdgeLabelRenderer<String, String>(){

            public void labelEdge(RenderContext<String, String> rc, Layout<String, String> layout, String e, String label) {
            }
        });
        vv.getRenderer().setVertexLabelRenderer((Renderer.VertexLabel)new BasicVertexLabelRenderer<String, String>(){

            public void labelVertex(RenderContext<String, String> rc, Layout<String, String> layout, String v, String label) {
                if (label.startsWith("Peptide") && ProteinInferenceGraphPanel.this.showPeptideLabels) {
                    String fullTooltip = (String)ProteinInferenceGraphPanel.this.nodeToolTips.get(label);
                    super.labelVertex(rc, layout, (Object)v, fullTooltip.substring(0, fullTooltip.indexOf("<br>")));
                }
                if (label.startsWith("Protein") && ProteinInferenceGraphPanel.this.showProteinLabels) {
                    super.labelVertex(rc, layout, (Object)v, label.substring(label.indexOf(" ") + 1));
                }
            }
        });
        vv.getRenderContext().setEdgeDrawPaintTransformer(this.edgePaint);
        vv.getRenderContext().setEdgeStrokeTransformer(this.edgeStroke);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        vv.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 65) {
                    for (String tempNode : ProteinInferenceGraphPanel.this.nodes) {
                        ProteinInferenceGraphPanel.this.visualizationViewer.getPickedVertexState().pick((Object)tempNode, true);
                    }
                } else if (e.getKeyCode() == 27) {
                    for (String tempNode : ProteinInferenceGraphPanel.this.nodes) {
                        ProteinInferenceGraphPanel.this.visualizationViewer.getPickedVertexState().pick((Object)tempNode, false);
                    }
                }
                super.keyReleased(e);
            }
        });
        vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller<String>(){

            public String transform(String v) {
                if (ProteinInferenceGraphPanel.this.nodeToolTips != null && ProteinInferenceGraphPanel.this.nodeToolTips.get(v) != null) {
                    return super.transform((Object)((String)ProteinInferenceGraphPanel.this.nodeToolTips.get(v)));
                }
                return super.transform((Object)v.substring(v.indexOf(" ") + 1));
            }
        });
        final PickedState pickedState = vv.getPickedVertexState();
        pickedState.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object subject = e.getItem();
                if (subject instanceof String) {
                    String vertex = (String)subject;
                    if (pickedState.isPicked((Object)vertex)) {
                        if (!ProteinInferenceGraphPanel.this.selectedNodes.contains(vertex)) {
                            ProteinInferenceGraphPanel.this.selectedNodes.add(vertex);
                        }
                    } else {
                        ProteinInferenceGraphPanel.this.selectedNodes.remove(vertex);
                    }
                }
                ProteinInferenceGraphPanel.this.updateNodeSelection();
            }
        });
        return vv;
    }

    private void updateNodeSelection() {
        this.selectedNeighborNodes = new ArrayList();
        this.selectedEdges = new ArrayList();
        for (String node : this.selectedNodes) {
            Object tempNode2;
            Collection neighbors = this.graph.getNeighbors((Object)node);
            for (Object tempNode2 : neighbors) {
                if (this.allRadioButton.isSelected()) {
                    if (this.selectedNeighborNodes.contains(tempNode2)) continue;
                    this.selectedNeighborNodes.add((String)tempNode2);
                    continue;
                }
                if (this.graph.getNeighbors(tempNode2).size() != 1 || this.selectedNeighborNodes.contains(tempNode2)) continue;
                this.selectedNeighborNodes.add((String)tempNode2);
            }
            Collection inEdges = this.graph.getInEdges((Object)node);
            tempNode2 = inEdges.iterator();
            while (tempNode2.hasNext()) {
                String tempEdge = (String)tempNode2.next();
                String[] tempNodes = tempEdge.split("\\|");
                if ((!this.selectedNodes.contains(tempNodes[0]) || !this.selectedNeighborNodes.contains(tempNodes[1])) && (!this.selectedNodes.contains(tempNodes[1]) || !this.selectedNeighborNodes.contains(tempNodes[0])) || this.selectedEdges.contains(tempEdge)) continue;
                this.selectedEdges.add(tempEdge);
            }
            Collection outEdges = this.graph.getOutEdges((Object)node);
            for (String tempEdge : outEdges) {
                String[] tempNodes = tempEdge.split("\\|");
                if ((!this.selectedNodes.contains(tempNodes[0]) || !this.selectedNeighborNodes.contains(tempNodes[1])) && (!this.selectedNodes.contains(tempNodes[1]) || !this.selectedNeighborNodes.contains(tempNodes[0])) || this.selectedEdges.contains(tempEdge)) continue;
                this.selectedEdges.add(tempEdge);
            }
        }
        int proteinCount = 0;
        int peptideCount = 0;
        for (String tempNode : this.selectedNodes) {
            if (tempNode.startsWith("Protein")) {
                ++proteinCount;
                continue;
            }
            if (!tempNode.startsWith("Peptide")) continue;
            ++peptideCount;
        }
        for (String tempNode : this.selectedNeighborNodes) {
            if (this.selectedNodes.contains(tempNode)) continue;
            if (tempNode.startsWith("Protein")) {
                ++proteinCount;
                continue;
            }
            if (!tempNode.startsWith("Peptide")) continue;
            ++peptideCount;
        }
        this.proteinCountValueLabel.setText("<html><a href>" + proteinCount + "</html>");
        this.peptideCountValueLabel.setText("<html><a href>" + peptideCount + "</html>");
    }

    private void initComponents() {
        this.annotationButtonGroup = new ButtonGroup();
        this.selectionButtonGroup = new ButtonGroup();
        this.selectionPanel = new JPanel();
        this.proteinCountLabel = new JLabel();
        this.proteinCountValueLabel = new JLabel();
        this.peptideCountLabel = new JLabel();
        this.peptideCountValueLabel = new JLabel();
        this.layoutLabel = new JLabel();
        this.exportLabel = new JLabel();
        this.legendLabel = new JLabel();
        this.helpLabel = new JLabel();
        this.selectAllLabel = new JLabel();
        this.showProteinLabelsLabel = new JLabel();
        this.showPeptideLabelsLabel = new JLabel();
        this.graphPanel = new JPanel();
        this.settingsPanel = new JPanel();
        this.evidenceRadioButton = new JRadioButton();
        this.validationStatusRadioButton = new JRadioButton();
        this.nodeTypeRadioButton = new JRadioButton();
        this.allRadioButton = new JRadioButton();
        this.uniqueRadioButton = new JRadioButton();
        this.highlightCheckBox = new JCheckBox();
        this.selectionPanel.setBackground(new Color(255, 255, 255));
        this.proteinCountLabel.setText("#Proteins:");
        this.proteinCountValueLabel.setHorizontalAlignment(4);
        this.proteinCountValueLabel.setText("0");
        this.proteinCountValueLabel.setMinimumSize(new Dimension(14, 14));
        this.proteinCountValueLabel.setPreferredSize(new Dimension(14, 14));
        this.proteinCountValueLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.proteinCountValueLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.proteinCountValueLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.proteinCountValueLabelMouseReleased(evt);
            }
        });
        this.peptideCountLabel.setText("#Peptides:");
        this.peptideCountValueLabel.setHorizontalAlignment(4);
        this.peptideCountValueLabel.setText("0");
        this.peptideCountValueLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.peptideCountValueLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.peptideCountValueLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.peptideCountValueLabelMouseReleased(evt);
            }
        });
        this.layoutLabel.setText("<html><a href>Layout</html>");
        this.layoutLabel.setToolTipText("Redo the graph layout");
        this.layoutLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.layoutLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.layoutLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.layoutLabelMouseReleased(evt);
            }
        });
        this.exportLabel.setText("<html><a href>Export</html>");
        this.exportLabel.setToolTipText("Export graph as image");
        this.exportLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.exportLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.exportLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.exportLabelMouseReleased(evt);
            }
        });
        this.legendLabel.setText("<html><a href>Legend</html>");
        this.legendLabel.setToolTipText("Show graph legend");
        this.legendLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.legendLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.legendLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.legendLabelMouseReleased(evt);
            }
        });
        this.helpLabel.setText("<html><a href>Help</html>");
        this.helpLabel.setToolTipText("Show graph help");
        this.helpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.helpLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.helpLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.helpLabelMouseReleased(evt);
            }
        });
        this.selectAllLabel.setText("<html><a href>Select All</html>");
        this.selectAllLabel.setToolTipText("Select all proteins and peptides");
        this.selectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.selectAllLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.selectAllLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.selectAllLabelMouseReleased(evt);
            }
        });
        this.showProteinLabelsLabel.setText("<html><a href>Protein Labels</html>");
        this.showProteinLabelsLabel.setToolTipText("Show the protein labels");
        this.showProteinLabelsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.showProteinLabelsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.showProteinLabelsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.showProteinLabelsLabelMouseReleased(evt);
            }
        });
        this.showPeptideLabelsLabel.setText("<html><a href>Peptide Labels</html>");
        this.showPeptideLabelsLabel.setToolTipText("Show the peptide labels");
        this.showPeptideLabelsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.showPeptideLabelsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.showPeptideLabelsLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinInferenceGraphPanel.this.showPeptideLabelsLabelMouseReleased(evt);
            }
        });
        GroupLayout selectionPanelLayout = new GroupLayout(this.selectionPanel);
        this.selectionPanel.setLayout(selectionPanelLayout);
        selectionPanelLayout.setHorizontalGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectionPanelLayout.createSequentialGroup().addContainerGap().addGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectionPanelLayout.createSequentialGroup().addComponent(this.layoutLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exportLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.legendLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.helpLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectAllLabel, -2, -1, -2)).addGroup(selectionPanelLayout.createSequentialGroup().addComponent(this.showProteinLabelsLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showPeptideLabelsLabel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinCountLabel).addComponent(this.peptideCountLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinCountValueLabel, -2, -1, -2).addComponent(this.peptideCountValueLabel)).addContainerGap()));
        selectionPanelLayout.linkSize(0, this.peptideCountValueLabel, this.proteinCountValueLabel);
        selectionPanelLayout.setVerticalGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(selectionPanelLayout.createSequentialGroup().addGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.proteinCountLabel).addComponent(this.proteinCountValueLabel, -2, -1, -2).addComponent(this.layoutLabel, -2, -1, -2).addComponent(this.exportLabel, -2, -1, -2).addComponent(this.helpLabel, -2, -1, -2).addComponent(this.legendLabel, -2, -1, -2).addComponent(this.selectAllLabel, -2, -1, -2)).addGap(0, 0, 0).addGroup(selectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideCountLabel).addComponent(this.peptideCountValueLabel).addComponent(this.showProteinLabelsLabel, -2, -1, -2).addComponent(this.showPeptideLabelsLabel, -2, -1, -2))));
        this.graphPanel.setBackground(new Color(255, 255, 255));
        this.graphPanel.setLayout(new BoxLayout(this.graphPanel, 2));
        this.settingsPanel.setBackground(new Color(255, 255, 255));
        this.annotationButtonGroup.add(this.evidenceRadioButton);
        this.evidenceRadioButton.setText("Protein Evidence");
        this.evidenceRadioButton.setToolTipText("Protein Evidence (from UniProt)");
        this.evidenceRadioButton.setOpaque(false);
        this.evidenceRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceGraphPanel.this.evidenceRadioButtonActionPerformed(evt);
            }
        });
        this.annotationButtonGroup.add(this.validationStatusRadioButton);
        this.validationStatusRadioButton.setText("Validation Status");
        this.validationStatusRadioButton.setToolTipText("Peptide and Protein Validation Status");
        this.validationStatusRadioButton.setOpaque(false);
        this.validationStatusRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceGraphPanel.this.validationStatusRadioButtonActionPerformed(evt);
            }
        });
        this.annotationButtonGroup.add(this.nodeTypeRadioButton);
        this.nodeTypeRadioButton.setSelected(true);
        this.nodeTypeRadioButton.setText("Molecule Type");
        this.nodeTypeRadioButton.setToolTipText("Peptide or Protein");
        this.nodeTypeRadioButton.setOpaque(false);
        this.nodeTypeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceGraphPanel.this.nodeTypeRadioButtonActionPerformed(evt);
            }
        });
        this.selectionButtonGroup.add(this.allRadioButton);
        this.allRadioButton.setSelected(true);
        this.allRadioButton.setText("All Neighbors");
        this.allRadioButton.setToolTipText("Select all neighbors");
        this.allRadioButton.setOpaque(false);
        this.allRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceGraphPanel.this.allRadioButtonActionPerformed(evt);
            }
        });
        this.selectionButtonGroup.add(this.uniqueRadioButton);
        this.uniqueRadioButton.setText("Unique Only");
        this.uniqueRadioButton.setToolTipText("Select unique neighbors only");
        this.uniqueRadioButton.setOpaque(false);
        this.uniqueRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceGraphPanel.this.uniqueRadioButtonActionPerformed(evt);
            }
        });
        this.highlightCheckBox.setText("Highlight");
        this.highlightCheckBox.setToolTipText("Highlight the selected peptides and proteins");
        this.highlightCheckBox.setOpaque(false);
        this.highlightCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinInferenceGraphPanel.this.highlightCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allRadioButton).addComponent(this.validationStatusRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.evidenceRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nodeTypeRadioButton)).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.uniqueRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.highlightCheckBox))).addContainerGap(-1, Short.MAX_VALUE)));
        settingsPanelLayout.linkSize(0, this.allRadioButton, this.evidenceRadioButton, this.highlightCheckBox, this.nodeTypeRadioButton, this.uniqueRadioButton, this.validationStatusRadioButton);
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.evidenceRadioButton).addComponent(this.validationStatusRadioButton).addComponent(this.nodeTypeRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uniqueRadioButton).addComponent(this.allRadioButton).addComponent(this.highlightCheckBox)).addGap(5, 5, 5)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.graphPanel, -1, -1, Short.MAX_VALUE).addComponent(this.selectionPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.selectionPanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.graphPanel, -1, 254, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.settingsPanel, -2, -1, -2)));
    }

    private void allRadioButtonActionPerformed(ActionEvent evt) {
        this.updateNodeSelection();
        this.repaint();
    }

    private void uniqueRadioButtonActionPerformed(ActionEvent evt) {
        this.updateNodeSelection();
        this.repaint();
    }

    private void validationStatusRadioButtonActionPerformed(ActionEvent evt) {
        this.repaint();
    }

    private void evidenceRadioButtonActionPerformed(ActionEvent evt) {
        this.repaint();
    }

    private void nodeTypeRadioButtonActionPerformed(ActionEvent evt) {
        this.repaint();
    }

    private void highlightCheckBoxActionPerformed(ActionEvent evt) {
        this.repaint();
    }

    private void proteinCountValueLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void proteinCountValueLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinCountValueLabelMouseReleased(MouseEvent evt) {
        new ProteinInferenceGraphSelectionDialog(this.parentDialog, true, this.getSelectedValuesAsString());
    }

    private void peptideCountValueLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideCountValueLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideCountValueLabelMouseReleased(MouseEvent evt) {
        new ProteinInferenceGraphSelectionDialog(this.parentDialog, true, this.getSelectedValuesAsString());
    }

    private void layoutLabelMouseReleased(MouseEvent evt) {
        this.updateGraphLayout();
    }

    private void layoutLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void layoutLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportLabelMouseReleased(MouseEvent evt) {
        new ExportGraphicsDialog(this.parentDialog, this.normalIcon, this.waitingIcon, true, (Component)this.graphPanel, this.lastSelectedFolder);
    }

    private void helpLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void helpLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void helpLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this.parentDialog, this.getClass().getResource("/helpFiles/ProteinInferenceGraph.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Inference - Help");
        this.setCursor(new Cursor(0));
    }

    private void legendLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void legendLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void legendLabelMouseReleased(MouseEvent evt) {
        new ProteinInferenceGraphLegendDialog(this.parentDialog, false);
    }

    private void selectAllLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void selectAllLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void selectAllLabelMouseReleased(MouseEvent evt) {
        for (String tempNode : this.nodes) {
            this.visualizationViewer.getPickedVertexState().pick((Object)tempNode, true);
        }
    }

    private void showProteinLabelsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void showProteinLabelsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void showProteinLabelsLabelMouseReleased(MouseEvent evt) {
        this.showProteinLabels = !this.showProteinLabels;
        this.repaint();
    }

    private void showPeptideLabelsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void showPeptideLabelsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void showPeptideLabelsLabelMouseReleased(MouseEvent evt) {
        this.showPeptideLabels = !this.showPeptideLabels;
        this.repaint();
    }

    private String getSelectedValuesAsString() {
        String proteinSelection = "";
        String peptideSelection = "";
        int proteinCount = 0;
        int peptideCount = 0;
        for (String tempNode : this.selectedNodes) {
            if (tempNode.startsWith("Protein")) {
                if (!proteinSelection.isEmpty()) {
                    proteinSelection = proteinSelection + "<br>";
                }
                if (this.nodeToolTips != null && this.nodeToolTips.containsKey(tempNode)) {
                    proteinSelection = proteinSelection + ++proteinCount + ": " + this.convertHtmlTooltip(this.nodeToolTips.get(tempNode));
                    continue;
                }
                proteinSelection = proteinSelection + ++proteinCount + ": " + tempNode.substring(tempNode.indexOf(" ") + 1);
                continue;
            }
            if (!tempNode.startsWith("Peptide")) continue;
            if (!peptideSelection.isEmpty()) {
                peptideSelection = peptideSelection + "<br>";
            }
            if (this.nodeToolTips != null && this.nodeToolTips.containsKey(tempNode)) {
                peptideSelection = peptideSelection + ++peptideCount + ": " + this.convertHtmlTooltip(this.nodeToolTips.get(tempNode));
                continue;
            }
            peptideSelection = peptideSelection + ++peptideCount + ": " + tempNode.substring(tempNode.indexOf(" ") + 1);
        }
        for (String tempNode : this.selectedNeighborNodes) {
            if (this.selectedNodes.contains(tempNode)) continue;
            if (tempNode.startsWith("Protein")) {
                if (!proteinSelection.isEmpty()) {
                    proteinSelection = proteinSelection + "<br>";
                }
                if (this.nodeToolTips != null && this.nodeToolTips.containsKey(tempNode)) {
                    proteinSelection = proteinSelection + ++proteinCount + ": " + this.convertHtmlTooltip(this.nodeToolTips.get(tempNode));
                    continue;
                }
                proteinSelection = proteinSelection + ++proteinCount + ": " + tempNode.substring(tempNode.indexOf(" ") + 1);
                continue;
            }
            if (!tempNode.startsWith("Peptide")) continue;
            if (!peptideSelection.isEmpty()) {
                peptideSelection = peptideSelection + "<br>";
            }
            if (this.nodeToolTips != null && this.nodeToolTips.containsKey(tempNode)) {
                peptideSelection = peptideSelection + ++peptideCount + ": " + this.convertHtmlTooltip(this.nodeToolTips.get(tempNode));
                continue;
            }
            peptideSelection = peptideSelection + ++peptideCount + ": " + tempNode.substring(tempNode.indexOf(" ") + 1);
        }
        return "<html><b>Proteins:</b><br>" + proteinSelection + "<br><br><b>Peptides:</b><br>" + peptideSelection + "</html>";
    }

    private String convertHtmlTooltip(String tooltipAsHtml) {
        String temp = tooltipAsHtml.replaceAll(Pattern.quote("<br>"), " - ");
        temp = temp.replaceAll(Pattern.quote("-  -"), "-");
        temp = temp.replaceAll(Pattern.quote("<html>"), "");
        temp = temp.replaceAll(Pattern.quote("</html>"), "");
        return temp;
    }

    public class ProteinInferenceVertexRenderer
    implements Renderer.Vertex<String, String> {
        public void paintVertex(RenderContext<String, String> rc, Layout<String, String> layout, String vertex) {
            GraphicsDecorator graphicsContext = rc.getGraphicsContext();
            Point2D center = (Point2D)layout.transform((Object)vertex);
            Ellipse2D.Double shape = null;
            Color color = null;
            int alpha = 255;
            if (!ProteinInferenceGraphPanel.this.selectedNeighborNodes.isEmpty()) {
                if (!ProteinInferenceGraphPanel.this.selectedNeighborNodes.contains(vertex) && !ProteinInferenceGraphPanel.this.selectedNodes.contains(vertex)) {
                    alpha = 50;
                }
            } else if (!ProteinInferenceGraphPanel.this.selectedNodes.contains(vertex)) {
                alpha = 50;
            }
            if (ProteinInferenceGraphPanel.this.selectedNodes.contains(vertex) && ProteinInferenceGraphPanel.this.highlightCheckBox.isSelected()) {
                if (vertex.startsWith("Protein")) {
                    shape = new Ellipse2D.Double(center.getX() - 22.0, center.getY() - 22.0, 44.0, 44.0);
                } else if (vertex.startsWith("Peptide")) {
                    shape = new Ellipse2D.Double(center.getX() - 14.0, center.getY() - 14.0, 28.0, 28.0);
                }
                graphicsContext.setPaint((Paint)Color.ORANGE);
                graphicsContext.fill(shape);
            }
            boolean highlightAdded = false;
            if (!ProteinInferenceGraphPanel.this.nodeTypeRadioButton.isSelected() && ProteinInferenceGraphPanel.this.nodeProperties.get(vertex) != null) {
                int evidenceLevel;
                int validationLevel;
                highlightAdded = true;
                String[] properties = ((String)ProteinInferenceGraphPanel.this.nodeProperties.get(vertex)).split("\\|");
                color = ProteinInferenceGraphPanel.this.validationStatusRadioButton.isSelected() ? ((validationLevel = Integer.parseInt(properties[0])) == 0 ? new Color(255, 0, 0, alpha) : (validationLevel == 1 ? new Color(255, 204, 0, alpha) : (validationLevel == 2 ? new Color(110, 196, 97, alpha) : new Color(200, 200, 200, alpha)))) : (properties.length > 1 ? ((evidenceLevel = Integer.parseInt(properties[1])) == 1 ? new Color(110, 196, 97, alpha) : (evidenceLevel == 2 ? new Color(255, 204, 0, alpha) : (evidenceLevel == 3 ? new Color(110, 196, 197, alpha) : (evidenceLevel == 4 ? new Color(247, 53, 233, alpha) : (evidenceLevel == 5 ? new Color(255, 0, 0, alpha) : new Color(200, 200, 200, alpha)))))) : new Color(200, 200, 200, alpha));
            }
            if (vertex.startsWith("Protein")) {
                shape = new Ellipse2D.Double(center.getX() - 18.0, center.getY() - 18.0, 36.0, 36.0);
                if (!highlightAdded) {
                    color = new Color(255, 0, 0, alpha);
                }
            } else if (vertex.startsWith("Peptide")) {
                shape = new Ellipse2D.Double(center.getX() - 10.0, center.getY() - 10.0, 20.0, 20.0);
                if (!highlightAdded) {
                    color = new Color(0, 0, 255, alpha);
                }
            }
            graphicsContext.setPaint(color);
            graphicsContext.fill(shape);
            color = new Color(150, 150, 150, alpha);
            graphicsContext.setPaint((Paint)color);
            graphicsContext.draw((Shape)shape);
            if (ProteinInferenceGraphPanel.this.selectedNodes.contains(vertex) && ProteinInferenceGraphPanel.this.highlightCheckBox.isSelected()) {
                if (vertex.startsWith("Protein")) {
                    shape = new Ellipse2D.Double(center.getX() - 22.0, center.getY() - 22.0, 44.0, 44.0);
                } else if (vertex.startsWith("Peptide")) {
                    shape = new Ellipse2D.Double(center.getX() - 14.0, center.getY() - 14.0, 28.0, 28.0);
                }
                color = new Color(150, 150, 150, alpha);
                graphicsContext.setPaint((Paint)color);
                graphicsContext.draw((Shape)shape);
            }
        }
    }
}

