/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.protein_sequence;

import eu.isas.peptideshaker.gui.protein_sequence.ProteinAnnotations;
import eu.isas.peptideshaker.gui.protein_sequence.ProteinSequencePanelParent;
import eu.isas.peptideshaker.gui.protein_sequence.ResidueAnnotation;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.IntervalCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ProteinSequencePanel {
    private ProteinSequencePanelParent proteinSequencePanelParent;
    private Color backgroundColor;
    private double referenceLineWidth = 0.03;
    private Color referenceLineColor = Color.BLACK;
    private ChartPanel chartPanel;

    public ProteinSequencePanel(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBackground(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setReferenceLine(double referenceLineWidth, Color referenceLineColor) {
        this.referenceLineWidth = referenceLineWidth;
        this.referenceLineColor = referenceLineColor;
    }

    public ChartPanel getSequencePlot(ProteinSequencePanelParent aProteinSequencePanelParent, JSparklinesDataset sparklineDataset, HashMap<Integer, ArrayList<ResidueAnnotation>> proteinAnnotations, boolean addReferenceLine, boolean allowZooming) {
        this.proteinSequencePanelParent = aProteinSequencePanelParent;
        DefaultCategoryDataset barChartDataset = new DefaultCategoryDataset();
        StackedBarRenderer renderer = new StackedBarRenderer();
        renderer.setShadowVisible(false);
        ProteinAnnotations myTooltips = new ProteinAnnotations(proteinAnnotations);
        for (int i = 0; i < sparklineDataset.getData().size(); ++i) {
            JSparklinesDataSeries sparklineDataSeries = (JSparklinesDataSeries)sparklineDataset.getData().get(i);
            for (int j = 0; j < sparklineDataSeries.getData().size(); ++j) {
                barChartDataset.addValue((Number)sparklineDataSeries.getData().get(j), (Comparable)((Object)("" + i)), (Comparable)((Object)("" + j)));
                renderer.setSeriesPaint(i, (Paint)sparklineDataSeries.getSeriesColor());
                renderer.setSeriesToolTipGenerator(i, (CategoryToolTipGenerator)myTooltips);
            }
        }
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)barChartDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.getDomainAxis().setUpperMargin(0.0);
        plot.getDomainAxis().setLowerMargin(0.0);
        plot.getRangeAxis().setUpperMargin(0.0);
        plot.getRangeAxis().setLowerMargin(0.0);
        renderer.setRenderAsPercentages(true);
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new IntervalCategoryToolTipGenerator());
        plot.setDataset((CategoryDataset)barChartDataset);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainGridlinesVisible(false);
        if (addReferenceLine) {
            DefaultCategoryDataset referenceLineDataset = new DefaultCategoryDataset();
            referenceLineDataset.addValue(1.0, (Comparable)((Object)"A"), (Comparable)((Object)"B"));
            plot.setDataset(1, (CategoryDataset)referenceLineDataset);
            LayeredBarRenderer referenceLineRenderer = new LayeredBarRenderer();
            referenceLineRenderer.setSeriesBarWidth(0, this.referenceLineWidth);
            referenceLineRenderer.setSeriesFillPaint(0, (Paint)this.referenceLineColor);
            referenceLineRenderer.setSeriesPaint(0, (Paint)this.referenceLineColor);
            plot.setRenderer(1, (CategoryItemRenderer)referenceLineRenderer);
        }
        plot.setRenderer(0, (CategoryItemRenderer)renderer);
        chart.getPlot().setOutlineVisible(false);
        chart.getPlot().setBackgroundPaint((Paint)this.backgroundColor);
        chart.setBackgroundPaint((Paint)this.backgroundColor);
        final HashMap<Integer, ArrayList<ResidueAnnotation>> blockTooltips = proteinAnnotations;
        this.chartPanel = new ChartPanel(chart);
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent cme) {
                if (cme.getEntity() != null && cme.getTrigger().getButton() == 1) {
                    ((CategoryItemEntity)cme.getEntity()).getDataset();
                    Integer blockNumber = Integer.valueOf((String)((Object)((CategoryItemEntity)cme.getEntity()).getRowKey()));
                    ArrayList annotation = (ArrayList)blockTooltips.get(blockNumber);
                    if (annotation != null) {
                        ProteinSequencePanel.this.proteinSequencePanelParent.annotationClicked(annotation, cme);
                    }
                }
            }

            public void chartMouseMoved(ChartMouseEvent cme) {
                cme.getTrigger().getComponent().setCursor(new Cursor(0));
                if (cme.getEntity() != null && cme.getEntity() instanceof CategoryItemEntity) {
                    ((CategoryItemEntity)cme.getEntity()).getDataset();
                    Integer blockNumber = Integer.valueOf((String)((Object)((CategoryItemEntity)cme.getEntity()).getRowKey()));
                    ArrayList annotation = (ArrayList)blockTooltips.get(blockNumber);
                    if (annotation != null && !annotation.isEmpty() && ((ResidueAnnotation)((ArrayList)blockTooltips.get((Object)blockNumber)).get((int)0)).clickable) {
                        cme.getTrigger().getComponent().setCursor(new Cursor(12));
                    }
                }
            }
        });
        if (!allowZooming) {
            this.chartPanel.setPopupMenu(null);
            this.chartPanel.setRangeZoomable(false);
        }
        this.chartPanel.setBackground(this.backgroundColor);
        return this.chartPanel;
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public static ArrayList<JSparklinesDataSeries> getSparkLineDataSeriesCoverage(double[] aaHeight, int[] aaColorIndex, HashMap<Integer, Color> colors) {
        if (aaHeight.length == 0) {
            throw new IllegalArgumentException("Empty height given to protein coverage panel.");
        }
        if (aaHeight.length != aaColorIndex.length) {
            throw new IllegalArgumentException("Height and length size given to protein coverage panel differ.");
        }
        ArrayList<JSparklinesDataSeries> sparkLineDataSeriesCoverage = new ArrayList<JSparklinesDataSeries>();
        int previousIndex = 0;
        int previousColorIndex = aaColorIndex[0];
        double previousHeight = aaHeight[0];
        for (int i = 0; i < aaHeight.length; ++i) {
            int newColorIndex = aaColorIndex[i];
            double newHeight = aaHeight[i];
            if (newColorIndex == previousColorIndex) continue;
            double length = i - previousIndex;
            ArrayList<Double> series = new ArrayList<Double>(1);
            series.add(length);
            Color color = colors.get(previousColorIndex);
            if (color == null) {
                throw new IllegalArgumentException("Color not set for index " + previousColorIndex + ".");
            }
            sparkLineDataSeriesCoverage.add(new JSparklinesDataSeries(series, color, null));
            previousColorIndex = newColorIndex;
            previousIndex = i;
            previousHeight = newHeight;
        }
        double length = aaHeight.length - previousIndex;
        ArrayList<Double> series = new ArrayList<Double>(1);
        series.add(length);
        Color color = colors.get(previousColorIndex);
        if (color == null) {
            throw new IllegalArgumentException("Color not set for index " + previousColorIndex + ".");
        }
        sparkLineDataSeriesCoverage.add(new JSparklinesDataSeries(series, color, null));
        return sparkLineDataSeriesCoverage;
    }
}

