/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.start;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.gui.GuiUtilities;
import eu.isas.peptideshaker.gui.ImageIconPanel;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.WelcomeDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;

public class GettingStartedDialog
extends JDialog {
    private final PeptideShakerGUI peptideShakerGUI;
    private final WelcomeDialog welcomeDialog;
    private ArrayList<ImageIconPanel> displayPanels;
    private int currentDisplayPanelIndex = 0;
    private JButton backButton;
    private JPanel backgroundPanel;
    private JPanel buttonsAndLinksPanel;
    private JButton compomicsButton;
    private JPanel displayPanel;
    private JButton isasButton;
    private JSeparator jSeparator;
    private JButton nextButton;
    private JButton probeButton;

    public GettingStartedDialog(PeptideShakerGUI peptideShakerGUI, WelcomeDialog welcomeDialog, boolean modal) {
        super((Frame)peptideShakerGUI, modal);
        this.peptideShakerGUI = peptideShakerGUI;
        this.welcomeDialog = welcomeDialog;
        this.initComponents();
        this.setUpDisplayPanels();
        GuiUtilities.installEscapeCloseOperation(this);
        this.displayPanel.add(this.displayPanels.get(this.currentDisplayPanelIndex));
        this.nextButton.setEnabled(this.currentDisplayPanelIndex < this.displayPanels.size() - 1);
        this.backButton.setEnabled(this.currentDisplayPanelIndex > 0);
        this.setFocusable(true);
        this.backgroundPanel.requestFocus();
        this.setLocationRelativeTo(peptideShakerGUI);
        this.setVisible(true);
    }

    private void setUpDisplayPanels() {
        this.displayPanels = new ArrayList();
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/introduction.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/searchgui.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/overview_tab.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/overview_tab_2.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/export_features.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/export_features_2.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/contextual_help.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/specific_tabs.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/save_and_export.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/pride_export.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/pride_reshake.png"))));
        this.displayPanels.add(new ImageIconPanel(new ImageIcon(this.getClass().getResource("/helpFiles/images/example_dataset.png"))));
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.displayPanel = new JPanel();
        this.buttonsAndLinksPanel = new JPanel();
        this.compomicsButton = new JButton();
        this.probeButton = new JButton();
        this.isasButton = new JButton();
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.jSeparator = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Getting Started with PeptideShaker");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.backgroundPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GettingStartedDialog.this.backgroundPanelKeyReleased(evt);
            }
        });
        this.displayPanel.setBackground(new Color(255, 255, 255));
        this.displayPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GettingStartedDialog.this.displayPanelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                GettingStartedDialog.this.displayPanelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GettingStartedDialog.this.displayPanelMouseExited(evt);
            }
        });
        this.displayPanel.setLayout(new BoxLayout(this.displayPanel, 2));
        this.buttonsAndLinksPanel.setBackground(new Color(255, 255, 255));
        this.compomicsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/compomics.png")));
        this.compomicsButton.setToolTipText("Computational Omics and Systems Biology Group");
        this.compomicsButton.setBorder(null);
        this.compomicsButton.setBorderPainted(false);
        this.compomicsButton.setContentAreaFilled(false);
        this.compomicsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GettingStartedDialog.this.compomicsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GettingStartedDialog.this.compomicsButtonMouseExited(evt);
            }
        });
        this.compomicsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GettingStartedDialog.this.compomicsButtonActionPerformed(evt);
            }
        });
        this.probeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/probe.png")));
        this.probeButton.setToolTipText("Proteomics Unit at the University of Bergen");
        this.probeButton.setBorder(null);
        this.probeButton.setBorderPainted(false);
        this.probeButton.setContentAreaFilled(false);
        this.probeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GettingStartedDialog.this.probeButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GettingStartedDialog.this.probeButtonMouseExited(evt);
            }
        });
        this.probeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GettingStartedDialog.this.probeButtonActionPerformed(evt);
            }
        });
        this.isasButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/isas.png")));
        this.isasButton.setToolTipText("<html>ISAS - Institute for Analytical Science</html>");
        this.isasButton.setBorder(null);
        this.isasButton.setBorderPainted(false);
        this.isasButton.setContentAreaFilled(false);
        this.isasButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                GettingStartedDialog.this.isasButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GettingStartedDialog.this.isasButtonMouseExited(evt);
            }
        });
        this.isasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GettingStartedDialog.this.isasButtonActionPerformed(evt);
            }
        });
        this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/helpFiles/images/back_gray.png")));
        this.backButton.setBorderPainted(false);
        this.backButton.setContentAreaFilled(false);
        this.backButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/helpFiles/images/back.png")));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GettingStartedDialog.this.backButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/helpFiles/images/next_gray.png")));
        this.nextButton.setBorderPainted(false);
        this.nextButton.setContentAreaFilled(false);
        this.nextButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/helpFiles/images/next.png")));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GettingStartedDialog.this.nextButtonActionPerformed(evt);
            }
        });
        GroupLayout buttonsAndLinksPanelLayout = new GroupLayout(this.buttonsAndLinksPanel);
        this.buttonsAndLinksPanel.setLayout(buttonsAndLinksPanelLayout);
        buttonsAndLinksPanelLayout.setHorizontalGroup(buttonsAndLinksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsAndLinksPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.backButton, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 91, Short.MAX_VALUE).addComponent(this.compomicsButton).addGap(26, 26, 26).addComponent(this.probeButton).addGap(18, 18, 18).addComponent(this.isasButton).addGap(89, 89, 89).addComponent(this.nextButton, -2, 96, -2).addContainerGap()));
        buttonsAndLinksPanelLayout.setVerticalGroup(buttonsAndLinksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backButton, GroupLayout.Alignment.CENTER, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.CENTER, buttonsAndLinksPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.nextButton, -2, 61, -2).addGroup(buttonsAndLinksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.isasButton, GroupLayout.Alignment.CENTER).addComponent(this.probeButton, GroupLayout.Alignment.CENTER).addComponent(this.compomicsButton, GroupLayout.Alignment.CENTER))));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addComponent(this.buttonsAndLinksPanel, -1, -1, Short.MAX_VALUE).addGap(10, 10, 10)).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.displayPanel, -1, 525, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator, -2, 5, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonsAndLinksPanel, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void compomicsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void compomicsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void compomicsButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://compomics.com");
        this.setCursor(new Cursor(0));
    }

    private void probeButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void probeButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void probeButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://probe.uib.no");
        this.setCursor(new Cursor(0));
    }

    private void isasButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void isasButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void isasButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://www.isas.de");
        this.setCursor(new Cursor(0));
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        ++this.currentDisplayPanelIndex;
        this.displayPanel.removeAll();
        this.displayPanel.add(this.displayPanels.get(this.currentDisplayPanelIndex));
        this.backgroundPanel.revalidate();
        this.backgroundPanel.repaint();
        this.nextButton.setEnabled(this.currentDisplayPanelIndex < this.displayPanels.size() - 1);
        this.backButton.setEnabled(this.currentDisplayPanelIndex > 0);
    }

    private void backButtonActionPerformed(ActionEvent evt) {
        --this.currentDisplayPanelIndex;
        this.displayPanel.removeAll();
        this.displayPanel.add(this.displayPanels.get(this.currentDisplayPanelIndex));
        this.backgroundPanel.revalidate();
        this.backgroundPanel.repaint();
        this.nextButton.setEnabled(this.currentDisplayPanelIndex < this.displayPanels.size() - 1);
        this.backButton.setEnabled(this.currentDisplayPanelIndex > 0);
    }

    private void displayPanelMouseEntered(MouseEvent evt) {
        if (this.currentDisplayPanelIndex == this.displayPanels.size() - 1) {
            this.setCursor(new Cursor(12));
            this.displayPanel.setToolTipText("Click to open example dataset.");
        } else if (this.currentDisplayPanelIndex == this.displayPanels.size() - 2) {
            this.setCursor(new Cursor(12));
            this.displayPanel.setToolTipText("Click to open the SearchGUI home page.");
        } else {
            this.displayPanel.setToolTipText(null);
        }
    }

    private void displayPanelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
        this.displayPanel.setToolTipText(null);
    }

    private void displayPanelMouseClicked(MouseEvent evt) {
        if (this.currentDisplayPanelIndex == this.displayPanels.size() - 1) {
            this.setCursor(new Cursor(3));
            this.setVisible(false);
            if (this.welcomeDialog != null) {
                this.welcomeDialog.setVisible(false);
            }
            this.peptideShakerGUI.setVisible(true);
            this.dispose();
            this.peptideShakerGUI.openExampleFile();
            this.setCursor(new Cursor(0));
        } else if (this.currentDisplayPanelIndex == 1) {
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL("https://compomics.github.io/projects/searchgui.html");
            this.setCursor(new Cursor(0));
        }
    }

    private void backgroundPanelKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 37) {
            if (this.backButton.isEnabled()) {
                this.backButtonActionPerformed(null);
            }
        } else if (evt.getKeyCode() == 39 && this.nextButton.isEnabled()) {
            this.nextButtonActionPerformed(null);
        }
    }
}

