/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tablemodels;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class PeptideFractionTableModel
extends DefaultTableModel {
    private final Identification identification;
    private final DisplayFeaturesGenerator displayFeaturesGenerator;
    private ArrayList<Long> peptideKeys = null;
    private ArrayList<String> fileNames = new ArrayList();

    public PeptideFractionTableModel(Identification identification, DisplayFeaturesGenerator displayFeaturesGenerator, ArrayList<Long> peptideKeys, ArrayList<String> fileNames) {
        this.identification = identification;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.peptideKeys = peptideKeys;
        this.fileNames = fileNames;
    }

    public void updateDataModel(ArrayList<Long> peptideKeys) {
        this.peptideKeys = peptideKeys;
    }

    public void reset() {
        this.peptideKeys = null;
    }

    @Override
    public int getRowCount() {
        return this.peptideKeys == null ? 0 : this.peptideKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.fileNames.size() + 4;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return " ";
        }
        if (column == 1) {
            return "Sequence";
        }
        if (column > 1 && column - 2 < this.fileNames.size()) {
            return this.fileNames.get(column - 2);
        }
        if (column == this.fileNames.size() + 2) {
            return "Confidence";
        }
        if (column == this.fileNames.size() + 3) {
            return "";
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        long peptideKey = this.peptideKeys.get(row);
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
        if (column == 0) {
            return row + 1;
        }
        if (column == 1) {
            return this.displayFeaturesGenerator.getTaggedPeptideSequence(peptideMatch, true, true, true);
        }
        if (column > 1) {
            PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
            if (column - 2 < this.fileNames.size()) {
                Double confidence;
                String fraction = this.fileNames.get(column - 2);
                if (psParameter.getFractionScore() != null && (confidence = psParameter.getFractionConfidence(fraction)) != null) {
                    return confidence;
                }
                return 0.0;
            }
            if (column == this.fileNames.size() + 2) {
                return psParameter.getConfidence();
            }
            if (column == this.fileNames.size() + 3) {
                return psParameter.getMatchValidationLevel().getIndex();
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }
}

