/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.preferences;

import com.compomics.util.io.file.SerializationUtils;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.preferences.UserParameters;
import java.io.File;

public abstract class UserPreferencesParent {
    protected UserParameters userPreferences;

    public void loadUserParameters() {
        try {
            File file = new File(PeptideShaker.getUserPreferencesFile());
            if (!file.exists()) {
                this.userPreferences = new UserParameters();
                this.saveUserParameters();
            } else {
                this.userPreferences = (UserParameters)SerializationUtils.readObject(file);
            }
        }
        catch (Exception e) {
            System.err.println("An error occurred while loading " + PeptideShaker.getUserPreferencesFile() + " (see below). User preferences set back to default.");
            e.printStackTrace();
            this.userPreferences = new UserParameters();
        }
    }

    public void saveUserParameters() {
        try {
            File file = new File(PeptideShaker.getUserPreferencesFile());
            boolean parentExists = true;
            if (!file.getParentFile().exists()) {
                parentExists = file.getParentFile().mkdir();
            }
            if (parentExists) {
                SerializationUtils.writeObject(this.userPreferences, file);
            } else {
                System.out.println("Parent folder does not exist: '" + file.getParentFile() + "'. User preferences not saved.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

