/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.processing;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.processing.PsmProcessorRunnable;
import eu.isas.peptideshaker.ptm.ModificationLocalizationScorer;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.validation.MatchesValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PsmProcessor {
    private final Identification identification;

    public PsmProcessor(Identification identification) {
        this.identification = identification;
    }

    public void processPsms(InputMap inputMap, IdentificationParameters identificationParameters, MatchesValidator matchesValidator, ModificationLocalizationScorer modificationLocalizationScorer, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ModificationProvider modificationProvider, HashMap<String, Integer> proteinCount, int nThreads, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws InterruptedException, TimeoutException {
        ConcurrentLinkedQueue<Long> spectrumMatchKeysIterator = new ConcurrentLinkedQueue<Long>(this.identification.getSpectrumIdentificationKeys());
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(spectrumMatchKeysIterator.size());
        ExecutorService importPool = Executors.newFixedThreadPool(nThreads);
        ArrayList<PsmProcessorRunnable> importRunnables = new ArrayList<PsmProcessorRunnable>(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            importRunnables.add(new PsmProcessorRunnable(spectrumMatchKeysIterator, this.identification, identificationParameters, inputMap, matchesValidator, modificationLocalizationScorer, sequenceProvider, spectrumProvider, modificationProvider, proteinCount, waitingHandler, exceptionHandler));
        }
        importRunnables.forEach(worker -> importPool.submit((Runnable)worker));
        importPool.shutdown();
        if (!importPool.awaitTermination(365L, TimeUnit.DAYS)) {
            throw new TimeoutException("Analysis timed out (time out: 365 days)");
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }
}

