/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.scoring.maps;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class SpecificTargetDecoyMap
extends ExperimentObject
implements Serializable {
    static final long serialVersionUID = 746516685643358198L;
    protected final HashMap<Integer, HashMap<String, TargetDecoyMap>> fileSpecificMaps = new HashMap(4);
    protected final HashMap<Integer, HashSet<String>> fileSpecificGrouping = new HashMap(4);
    protected final HashMap<Integer, TargetDecoyMap> groupedMaps = new HashMap(4);
    protected final HashMap<Integer, Integer> grouping = new HashMap(4);

    public void estimateProbabilities(WaitingHandler waitingHandler) {
        int max = this.getMapsSize();
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(max);
        this.fileSpecificMaps.entrySet().stream().forEach(entry1 -> ((HashMap)entry1.getValue()).entrySet().stream().filter(entry2 -> !this.fileSpecificGrouping.containsKey(entry1.getKey()) || this.fileSpecificGrouping.get(entry1.getKey()).contains(entry2.getKey())).forEach(entry2 -> ((TargetDecoyMap)entry2.getValue()).estimateProbabilities(waitingHandler)));
        this.groupedMaps.entrySet().stream().filter(entry -> !this.grouping.containsKey(entry.getKey())).forEach(entry -> ((TargetDecoyMap)entry.getValue()).estimateProbabilities(waitingHandler));
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public double getProbability(String file, int category, double score) {
        HashSet<String> groupedFiles = this.fileSpecificGrouping.get(category);
        if (groupedFiles != null && groupedFiles.contains(file)) {
            TargetDecoyMap targetDecoyMap;
            Integer key = this.grouping.get(category);
            if (key == null) {
                key = category;
            }
            if ((targetDecoyMap = this.groupedMaps.get(key)) == null) {
                return 1.0;
            }
            return targetDecoyMap.getProbability(score);
        }
        HashMap<String, TargetDecoyMap> specificMap = this.fileSpecificMaps.get(category);
        if (specificMap == null) {
            return 1.0;
        }
        TargetDecoyMap targetDecoyMap = specificMap.get(file);
        if (targetDecoyMap == null) {
            return 1.0;
        }
        return targetDecoyMap.getProbability(score);
    }

    public void addPoint(String fileName, int category, double score, boolean decoy) {
        TargetDecoyMap targetDecoyMap;
        HashMap<String, TargetDecoyMap> fileMapping = this.fileSpecificMaps.get(category);
        if (fileMapping == null) {
            fileMapping = new HashMap(4);
            this.fileSpecificMaps.put(category, fileMapping);
        }
        if ((targetDecoyMap = fileMapping.get(fileName)) == null) {
            targetDecoyMap = new TargetDecoyMap();
            fileMapping.put(fileName, targetDecoyMap);
        }
        targetDecoyMap.put(score, decoy);
    }

    public abstract void clean(double var1);

    public TargetDecoyMap getTargetDecoyMap(int category, String spectrumFile) {
        HashMap<String, TargetDecoyMap> categoryMapping;
        if (spectrumFile != null && this.isFileGrouped(category, spectrumFile) && (categoryMapping = this.fileSpecificMaps.get(category)) != null) {
            return categoryMapping.get(spectrumFile);
        }
        int correctedCharge = this.getCorrectedCharge(category);
        return this.groupedMaps.get(correctedCharge);
    }

    public boolean isFileGrouped(int category, String fileName) {
        HashSet<String> groupedFiles = this.fileSpecificGrouping.get(category);
        return groupedFiles != null && groupedFiles.contains(fileName);
    }

    public int getCorrectedCharge(int category) {
        Integer correctedCharge = this.grouping.get(category);
        if (correctedCharge == null) {
            return category;
        }
        return correctedCharge;
    }

    public Set<Integer> getPossibleCategories() {
        return this.fileSpecificMaps.keySet();
    }

    public Set<Integer> getCategoriesFromGroupedFiles() {
        return this.groupedMaps.keySet();
    }

    public int[] getGroupedCategories() {
        return this.groupedMaps.keySet().stream().mapToInt(category -> this.getCorrectedCharge((int)category)).distinct().toArray();
    }

    public HashMap<Integer, ArrayList<Integer>> getChargeGroupingMap() {
        HashMap<Integer, ArrayList<Integer>> result = new HashMap<Integer, ArrayList<Integer>>(4);
        for (int category : this.getCategoriesFromGroupedFiles()) {
            int correctedCategory = this.getCorrectedCharge(category);
            if (correctedCategory != category) {
                ArrayList<Integer> secondaryCategories = result.get(correctedCategory);
                if (secondaryCategories == null) {
                    secondaryCategories = new ArrayList(1);
                    result.put(correctedCategory, secondaryCategories);
                }
                secondaryCategories.add(category);
                continue;
            }
            if (result.containsKey(category)) continue;
            result.put(category, new ArrayList(1));
        }
        return result;
    }

    public TreeSet<String> getFilesAtCategory(int category) {
        HashMap<String, TargetDecoyMap> categoryMap = this.fileSpecificMaps.get(category);
        return categoryMap == null ? new TreeSet<String>() : new TreeSet<String>(categoryMap.keySet());
    }

    public int getMapsSize() {
        return this.groupedMaps.values().stream().mapToInt(map -> map.getMapSize()).sum() + this.fileSpecificMaps.values().stream().flatMap(map -> map.values().stream()).mapToInt(map -> map.getMapSize()).sum();
    }

    public ArrayList<TargetDecoyMap> getTargetDecoyMaps() {
        ArrayList<TargetDecoyMap> result = new ArrayList<TargetDecoyMap>(0);
        result.addAll(this.fileSpecificMaps.entrySet().stream().flatMap(entry1 -> ((HashMap)entry1.getValue()).entrySet().stream().filter(entry2 -> !this.isFileGrouped((Integer)entry1.getKey(), (String)entry2.getKey())).map(entry2 -> (TargetDecoyMap)entry2.getValue())).collect(Collectors.toList()));
        result.addAll(Arrays.stream(this.getGroupedCategories()).mapToObj(category -> this.groupedMaps.get(category)).collect(Collectors.toList()));
        return result;
    }
}

