/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.scoring.targetdecoy;

import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyPoint;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyResults;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoySeries;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class TargetDecoyMap
extends ExperimentObject {
    static final long serialVersionUID = 7333389442377322662L;
    private HashMap<Double, TargetDecoyPoint> hitMap = new HashMap();
    private ArrayList<Double> scores;
    private Integer minDecoysInBin = 2;
    private Integer nmax;
    private Integer windowSize;
    private Integer nTargetOnly;
    private double minFDR = 1.0;
    private TargetDecoyResults targetDecoyResults = new TargetDecoyResults();

    public TargetDecoyMap() {
    }

    public TargetDecoyMap(Integer minDecoysInBin) {
        this.minDecoysInBin = minDecoysInBin;
    }

    public double getProbability(double score) {
        TargetDecoyPoint point = this.hitMap.get(score);
        if (point != null) {
            return point.p;
        }
        if (score >= this.scores.get(this.scores.size() - 1)) {
            return this.hitMap.get((Object)this.scores.get((int)(this.scores.size() - 1))).p;
        }
        int indexDown = 0;
        int indexUp = this.scores.size() - 1;
        while (indexUp - indexDown > 1) {
            int indexTemp = (indexUp - indexDown) / 2 + indexDown;
            if (this.scores.get(indexTemp) > score) {
                indexUp = indexTemp;
                continue;
            }
            indexDown = indexTemp;
        }
        return (this.hitMap.get((Object)this.scores.get((int)indexUp)).p + this.hitMap.get((Object)this.scores.get((int)indexDown)).p) / 2.0;
    }

    public int getNTarget(double score) {
        return this.hitMap.get((Object)Double.valueOf((double)score)).nTarget;
    }

    public int getNDecoy(double score) {
        return this.hitMap.get((Object)Double.valueOf((double)score)).nDecoy;
    }

    public void put(double score, boolean isDecoy) {
        TargetDecoyPoint targetDecoyPoint = this.hitMap.get(score);
        if (targetDecoyPoint == null) {
            targetDecoyPoint = this.createTargetDecoyPoint(score);
        }
        if (isDecoy) {
            targetDecoyPoint.increaseDecoy();
        } else {
            targetDecoyPoint.increaseTarget();
        }
    }

    public synchronized TargetDecoyPoint createTargetDecoyPoint(double score) {
        TargetDecoyPoint targetDecoyPoint = this.hitMap.get(score);
        if (targetDecoyPoint == null) {
            targetDecoyPoint = new TargetDecoyPoint();
            this.hitMap.put(score, targetDecoyPoint);
        }
        return targetDecoyPoint;
    }

    public void remove(double score, boolean isDecoy) {
        TargetDecoyPoint targetDecoyPoint = this.hitMap.get(score);
        if (!isDecoy) {
            targetDecoyPoint.decreaseTarget();
        } else {
            targetDecoyPoint.decreaseDecoy();
        }
    }

    public synchronized void cleanUp() {
        boolean removed = false;
        HashSet<Double> currentScores = new HashSet<Double>(this.hitMap.keySet());
        for (double score : currentScores) {
            TargetDecoyPoint targetDecoyPoint = this.hitMap.get(score);
            if (targetDecoyPoint.nTarget != 0 || targetDecoyPoint.nDecoy != 0) continue;
            this.hitMap.remove(score);
            removed = true;
        }
        if (removed) {
            this.scores = null;
            this.nmax = null;
            this.windowSize = null;
        }
    }

    private void estimateNs() {
        if (this.scores == null) {
            this.estimateScores();
        }
        boolean onlyTarget = true;
        this.nmax = 0;
        int targetCpt = 0;
        int decoyCpt = 0;
        this.nTargetOnly = 0;
        int targetCount = 0;
        int decoyCount = 0;
        for (double score : this.scores) {
            double fdr;
            TargetDecoyPoint point = this.hitMap.get(score);
            if (onlyTarget) {
                if (point.nDecoy > 0) {
                    this.nTargetOnly = this.nTargetOnly + (point.nTarget / 2 + point.nTarget % 2);
                    targetCpt += point.nTarget / 2;
                    onlyTarget = false;
                    decoyCpt += point.nDecoy;
                } else {
                    this.nTargetOnly = this.nTargetOnly + point.nTarget;
                }
            } else if (point.nDecoy > 0) {
                if ((targetCpt += point.nTarget / 2 + point.nTarget % 2) > this.nmax && score < 1.0 && (decoyCpt += point.nDecoy) >= this.minDecoysInBin) {
                    this.nmax = targetCpt;
                }
                targetCpt = point.nTarget / 2;
                decoyCpt = point.nDecoy;
            } else {
                targetCpt += point.nTarget;
            }
            decoyCount += point.nDecoy;
            if ((targetCount += point.nTarget) <= 0 || !((fdr = (double)decoyCount / (double)targetCount) < this.minFDR)) continue;
            this.minFDR = fdr;
        }
    }

    public void estimateProbabilities(WaitingHandler waitingHandler) {
        if (this.scores == null) {
            this.estimateScores();
        }
        if (this.nmax == null) {
            this.estimateNs();
        }
        if (this.windowSize == null) {
            this.windowSize = this.nmax;
        }
        double currentScore = this.scores.get(0);
        TargetDecoyPoint previousPoint = this.hitMap.get(currentScore);
        double nLimit = 0.5 * (double)this.windowSize.intValue();
        double nTargetUp = 1.5 * (double)previousPoint.nTarget;
        double nTargetDown = -0.5 * (double)previousPoint.nTarget;
        double nDecoy = previousPoint.nDecoy;
        int iDown = 0;
        int iUp = 1;
        boolean oneReached = false;
        for (int i = 0; i < this.scores.size(); ++i) {
            currentScore = this.scores.get(i);
            TargetDecoyPoint point = this.hitMap.get(currentScore);
            if (!oneReached) {
                TargetDecoyPoint tempPoint;
                double change = 0.5 * (double)(previousPoint.nTarget + point.nTarget);
                nTargetDown += change;
                nTargetUp -= change;
                while (nTargetDown > nLimit && iDown < i) {
                    tempPoint = this.hitMap.get(this.scores.get(iDown));
                    double nTargetDownTemp = nTargetDown - (double)tempPoint.nTarget;
                    if (!(nTargetDownTemp >= nLimit)) break;
                    nDecoy -= (double)tempPoint.nDecoy;
                    nTargetDown = nTargetDownTemp;
                    ++iDown;
                }
                while (nTargetUp < nLimit && iUp < this.scores.size()) {
                    tempPoint = this.hitMap.get(this.scores.get(iUp));
                    nTargetUp += (double)tempPoint.nTarget;
                    nDecoy += (double)tempPoint.nDecoy;
                    ++iUp;
                }
                double nTarget = nTargetDown + nTargetUp;
                point.p = Math.max(Math.min(nDecoy / nTarget, 1.0), 0.0);
                if (point.p >= 0.98) {
                    oneReached = true;
                }
            } else {
                point.p = 1.0;
            }
            previousPoint = point;
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
    }

    public int getnMax() {
        if (this.nmax == null) {
            this.estimateNs();
        }
        return this.nmax;
    }

    public double getMinFdr() {
        return this.minFDR;
    }

    public double getResolution() {
        double pmin = 0.0;
        int nMax = this.getnMax();
        if (nMax != 0) {
            pmin = 100.0 / (double)nMax;
        }
        return pmin;
    }

    public Integer getnTargetOnly() {
        return this.nTargetOnly;
    }

    private void estimateScores() {
        this.scores = new ArrayList<Double>(this.hitMap.keySet());
        Collections.sort(this.scores);
    }

    public ArrayList<Double> getScores() {
        if (this.scores == null) {
            this.estimateScores();
        }
        return this.scores;
    }

    public void addAll(TargetDecoyMap anOtherMap) {
        for (double score : anOtherMap.getScores()) {
            int i;
            for (i = 0; i < anOtherMap.getNDecoy(score); ++i) {
                this.put(score, true);
            }
            for (i = 0; i < anOtherMap.getNTarget(score); ++i) {
                this.put(score, false);
            }
        }
        this.scores = null;
        this.nmax = null;
        this.windowSize = null;
    }

    public boolean suspiciousInput(double initialFDR) {
        if (this.nmax == null) {
            this.estimateNs();
        }
        return this.nmax < 100 || this.minFDR > initialFDR;
    }

    public TargetDecoyResults getTargetDecoyResults() {
        return this.targetDecoyResults;
    }

    public TargetDecoySeries getTargetDecoySeries() {
        return new TargetDecoySeries(this.hitMap);
    }

    public int getWindowSize() {
        if (this.windowSize == null) {
            this.windowSize = this.getnMax();
        }
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public int getMapSize() {
        return this.hitMap.size();
    }
}

