/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.utils;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.filtering.PeptideFilter;
import com.compomics.util.experiment.identification.filtering.ProteinFilter;
import com.compomics.util.experiment.identification.filtering.PsmFilter;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.gui.filtering.FilterParameters;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class StarHider {
    private final Identification identification;
    private final FilterParameters filterPreferences;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final ProteinDetailsProvider proteinDetailsProvider;
    private final GeneMaps geneMaps;
    private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private final IdentificationParameters identificationParameters;
    private final Metrics metrics;
    private final ProgressDialogX progressDialog;
    private final int nThreads;
    private final ExceptionHandler exceptionHandler;

    public StarHider(Identification identification, FilterParameters filterParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationFeaturesGenerator identificationFeaturesGenerator, IdentificationParameters identificationParameters, Metrics metrics, ProgressDialogX progressDialog, int nThreads, ExceptionHandler exceptionHandler) {
        this.identification = identification;
        this.filterPreferences = filterParameters;
        this.sequenceProvider = sequenceProvider;
        this.proteinDetailsProvider = proteinDetailsProvider;
        this.spectrumProvider = spectrumProvider;
        this.geneMaps = geneMaps;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.identificationParameters = identificationParameters;
        this.metrics = metrics;
        this.progressDialog = progressDialog;
        this.nThreads = nThreads;
        this.exceptionHandler = exceptionHandler;
    }

    public void starHide() {
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Hiding/Starring Matches. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StarHider.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("Star/Hide"){

            @Override
            public void run() {
                try {
                    ExecutorService pool = Executors.newFixedThreadPool(StarHider.this.nThreads);
                    StarHider.this.progressDialog.setPrimaryProgressCounterIndeterminate(false);
                    StarHider.this.progressDialog.setMaxPrimaryProgressCounter(StarHider.this.identification.getProteinIdentification().size());
                    ProteinMatchesIterator proteinMatchesIterator = StarHider.this.identification.getProteinMatchesIterator(StarHider.this.progressDialog);
                    ArrayList<StarHiderRunnable> runnables = new ArrayList<StarHiderRunnable>(StarHider.this.nThreads);
                    for (int i = 1; i <= StarHider.this.nThreads && !StarHider.this.progressDialog.isRunCanceled(); ++i) {
                        StarHiderRunnable starHiderRunnable = new StarHiderRunnable(proteinMatchesIterator, StarHider.this.progressDialog);
                        pool.submit(starHiderRunnable);
                        runnables.add(starHiderRunnable);
                    }
                    if (StarHider.this.progressDialog.isRunCanceled()) {
                        pool.shutdownNow();
                        return;
                    }
                    pool.shutdown();
                    if (!pool.awaitTermination(StarHider.this.identification.getProteinIdentification().size(), TimeUnit.MINUTES)) {
                        throw new TimeoutException("Hiding/Starring matches timed out. Please contact the developers.");
                    }
                    HashMap<String, ArrayList<Double>> fractionMW = new HashMap<String, ArrayList<Double>>();
                    for (StarHiderRunnable starHiderRunnable : runnables) {
                        HashMap<String, ArrayList<Double>> threadFractionMW = starHiderRunnable.getThreadFractionMW();
                        for (String fraction : threadFractionMW.keySet()) {
                            ArrayList<Double> mws = fractionMW.get(fraction);
                            ArrayList<Double> threadMws = threadFractionMW.get(fraction);
                            if (mws == null) {
                                fractionMW.put(fraction, threadMws);
                                continue;
                            }
                            mws.addAll(threadMws);
                        }
                    }
                    StarHider.this.metrics.setObservedFractionalMassesAll(fractionMW);
                    StarHider.this.progressDialog.setRunFinished();
                }
                catch (Exception e) {
                    StarHider.this.exceptionHandler.catchException(e);
                }
            }
        }.start();
    }

    public void starProtein(long matchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(matchKey);
        PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
        boolean validated = false;
        for (ProteinFilter matchFilter : this.filterPreferences.getProteinStarFilters().values()) {
            if (matchFilter.getExceptions().contains(matchKey)) {
                matchFilter.removeException(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            validated = true;
        }
        if (!validated) {
            ProteinFilter proteinFilter;
            if (!this.filterPreferences.getProteinStarFilters().containsKey("manual selection")) {
                proteinFilter = new ProteinFilter("manual selection");
                proteinFilter.setDescription("Manual selection via the graphical interface");
                this.filterPreferences.getProteinStarFilters().put(proteinFilter.getName(), proteinFilter);
            } else {
                proteinFilter = this.filterPreferences.getProteinStarFilters().get("manual selection");
            }
            proteinFilter.addManualValidation(matchKey);
        }
        psParameter.setStarred(true);
    }

    public void unStarProtein(long matchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(matchKey);
        PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
        for (ProteinFilter matchFilter : this.filterPreferences.getProteinStarFilters().values()) {
            if (matchFilter.getManualValidation().contains(matchKey)) {
                matchFilter.removeManualValidation(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            matchFilter.addException(matchKey);
        }
        psParameter.setStarred(false);
    }

    public void hideProtein(long matchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(matchKey);
        PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
        boolean validated = false;
        for (ProteinFilter matchFilter : this.filterPreferences.getProteinHideFilters().values()) {
            if (matchFilter.getExceptions().contains(matchKey)) {
                matchFilter.removeException(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            validated = true;
        }
        if (!validated) {
            ProteinFilter proteinFilter;
            if (!this.filterPreferences.getProteinHideFilters().containsKey("manual selection")) {
                proteinFilter = new ProteinFilter("manual selection");
                proteinFilter.setDescription("Manual selection via the graphical interface");
                this.filterPreferences.getProteinHideFilters().put(proteinFilter.getName(), proteinFilter);
            } else {
                proteinFilter = this.filterPreferences.getProteinHideFilters().get("manual selection");
            }
            proteinFilter.addManualValidation(matchKey);
        }
        psParameter.setHidden(true);
    }

    public void unHideProtein(long matchKey) {
        ProteinMatch proteinMatch = this.identification.getProteinMatch(matchKey);
        PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
        for (ProteinFilter matchFilter : this.filterPreferences.getProteinHideFilters().values()) {
            if (matchFilter.getManualValidation().contains(matchKey)) {
                matchFilter.removeManualValidation(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            matchFilter.addException(matchKey);
        }
        psParameter.setHidden(true);
    }

    public void starPeptide(long matchKey) {
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(matchKey);
        PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
        boolean validated = false;
        for (PeptideFilter matchFilter : this.filterPreferences.getPeptideStarFilters().values()) {
            if (matchFilter.getExceptions().contains(matchKey)) {
                matchFilter.removeException(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            validated = true;
        }
        if (!validated) {
            PeptideFilter peptideFilter;
            if (!this.filterPreferences.getPeptideStarFilters().containsKey("manual selection")) {
                peptideFilter = new PeptideFilter("manual selection");
                peptideFilter.setDescription("Manual selection via the graphical interface");
                this.filterPreferences.getPeptideStarFilters().put(peptideFilter.getName(), peptideFilter);
            } else {
                peptideFilter = this.filterPreferences.getPeptideStarFilters().get("manual selection");
            }
            peptideFilter.addManualValidation(matchKey);
        }
        psParameter.setStarred(true);
    }

    public void unStarPeptide(long matchKey) {
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(matchKey);
        PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
        for (PeptideFilter matchFilter : this.filterPreferences.getPeptideStarFilters().values()) {
            if (matchFilter.getManualValidation().contains(matchKey)) {
                matchFilter.removeManualValidation(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            matchFilter.addException(matchKey);
        }
        psParameter.setStarred(false);
    }

    public void hidePeptide(long matchKey) {
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(matchKey);
        PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
        boolean validated = false;
        for (PeptideFilter matchFilter : this.filterPreferences.getPeptideHideFilters().values()) {
            if (matchFilter.getExceptions().contains(matchKey)) {
                matchFilter.removeException(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            validated = true;
        }
        if (!validated) {
            PeptideFilter peptideFilter;
            if (!this.filterPreferences.getPeptideHideFilters().containsKey("manual selection")) {
                peptideFilter = new PeptideFilter("manual selection");
                peptideFilter.setDescription("Manual selection via the graphical interface");
                this.filterPreferences.getPeptideHideFilters().put(peptideFilter.getName(), peptideFilter);
            } else {
                peptideFilter = this.filterPreferences.getPeptideHideFilters().get("manual selection");
            }
            peptideFilter.addManualValidation(matchKey);
        }
        psParameter.setHidden(true);
    }

    public void unHidePeptide(long matchKey) {
        PeptideMatch peptideMatch = this.identification.getPeptideMatch(matchKey);
        PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
        for (PeptideFilter matchFilter : this.filterPreferences.getPeptideHideFilters().values()) {
            if (matchFilter.getManualValidation().contains(matchKey)) {
                matchFilter.removeManualValidation(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            matchFilter.addException(matchKey);
        }
        psParameter.setHidden(false);
    }

    public void starPsm(long matchKey) {
        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(matchKey);
        PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
        boolean validated = false;
        for (PsmFilter matchFilter : this.filterPreferences.getPsmStarFilters().values()) {
            if (matchFilter.getExceptions().contains(matchKey)) {
                matchFilter.removeException(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            validated = true;
        }
        if (!validated) {
            PsmFilter psmFilter;
            if (!this.filterPreferences.getPsmStarFilters().containsKey("manual selection")) {
                psmFilter = new PsmFilter("manual selection");
                psmFilter.setDescription("Manual selection via the graphical interface");
                this.filterPreferences.getPsmStarFilters().put(psmFilter.getName(), psmFilter);
            } else {
                psmFilter = this.filterPreferences.getPsmStarFilters().get("manual selection");
            }
            psmFilter.addManualValidation(matchKey);
        }
        psParameter.setStarred(true);
    }

    public void unStarPsm(long matchKey) {
        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(matchKey);
        PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
        for (PsmFilter matchFilter : this.filterPreferences.getPsmStarFilters().values()) {
            if (matchFilter.getManualValidation().contains(matchKey)) {
                matchFilter.removeManualValidation(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            matchFilter.addException(matchKey);
        }
        psParameter.setStarred(false);
    }

    public void hidePsm(long matchKey) {
        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(matchKey);
        PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
        boolean validated = false;
        for (PsmFilter matchFilter : this.filterPreferences.getPsmHideFilters().values()) {
            if (matchFilter.getExceptions().contains(matchKey)) {
                matchFilter.removeException(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            validated = true;
        }
        if (!validated) {
            PsmFilter psmFilter;
            if (!this.filterPreferences.getPsmHideFilters().containsKey("manual selection")) {
                psmFilter = new PsmFilter("manual selection");
                psmFilter.setDescription("Manual selection via the graphical interface");
                this.filterPreferences.getPsmHideFilters().put(psmFilter.getName(), psmFilter);
            } else {
                psmFilter = this.filterPreferences.getPsmHideFilters().get("manual selection");
            }
            psmFilter.addManualValidation(matchKey);
        }
        psParameter.setHidden(true);
    }

    public void unHidePsm(long matchKey) {
        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(matchKey);
        PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
        for (PsmFilter matchFilter : this.filterPreferences.getPsmHideFilters().values()) {
            if (matchFilter.getManualValidation().contains(matchKey)) {
                matchFilter.removeManualValidation(matchKey);
            }
            if (!matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider)) continue;
            matchFilter.addException(matchKey);
        }
        psParameter.setHidden(false);
    }

    public boolean isProteinHidden(long matchKey) {
        return this.filterPreferences.getProteinHideFilters().values().stream().anyMatch(matchFilter -> matchFilter.isActive() && matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider));
    }

    public boolean isPeptideHidden(long matchKey) {
        return this.filterPreferences.getPeptideHideFilters().values().stream().anyMatch(matchFilter -> matchFilter.isActive() && matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider));
    }

    public boolean isPsmHidden(long matchKey) {
        return this.filterPreferences.getPsmHideFilters().values().stream().anyMatch(matchFilter -> matchFilter.isActive() && matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider));
    }

    public boolean isProteinStarred(long matchKey) {
        return this.filterPreferences.getProteinStarFilters().values().stream().anyMatch(matchFilter -> matchFilter.isActive() && matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider));
    }

    public boolean isPeptideStarred(long matchKey) {
        return this.filterPreferences.getPeptideStarFilters().values().stream().anyMatch(matchFilter -> matchFilter.isActive() && matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider));
    }

    public boolean isPsmStarred(long matchKey) {
        return this.filterPreferences.getPsmStarFilters().values().stream().anyMatch(matchFilter -> matchFilter.isActive() && matchFilter.isValidated(matchKey, this.identification, this.geneMaps, this.identificationFeaturesGenerator, this.identificationParameters, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider));
    }

    private class StarHiderRunnable
    implements Runnable {
        private final WaitingHandler waitingHandler;
        private final HashMap<String, ArrayList<Double>> threadFractionMW = new HashMap();
        private final ProteinMatchesIterator proteinMatchesIterator;
        private final PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();

        public StarHiderRunnable(ProteinMatchesIterator proteinMatchesIterator, WaitingHandler waitingHandler) {
            this.proteinMatchesIterator = proteinMatchesIterator;
            this.waitingHandler = waitingHandler;
        }

        @Override
        public void run() {
            try {
                ProteinMatch proteinMatch;
                while ((proteinMatch = this.proteinMatchesIterator.next()) != null && !StarHider.this.progressDialog.isRunCanceled()) {
                    long proteinKey = proteinMatch.getKey();
                    boolean peptidePassed = false;
                    for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                        PeptideMatch peptideMatch = StarHider.this.identification.getPeptideMatch(peptideKey);
                        boolean psmpassed = false;
                        for (long spectrumKey : peptideMatch.getSpectrumMatchesKeys()) {
                            SpectrumMatch spectrumMatch = StarHider.this.identification.getSpectrumMatch(spectrumKey);
                            PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                            if (StarHider.this.isPsmHidden(spectrumKey)) {
                                psParameter.setHidden(true);
                            } else {
                                psParameter.setHidden(false);
                                psmpassed = true;
                            }
                            psParameter.setStarred(StarHider.this.isPsmStarred(spectrumKey));
                        }
                        PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                        if (!psmpassed) {
                            psParameter.setHidden(true);
                        } else if (StarHider.this.isPeptideHidden(peptideKey)) {
                            psParameter.setHidden(true);
                        } else {
                            psParameter.setHidden(false);
                            peptidePassed = true;
                        }
                        psParameter.setStarred(StarHider.this.isPeptideStarred(peptideKey));
                    }
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                    if (!peptidePassed) {
                        psParameter.setHidden(true);
                    } else {
                        psParameter.setHidden(StarHider.this.isProteinHidden(proteinKey));
                    }
                    psParameter.setStarred(StarHider.this.isProteinStarred(proteinKey));
                    if (!psParameter.getHidden() && psParameter.getMatchValidationLevel().isValidated() && !proteinMatch.isDecoy()) {
                        String proteinSequence = StarHider.this.sequenceProvider.getSequence(proteinMatch.getLeadingAccession());
                        double proteinMW = ProteinUtils.computeMolecularWeight(proteinSequence);
                        for (String fraction : psParameter.getFractions()) {
                            if (!(psParameter.getFractionConfidence(fraction) > StarHider.this.identificationParameters.getFractionParameters().getProteinConfidenceMwPlots())) continue;
                            if (this.threadFractionMW.containsKey(fraction)) {
                                this.threadFractionMW.get(fraction).add(proteinMW);
                                continue;
                            }
                            ArrayList<Double> mw = new ArrayList<Double>();
                            mw.add(proteinMW);
                            this.threadFractionMW.put(fraction, mw);
                        }
                    }
                    StarHider.this.progressDialog.increasePrimaryProgressCounter();
                    if (!StarHider.this.progressDialog.isRunCanceled()) continue;
                    break;
                }
            }
            catch (Exception e) {
                StarHider.this.exceptionHandler.catchException(e);
                StarHider.this.progressDialog.setRunCanceled();
            }
        }

        public HashMap<String, ArrayList<Double>> getThreadFractionMW() {
            return this.threadFractionMW;
        }
    }
}

