/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.validation;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.filtering.Filter;
import com.compomics.util.experiment.filtering.FilterItemComparator;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.filtering.AssumptionFilter;
import com.compomics.util.experiment.identification.filtering.PeptideFilter;
import com.compomics.util.experiment.identification.filtering.ProteinFilter;
import com.compomics.util.experiment.identification.filtering.PsmFilter;
import com.compomics.util.experiment.identification.filtering.items.AssumptionFilterItem;
import com.compomics.util.experiment.identification.filtering.items.PeptideFilterItem;
import com.compomics.util.experiment.identification.filtering.items.ProteinFilterItem;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.identification.validation.percolator.PercolatorFeature;
import com.compomics.util.experiment.identification.validation.percolator.PercolatorFeaturesCache;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.FractionParameters;
import com.compomics.util.parameters.identification.advanced.IdMatchValidationParameters;
import com.compomics.util.parameters.identification.advanced.ValidationQcParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.peptide_shaker.ProjectType;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyMap;
import eu.isas.peptideshaker.scoring.targetdecoy.TargetDecoyResults;
import eu.isas.peptideshaker.utils.PercolatorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class MatchesValidator {
    private TargetDecoyMap psmMap;
    private TargetDecoyMap peptideMap;
    private TargetDecoyMap proteinMap;

    public MatchesValidator(TargetDecoyMap psmMap, TargetDecoyMap peptideMap, TargetDecoyMap proteinMap) {
        this.psmMap = psmMap;
        this.peptideMap = peptideMap;
        this.proteinMap = proteinMap;
    }

    public void validateIdentifications(Identification identification, Metrics metrics, InputMap inputMap, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, ProjectType projectType, ProcessingParameters processingParameters) throws InterruptedException, TimeoutException {
        IdMatchValidationParameters validationParameters = identificationParameters.getIdValidationParameters();
        waitingHandler.setWaitingText("Finding FDR Thresholds. Please Wait...");
        for (int algorithm : inputMap.getInputAlgorithms()) {
            TargetDecoyMap targetDecoyMap = inputMap.getTargetDecoyMap(algorithm);
            TargetDecoyResults currentResults = targetDecoyMap.getTargetDecoyResults();
            currentResults.setInputType(1);
            currentResults.setUserInput(validationParameters.getDefaultPsmFDR());
            currentResults.setFdrLimit(validationParameters.getDefaultPsmFDR());
            targetDecoyMap.getTargetDecoySeries().getFDRResults(currentResults);
        }
        TargetDecoyResults currentResults = this.psmMap.getTargetDecoyResults();
        currentResults.setInputType(1);
        currentResults.setUserInput(validationParameters.getDefaultPsmFDR());
        currentResults.setFdrLimit(validationParameters.getDefaultPsmFDR());
        this.psmMap.getTargetDecoySeries().getFDRResults(currentResults);
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        currentResults = this.peptideMap.getTargetDecoyResults();
        currentResults.setInputType(1);
        currentResults.setUserInput(validationParameters.getDefaultPeptideFDR());
        currentResults.setFdrLimit(validationParameters.getDefaultPeptideFDR());
        this.peptideMap.getTargetDecoySeries().getFDRResults(currentResults);
        currentResults = this.proteinMap.getTargetDecoyResults();
        currentResults.setInputType(1);
        currentResults.setUserInput(validationParameters.getDefaultProteinFDR());
        currentResults.setFdrLimit(validationParameters.getDefaultProteinFDR());
        this.proteinMap.getTargetDecoySeries().getFDRResults(currentResults);
        ValidationQcParameters validationQCParameters = validationParameters.getValidationQCParameters();
        waitingHandler.setWaitingText("Match Validation and Quality Control. Please Wait...");
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.resetSecondaryProgressCounter();
        waitingHandler.setMaxSecondaryProgressCounter(identification.getProteinIdentification().size() + identification.getPeptideIdentification().size() + 2 * identification.getSpectrumIdentificationSize());
        inputMap.resetAdvocateContributions();
        AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
        double intensityLimit = annotationParameters.getAnnotationIntensityLimit();
        annotationParameters.setIntensityLimit(0.0);
        ExecutorService pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
        SpectrumMatchesIterator psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        ArrayList psmRunnables = new ArrayList(processingParameters.getnThreads());
        for (int i = 1; i <= processingParameters.getnThreads(); ++i) {
            Iterator runnable2 = new PsmValidatorRunnable(psmIterator, identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, geneMaps, identificationParameters, processingParameters, waitingHandler, exceptionHandler, inputMap, false, true);
            pool.submit((Runnable)((Object)runnable2));
            psmRunnables.add(runnable2);
        }
        if (waitingHandler.isRunCanceled()) {
            pool.shutdownNow();
            return;
        }
        pool.shutdown();
        if (!pool.awaitTermination(identification.getSpectrumIdentificationSize(), TimeUnit.MINUTES)) {
            throw new TimeoutException("Spectrum matches validation timed out. Please contact the developers.");
        }
        HashMap<String, ArrayList<Double>> precursorMzDeviations = new HashMap<String, ArrayList<Double>>(identification.getSpectrumIdentification().size());
        for (PsmValidatorRunnable psmValidatorRunnable : psmRunnables) {
            for (String string : psmValidatorRunnable.getThreadPrecursorMzDeviations().keySet()) {
                ArrayList<Double> arrayList = psmValidatorRunnable.getThreadPrecursorMzDeviations().get(string);
                ArrayList filePrecursorMzDeviations = (ArrayList)precursorMzDeviations.get(string);
                if (filePrecursorMzDeviations != null) {
                    filePrecursorMzDeviations.addAll(arrayList);
                    continue;
                }
                precursorMzDeviations.put(string, arrayList);
            }
        }
        for (String string : precursorMzDeviations.keySet()) {
            double[] precursorMzDeviationsFile = ((ArrayList)precursorMzDeviations.get(string)).stream().mapToDouble(a -> a).toArray();
            if (precursorMzDeviationsFile.length >= 100) {
                Arrays.sort(precursorMzDeviationsFile);
                identificationFeaturesGenerator.setMassErrorDistribution(string, precursorMzDeviationsFile);
                continue;
            }
            if (validationQCParameters.getPsmFilters() == null) continue;
            for (Filter filter : validationQCParameters.getPsmFilters()) {
                AssumptionFilter assumptionFilter;
                PsmFilter psmFilter = (PsmFilter)filter;
                if (psmFilter.getItemsNames().contains(AssumptionFilterItem.precrusorMzErrorStat.name)) {
                    psmFilter.removeFilterItem(AssumptionFilterItem.precrusorMzErrorStat.name);
                    SearchParameters searchParameters = identificationParameters.getSearchParameters();
                    if (searchParameters.isPrecursorAccuracyTypePpm().booleanValue()) {
                        psmFilter.setFilterItem(AssumptionFilterItem.precrusorMzErrorPpm.name, FilterItemComparator.lowerOrEqual, searchParameters.getPrecursorAccuracy());
                    } else {
                        psmFilter.setFilterItem(AssumptionFilterItem.precrusorMzErrorDa.name, FilterItemComparator.lowerOrEqual, searchParameters.getPrecursorAccuracy());
                    }
                }
                if (!(assumptionFilter = psmFilter.getAssumptionFilter()).getItemsNames().contains(AssumptionFilterItem.precrusorMzErrorStat.name)) continue;
                assumptionFilter.removeFilterItem(AssumptionFilterItem.precrusorMzErrorStat.name);
                SearchParameters searchParameters = identificationParameters.getSearchParameters();
                if (searchParameters.isPrecursorAccuracyTypePpm().booleanValue()) {
                    assumptionFilter.setFilterItem(AssumptionFilterItem.precrusorMzErrorPpm.name, FilterItemComparator.lowerOrEqual, searchParameters.getPrecursorAccuracy());
                    continue;
                }
                assumptionFilter.setFilterItem(AssumptionFilterItem.precrusorMzErrorDa.name, FilterItemComparator.lowerOrEqual, searchParameters.getPrecursorAccuracy());
            }
        }
        pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
        psmIterator = identification.getSpectrumMatchesIterator(waitingHandler);
        for (int i = 1; i <= processingParameters.getnThreads(); ++i) {
            PsmValidatorRunnable psmValidatorRunnable = new PsmValidatorRunnable(psmIterator, identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, geneMaps, identificationParameters, processingParameters, waitingHandler, exceptionHandler, inputMap, true, false);
            pool.submit(psmValidatorRunnable);
        }
        if (waitingHandler.isRunCanceled()) {
            pool.shutdownNow();
            return;
        }
        pool.shutdown();
        if (!pool.awaitTermination(identification.getSpectrumIdentificationSize(), TimeUnit.MINUTES)) {
            throw new TimeoutException("Spectrum matches validation timed out. Please contact the developers.");
        }
        annotationParameters.setIntensityLimit(intensityLimit);
        if (projectType == ProjectType.peptide || projectType == ProjectType.protein) {
            pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
            ArrayList<PeptideValidatorRunnable> peptideRunnables = new ArrayList<PeptideValidatorRunnable>(processingParameters.getnThreads());
            PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(waitingHandler);
            for (int i = 1; i <= processingParameters.getnThreads(); ++i) {
                PeptideValidatorRunnable peptideValidatorRunnable = new PeptideValidatorRunnable(peptideMatchesIterator, identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, geneMaps, identificationParameters, waitingHandler, exceptionHandler, metrics);
                pool.submit(peptideValidatorRunnable);
                peptideRunnables.add(peptideValidatorRunnable);
            }
            if (waitingHandler.isRunCanceled()) {
                pool.shutdownNow();
                return;
            }
            pool.shutdown();
            if (!pool.awaitTermination(identification.getPeptideIdentification().size(), TimeUnit.MINUTES)) {
                throw new InterruptedException("Peptide matches validation timed out. Please contact the developers.");
            }
            HashMap<String, Integer> validatedTotalPeptidesPerFraction = new HashMap<String, Integer>();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (PeptideValidatorRunnable runnable5 : peptideRunnables) {
                HashMap<String, Integer> threadValidatedTotalPeptidesPerFraction = runnable5.getValidatedTotalPeptidesPerFraction();
                for (String fraction : threadValidatedTotalPeptidesPerFraction.keySet()) {
                    Integer nValidated = validatedTotalPeptidesPerFraction.get(fraction);
                    if (nValidated == null) {
                        nValidated = 0;
                    }
                    nValidated = nValidated + threadValidatedTotalPeptidesPerFraction.get(fraction);
                    validatedTotalPeptidesPerFraction.put(fraction, nValidated);
                }
                arrayList.addAll(runnable5.getValidatedPeptideLengths());
            }
            if (arrayList.size() >= 100) {
                NonSymmetricalNormalDistribution nonSymmetricalNormalDistribution = NonSymmetricalNormalDistribution.getRobustNonSymmetricalNormalDistribution(arrayList);
                metrics.setPeptideLengthDistribution(nonSymmetricalNormalDistribution);
            }
            metrics.setTotalPeptidesPerFraction(validatedTotalPeptidesPerFraction);
            if (projectType == ProjectType.protein) {
                pool = Executors.newFixedThreadPool(processingParameters.getnThreads());
                ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(waitingHandler);
                ArrayList<ProteinValidatorRunnable> proteinRunnables = new ArrayList<ProteinValidatorRunnable>(processingParameters.getnThreads());
                for (int i = 1; i <= processingParameters.getnThreads(); ++i) {
                    ProteinValidatorRunnable runnable6 = new ProteinValidatorRunnable(proteinMatchesIterator, identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, geneMaps, metrics, identificationParameters, waitingHandler, exceptionHandler);
                    pool.submit(runnable6);
                    proteinRunnables.add(runnable6);
                }
                if (waitingHandler.isRunCanceled()) {
                    pool.shutdownNow();
                    return;
                }
                pool.shutdown();
                if (!pool.awaitTermination(identification.getProteinIdentification().size(), TimeUnit.MINUTES)) {
                    throw new InterruptedException("Protein matches validation timed out. Please contact the developers.");
                }
                long[] validatedTargetProteinKeys = proteinRunnables.stream().flatMap(runnable -> runnable.getValidatedProteinMatches().stream()).mapToLong(a -> a).toArray();
                metrics.setValidatedTargetProteinKeys(validatedTargetProteinKeys);
            }
        }
    }

    public static void updateProteinMatchValidationLevel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ProteinDetailsProvider proteinDetailsProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, TargetDecoyMap proteinMap, long proteinKey) {
        ValidationQcParameters validationQCParameters = identificationParameters.getIdValidationParameters().getValidationQCParameters();
        TargetDecoyResults targetDecoyResults = proteinMap.getTargetDecoyResults();
        double fdrLimit = targetDecoyResults.getFdrLimit();
        double nTargetLimit = 100.0 / fdrLimit;
        double proteinThreshold = targetDecoyResults.getScoreLimit();
        double margin = validationQCParameters.getConfidenceMargin() * proteinMap.getResolution();
        double proteinConfidentThreshold = targetDecoyResults.getConfidenceLimit() + margin;
        if (proteinConfidentThreshold > 100.0) {
            proteinConfidentThreshold = 100.0;
        }
        boolean noValidated = proteinMap.getTargetDecoyResults().noValidated();
        MatchesValidator.updateProteinMatchValidationLevel(identification, identificationFeaturesGenerator, sequenceProvider, proteinDetailsProvider, spectrumProvider, geneMaps, identificationParameters, proteinMap, proteinThreshold, nTargetLimit, proteinConfidentThreshold, noValidated, proteinKey);
    }

    public static void updateProteinMatchValidationLevel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, TargetDecoyMap targetDecoyMap, double scoreThreshold, double nTargetLimit, double confidenceThreshold, boolean noValidated, long proteinKey) {
        PSParameter psParameter = new PSParameter();
        ProteinMatch proteinMatch = (ProteinMatch)identification.retrieveObject(proteinKey);
        psParameter = (PSParameter)proteinMatch.getUrParam(psParameter);
        psParameter.resetQcResults();
        ValidationQcParameters validationQCParameters = identificationParameters.getIdValidationParameters().getValidationQCParameters();
        if (!psParameter.getManualValidation()) {
            if (identificationParameters.getFastaParameters().isTargetDecoy()) {
                if (!noValidated && psParameter.getScore() <= scoreThreshold) {
                    boolean confidenceThresholdPassed;
                    boolean filtersPassed = true;
                    if (validationQCParameters.getProteinFilters() != null) {
                        for (Filter filter : validationQCParameters.getProteinFilters()) {
                            ProteinFilter proteinFilter = (ProteinFilter)filter;
                            boolean validation = proteinFilter.isValidated(proteinKey, identification, geneMaps, identificationFeaturesGenerator, identificationParameters, sequenceProvider, proteinDetailsProvider, spectrumProvider);
                            psParameter.setQcResult(filter.getName(), validation);
                            if (validation) continue;
                            filtersPassed = false;
                        }
                    }
                    boolean bl = confidenceThresholdPassed = psParameter.getConfidence() >= confidenceThreshold;
                    if (filtersPassed && confidenceThresholdPassed) {
                        psParameter.setMatchValidationLevel(MatchValidationLevel.confident);
                    } else {
                        psParameter.setMatchValidationLevel(MatchValidationLevel.doubtful);
                    }
                } else {
                    psParameter.setMatchValidationLevel(MatchValidationLevel.not_validated);
                }
            } else {
                psParameter.setMatchValidationLevel(MatchValidationLevel.none);
            }
            identification.updateObject(proteinKey, proteinMatch);
        }
    }

    public static void updatePeptideMatchValidationLevel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, TargetDecoyMap peptideMap, long peptideKey) {
        PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
        PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
        psParameter.resetQcResults();
        ValidationQcParameters validationQCParameters = identificationParameters.getIdValidationParameters().getValidationQCParameters();
        if (identificationParameters.getFastaParameters().isTargetDecoy()) {
            boolean noValidated;
            TargetDecoyResults targetDecoyResults = peptideMap.getTargetDecoyResults();
            double peptideThreshold = targetDecoyResults.getScoreLimit();
            double margin = validationQCParameters.getConfidenceMargin() * peptideMap.getResolution();
            double confidenceThreshold = targetDecoyResults.getConfidenceLimit() + margin;
            if (confidenceThreshold > 100.0) {
                confidenceThreshold = 100.0;
            }
            if (!(noValidated = peptideMap.getTargetDecoyResults().noValidated()) && psParameter.getScore() <= peptideThreshold) {
                boolean confidenceThresholdPassed;
                boolean filtersPassed = true;
                if (validationQCParameters.getPeptideFilters() != null) {
                    for (Filter filter : validationQCParameters.getPeptideFilters()) {
                        PeptideFilter peptideFilter = (PeptideFilter)filter;
                        boolean validation = peptideFilter.isValidated(peptideKey, identification, geneMaps, identificationFeaturesGenerator, identificationParameters, sequenceProvider, proteinDetailsProvider, spectrumProvider);
                        psParameter.setQcResult(filter.getName(), validation);
                        if (validation) continue;
                        filtersPassed = false;
                    }
                }
                boolean bl = confidenceThresholdPassed = psParameter.getConfidence() >= confidenceThreshold;
                if (filtersPassed && confidenceThresholdPassed) {
                    psParameter.setMatchValidationLevel(MatchValidationLevel.confident);
                } else {
                    psParameter.setMatchValidationLevel(MatchValidationLevel.doubtful);
                }
            } else {
                psParameter.setMatchValidationLevel(MatchValidationLevel.not_validated);
            }
        } else {
            psParameter.setMatchValidationLevel(MatchValidationLevel.none);
        }
        identification.updateObject(peptideKey, peptideMatch);
    }

    public static void updateSpectrumMatchValidationLevel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, TargetDecoyMap psmMap, long spectrumMatchKey, boolean applyQCFilters) {
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumMatchKey);
        PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
        psParameter.resetQcResults();
        ValidationQcParameters validationQCParameters = identificationParameters.getIdValidationParameters().getValidationQCParameters();
        if (identificationParameters.getFastaParameters().isTargetDecoy()) {
            double psmThreshold = 0.0;
            double confidenceThreshold = 100.0;
            boolean noValidated = true;
            if (psmMap != null) {
                TargetDecoyResults targetDecoyResults = psmMap.getTargetDecoyResults();
                psmThreshold = targetDecoyResults.getScoreLimit();
                double margin = validationQCParameters.getConfidenceMargin() * psmMap.getResolution();
                confidenceThreshold = targetDecoyResults.getConfidenceLimit() + margin;
                if (confidenceThreshold > 100.0) {
                    confidenceThreshold = 100.0;
                }
                noValidated = targetDecoyResults.noValidated();
            }
            if (!noValidated && psParameter.getScore() <= psmThreshold) {
                boolean confidenceThresholdPassed;
                boolean filtersPassed = true;
                if (applyQCFilters && validationQCParameters.getPsmFilters() != null) {
                    for (Filter filter : validationQCParameters.getPsmFilters()) {
                        PsmFilter psmFilter = (PsmFilter)filter;
                        boolean validated = psmFilter.isValidated(spectrumMatchKey, identification, geneMaps, identificationFeaturesGenerator, identificationParameters, sequenceProvider, proteinDetailsProvider, spectrumProvider);
                        psParameter.setQcResult(psmFilter.getName(), validated);
                        if (validated) continue;
                        filtersPassed = false;
                    }
                }
                boolean bl = confidenceThresholdPassed = psParameter.getConfidence() >= confidenceThreshold;
                if (filtersPassed && confidenceThresholdPassed) {
                    psParameter.setMatchValidationLevel(MatchValidationLevel.confident);
                } else {
                    psParameter.setMatchValidationLevel(MatchValidationLevel.doubtful);
                }
            } else {
                psParameter.setMatchValidationLevel(MatchValidationLevel.not_validated);
            }
        } else {
            psParameter.setMatchValidationLevel(MatchValidationLevel.none);
        }
        identification.updateObject(spectrumMatchKey, spectrumMatch);
    }

    public static void updatePeptideAssumptionValidationLevel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, InputMap inputMap, long spectrumMatchKey, PeptideAssumption peptideAssumption, boolean applyQCFilters) {
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumMatchKey);
        PSParameter psParameter = (PSParameter)peptideAssumption.getUrParam(PSParameter.dummy);
        ValidationQcParameters validationQCParameters = identificationParameters.getIdValidationParameters().getValidationQCParameters();
        if (identificationParameters.getFastaParameters().isTargetDecoy()) {
            TargetDecoyMap targetDecoyMap = inputMap.getTargetDecoyMap(peptideAssumption.getAdvocate());
            double seThreshold = 0.0;
            double confidenceThreshold = 100.0;
            boolean noValidated = true;
            if (targetDecoyMap != null) {
                TargetDecoyResults targetDecoyResults = targetDecoyMap.getTargetDecoyResults();
                seThreshold = targetDecoyResults.getScoreLimit();
                double margin = validationQCParameters.getConfidenceMargin() * targetDecoyMap.getResolution();
                confidenceThreshold = targetDecoyResults.getConfidenceLimit() + margin;
                if (confidenceThreshold > 100.0) {
                    confidenceThreshold = 100.0;
                }
                noValidated = targetDecoyResults.noValidated();
            }
            if (!noValidated && peptideAssumption.getScore() <= seThreshold) {
                boolean confidenceThresholdPassed;
                boolean filtersPassed = true;
                if (applyQCFilters) {
                    for (Filter filter : validationQCParameters.getPsmFilters()) {
                        PsmFilter psmFilter = (PsmFilter)filter;
                        AssumptionFilter assumptionFilter = psmFilter.getAssumptionFilter();
                        boolean validated = assumptionFilter.isValidated(spectrumMatch.getKey(), spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle(), peptideAssumption, identification, sequenceProvider, spectrumProvider, identificationFeaturesGenerator, identificationParameters);
                        psParameter.setQcResult(filter.getName(), validated);
                        if (validated) continue;
                        filtersPassed = false;
                    }
                }
                boolean bl = confidenceThresholdPassed = psParameter.getConfidence() >= confidenceThreshold;
                if (filtersPassed && confidenceThresholdPassed) {
                    psParameter.setMatchValidationLevel(MatchValidationLevel.confident);
                } else {
                    psParameter.setMatchValidationLevel(MatchValidationLevel.doubtful);
                }
            } else {
                psParameter.setMatchValidationLevel(MatchValidationLevel.not_validated);
            }
        } else {
            psParameter.setMatchValidationLevel(MatchValidationLevel.none);
        }
    }

    public void fillPeptideMaps(Identification identification, Metrics metrics, WaitingHandler waitingHandler, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider) {
        PeptideMatch peptideMatch;
        waitingHandler.setWaitingText("Filling Peptide Maps. Please Wait...");
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(identification.getPeptideIdentification().size() * 2);
        HashSet foundModifications = new HashSet();
        HashMap<String, ArrayList<Long>> fractionPsmMatches = new HashMap<String, ArrayList<Long>>();
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(waitingHandler);
        int nFractions = identification.getSpectrumIdentification().size();
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            long peptideKey = peptideMatch.getKey();
            foundModifications.addAll(Arrays.stream(peptideMatch.getPeptide().getVariableModifications()).map(ModificationMatch::getModification).collect(Collectors.toSet()));
            double probaScore = 1.0;
            HashMap<String, Double> fractionScores = new HashMap<String, Double>(nFractions);
            for (long spectrumKey : peptideMatch.getSpectrumMatchesKeys()) {
                double tempScore;
                SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumKey);
                PSParameter psmParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                probaScore *= psmParameter.getProbability();
                if (nFractions <= 1) continue;
                String fraction = spectrumMatch.getSpectrumFile();
                Double fractionScore = (Double)fractionScores.get(fraction);
                boolean change = false;
                if (fractionScore == null) {
                    fractionScore = 1.0;
                    change = true;
                }
                if ((tempScore = psmParameter.getProbability()) != 1.0 && fractionScore != 0.0) {
                    fractionScore = fractionScore * tempScore;
                    change = true;
                }
                if (change) {
                    fractionScores.put(fraction, fractionScore);
                }
                String peptideKeyString = Long.toString(peptideKey);
                StringBuilder fractionKeyB = new StringBuilder(fraction.length() + peptideKeyString.length() + 1);
                fractionKeyB.append(fraction).append('_').append(peptideKeyString);
                String fractionKey = fractionKeyB.toString();
                ArrayList<Long> spectrumMatches = fractionPsmMatches.get(fractionKey);
                if (spectrumMatches == null) {
                    spectrumMatches = new ArrayList(1);
                    fractionPsmMatches.put(fractionKey, spectrumMatches);
                }
                spectrumMatches.add(spectrumKey);
            }
            if (nFractions == 1) {
                String fraction = spectrumProvider.getOrderedFileNamesWithoutExtensions()[0];
                fractionScores.put(fraction, probaScore);
                String peptideKeyString = Long.toString(peptideKey);
                StringBuilder fractionKeyB = new StringBuilder(fraction.length() + peptideKeyString.length() + 1);
                fractionKeyB.append(fraction).append('_').append(peptideKeyString);
                String fractionKey = fractionKeyB.toString();
                fractionPsmMatches.put(fractionKey, Arrays.stream(peptideMatch.getSpectrumMatchesKeys()).boxed().collect(Collectors.toCollection(ArrayList::new)));
            }
            PSParameter peptideParameter = new PSParameter();
            for (String fractionName : fractionScores.keySet()) {
                peptideParameter.setFractionScore(fractionName, (Double)fractionScores.get(fractionName));
            }
            peptideParameter.setScore(probaScore);
            peptideMatch.addUrParam(peptideParameter);
            this.peptideMap.put(peptideParameter.getScore(), PeptideUtils.isDecoy(peptideMatch.getPeptide(), sequenceProvider));
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        if (metrics != null) {
            metrics.setFractionPsmMatches(fractionPsmMatches);
            metrics.setFoundModifications(new TreeSet<String>(foundModifications));
        }
    }

    public void attachPeptideProbabilities(Identification identification, FastaParameters fastaParameters, WaitingHandler waitingHandler) {
        PeptideMatch peptideMatch;
        waitingHandler.setWaitingText("Attaching Peptide Probabilities. Please Wait...");
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(identification.getPeptideIdentification().size());
        PSParameter psParameter = new PSParameter();
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            long peptideKey = peptideMatch.getKey();
            psParameter = (PSParameter)peptideMatch.getUrParam(psParameter);
            if (fastaParameters.isTargetDecoy()) {
                double probability = this.peptideMap.getProbability(psParameter.getScore());
                psParameter.setProbability(probability);
            } else {
                psParameter.setProbability(1.0);
            }
            Set<String> fractions = psParameter.getFractions();
            if (fractions == null) {
                throw new IllegalArgumentException("Fractions not found for peptide " + peptideKey + ".");
            }
            for (String fraction : fractions) {
                if (fastaParameters.isTargetDecoy()) {
                    double probability = this.peptideMap.getProbability(psParameter.getFractionScore(fraction));
                    psParameter.setFractionPEP(fraction, probability);
                    continue;
                }
                psParameter.setFractionPEP(fraction, 1.0);
            }
            identification.updateObject(peptideKey, peptideMatch);
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public void fillProteinMap(Identification identification, SpectrumProvider spectrumProvider, WaitingHandler waitingHandler) {
        ProteinMatch proteinMatch;
        waitingHandler.setWaitingText("Filling Protein Map. Please Wait...");
        int totalProgress = identification.getProteinIdentification().size();
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(totalProgress);
        ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(waitingHandler);
        int nFractions = identification.getSpectrumIdentification().size();
        while ((proteinMatch = proteinMatchesIterator.next()) != null) {
            long proteinKey = proteinMatch.getKey();
            waitingHandler.increaseSecondaryProgressCounter();
            if (waitingHandler.isRunCanceled()) {
                return;
            }
            HashMap<String, Double> fractionScores = new HashMap<String, Double>(nFractions);
            double proteinGroupScore = 1.0;
            if (proteinMatch == null) {
                throw new IllegalArgumentException("Protein match " + proteinKey + " not found.");
            }
            for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                TreeSet<Long> proteinGroups = identification.getProteinMatches(peptideKey);
                if (proteinGroups.size() == 1) {
                    proteinGroupScore *= psParameter.getProbability();
                }
                if (nFractions <= 1) continue;
                for (String fraction : psParameter.getFractions()) {
                    double peptideScore;
                    Double fractionScore = (Double)fractionScores.get(fraction);
                    boolean change = false;
                    if (fractionScore == null) {
                        fractionScore = 1.0;
                        change = true;
                    }
                    if (proteinGroups.size() == 1 && (peptideScore = psParameter.getFractionPEP(fraction).doubleValue()) != 1.0) {
                        fractionScore = fractionScore * peptideScore;
                        change = true;
                    }
                    if (!change) continue;
                    fractionScores.put(fraction, fractionScore);
                }
            }
            if (nFractions == 1) {
                String spectrumFile = spectrumProvider.getOrderedFileNamesWithoutExtensions()[0];
                fractionScores.put(spectrumFile, proteinGroupScore);
            }
            PSParameter proteinParameter = new PSParameter();
            for (String fractionName : fractionScores.keySet()) {
                proteinParameter.setFractionScore(fractionName, (Double)fractionScores.get(fractionName));
            }
            proteinParameter.setScore(proteinGroupScore);
            proteinMatch.addUrParam(proteinParameter);
            this.proteinMap.put(proteinParameter.getScore(), proteinMatch.isDecoy());
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public void attachProteinProbabilities(Identification identification, SequenceProvider sequenceProvider, FastaParameters fastaParameters, Metrics metrics, WaitingHandler waitingHandler, FractionParameters fractionParameters) {
        ProteinMatch proteinMatch;
        waitingHandler.setWaitingText("Attaching Protein Probabilities. Please Wait...");
        waitingHandler.setSecondaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxSecondaryProgressCounter(identification.getProteinIdentification().size());
        HashMap<String, ArrayList<Double>> fractionMW = new HashMap<String, ArrayList<Double>>();
        ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(waitingHandler);
        while ((proteinMatch = proteinMatchesIterator.next()) != null) {
            double proteinMW = ProteinUtils.computeMolecularWeight(sequenceProvider.getSequence(proteinMatch.getLeadingAccession()));
            PSParameter psParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
            if (fastaParameters.isTargetDecoy()) {
                double proteinProbability = this.proteinMap.getProbability(psParameter.getScore());
                psParameter.setProbability(proteinProbability);
            } else {
                psParameter.setProbability(1.0);
            }
            for (String fraction : psParameter.getFractions()) {
                if (fastaParameters.isTargetDecoy()) {
                    psParameter.setFractionPEP(fraction, this.proteinMap.getProbability(psParameter.getFractionScore(fraction)));
                } else {
                    psParameter.setFractionPEP(fraction, 1.0);
                }
                if (proteinMatch.isDecoy() || !(psParameter.getFractionConfidence(fraction) > fractionParameters.getProteinConfidenceMwPlots())) continue;
                ArrayList<Double> mw = fractionMW.get(fraction);
                if (mw == null) {
                    mw = new ArrayList(1);
                    fractionMW.put(fraction, mw);
                }
                mw.add(proteinMW);
            }
            identification.updateObject(proteinMatch.getKey(), proteinMatch);
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            return;
        }
        if (metrics != null) {
            metrics.setObservedFractionalMassesAll(fractionMW);
        }
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
    }

    public TargetDecoyMap getPsmMap() {
        return this.psmMap;
    }

    public void setPsmMap(TargetDecoyMap psmMap) {
        this.psmMap = psmMap;
    }

    public TargetDecoyMap getPeptideMap() {
        return this.peptideMap;
    }

    public void setPeptideMap(TargetDecoyMap peptideMap) {
        this.peptideMap = peptideMap;
    }

    public TargetDecoyMap getProteinMap() {
        return this.proteinMap;
    }

    public void setProteinMap(TargetDecoyMap proteinMap) {
        this.proteinMap = proteinMap;
    }

    public static void setDefaultMatchesQCFilters(ValidationQcParameters validationQCParameters) {
        ArrayList<Filter> psmFilters = new ArrayList<Filter>(2);
        PsmFilter psmFilter = new PsmFilter("Fragment Ion Sequence Coverage");
        psmFilter.setDescription("Sequence coverage filter by fragment ions");
        psmFilter.setFilterItem(AssumptionFilterItem.sequenceCoverage.name, FilterItemComparator.higherOrEqual, 30);
        psmFilter.getAssumptionFilter().setFilterItem(AssumptionFilterItem.sequenceCoverage.name, FilterItemComparator.higherOrEqual, 30);
        psmFilters.add(psmFilter);
        psmFilter = new PsmFilter("Mass deviation");
        psmFilter.setDescription("Precursor m/z deviation probability");
        psmFilter.setFilterItem(AssumptionFilterItem.precrusorMzErrorStat.name, FilterItemComparator.higherOrEqual, 1.0E-4);
        psmFilter.getAssumptionFilter().setFilterItem(AssumptionFilterItem.precrusorMzErrorStat.name, FilterItemComparator.higherOrEqual, 1.0E-4);
        psmFilters.add(psmFilter);
        validationQCParameters.setPsmFilters(psmFilters);
        ArrayList<Filter> peptideFilters = new ArrayList<Filter>(1);
        PeptideFilter peptideFilter = new PeptideFilter("One confident PSM");
        peptideFilter.setDescription("Number of confident PSMs filter");
        peptideFilter.setFilterItem(PeptideFilterItem.nConfidentPSMs.name, FilterItemComparator.higherOrEqual, 1);
        peptideFilters.add(peptideFilter);
        validationQCParameters.setPeptideFilters(peptideFilters);
        ArrayList<Filter> proteinFilters = new ArrayList<Filter>(2);
        ProteinFilter proteinFilter = new ProteinFilter(">=2 confident peptides");
        proteinFilter.setDescription("Number of confident peptides filter");
        proteinFilter.setFilterItem(ProteinFilterItem.nConfidentPeptides.name, FilterItemComparator.higherOrEqual, 2);
        proteinFilters.add(proteinFilter);
        proteinFilter = new ProteinFilter(">=2 confident spectra");
        proteinFilter.setDescription("Number of confident spectra filter");
        proteinFilter.setFilterItem(ProteinFilterItem.nConfidentPSMs.name, FilterItemComparator.higherOrEqual, 2);
        proteinFilters.add(proteinFilter);
        validationQCParameters.setProteinFilters(proteinFilters);
    }

    private class PsmValidatorRunnable
    implements Runnable {
        private final SpectrumMatchesIterator psmIterator;
        private final Identification identification;
        private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
        private final SequenceProvider sequenceProvider;
        private final ProteinDetailsProvider proteinDetailsProvider;
        private final SpectrumProvider spectrumProvider;
        private final GeneMaps geneMaps;
        private final IdentificationParameters identificationParameters;
        private final WaitingHandler waitingHandler;
        private final ExceptionHandler exceptionHandler;
        private final HashMap<String, ArrayList<Double>> threadPrecursorMzDeviations = new HashMap(128);
        private final InputMap inputMap;
        private final boolean applyQCFilters;
        private final boolean storeContributions;
        private final ProcessingParameters processingParameters;

        public PsmValidatorRunnable(SpectrumMatchesIterator psmIterator, Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, ProcessingParameters processingParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, InputMap inputMap, boolean applyQCFilters, boolean storeContributions) {
            this.psmIterator = psmIterator;
            this.identification = identification;
            this.identificationFeaturesGenerator = identificationFeaturesGenerator;
            this.sequenceProvider = sequenceProvider;
            this.proteinDetailsProvider = proteinDetailsProvider;
            this.spectrumProvider = spectrumProvider;
            this.geneMaps = geneMaps;
            this.identificationParameters = identificationParameters;
            this.processingParameters = processingParameters;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
            this.inputMap = inputMap;
            this.applyQCFilters = applyQCFilters;
            this.storeContributions = storeContributions;
        }

        @Override
        public void run() {
            try {
                SpectrumMatch spectrumMatch;
                while ((spectrumMatch = this.psmIterator.next()) != null && !this.waitingHandler.isRunCanceled()) {
                    long spectrumKey = spectrumMatch.getKey();
                    String spectrumFileName = spectrumMatch.getSpectrumFile();
                    if (spectrumMatch.getBestPeptideAssumption() == null) continue;
                    MatchesValidator.updateSpectrumMatchValidationLevel(this.identification, this.identificationFeaturesGenerator, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider, this.geneMaps, this.identificationParameters, MatchesValidator.this.psmMap, spectrumKey, this.applyQCFilters);
                    HashMap<Integer, TreeMap<Double, ArrayList<PeptideAssumption>>> assumptions = spectrumMatch.getPeptideAssumptionsMap();
                    for (TreeMap<Double, ArrayList<PeptideAssumption>> algorithmMap : assumptions.values()) {
                        for (ArrayList<PeptideAssumption> scoreList : algorithmMap.values()) {
                            for (PeptideAssumption peptideAssumption : scoreList) {
                                peptideAssumption.getPeptide().getMass(this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters());
                                MatchesValidator.updatePeptideAssumptionValidationLevel(this.identification, this.identificationFeaturesGenerator, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider, this.identificationParameters, this.inputMap, spectrumKey, peptideAssumption, this.applyQCFilters);
                                if (!this.processingParameters.cachePercolatorFeatures()) continue;
                                PercolatorFeaturesCache percolatorFeaturesCache = (PercolatorFeaturesCache)peptideAssumption.getUrParam(PercolatorFeaturesCache.dummy);
                                if (percolatorFeaturesCache == null) {
                                    percolatorFeaturesCache = new PercolatorFeaturesCache();
                                    peptideAssumption.addUrParam(percolatorFeaturesCache);
                                }
                                double[] measuredAndDeltaMz = PercolatorUtils.getMeasuredAndDeltaMzFeature(spectrumMatch, peptideAssumption, this.identificationParameters.getSearchParameters(), this.spectrumProvider);
                                percolatorFeaturesCache.cache.put(PercolatorFeature.measuredAndDeltaMz, (Object)measuredAndDeltaMz);
                                double intensityCoverage = PercolatorUtils.getIntensityCoverageFeature(spectrumMatch, peptideAssumption, this.identificationParameters.getSearchParameters(), this.identificationParameters.getAnnotationParameters(), this.identificationParameters.getModificationLocalizationParameters(), this.sequenceProvider, this.spectrumProvider);
                                percolatorFeaturesCache.cache.put(PercolatorFeature.intensityCoverage, (Object)intensityCoverage);
                            }
                        }
                    }
                    PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                    PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
                    if (peptideAssumption != null) {
                        peptideAssumption.getPeptide().getMass(this.identificationParameters.getSearchParameters().getModificationParameters(), this.sequenceProvider, this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters());
                        if (psParameter.getMatchValidationLevel().isValidated() && !PeptideUtils.isDecoy(peptideAssumption.getPeptide(), this.sequenceProvider)) {
                            double precursorMz = this.spectrumProvider.getPrecursorMz(spectrumFileName, spectrumMatch.getSpectrumTitle());
                            SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
                            double precursorMzError = peptideAssumption.getDeltaMz(precursorMz, searchParameters.isPrecursorAccuracyTypePpm(), searchParameters.getMinIsotopicCorrection(), searchParameters.getMaxIsotopicCorrection());
                            ArrayList<Double> fileDeviations = this.threadPrecursorMzDeviations.get(spectrumFileName);
                            if (fileDeviations == null) {
                                fileDeviations = new ArrayList();
                                this.threadPrecursorMzDeviations.put(spectrumFileName, fileDeviations);
                            }
                            fileDeviations.add(precursorMzError);
                            if (this.inputMap != null && this.storeContributions) {
                                Peptide bestPeptide = peptideAssumption.getPeptide();
                                int[] agreementAdvocates = assumptions.entrySet().stream().filter(entry -> !((TreeMap)entry.getValue()).isEmpty() && this.hasBestAssumption((TreeMap)entry.getValue(), bestPeptide)).mapToInt(entry -> (Integer)entry.getKey()).distinct().toArray();
                                boolean unique = agreementAdvocates.length == 1;
                                for (int advocateId : agreementAdvocates) {
                                    this.inputMap.addAdvocateContribution(advocateId, spectrumFileName, unique);
                                }
                                this.inputMap.addPeptideShakerHit(spectrumFileName, agreementAdvocates.length == 0);
                            }
                        }
                    }
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.exceptionHandler.catchException(e);
                this.waitingHandler.setRunCanceled();
            }
        }

        private boolean hasBestAssumption(TreeMap<Double, ArrayList<PeptideAssumption>> advocateAssumptions, Peptide bestPeptide) {
            ArrayList<PeptideAssumption> firstHits = advocateAssumptions.firstEntry().getValue();
            return firstHits.stream().anyMatch(assumption -> bestPeptide.isSameSequenceAndModificationStatus(assumption.getPeptide(), this.identificationParameters.getSequenceMatchingParameters()));
        }

        public HashMap<String, ArrayList<Double>> getThreadPrecursorMzDeviations() {
            return this.threadPrecursorMzDeviations;
        }
    }

    private class PeptideValidatorRunnable
    implements Runnable {
        private final PeptideMatchesIterator peptideMatchesIterator;
        private final Identification identification;
        private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
        private final SequenceProvider sequenceProvider;
        private final ProteinDetailsProvider proteinDetailsProvider;
        private final SpectrumProvider spectrumProvider;
        private final GeneMaps geneMaps;
        private final IdentificationParameters identificationParameters;
        private final WaitingHandler waitingHandler;
        private final ExceptionHandler exceptionHandler;
        private final ArrayList<Double> validatedPeptideLengths = new ArrayList();
        private final HashMap<String, Integer> validatedTotalPeptidesPerFraction = new HashMap();
        private final Metrics metrics;

        public PeptideValidatorRunnable(PeptideMatchesIterator peptideMatchesIterator, Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, IdentificationParameters identificationParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, Metrics metrics) {
            this.peptideMatchesIterator = peptideMatchesIterator;
            this.identification = identification;
            this.identificationFeaturesGenerator = identificationFeaturesGenerator;
            this.sequenceProvider = sequenceProvider;
            this.proteinDetailsProvider = proteinDetailsProvider;
            this.spectrumProvider = spectrumProvider;
            this.geneMaps = geneMaps;
            this.identificationParameters = identificationParameters;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
            this.metrics = metrics;
        }

        @Override
        public void run() {
            try {
                PeptideMatch peptideMatch;
                while ((peptideMatch = this.peptideMatchesIterator.next()) != null && !this.waitingHandler.isRunCanceled()) {
                    long peptideKey = peptideMatch.getKey();
                    MatchesValidator.updatePeptideMatchValidationLevel(this.identification, this.identificationFeaturesGenerator, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider, this.geneMaps, this.identificationParameters, MatchesValidator.this.peptideMap, peptideKey);
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    if (psParameter.getMatchValidationLevel().isValidated()) {
                        double length = peptideMatch.getPeptide().getSequence().length();
                        this.validatedPeptideLengths.add(length);
                    }
                    if (this.identification.getFractions().size() > 1) {
                        HashMap<String, Integer> validatedPsmsPerFraction = new HashMap<String, Integer>(psParameter.getFractionScore().size());
                        HashMap<String, ArrayList<Double>> precursorIntensitesPerFractionPeptideLevel = new HashMap<String, ArrayList<Double>>(psParameter.getFractionScore().size());
                        for (String fractionName : psParameter.getFractions()) {
                            ArrayList<Double> precursorIntensities = new ArrayList<Double>();
                            String peptideKeyString = Long.toString(peptideKey);
                            StringBuilder fractionKeyB = new StringBuilder(fractionName.length() + peptideKeyString.length() + 1);
                            fractionKeyB.append(fractionName).append('_').append(peptideKeyString);
                            String fractionKey = fractionKeyB.toString();
                            ArrayList<Long> spectrumKeys = this.metrics.getFractionPsmMatches().get(fractionKey);
                            if (spectrumKeys != null) {
                                for (long spectrumKey : spectrumKeys) {
                                    SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumKey);
                                    PSParameter psParameter2 = (PSParameter)spectrumMatch.getUrParam(PSParameter.dummy);
                                    if (psParameter2.getMatchValidationLevel().isValidated()) {
                                        if (validatedPsmsPerFraction.containsKey(fractionName)) {
                                            int value = validatedPsmsPerFraction.get(fractionName);
                                            validatedPsmsPerFraction.put(fractionName, value + 1);
                                        } else {
                                            validatedPsmsPerFraction.put(fractionName, 1);
                                        }
                                        double intensity = this.spectrumProvider.getPrecursor((String)spectrumMatch.getSpectrumFile(), (String)spectrumMatch.getSpectrumTitle()).intensity;
                                        if (intensity > 0.0) {
                                            precursorIntensities.add(intensity);
                                        }
                                    }
                                    if (!this.waitingHandler.isRunCanceled()) continue;
                                    return;
                                }
                            }
                            precursorIntensitesPerFractionPeptideLevel.put(fractionName, precursorIntensities);
                            if (!psParameter.getMatchValidationLevel().isValidated()) continue;
                            this.addValidatedPeptideForFraction(fractionName);
                        }
                        psParameter.setValidatedSpectraPepFraction(validatedPsmsPerFraction);
                        psParameter.setPrecursorIntensityPerFraction(precursorIntensitesPerFractionPeptideLevel);
                    }
                    this.identification.updateObject(peptideKey, peptideMatch);
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.exceptionHandler.catchException(e);
                this.waitingHandler.setRunCanceled();
            }
        }

        private synchronized void addValidatedPeptideForFraction(String fractionName) {
            Integer value = this.validatedTotalPeptidesPerFraction.get(fractionName);
            if (value != null) {
                this.validatedTotalPeptidesPerFraction.put(fractionName, value + 1);
            } else {
                this.validatedTotalPeptidesPerFraction.put(fractionName, 1);
            }
        }

        public ArrayList<Double> getValidatedPeptideLengths() {
            return this.validatedPeptideLengths;
        }

        public HashMap<String, Integer> getValidatedTotalPeptidesPerFraction() {
            return this.validatedTotalPeptidesPerFraction;
        }
    }

    private class ProteinValidatorRunnable
    implements Runnable {
        private final ProteinMatchesIterator proteinMatchesIterator;
        private final Identification identification;
        private final IdentificationFeaturesGenerator identificationFeaturesGenerator;
        private final SequenceProvider sequenceProvider;
        private final ProteinDetailsProvider proteinDetailsProvider;
        private final SpectrumProvider spectrumProvider;
        private final GeneMaps geneMaps;
        private final IdentificationParameters identificationParameters;
        private final WaitingHandler waitingHandler;
        private final ExceptionHandler exceptionHandler;
        private final ValidationQcParameters validationQCParameters;
        private final Metrics metrics;
        private final HashSet<Long> validatedProteinMatches = new HashSet();

        public ProteinValidatorRunnable(ProteinMatchesIterator proteinMatchesIterator, Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, SpectrumProvider spectrumProvider, GeneMaps geneMaps, Metrics metrics, IdentificationParameters identificationParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.proteinMatchesIterator = proteinMatchesIterator;
            this.identification = identification;
            this.identificationFeaturesGenerator = identificationFeaturesGenerator;
            this.sequenceProvider = sequenceProvider;
            this.proteinDetailsProvider = proteinDetailsProvider;
            this.spectrumProvider = spectrumProvider;
            this.geneMaps = geneMaps;
            this.metrics = metrics;
            this.identificationParameters = identificationParameters;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
            this.validationQCParameters = identificationParameters.getIdValidationParameters().getValidationQCParameters();
        }

        @Override
        public void run() {
            try {
                ProteinMatch proteinMatch;
                TargetDecoyResults targetDecoyResults = MatchesValidator.this.proteinMap.getTargetDecoyResults();
                double desiredThreshold = targetDecoyResults.getUserInput();
                double nTargetLimit = 100.0 / desiredThreshold;
                double proteinThreshold = targetDecoyResults.getScoreLimit();
                double margin = this.validationQCParameters.getConfidenceMargin() * MatchesValidator.this.proteinMap.getResolution();
                double proteinConfidentThreshold = targetDecoyResults.getConfidenceLimit() + margin;
                if (proteinConfidentThreshold > 100.0) {
                    proteinConfidentThreshold = 100.0;
                }
                boolean noValidated = MatchesValidator.this.proteinMap.getTargetDecoyResults().noValidated();
                int maxValidatedSpectraFractionLevel = 0;
                int maxValidatedPeptidesFractionLevel = 0;
                double maxProteinAveragePrecursorIntensity = 0.0;
                double maxProteinSummedPrecursorIntensity = 0.0;
                while ((proteinMatch = this.proteinMatchesIterator.next()) != null && !this.waitingHandler.isRunCanceled()) {
                    long proteinKey = proteinMatch.getKey();
                    MatchesValidator.updateProteinMatchValidationLevel(this.identification, this.identificationFeaturesGenerator, this.sequenceProvider, this.proteinDetailsProvider, this.spectrumProvider, this.geneMaps, this.identificationParameters, MatchesValidator.this.proteinMap, proteinThreshold, nTargetLimit, proteinConfidentThreshold, noValidated, proteinKey);
                    PSParameter proteinMatchPsParameter = (PSParameter)proteinMatch.getUrParam(PSParameter.dummy);
                    if (!proteinMatch.isDecoy() && proteinMatchPsParameter.getMatchValidationLevel().isValidated()) {
                        this.identificationFeaturesGenerator.getSequenceCoverage(proteinKey);
                        this.validatedProteinMatches.add(proteinKey);
                    }
                    if (this.identification.getFractions().size() > 1) {
                        HashMap<String, Integer> validatedPsmsPerFraction = new HashMap<String, Integer>();
                        HashMap<String, Integer> validatedPeptidesPerFraction = new HashMap<String, Integer>();
                        HashMap<String, ArrayList<Double>> precursorIntensitesPerFractionProteinLevel = new HashMap<String, ArrayList<Double>>();
                        for (long peptideKey : proteinMatch.getPeptideMatchesKeys()) {
                            PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
                            PSParameter peptideMatchPsParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                            for (String fraction : peptideMatchPsParameter.getFractions()) {
                                ArrayList<Double> peptideIntensities;
                                Integer psmValue = peptideMatchPsParameter.getFractionValidatedSpectra(fraction);
                                if (psmValue != null) {
                                    Integer value = validatedPsmsPerFraction.get(fraction);
                                    int newValue = value == null ? psmValue : psmValue + value;
                                    validatedPsmsPerFraction.put(fraction, newValue);
                                    if (newValue > maxValidatedSpectraFractionLevel) {
                                        maxValidatedSpectraFractionLevel = newValue;
                                    }
                                }
                                if ((peptideIntensities = peptideMatchPsParameter.getPrecursorIntensityPerFraction(fraction)) != null) {
                                    ArrayList<Double> proteinIntensities = precursorIntensitesPerFractionProteinLevel.get(fraction);
                                    if (proteinIntensities != null) {
                                        proteinIntensities.addAll(peptideIntensities);
                                    } else {
                                        precursorIntensitesPerFractionProteinLevel.put(fraction, new ArrayList<Double>(peptideIntensities));
                                    }
                                }
                                if (!peptideMatchPsParameter.getMatchValidationLevel().isValidated()) continue;
                                Integer value = validatedPeptidesPerFraction.get(fraction);
                                if (value != null) {
                                    Integer n = value;
                                    value = value + 1;
                                } else {
                                    value = 1;
                                }
                                validatedPeptidesPerFraction.put(fraction, value);
                                if (value <= maxValidatedPeptidesFractionLevel) continue;
                                maxValidatedPeptidesFractionLevel = value;
                            }
                            if (!this.waitingHandler.isRunCanceled()) continue;
                            return;
                        }
                        if (proteinMatchPsParameter.getFractionScore().size() > 0) {
                            proteinMatchPsParameter.setValidatedSpectraPepFraction(validatedPsmsPerFraction);
                            proteinMatchPsParameter.setValidatedPeptidesPerFraction(validatedPeptidesPerFraction);
                            proteinMatchPsParameter.setPrecursorIntensityPerFraction(precursorIntensitesPerFractionProteinLevel);
                            Object object = proteinMatchPsParameter.getFractions().iterator();
                            while (object.hasNext()) {
                                String fraction = (String)object.next();
                                if (proteinMatchPsParameter.getPrecursorIntensityAveragePerFraction(fraction) == null) continue;
                                if (proteinMatchPsParameter.getPrecursorIntensityAveragePerFraction(fraction) > maxProteinAveragePrecursorIntensity) {
                                    maxProteinAveragePrecursorIntensity = proteinMatchPsParameter.getPrecursorIntensityAveragePerFraction(fraction);
                                }
                                if (proteinMatchPsParameter.getPrecursorIntensitySummedPerFraction(fraction) == null || !(proteinMatchPsParameter.getPrecursorIntensitySummedPerFraction(fraction) > maxProteinSummedPrecursorIntensity)) continue;
                                maxProteinSummedPrecursorIntensity = proteinMatchPsParameter.getPrecursorIntensitySummedPerFraction(fraction);
                            }
                        }
                    }
                    this.identification.updateObject(proteinKey, proteinMatch);
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
                if (this.identification.getFractions().size() > 1) {
                    this.setMaxValues(maxValidatedPeptidesFractionLevel, maxValidatedSpectraFractionLevel, maxProteinAveragePrecursorIntensity, maxProteinSummedPrecursorIntensity);
                }
            }
            catch (Exception e) {
                this.exceptionHandler.catchException(e);
            }
        }

        private synchronized void setMaxValues(int maxValidatedPeptidesFractionLevel, int maxValidatedSpectraFractionLevel, double maxProteinAveragePrecursorIntensity, double maxProteinSummedPrecursorIntensity) {
            if (this.metrics.getMaxValidatedPeptidesPerFraction() != null && maxValidatedPeptidesFractionLevel > this.metrics.getMaxValidatedPeptidesPerFraction()) {
                this.metrics.setMaxValidatedPeptidesPerFraction(maxValidatedPeptidesFractionLevel);
            }
            if (this.metrics.getMaxValidatedSpectraPerFraction() != null && maxValidatedSpectraFractionLevel > this.metrics.getMaxValidatedSpectraPerFraction()) {
                this.metrics.setMaxValidatedSpectraPerFraction(maxValidatedSpectraFractionLevel);
            }
            if (this.metrics.getMaxProteinAveragePrecursorIntensity() != null && maxProteinAveragePrecursorIntensity > this.metrics.getMaxProteinAveragePrecursorIntensity()) {
                this.metrics.setMaxProteinAveragePrecursorIntensity(maxProteinAveragePrecursorIntensity);
            }
            if (this.metrics.getMaxProteinSummedPrecursorIntensity() != null && maxProteinSummedPrecursorIntensity > this.metrics.getMaxProteinSummedPrecursorIntensity()) {
                this.metrics.setMaxProteinSummedPrecursorIntensity(maxProteinSummedPrecursorIntensity);
            }
        }

        public HashSet<Long> getValidatedProteinMatches() {
            return this.validatedProteinMatches;
        }
    }
}

