/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.ebi.pride.tools.ErrorHandlerIface;

public class ValidationErrorHandler
implements ErrorHandlerIface {
    List<String> errorMessages = new ArrayList<String>();

    @Override
    public boolean noErrors() {
        return this.errorMessages.size() == 0;
    }

    @Override
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        StringBuilder sb = new StringBuilder();
        sb.append("Warning: Validation of the XMl has detected the following condition on line ").append(exception.getLineNumber()).append("\n  Warning message: ").append(exception.getMessage());
        this.errorMessages.add(sb.toString());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        StringBuilder sb = new StringBuilder();
        sb.append("Non-fatal XML Parsing error detected on line ").append(exception.getLineNumber()).append("\n  Error message: ").append(exception.getMessage());
        this.errorMessages.add(sb.toString());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        StringBuilder sb = new StringBuilder();
        sb.append("FATAL XML Parsing error detected on line ").append(exception.getLineNumber()).append("\n  Fatal Error message: ").append(exception.getMessage());
        this.errorMessages.add(sb.toString());
    }

    @Override
    public void fatalError(IOException exception) {
        StringBuilder sb = new StringBuilder();
        sb.append("FATAL XML Validation error. ");
        if (exception instanceof FileNotFoundException) {
            String exceptionMsg = exception.getMessage();
            String sub = exceptionMsg.substring(exceptionMsg.lastIndexOf(File.separatorChar) + 1);
            sb.append("A needed or referenced File was not found!\n").append("  ").append(sub).append("\n  Hint: Please make sure your file does not reference local schema or DTD files.");
        } else {
            sb.append("An I/O error prevented the file from being validated!\n");
        }
        this.errorMessages.add(sb.toString());
    }
}

