/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.cl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLValidationErrorHandler
implements ErrorHandler {
    private List<String> errorMessages = null;

    public boolean noErrors() {
        return this.errorMessages == null || this.errorMessages.isEmpty();
    }

    public String getErrorsFormattedAsPlainText() {
        if (this.noErrors()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String errorMessage : this.errorMessages) {
            sb.append(errorMessage);
        }
        return sb.toString();
    }

    public String getErrorsFormattedAsHTML() {
        if (this.noErrors()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String errorMessage : this.errorMessages) {
            sb.append(errorMessage);
        }
        return sb.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\n", "<br/>");
    }

    public List<String> getErrorsAsList() {
        return this.errorMessages;
    }

    private void initialiseErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new ArrayList<String>();
            this.errorMessages.add("Unfortunately, your XML document does not conform to the XML schema for the following reasons:\n");
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.initialiseErrorMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nNon-fatal XML Parsing error detected on line ").append(exception.getLineNumber()).append("\nError message: ").append(exception.getMessage());
        this.errorMessages.add(sb.toString());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.initialiseErrorMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nFATAL XML Parsing error detected on line ").append(exception.getLineNumber()).append("\nFatal Error message: ").append(exception.getMessage());
        this.errorMessages.add(sb.toString());
    }

    public void fatalError(IOException exception) {
        this.initialiseErrorMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nFATAL XML Validation error. ");
        if (exception instanceof FileNotFoundException) {
            sb.append("A needed or referenced File was not found!\n").append(exception.getMessage()).append("\nHint: Please make sure your file does not reference local schema or DTD files.");
        } else {
            sb.append("An I/O error prevented the file from being validated!\n");
        }
        this.errorMessages.add(sb.toString());
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.initialiseErrorMessages();
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nWarning: Validation of the XMl has detected the following condition on line ").append(exception.getLineNumber()).append("\nWarning message: ").append(exception.getMessage());
        this.errorMessages.add(sb.toString());
    }
}

