/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.isorelax;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLValidationErrorHandler
implements ErrorHandler {
    private StringBuffer errorMessageBuffer = null;

    public boolean noErrors() {
        return this.errorMessageBuffer == null;
    }

    public String getErrorsFormattedAsPlainText() {
        if (this.noErrors()) {
            return null;
        }
        return this.errorMessageBuffer.toString();
    }

    public String getErrorsFormattedAsHTML() {
        if (this.noErrors()) {
            return null;
        }
        return this.errorMessageBuffer.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\n", "<br/>");
    }

    private void initialiseErrorMessageBuffer() {
        if (this.errorMessageBuffer == null) {
            this.errorMessageBuffer = new StringBuffer("Unfortunately, your XML document does not conform to the XML schema for the following reasons:\n");
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.initialiseErrorMessageBuffer();
        this.errorMessageBuffer.append("\n\nNon-fatal XML Parsing error detected on line ").append(exception.getLineNumber()).append("\nError message: ").append(exception.getMessage());
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.initialiseErrorMessageBuffer();
        this.errorMessageBuffer.append("\n\nFATAL XML Parsing error detected on line ").append(exception.getLineNumber()).append("\nFatal Error message: ").append(exception.getMessage());
    }

    public void fatalError(IOException exception) {
        this.initialiseErrorMessageBuffer();
        this.errorMessageBuffer.append("\n\nFATAL XML Validation error. ");
        if (exception instanceof FileNotFoundException) {
            this.errorMessageBuffer.append("A needed or referenced File was not found!\n").append(exception.getMessage()).append("\nHint: Please make sure your file does not reference local schema or DTD files.");
        } else {
            this.errorMessageBuffer.append("An I/O error prevented the file from being validated!\n");
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.initialiseErrorMessageBuffer();
        this.errorMessageBuffer.append("\n\nWarning: Validation of the XMl has detected the following condition on line ").append(exception.getLineNumber()).append("\nWarning message: ").append(exception.getMessage());
    }
}

