/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.validator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.ebi.pride.tools.cl.PrideXmlClValidator;
import uk.ac.ebi.pride.tools.isorelax.PrideXmlValidatorIsoRelax;
import uk.ac.ebi.pride.tools.validator.MyErrorHandler;
import uk.ac.ebi.pride.tools.validator.Validate;

public class ComparePerformance {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    ErrorHandler eh = new MyErrorHandler();
    DefaultHandler dh = new DefaultHandler();

    public static void main(String[] args) {
        long totalStart = System.currentTimeMillis();
        try {
            if (args.length != 3) {
                ComparePerformance.usage();
            }
            ComparePerformance cp = new ComparePerformance();
            String schema = args[0];
            String xml = args[1];
            System.out.println("Schema File = " + args[0]);
            System.out.println("XML Document= " + args[1]);
            SAXParserFactory spFactory = SAXParserFactory.newInstance();
            spFactory.setNamespaceAware(true);
            spFactory.setValidating(true);
            SAXParser sp = spFactory.newSAXParser();
            long startSchemaCompile = System.currentTimeMillis();
            javax.xml.validation.Schema cschema = Validate.compileSchema(schema);
            System.out.println("Time to compile schema: " + (System.currentTimeMillis() - startSchemaCompile));
            long startSaxParserInit = System.currentTimeMillis();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setSchema(cschema);
            SAXParser parser = spf.newSAXParser();
            System.out.println("Time to initialise SAX parser: " + (System.currentTimeMillis() - startSaxParserInit));
            Validator validator = cschema.newValidator();
            long e = ComparePerformance.useClValidator(schema, xml);
            System.out.println("Using cl Validator approach, Time taken for 1 iteration is " + e + " ms ");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Total time [ms]: " + (System.currentTimeMillis() - totalStart));
    }

    long usingJAXP1_3Validator(Validator validator, String xml) throws SAXException, IOException {
        long start = System.currentTimeMillis();
        validator.reset();
        validator.setErrorHandler(this.eh);
        validator.validate(new StreamSource(xml));
        return System.currentTimeMillis() - start;
    }

    long usingJAXP1_3setSchema(SAXParser sp, String xml) throws SAXException, IOException {
        long start = System.currentTimeMillis();
        sp.reset();
        sp.parse(new File(xml), this.dh);
        return System.currentTimeMillis() - start;
    }

    long usingJAXP1_2(SAXParser sp, String xml, String schema) throws SAXException, IOException {
        long start = System.currentTimeMillis();
        sp.reset();
        sp.setProperty(SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        sp.setProperty(SCHEMA_SOURCE, schema);
        sp.parse(new File(xml), this.dh);
        return System.currentTimeMillis() - start;
    }

    static void usage() {
        System.out.println("java -cp . ValidationFramework <SchemaFile> <XML Document>");
    }

    private static long useIsoRelaxValidator(String schemaFileName, String xmlFileName) throws VerifierConfigurationException, IOException, SAXException {
        long startTime = System.currentTimeMillis();
        File schemaFile = new File(schemaFileName);
        if (!schemaFile.exists() || !schemaFile.canRead()) {
            throw new IllegalArgumentException("Invalid schema file provided. Could not find: " + schemaFileName);
        }
        File xmlFile = new File(xmlFileName);
        if (!xmlFile.exists() || !xmlFile.canRead()) {
            throw new IllegalArgumentException("Invalid schema file provided. Could not find: " + xmlFile);
        }
        BufferedReader reader = new BufferedReader(new FileReader(xmlFile));
        PrideXmlValidatorIsoRelax.validate((Reader)reader, schemaFile);
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }

    private static long useClValidator(String schemaFileName, String xmlFileName) throws VerifierConfigurationException, IOException, SAXException {
        long startTime = System.currentTimeMillis();
        File schemaFile = new File(schemaFileName);
        if (!schemaFile.exists() || !schemaFile.canRead()) {
            throw new IllegalArgumentException("Invalid schema file provided. Could not find: " + schemaFileName);
        }
        File xmlFile = new File(xmlFileName);
        if (!xmlFile.exists() || !xmlFile.canRead()) {
            throw new IllegalArgumentException("Invalid schema file provided. Could not find: " + xmlFile);
        }
        Schema clSchema = PrideXmlClValidator.VERIFIER_FACTORY.compileSchema(schemaFile);
        BufferedReader reader = new BufferedReader(new FileReader(xmlFile));
        PrideXmlClValidator validator = new PrideXmlClValidator();
        validator.validate(reader, clSchema);
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }
}

