/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.pride.tools.validator;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.ac.ebi.pride.tools.validator.ContentHandlerImpl;
import uk.ac.ebi.pride.tools.validator.MyErrorHandler;
import uk.ac.ebi.pride.tools.validator.Validate;

public class ValidateSAXStream {
    private Schema compiledSchema;

    public ValidateSAXStream(String schema) throws SAXException {
        this.compiledSchema = Validate.compileSchema(schema);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            ValidateSAXStream.printUsage();
        }
        try {
            ValidateSAXStream vss = new ValidateSAXStream(args[0]);
            vss.validateSAXStream(vss.getSAXReader(), args[1]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void validateSAXStream(XMLReader reader, String xml) throws SAXException, IOException {
        ValidatorHandler vh = this.getValidatorHandler();
        reader.setContentHandler(vh);
        reader.parse(xml);
    }

    public ValidatorHandler getValidatorHandler() throws SAXException, IOException {
        ValidatorHandler vh = this.compiledSchema.newValidatorHandler();
        vh.setErrorHandler(new MyErrorHandler());
        vh.setContentHandler(new ContentHandlerImpl());
        return vh;
    }

    public Validator getValidator() {
        Validator validator = this.compiledSchema.newValidator();
        validator.setErrorHandler(new MyErrorHandler());
        return validator;
    }

    protected XMLReader getSAXReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        return spf.newSAXParser().getXMLReader();
    }

    static void printUsage() {
        System.out.println("java ValidateSAXStream <schema file> <XML document>");
    }
}

