/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.omxparser;

import de.proteinms.omxparser.util.MSHitSet;
import de.proteinms.omxparser.util.MSHits;
import de.proteinms.omxparser.util.MSPepHit;
import de.proteinms.omxparser.util.MSSearch;
import de.proteinms.omxparser.util.MSSpectrum;
import de.proteinms.omxparser.util.OmssaModification;
import de.proteinms.omxparser.util.OmxParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OmssaOmxFile {
    private static Logger logger = LogManager.getLogger(OmssaOmxFile.class);
    private HashMap<MSSpectrum, MSHitSet> spectrumToHitSetMap = new HashMap();
    private HashMap<MSSpectrum, HashSet<String>> spectrumToPeptideMap = new HashMap();
    private HashMap<String, LinkedList<MSSpectrum>> peptideToSpectrumMap = new HashMap();
    private HashMap<String, LinkedList<MSPepHit>> peptideToProteinMap = new HashMap();
    private HashMap<String, LinkedList<String>> proteinToPeptideMap = new HashMap();
    private MSSearch parserResult;
    private OmxParser parser;

    public MSSearch getParserResult() {
        return this.parserResult;
    }

    public HashMap<MSSpectrum, MSHitSet> getSpectrumToHitSetMap() {
        return this.spectrumToHitSetMap;
    }

    public HashMap<MSSpectrum, HashSet<String>> getSpectrumToPeptideMap() {
        return this.spectrumToPeptideMap;
    }

    public HashMap<String, LinkedList<MSSpectrum>> getPeptideToSpectrumMap() {
        return this.peptideToSpectrumMap;
    }

    public HashMap<String, LinkedList<MSPepHit>> getPeptideToProteinMap() {
        return this.peptideToProteinMap;
    }

    public HashMap<String, LinkedList<String>> getProteinToPeptideMap() {
        return this.proteinToPeptideMap;
    }

    public OmssaOmxFile(String omxFile, String modsFile, String userModsFile) {
        this(omxFile, modsFile, userModsFile, true);
    }

    public OmssaOmxFile(String omxFile, String modsFile, String userModsFile, boolean importSpectra) {
        this(omxFile, modsFile, userModsFile, importSpectra, importSpectra, true);
    }

    public OmssaOmxFile(String omxFile, String modsFile, String userModsFile, boolean importSpectra, boolean importIdDetails, boolean processMaps) {
        this.parser = new OmxParser(omxFile, modsFile, userModsFile, importSpectra, importIdDetails);
        this.parserResult = this.parser.parserResult;
        logger.debug("processing information...");
        if (processMaps) {
            this.processSpectrumToHitSetMap(this.parserResult);
            this.processSpectrumToPeptideMap(this.parserResult);
            this.processPeptideToSpectrumMap(this.parserResult);
            this.processPeptideToProteineMap(this.parserResult);
            this.processProteineToPeptideMap(this.parserResult);
        }
        logger.debug("parsing completed");
    }

    public OmssaOmxFile(String omxFile, String modsFile) {
        this(omxFile, modsFile, null);
    }

    public OmssaOmxFile(String omxFile) {
        this(omxFile, null, null);
    }

    public OmssaOmxFile(String omxFile, boolean importSpectra) {
        this(omxFile, null, null, importSpectra);
    }

    public OmssaOmxFile(String omxFile, boolean importSpectra, boolean importIdDetails, boolean processMaps) {
        this(omxFile, null, null, importSpectra, importIdDetails, processMaps);
    }

    public HashMap<Integer, OmssaModification> getModifications() {
        return this.parser.getOmssaModificationDetails();
    }

    public HashMap<String, MSPepHit> getPeptidesToPepHit(String protein_accession) {
        HashMap<String, MSPepHit> resultMap = new HashMap<String, MSPepHit>();
        LinkedList<String> peptides = this.proteinToPeptideMap.get(protein_accession);
        for (String thisPeptide : peptides) {
            LinkedList<MSPepHit> pephits = this.peptideToProteinMap.get(thisPeptide);
            for (MSPepHit thisPepHit : pephits) {
                if (!thisPepHit.MSPepHit_accession.equals(protein_accession)) continue;
                resultMap.put(thisPeptide, thisPepHit);
            }
        }
        return resultMap;
    }

    private void processSpectrumToHitSetMap(MSSearch result) {
        for (int i = 0; i < result.MSSearch_request.MSRequest.size(); ++i) {
            for (Integer key : result.MSSearch_request.MSRequest.get((int)i).MSRequest_spectra.MSSpectrumset.MSSpectrum.keySet()) {
                this.spectrumToHitSetMap.put(result.MSSearch_request.MSRequest.get((int)i).MSRequest_spectra.MSSpectrumset.MSSpectrum.get(key), result.MSSearch_response.MSResponse.get((int)i).MSResponse_hitsets.MSHitSet.get(key));
            }
        }
    }

    private void processSpectrumToPeptideMap(MSSearch result) {
        HashSet<String> peptideSet = new HashSet<String>();
        for (int i = 0; i < result.MSSearch_request.MSRequest.size(); ++i) {
            for (Integer key : result.MSSearch_request.MSRequest.get((int)i).MSRequest_spectra.MSSpectrumset.MSSpectrum.keySet()) {
                if (result.MSSearch_response.MSResponse.get(i) == null || result.MSSearch_response.MSResponse.get((int)i).MSResponse_hitsets.MSHitSet.get(key) == null) continue;
                Iterator<MSHits> itMSHits = result.MSSearch_response.MSResponse.get((int)i).MSResponse_hitsets.MSHitSet.get((Object)key).MSHitSet_hits.MSHits.iterator();
                while (itMSHits.hasNext()) {
                    peptideSet.add(itMSHits.next().MSHits_pepstring);
                }
                this.spectrumToPeptideMap.put(result.MSSearch_request.MSRequest.get((int)i).MSRequest_spectra.MSSpectrumset.MSSpectrum.get(key), peptideSet);
            }
        }
    }

    private void processPeptideToSpectrumMap(MSSearch result) {
        for (MSSpectrum thisSpectrum : this.spectrumToHitSetMap.keySet()) {
            MSHitSet thisHitSet = this.spectrumToHitSetMap.get(thisSpectrum);
            if (thisHitSet == null) continue;
            Iterator<MSHits> mshitsIt = thisHitSet.MSHitSet_hits.MSHits.iterator();
            while (mshitsIt.hasNext()) {
                String thisPepString = mshitsIt.next().MSHits_pepstring;
                if (this.peptideToSpectrumMap.containsKey(thisPepString)) {
                    this.peptideToSpectrumMap.get(thisPepString).add(thisSpectrum);
                    continue;
                }
                LinkedList<MSSpectrum> spectrumList = new LinkedList<MSSpectrum>();
                spectrumList.add(thisSpectrum);
                this.peptideToSpectrumMap.put(thisPepString, spectrumList);
            }
        }
    }

    private void processPeptideToProteineMap(MSSearch result) {
        for (int i = 0; i < result.MSSearch_request.MSRequest.size(); ++i) {
            for (Integer key : result.MSSearch_request.MSRequest.get((int)i).MSRequest_spectra.MSSpectrumset.MSSpectrum.keySet()) {
                if (result.MSSearch_response.MSResponse.get(i) == null || result.MSSearch_response.MSResponse.get((int)i).MSResponse_hitsets.MSHitSet.get(key) == null) continue;
                for (MSHits thisMSHits : result.MSSearch_response.MSResponse.get((int)i).MSResponse_hitsets.MSHitSet.get((Object)key).MSHitSet_hits.MSHits) {
                    String pepString = thisMSHits.MSHits_pepstring;
                    Iterator<MSPepHit> msPepHitIt = thisMSHits.MSHits_pephits.MSPepHit.iterator();
                    while (msPepHitIt.hasNext()) {
                        if (this.peptideToProteinMap.containsKey(pepString)) {
                            this.peptideToProteinMap.get(pepString).add(msPepHitIt.next());
                            continue;
                        }
                        LinkedList<MSPepHit> newList = new LinkedList<MSPepHit>();
                        newList.add(msPepHitIt.next());
                        this.peptideToProteinMap.put(pepString, newList);
                    }
                }
            }
        }
    }

    private void processProteineToPeptideMap(MSSearch result) {
        for (int i = 0; i < result.MSSearch_request.MSRequest.size(); ++i) {
            for (Integer key : result.MSSearch_request.MSRequest.get((int)i).MSRequest_spectra.MSSpectrumset.MSSpectrum.keySet()) {
                if (result.MSSearch_response.MSResponse.get(i) == null || result.MSSearch_response.MSResponse.get((int)i).MSResponse_hitsets.MSHitSet.get(key) == null) continue;
                for (MSHits thisMSHits : result.MSSearch_response.MSResponse.get((int)i).MSResponse_hitsets.MSHitSet.get((Object)key).MSHitSet_hits.MSHits) {
                    String pepString = thisMSHits.MSHits_pepstring;
                    Iterator<MSPepHit> msPepHitIt = thisMSHits.MSHits_pephits.MSPepHit.iterator();
                    while (msPepHitIt.hasNext()) {
                        String proteinAccession = msPepHitIt.next().MSPepHit_accession;
                        if (this.proteinToPeptideMap.containsKey(proteinAccession)) {
                            this.proteinToPeptideMap.get(proteinAccession).add(pepString);
                            continue;
                        }
                        LinkedList<String> newList = new LinkedList<String>();
                        newList.add(pepString);
                        this.proteinToPeptideMap.put(proteinAccession, newList);
                    }
                }
            }
        }
    }
}

