/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.omxparser.tools;

import com.compomics.util.experiment.io.biology.protein.Header;
import com.compomics.util.gui.interfaces.SpectrumAnnotation;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import de.proteinms.omxparser.OmssaOmxFile;
import de.proteinms.omxparser.tools.BlackWhiteTextColorRenderer;
import de.proteinms.omxparser.tools.HelpWindow;
import de.proteinms.omxparser.tools.OmssaViewerFileSelection;
import de.proteinms.omxparser.tools.ProgressDialog;
import de.proteinms.omxparser.tools.Properties;
import de.proteinms.omxparser.tools.ScientificNumberTableCellRenderer;
import de.proteinms.omxparser.tools.TxtFileFilter;
import de.proteinms.omxparser.tools.Util;
import de.proteinms.omxparser.util.MSHitSet;
import de.proteinms.omxparser.util.MSHits;
import de.proteinms.omxparser.util.MSMZHit;
import de.proteinms.omxparser.util.MSModHit;
import de.proteinms.omxparser.util.MSPepHit;
import de.proteinms.omxparser.util.MSSpectrum;
import de.proteinms.omxparser.util.OmssaModification;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.NimbusCheckBoxRenderer;
import org.jdesktop.layout.GroupLayout;

public class OmssaViewer
extends JFrame {
    private OmssaOmxFile omssaOmxFile;
    private ProgressDialog progressDialog;
    private SpectrumPanel spectrumPanel;
    private String omxFile;
    private String modsFile;
    private String userModsFile;
    private HashMap<Integer, ArrayList<Double>> allMzValues;
    private HashMap<Integer, ArrayList<Double>> allAbundanceValues;
    private HashMap<MSSpectrum, MSHitSet> spectrumHitSetMap;
    private HashMap<Integer, MSSpectrum> spectra;
    private Vector spectraJTableColumnToolTips;
    private Vector spectrumJTableColumnToolTips;
    private Vector identificationsJTableColumnToolTips;
    private HashMap<String, Vector<SpectrumAnnotation>> allAnnotations;
    public final double HYDROGEN_MASS = 1.00794;
    private double ionCoverageErrorMargin;
    private int omssaResponseScale;
    private List<Integer> usedIonTypes;
    private String ionCoverageLegend = "Ion Coverage: b-ions underlined, y-ions red font";
    private String lastSelectedFolder = "user.home";
    private static boolean useErrorLog = true;
    private JCheckBox aIonsJCheckBox;
    private JMenuItem aboutJMenuItem;
    private ButtonGroup accesionDetailsButtonGroup;
    private JCheckBox bIonsJCheckBox;
    private JPanel backgroundPanel;
    private JCheckBox cIonsJCheckBox;
    private JCheckBox chargeOneJCheckBox;
    private JCheckBox chargeOverTwoJCheckBox;
    private JCheckBox chargeTwoJCheckBox;
    private JMenuItem copyIdentificationsJMenuItem;
    private JPopupMenu copyIdentificationsJPopupMenu;
    private JMenuItem copySpectraJMenuItem;
    private JPopupMenu copySpectraJPopupMenu;
    private JMenuItem copySpectrumJMenuItem;
    private JPopupMenu copySpectrumJPopupMenu;
    private JMenuItem exitJMenuItem;
    private JMenuItem exportAllIdentificationsJMenuItem;
    private JMenuItem exportAllSpectraJMenuItem;
    private JMenuItem exportBestIdentificationsJMenuItem;
    private JMenu exportJMenu;
    private JMenuItem exportSelectedSpectrumJMenuItem;
    private JMenuItem exportSpectraFilesTableJMenuItem;
    private JMenu fileJMenu;
    private JMenu helpJMenu;
    private JMenuItem helpJMenuItem;
    private JScrollPane identificationsJScrollPane;
    private JTable identificationsJTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel legendJLabel;
    private JMenuItem openJMenuItem;
    private JTextField ptmsJTextField;
    private JScrollPane spectraJScrollPane;
    private JTable spectraJTable;
    private JPanel spectrumJPanel;
    private JScrollPane spectrumJScrollPane;
    private JTable spectrumJTable;
    private JCheckBox xIonsJCheckBox;
    private JCheckBox yIonsJCheckBox;
    private JCheckBox zIonsJCheckBox;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new OmssaViewerFileSelection(new OmssaViewer(), false, null, null, null, "user.home");
            }
        });
    }

    public String getJarFilePath() {
        String path = this.getClass().getResource("OmssaViewer.class").getPath();
        if (path.lastIndexOf("/omssa-parser-") != -1) {
            path = path.startsWith("file:") ? path.substring("file:".length(), path.lastIndexOf("/omssa-parser-")) : path.substring(0, path.lastIndexOf("/omssa-parser-"));
            path = path.replace("%20", " ");
            path = path.replace("%5b", "[");
            path = path.replace("%5d", "]");
        } else {
            path = ".";
        }
        return path;
    }

    private void setUpErrorLog() {
        if (useErrorLog && !this.getJarFilePath().equalsIgnoreCase(".")) {
            try {
                String path = this.getJarFilePath() + "/resources/conf/ErrorLog.txt";
                File file = new File(path);
                System.setOut(new PrintStream(new FileOutputStream(file, true)));
                System.setErr(new PrintStream(new FileOutputStream(file, true)));
                if (!file.exists()) {
                    file.createNewFile();
                    FileWriter w = new FileWriter(file);
                    BufferedWriter bw = new BufferedWriter(w);
                    bw.close();
                    w.close();
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occured when creating the ErrorLog.\n" + e.getMessage(), "Error Creating ErrorLog", 0);
                System.out.println("Error when creating ErrorLog: ");
                e.printStackTrace();
            }
        }
    }

    public OmssaViewer() {
        this.setUpErrorLog();
        this.initComponents();
        this.setMinimumSize(new Dimension(900, 600));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/de/proteinms/omxparser/icons/omssaviewer.GIF")));
        this.identificationsJTable.setDefaultRenderer(Float.class, new ScientificNumberTableCellRenderer());
        this.identificationsJTable.getColumn("Modified Sequence").setCellRenderer(new BlackWhiteTextColorRenderer());
        this.spectraJTable.getColumn("Identified").setCellRenderer((TableCellRenderer)new NimbusCheckBoxRenderer());
        this.spectraJScrollPane.getViewport().setOpaque(false);
        this.spectrumJScrollPane.getViewport().setOpaque(false);
        this.identificationsJScrollPane.getViewport().setOpaque(false);
        this.spectraJTable.setAutoCreateRowSorter(true);
        this.spectrumJTable.setAutoCreateRowSorter(true);
        this.identificationsJTable.setAutoCreateRowSorter(true);
        this.spectraJTable.getColumn(" ").setMaxWidth(45);
        this.spectraJTable.getColumn(" ").setMinWidth(45);
        this.spectraJTable.getColumn("m/z").setMaxWidth(65);
        this.spectraJTable.getColumn("m/z").setMinWidth(65);
        this.spectraJTable.getColumn("Charge").setMaxWidth(65);
        this.spectraJTable.getColumn("Charge").setMinWidth(65);
        this.spectraJTable.getColumn("Identified").setMaxWidth(80);
        this.spectraJTable.getColumn("Identified").setMinWidth(80);
        this.spectrumJTable.getColumn(" ").setMaxWidth(35);
        this.spectrumJTable.getColumn(" ").setMinWidth(35);
        this.identificationsJTable.getColumn(" ").setMaxWidth(45);
        this.identificationsJTable.getColumn(" ").setMinWidth(45);
        this.identificationsJTable.getColumn("Start").setMaxWidth(45);
        this.identificationsJTable.getColumn("Start").setMinWidth(45);
        this.identificationsJTable.getColumn("End").setMaxWidth(45);
        this.identificationsJTable.getColumn("End").setMinWidth(45);
        this.identificationsJTable.getColumn("Exp. Mass").setMaxWidth(75);
        this.identificationsJTable.getColumn("Exp. Mass").setMinWidth(75);
        this.identificationsJTable.getColumn("Theo. Mass").setMaxWidth(75);
        this.identificationsJTable.getColumn("Theo. Mass").setMinWidth(75);
        this.identificationsJTable.getColumn("E-value").setMinWidth(75);
        this.identificationsJTable.getColumn("E-value").setMaxWidth(75);
        this.identificationsJTable.getColumn("P-value").setMinWidth(75);
        this.identificationsJTable.getColumn("P-value").setMaxWidth(75);
        this.identificationsJTable.getColumn("Accession").setPreferredWidth(10);
        this.spectraJTable.getTableHeader().setReorderingAllowed(false);
        this.spectrumJTable.getTableHeader().setReorderingAllowed(false);
        this.identificationsJTable.getTableHeader().setReorderingAllowed(false);
        this.spectraJTableColumnToolTips = new Vector();
        this.spectraJTableColumnToolTips.add("Spectrum Number");
        this.spectraJTableColumnToolTips.add("Spectrum File Name");
        this.spectraJTableColumnToolTips.add("Precursor Mass Over Charge Ratio");
        this.spectraJTableColumnToolTips.add("Precursor Charge");
        this.spectraJTableColumnToolTips.add("Spectrum Identified");
        this.spectrumJTableColumnToolTips = new Vector();
        this.spectrumJTableColumnToolTips.add(null);
        this.spectrumJTableColumnToolTips.add("Mass Over Charge Ratio");
        this.spectrumJTableColumnToolTips.add("Abundance");
        this.identificationsJTableColumnToolTips = new Vector();
        this.identificationsJTableColumnToolTips.add("Spectrum Number");
        this.identificationsJTableColumnToolTips.add("Peptide Sequence");
        this.identificationsJTableColumnToolTips.add("Modified Peptide Sequence");
        this.identificationsJTableColumnToolTips.add("Peptide Start Index");
        this.identificationsJTableColumnToolTips.add("Peptide End Index");
        this.identificationsJTableColumnToolTips.add("Experimental Mass");
        this.identificationsJTableColumnToolTips.add("Theoretical Mass");
        this.identificationsJTableColumnToolTips.add("E-value");
        this.identificationsJTableColumnToolTips.add("P-value");
        this.identificationsJTableColumnToolTips.add("Protein Accession Number");
        this.identificationsJTableColumnToolTips.add("Protein Description");
        this.setLocationRelativeTo(null);
    }

    public OmssaViewer(String aOmxFile, String aModsFile, String aUserModsFile, String lastSelectedFolder) {
        this.setUpErrorLog();
        this.initComponents();
        this.setMinimumSize(new Dimension(900, 600));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/de/proteinms/omxparser/icons/omssaviewer.GIF")));
        this.identificationsJTable.setDefaultRenderer(Float.class, new ScientificNumberTableCellRenderer());
        this.spectraJTable.getColumn(" ").setMaxWidth(35);
        this.spectraJTable.getColumn(" ").setMinWidth(35);
        this.spectraJTable.getColumn("m/z").setMaxWidth(65);
        this.spectraJTable.getColumn("m/z").setMinWidth(65);
        this.spectraJTable.getColumn("Charge").setMaxWidth(65);
        this.spectraJTable.getColumn("Charge").setMinWidth(65);
        this.spectraJTable.getColumn("Identified").setMaxWidth(80);
        this.spectraJTable.getColumn("Identified").setMinWidth(80);
        this.spectrumJTable.getColumn(" ").setMaxWidth(35);
        this.spectrumJTable.getColumn(" ").setMinWidth(35);
        this.identificationsJTable.getColumn(" ").setMaxWidth(35);
        this.identificationsJTable.getColumn(" ").setMinWidth(35);
        this.identificationsJTable.getColumn("Start").setMaxWidth(45);
        this.identificationsJTable.getColumn("Start").setMinWidth(45);
        this.identificationsJTable.getColumn("End").setMaxWidth(45);
        this.identificationsJTable.getColumn("End").setMinWidth(45);
        this.identificationsJTable.getColumn("Exp. Mass").setMaxWidth(75);
        this.identificationsJTable.getColumn("Exp. Mass").setMinWidth(75);
        this.identificationsJTable.getColumn("Theo. Mass").setMaxWidth(75);
        this.identificationsJTable.getColumn("Theo. Mass").setMinWidth(75);
        this.identificationsJTable.getColumn("E-value").setMinWidth(75);
        this.identificationsJTable.getColumn("E-value").setMaxWidth(75);
        this.identificationsJTable.getColumn("P-value").setMinWidth(75);
        this.identificationsJTable.getColumn("P-value").setMaxWidth(75);
        this.identificationsJTable.getColumn("Accession").setPreferredWidth(10);
        this.spectraJTable.getTableHeader().setReorderingAllowed(false);
        this.spectrumJTable.getTableHeader().setReorderingAllowed(false);
        this.identificationsJTable.getTableHeader().setReorderingAllowed(false);
        this.spectraJTable.setAutoCreateRowSorter(true);
        this.spectrumJTable.setAutoCreateRowSorter(true);
        this.identificationsJTable.setAutoCreateRowSorter(true);
        this.spectraJTableColumnToolTips = new Vector();
        this.spectraJTableColumnToolTips.add("Spectrum Number");
        this.spectraJTableColumnToolTips.add("Spectrum File Name");
        this.spectraJTableColumnToolTips.add("Precursor Mass Over Charge Ratio");
        this.spectraJTableColumnToolTips.add("Precursor Charge");
        this.spectraJTableColumnToolTips.add("Spectrum Identified");
        this.spectrumJTableColumnToolTips = new Vector();
        this.spectrumJTableColumnToolTips.add(null);
        this.spectrumJTableColumnToolTips.add("Mass Over Charge Ratio");
        this.spectrumJTableColumnToolTips.add("Abundance");
        this.identificationsJTableColumnToolTips = new Vector();
        this.identificationsJTableColumnToolTips.add("Spectrum Number");
        this.identificationsJTableColumnToolTips.add("Peptide Sequence");
        this.identificationsJTableColumnToolTips.add("Modified Peptide Sequence");
        this.identificationsJTableColumnToolTips.add("Peptide Start Index");
        this.identificationsJTableColumnToolTips.add("Peptide End Index");
        this.identificationsJTableColumnToolTips.add("Experimental Mass");
        this.identificationsJTableColumnToolTips.add("Theoretical Mass");
        this.identificationsJTableColumnToolTips.add("E-value");
        this.identificationsJTableColumnToolTips.add("P-value");
        this.identificationsJTableColumnToolTips.add("Protein Accession Number");
        this.identificationsJTableColumnToolTips.add("Protein Description");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.insertOmxFile(aOmxFile, aModsFile, aUserModsFile, lastSelectedFolder);
    }

    public void insertOmxFile(String aOmxFile, String aModsFile, String aUserModsFile, String lastSelectedFolder) {
        this.setTitle("OMSSA Viewer " + new Properties().getVersion() + "  -  [" + new File(aOmxFile).getPath() + "]");
        this.lastSelectedFolder = lastSelectedFolder;
        this.omxFile = aOmxFile;
        this.modsFile = aModsFile;
        this.userModsFile = aUserModsFile;
        this.exportSelectedSpectrumJMenuItem.setEnabled(false);
        this.progressDialog = new ProgressDialog((Frame)this, true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                OmssaViewer.this.progressDialog.setTitle("Parsing OMX File. Please Wait...");
                OmssaViewer.this.progressDialog.setIntermidiate(true);
                OmssaViewer.this.progressDialog.setVisible(true);
            }
        }, "ProgressDialog");
        t.start();
        new Thread("ParserThread"){

            @Override
            public void run() {
                while (((DefaultTableModel)OmssaViewer.this.spectraJTable.getModel()).getRowCount() > 0) {
                    ((DefaultTableModel)OmssaViewer.this.spectraJTable.getModel()).removeRow(0);
                }
                while (((DefaultTableModel)OmssaViewer.this.spectrumJTable.getModel()).getRowCount() > 0) {
                    ((DefaultTableModel)OmssaViewer.this.spectrumJTable.getModel()).removeRow(0);
                }
                while (((DefaultTableModel)OmssaViewer.this.identificationsJTable.getModel()).getRowCount() > 0) {
                    ((DefaultTableModel)OmssaViewer.this.identificationsJTable.getModel()).removeRow(0);
                }
                OmssaViewer.this.legendJLabel.setText("");
                OmssaViewer.this.ptmsJTextField.setText("");
                while (OmssaViewer.this.spectrumJPanel.getComponents().length > 0) {
                    OmssaViewer.this.spectrumJPanel.remove(0);
                }
                OmssaViewer.this.spectrumJPanel.validate();
                OmssaViewer.this.spectrumJPanel.repaint();
                try {
                    OmssaViewer.this.omssaOmxFile = new OmssaOmxFile(OmssaViewer.this.omxFile, OmssaViewer.this.modsFile, OmssaViewer.this.userModsFile);
                }
                catch (OutOfMemoryError error) {
                    OmssaViewer.this.progressDialog.setVisible(false);
                    OmssaViewer.this.progressDialog.dispose();
                    Runtime.getRuntime().gc();
                    JOptionPane.showMessageDialog(null, "The task used up all the available memory and had to be stopped.\nMemory boundaries are set in ../Properties/JavaOptions.txt.", "Out Of Memory Error", 0);
                    Util.writeToErrorLog("OMSSA Viewer: Ran out of memory!");
                    error.printStackTrace();
                    System.exit(0);
                }
                OmssaViewer.this.ionCoverageErrorMargin = ((OmssaViewer)OmssaViewer.this).omssaOmxFile.getParserResult().MSSearch_request.MSRequest.get((int)0).MSRequest_settings.MSSearchSettings.MSSearchSettings_msmstol;
                OmssaViewer.this.omssaResponseScale = ((OmssaViewer)OmssaViewer.this).omssaOmxFile.getParserResult().MSSearch_response.MSResponse.get((int)0).MSResponse_scale;
                OmssaViewer.this.usedIonTypes = ((OmssaViewer)OmssaViewer.this).omssaOmxFile.getParserResult().MSSearch_request.MSRequest.get((int)0).MSRequest_settings.MSSearchSettings.MSSearchSettings_ionstosearch.MSIonType;
                OmssaViewer.this.spectrumHitSetMap = OmssaViewer.this.omssaOmxFile.getSpectrumToHitSetMap();
                Iterator iterator = OmssaViewer.this.spectrumHitSetMap.keySet().iterator();
                OmssaViewer.this.allMzValues = new HashMap();
                OmssaViewer.this.allAbundanceValues = new HashMap();
                OmssaViewer.this.spectra = new HashMap();
                while (iterator.hasNext()) {
                    MSSpectrum tempSpectrum = (MSSpectrum)iterator.next();
                    OmssaViewer.this.spectra.put(tempSpectrum.MSSpectrum_number, tempSpectrum);
                }
                Object[] keys = OmssaViewer.this.spectra.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < keys.length; ++i) {
                    MSSpectrum tempSpectrum = (MSSpectrum)OmssaViewer.this.spectra.get((Integer)keys[i]);
                    String fileName = tempSpectrum.MSSpectrum_ids.MSSpectrum_ids_E.isEmpty() ? "" + tempSpectrum.MSSpectrum_number : tempSpectrum.MSSpectrum_ids.MSSpectrum_ids_E.get(0);
                    String chargeString = "0";
                    if (tempSpectrum.MSSpectrum_charge.MSSpectrum_charge_E.size() == 1) {
                        chargeString = "" + tempSpectrum.MSSpectrum_charge.MSSpectrum_charge_E.get(0);
                    }
                    chargeString = chargeString.replaceFirst("\\+", "");
                    double omssaAbundanceScale = tempSpectrum.MSSpectrum_iscale;
                    ArrayList<Double> currentRealMzValues = new ArrayList<Double>();
                    ArrayList<Double> currentRealAbundanceValues = new ArrayList<Double>();
                    List<Integer> currentMzValuesAsIntegers = tempSpectrum.MSSpectrum_mz.MSSpectrum_mz_E;
                    List<Integer> currentAbundanceValuesAsIntegers = tempSpectrum.MSSpectrum_abundance.MSSpectrum_abundance_E;
                    for (int j = 0; j < currentMzValuesAsIntegers.size(); ++j) {
                        currentRealMzValues.add(currentMzValuesAsIntegers.get(j).doubleValue() / (double)OmssaViewer.this.omssaResponseScale);
                        currentRealAbundanceValues.add(currentAbundanceValuesAsIntegers.get(j).doubleValue() / omssaAbundanceScale);
                    }
                    OmssaViewer.this.allMzValues.put(tempSpectrum.MSSpectrum_number, currentRealMzValues);
                    OmssaViewer.this.allAbundanceValues.put(tempSpectrum.MSSpectrum_number, currentRealAbundanceValues);
                    boolean identified = false;
                    MSHitSet msHitSet = (MSHitSet)OmssaViewer.this.spectrumHitSetMap.get(tempSpectrum);
                    List<MSHits> allMSHits = msHitSet.MSHitSet_hits.MSHits;
                    if (allMSHits.size() > 0) {
                        identified = true;
                    }
                    ((DefaultTableModel)OmssaViewer.this.spectraJTable.getModel()).addRow(new Object[]{tempSpectrum.MSSpectrum_number, fileName, (double)tempSpectrum.MSSpectrum_precursormz / (double)OmssaViewer.this.omssaResponseScale, Integer.valueOf(chargeString), identified});
                }
                if (OmssaViewer.this.spectraJTable.getRowCount() > 0) {
                    OmssaViewer.this.spectraJTable.setRowSelectionInterval(0, 0);
                    OmssaViewer.this.spectraJTableMouseClicked(null);
                }
                OmssaViewer.this.progressDialog.setVisible(false);
                OmssaViewer.this.progressDialog.dispose();
            }
        }.start();
    }

    private void initComponents() {
        this.copySpectraJPopupMenu = new JPopupMenu();
        this.copySpectraJMenuItem = new JMenuItem();
        this.copySpectrumJPopupMenu = new JPopupMenu();
        this.copySpectrumJMenuItem = new JMenuItem();
        this.copyIdentificationsJPopupMenu = new JPopupMenu();
        this.copyIdentificationsJMenuItem = new JMenuItem();
        this.accesionDetailsButtonGroup = new ButtonGroup();
        this.backgroundPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.spectraJScrollPane = new JScrollPane();
        this.spectraJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)OmssaViewer.this.spectraJTableColumnToolTips.get(realIndex);
                    }
                };
            }
        };
        this.jPanel2 = new JPanel();
        this.legendJLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.identificationsJScrollPane = new JScrollPane();
        this.identificationsJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)OmssaViewer.this.identificationsJTableColumnToolTips.get(realIndex);
                    }
                };
            }
        };
        this.jLabel2 = new JLabel();
        this.ptmsJTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.spectrumJPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.aIonsJCheckBox = new JCheckBox();
        this.bIonsJCheckBox = new JCheckBox();
        this.cIonsJCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.yIonsJCheckBox = new JCheckBox();
        this.xIonsJCheckBox = new JCheckBox();
        this.zIonsJCheckBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.chargeOneJCheckBox = new JCheckBox();
        this.chargeTwoJCheckBox = new JCheckBox();
        this.chargeOverTwoJCheckBox = new JCheckBox();
        this.spectrumJScrollPane = new JScrollPane();
        this.spectrumJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)OmssaViewer.this.spectrumJTableColumnToolTips.get(realIndex);
                    }
                };
            }
        };
        this.jMenuBar1 = new JMenuBar();
        this.fileJMenu = new JMenu();
        this.openJMenuItem = new JMenuItem();
        this.exitJMenuItem = new JMenuItem();
        this.exportJMenu = new JMenu();
        this.exportSpectraFilesTableJMenuItem = new JMenuItem();
        this.exportAllIdentificationsJMenuItem = new JMenuItem();
        this.exportBestIdentificationsJMenuItem = new JMenuItem();
        this.exportSelectedSpectrumJMenuItem = new JMenuItem();
        this.exportAllSpectraJMenuItem = new JMenuItem();
        this.helpJMenu = new JMenu();
        this.helpJMenuItem = new JMenuItem();
        this.aboutJMenuItem = new JMenuItem();
        this.copySpectraJMenuItem.setMnemonic('C');
        this.copySpectraJMenuItem.setText("Copy");
        this.copySpectraJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.copySpectraJMenuItemActionPerformed(evt);
            }
        });
        this.copySpectraJPopupMenu.add(this.copySpectraJMenuItem);
        this.copySpectrumJMenuItem.setMnemonic('C');
        this.copySpectrumJMenuItem.setText("Copy");
        this.copySpectrumJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.copySpectrumJMenuItemActionPerformed(evt);
            }
        });
        this.copySpectrumJPopupMenu.add(this.copySpectrumJMenuItem);
        this.copyIdentificationsJMenuItem.setMnemonic('C');
        this.copyIdentificationsJMenuItem.setText("Copy");
        this.copyIdentificationsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.copyIdentificationsJMenuItemActionPerformed(evt);
            }
        });
        this.copyIdentificationsJPopupMenu.add(this.copyIdentificationsJMenuItem);
        this.setDefaultCloseOperation(3);
        this.setTitle("OMSSA Viewer v1.0");
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Spectrum Files"));
        this.jPanel1.setOpaque(false);
        this.spectraJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Filename", "m/z", "Charge", "Identified"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Double.class, Integer.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.spectraJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OmssaViewer.this.spectraJTableMouseClicked(evt);
            }
        });
        this.spectraJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaViewer.this.spectraJTableKeyReleased(evt);
            }
        });
        this.spectraJScrollPane.setViewportView(this.spectraJTable);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.spectraJScrollPane, -1, 535, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.spectraJScrollPane).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Identifications"));
        this.jPanel2.setOpaque(false);
        this.legendJLabel.setFont(this.legendJLabel.getFont().deriveFont(this.legendJLabel.getFont().getStyle() | 2));
        this.legendJLabel.setText("-");
        this.jLabel1.setFont(this.jLabel1.getFont().deriveFont(this.jLabel1.getFont().getStyle() | 2));
        this.jLabel1.setText("Legend:   ");
        this.identificationsJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Sequence", "Modified Sequence", "Start", "End", "Exp. Mass", "Theo. Mass", "E-value", "P-value", "Accession", "Description"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, Integer.class, Integer.class, Double.class, Double.class, Float.class, Float.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.identificationsJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OmssaViewer.this.identificationsJTableMouseClicked(evt);
            }
        });
        this.identificationsJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OmssaViewer.this.identificationsJTableKeyReleased(evt);
            }
        });
        this.identificationsJScrollPane.setViewportView(this.identificationsJTable);
        this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 2));
        this.jLabel2.setText("PTMs:");
        this.ptmsJTextField.setEditable(false);
        this.ptmsJTextField.setHorizontalAlignment(2);
        this.ptmsJTextField.setBorder(null);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.identificationsJScrollPane).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.legendJLabel).add(0, 0, Short.MAX_VALUE)).add((Component)this.ptmsJTextField)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.identificationsJScrollPane, -2, 95, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.legendJLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.ptmsJTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Selected Spectrum"));
        this.jPanel3.setOpaque(false);
        this.spectrumJPanel.setOpaque(false);
        this.spectrumJPanel.setLayout(new BoxLayout(this.spectrumJPanel, 2));
        this.jPanel4.setOpaque(false);
        this.aIonsJCheckBox.setSelected(true);
        this.aIonsJCheckBox.setText("a");
        this.aIonsJCheckBox.setToolTipText("Show a-ions");
        this.aIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.aIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.aIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.aIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.aIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.bIonsJCheckBox.setSelected(true);
        this.bIonsJCheckBox.setText("b");
        this.bIonsJCheckBox.setToolTipText("Show b-ions");
        this.bIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.bIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.bIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.bIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.bIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.cIonsJCheckBox.setSelected(true);
        this.cIonsJCheckBox.setText("c");
        this.cIonsJCheckBox.setToolTipText("Show c-ions");
        this.cIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.cIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.cIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.cIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.cIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.yIonsJCheckBox.setSelected(true);
        this.yIonsJCheckBox.setText("y");
        this.yIonsJCheckBox.setToolTipText("Show y-ions");
        this.yIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.yIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.yIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.yIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.yIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.xIonsJCheckBox.setSelected(true);
        this.xIonsJCheckBox.setText("x");
        this.xIonsJCheckBox.setToolTipText("Show x-ions");
        this.xIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.xIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.xIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.xIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.xIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.zIonsJCheckBox.setSelected(true);
        this.zIonsJCheckBox.setText("z");
        this.zIonsJCheckBox.setToolTipText("Show z-ions");
        this.zIonsJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.zIonsJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.zIonsJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.zIonsJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.zIonsJCheckBoxActionPerformed(evt);
            }
        });
        this.chargeOneJCheckBox.setSelected(true);
        this.chargeOneJCheckBox.setText("+");
        this.chargeOneJCheckBox.setToolTipText("Show ions with charge 1");
        this.chargeOneJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.chargeOneJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.chargeOneJCheckBoxActionPerformed(evt);
            }
        });
        this.chargeTwoJCheckBox.setSelected(true);
        this.chargeTwoJCheckBox.setText("++");
        this.chargeTwoJCheckBox.setToolTipText("Show ions with charge 2");
        this.chargeTwoJCheckBox.setMaximumSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.setMinimumSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.setPreferredSize(new Dimension(39, 23));
        this.chargeTwoJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.chargeTwoJCheckBoxActionPerformed(evt);
            }
        });
        this.chargeOverTwoJCheckBox.setSelected(true);
        this.chargeOverTwoJCheckBox.setText(">2");
        this.chargeOverTwoJCheckBox.setToolTipText("Show ions with charge >2");
        this.chargeOverTwoJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.chargeOverTwoJCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.chargeOverTwoJCheckBox, -1, 44, Short.MAX_VALUE).add((Component)this.yIonsJCheckBox, -1, -1, Short.MAX_VALUE).add(2, (Component)this.zIonsJCheckBox, -1, -1, Short.MAX_VALUE).add((Component)this.xIonsJCheckBox, -1, -1, Short.MAX_VALUE).add((Component)this.bIonsJCheckBox, -1, -1, Short.MAX_VALUE).add((Component)this.aIonsJCheckBox, -1, -1, Short.MAX_VALUE).add((Component)this.cIonsJCheckBox, -1, -1, Short.MAX_VALUE).add((Component)this.chargeOneJCheckBox, -1, -1, Short.MAX_VALUE).add(2, (Component)this.chargeTwoJCheckBox, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jSeparator2).add((Component)this.jSeparator1)).addContainerGap()))));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.aIonsJCheckBox, -2, 23, -2).addPreferredGap(0).add((Component)this.bIonsJCheckBox, -2, 24, -2).addPreferredGap(0).add((Component)this.cIonsJCheckBox, -2, 24, -2).addPreferredGap(1).add((Component)this.jSeparator1, -2, -1, -2).add(13, 13, 13).add((Component)this.xIonsJCheckBox, -2, 24, -2).addPreferredGap(0).add((Component)this.yIonsJCheckBox, -2, 24, -2).addPreferredGap(0).add((Component)this.zIonsJCheckBox, -2, 23, -2).add(12, 12, 12).add((Component)this.jSeparator2, -2, 8, -2).addPreferredGap(0).add((Component)this.chargeOneJCheckBox, -2, 23, -2).addPreferredGap(0).add((Component)this.chargeTwoJCheckBox, -2, 23, -2).addPreferredGap(0).add((Component)this.chargeOverTwoJCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.spectrumJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "m/z", "Abundance"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Integer.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.spectrumJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OmssaViewer.this.spectrumJTableMouseClicked(evt);
            }
        });
        this.spectrumJScrollPane.setViewportView(this.spectrumJTable);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.spectrumJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2)).add((Component)this.spectrumJScrollPane, -1, 535, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jPanel4, -2, -1, -2).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.spectrumJPanel, -1, -1, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.spectrumJScrollPane, -2, 175, -2).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout((Container)this.backgroundPanel);
        this.backgroundPanel.setLayout((LayoutManager)backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE)).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((GroupLayout.Group)backgroundPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)backgroundPanelLayout.createParallelGroup(1).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).add(6, 6, 6)));
        this.fileJMenu.setMnemonic('F');
        this.fileJMenu.setText("File");
        this.openJMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 3));
        this.openJMenuItem.setMnemonic('O');
        this.openJMenuItem.setText("Open");
        this.openJMenuItem.setToolTipText("Open a New OMX File");
        this.openJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.openJMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.openJMenuItem);
        this.exitJMenuItem.setMnemonic('x');
        this.exitJMenuItem.setText("Exit");
        this.exitJMenuItem.setToolTipText("Exit OMSSA Viewer");
        this.exitJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.exitJMenuItemActionPerformed(evt);
            }
        });
        this.fileJMenu.add(this.exitJMenuItem);
        this.jMenuBar1.add(this.fileJMenu);
        this.exportJMenu.setMnemonic('E');
        this.exportJMenu.setText("Export");
        this.exportSpectraFilesTableJMenuItem.setMnemonic('P');
        this.exportSpectraFilesTableJMenuItem.setText("Spectra Files Table");
        this.exportSpectraFilesTableJMenuItem.setToolTipText("Export the Spectra Files Table as Tab Delimited Text File");
        this.exportSpectraFilesTableJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.exportSpectraFilesTableJMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.exportSpectraFilesTableJMenuItem);
        this.exportAllIdentificationsJMenuItem.setMnemonic('I');
        this.exportAllIdentificationsJMenuItem.setText("All Identifications (all hits)");
        this.exportAllIdentificationsJMenuItem.setToolTipText("Export All Identifications (all hits) as Tab Delimited Text File");
        this.exportAllIdentificationsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.exportAllIdentificationsJMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.exportAllIdentificationsJMenuItem);
        this.exportBestIdentificationsJMenuItem.setMnemonic('I');
        this.exportBestIdentificationsJMenuItem.setText("All Identifications (best hits only)");
        this.exportBestIdentificationsJMenuItem.setToolTipText("Export All Identifications (best hits only) as Tab Delimited Text File");
        this.exportBestIdentificationsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.exportBestIdentificationsJMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.exportBestIdentificationsJMenuItem);
        this.exportSelectedSpectrumJMenuItem.setMnemonic('S');
        this.exportSelectedSpectrumJMenuItem.setText("Selected Spectrum");
        this.exportSelectedSpectrumJMenuItem.setToolTipText("Export the Selected Spectrum as Tab Delimited Text File");
        this.exportSelectedSpectrumJMenuItem.setEnabled(false);
        this.exportSelectedSpectrumJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.exportSelectedSpectrumJMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.exportSelectedSpectrumJMenuItem);
        this.exportAllSpectraJMenuItem.setMnemonic('S');
        this.exportAllSpectraJMenuItem.setText("All Spectra");
        this.exportAllSpectraJMenuItem.setToolTipText("Export all the Spectra as DTA Files");
        this.exportAllSpectraJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.exportAllSpectraJMenuItemActionPerformed(evt);
            }
        });
        this.exportJMenu.add(this.exportAllSpectraJMenuItem);
        this.jMenuBar1.add(this.exportJMenu);
        this.helpJMenu.setMnemonic('H');
        this.helpJMenu.setText("Help");
        this.helpJMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpJMenuItem.setMnemonic('H');
        this.helpJMenuItem.setText("Help");
        this.helpJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.helpJMenuItemActionPerformed(evt);
            }
        });
        this.helpJMenu.add(this.helpJMenuItem);
        this.aboutJMenuItem.setMnemonic('a');
        this.aboutJMenuItem.setText("About");
        this.aboutJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewer.this.aboutJMenuItemActionPerformed(evt);
            }
        });
        this.helpJMenu.add(this.aboutJMenuItem);
        this.jMenuBar1.add(this.helpJMenu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void exitJMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void copySpectraJMenuItemActionPerformed(ActionEvent evt) {
        TransferHandler th = this.spectraJTable.getTransferHandler();
        if (th != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            th.exportToClipboard(this.spectraJTable, cb, 1);
        }
    }

    private void copySpectrumJMenuItemActionPerformed(ActionEvent evt) {
        TransferHandler th = this.spectrumJTable.getTransferHandler();
        if (th != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            th.exportToClipboard(this.spectrumJTable, cb, 1);
        }
    }

    private void copyIdentificationsJMenuItemActionPerformed(ActionEvent evt) {
        TransferHandler th = this.identificationsJTable.getTransferHandler();
        if (th != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            th.exportToClipboard(this.identificationsJTable, cb, 1);
        }
    }

    private Vector<SpectrumAnnotation> filterAnnotations(Vector<SpectrumAnnotation> annotations) {
        Vector<SpectrumAnnotation> filteredAnnotations = new Vector<SpectrumAnnotation>();
        for (int i = 0; i < annotations.size(); ++i) {
            String currentLabel = annotations.get(i).getLabel();
            boolean useAnnotation = true;
            if (currentLabel.lastIndexOf("a") != -1) {
                if (!this.aIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("b") != -1) {
                if (!this.bIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("c") != -1) {
                if (!this.cIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("x") != -1) {
                if (!this.xIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("y") != -1) {
                if (!this.yIonsJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            } else if (currentLabel.lastIndexOf("z") != -1 && !this.zIonsJCheckBox.isSelected()) {
                useAnnotation = false;
            }
            if (useAnnotation) {
                if (currentLabel.lastIndexOf("+") == -1) {
                    if (!this.chargeOneJCheckBox.isSelected()) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("+++") != -1) {
                    if (!this.chargeOverTwoJCheckBox.isSelected()) {
                        useAnnotation = false;
                    }
                } else if (currentLabel.lastIndexOf("++") != -1 && !this.chargeTwoJCheckBox.isSelected()) {
                    useAnnotation = false;
                }
            }
            if (!useAnnotation) continue;
            filteredAnnotations.add(annotations.get(i));
        }
        return filteredAnnotations;
    }

    private void openJMenuItemActionPerformed(ActionEvent evt) {
        new OmssaViewerFileSelection(this, false, this.omxFile, this.modsFile, this.userModsFile, this.lastSelectedFolder);
    }

    private void exportSpectraFilesTableJMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setFileFilter(new TxtFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export Spectra File Details");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(this, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(this.lastSelectedFolder);
                chooser.setFileFilter(new TxtFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export Spectra File Details");
                returnVal = chooser.showSaveDialog(this);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".txt")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            this.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                FileWriter f = new FileWriter(selectedFile);
                for (int j = 0; j < this.spectraJTable.getColumnCount() - 1; ++j) {
                    f.write(this.spectraJTable.getColumnName(j) + "\t");
                }
                f.write(this.spectraJTable.getColumnName(this.spectraJTable.getColumnCount() - 1) + "\n");
                for (int i = 0; i < this.spectraJTable.getRowCount(); ++i) {
                    for (int j = 0; j < this.spectraJTable.getColumnCount() - 1; ++j) {
                        f.write(this.spectraJTable.getValueAt(i, j) + "\t");
                    }
                    f.write(this.spectraJTable.getValueAt(i, this.spectraJTable.getColumnCount() - 1) + "\n");
                }
                f.close();
                this.lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "An error occured when exporting the spectra file details.\nSee ../resources/conf/ErrorLog.txt for more details.", "Error Exporting Spectra Files", 0);
                Util.writeToErrorLog("Error when exporting spectra file details: ");
                ex.printStackTrace();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void exportSelectedSpectrumJMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setFileFilter(new TxtFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export Selected Spectrum");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(this, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(this.lastSelectedFolder);
                chooser.setFileFilter(new TxtFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export Selected Spectrum");
                returnVal = chooser.showSaveDialog(this);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".txt")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            this.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                FileWriter f = new FileWriter(selectedFile);
                for (int j = 0; j < this.spectrumJTable.getColumnCount() - 1; ++j) {
                    f.write(this.spectrumJTable.getColumnName(j) + "\t");
                }
                f.write(this.spectrumJTable.getColumnName(this.spectrumJTable.getColumnCount() - 1) + "\n");
                for (int i = 0; i < this.spectrumJTable.getRowCount(); ++i) {
                    for (int j = 0; j < this.spectrumJTable.getColumnCount() - 1; ++j) {
                        f.write(this.spectrumJTable.getValueAt(i, j) + "\t");
                    }
                    f.write(this.spectrumJTable.getValueAt(i, this.spectrumJTable.getColumnCount() - 1) + "\n");
                }
                f.close();
                this.lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "An error occured when exporting the selected spectrum.\nSee ../resources/conf/ErrorLog.txt for more details.", "Error Exporting Selected Spectrum", 0);
                Util.writeToErrorLog("Error when exporting selected spectrum: ");
                ex.printStackTrace();
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void exportAllIdentificationsJMenuItemActionPerformed(ActionEvent evt) {
        this.exportAllIdentifications(false);
    }

    private void exportAllIdentifications(boolean includeBestHitOnly) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setFileFilter(new TxtFileFilter());
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Export All Identifications");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            int option;
            File selectedFile = chooser.getSelectedFile();
            if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            while (selectedFile.exists() && (option = JOptionPane.showConfirmDialog(this, "The  file " + chooser.getSelectedFile().getName() + " already exists. Replace file?", "Replace File?", 1)) == 1) {
                chooser = new JFileChooser(this.lastSelectedFolder);
                chooser.setFileFilter(new TxtFileFilter());
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle("Export All Identifications");
                returnVal = chooser.showSaveDialog(this);
                if (returnVal == 1) {
                    return;
                }
                selectedFile = chooser.getSelectedFile();
                if (selectedFile.getName().toLowerCase().endsWith(".txt")) continue;
                selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
            }
            this.setCursor(new Cursor(3));
            try {
                selectedFile = chooser.getSelectedFile();
                if (!selectedFile.getName().toLowerCase().endsWith(".txt")) {
                    selectedFile = new File(selectedFile.getAbsolutePath() + ".txt");
                }
                if (selectedFile.exists()) {
                    selectedFile.delete();
                }
                selectedFile.createNewFile();
                FileWriter f = new FileWriter(selectedFile);
                for (int j = 0; j < this.identificationsJTable.getColumnCount() - 1; ++j) {
                    if (j == 0) {
                        f.write("Spectrum number\t");
                        f.write("Spectrum name\t");
                        continue;
                    }
                    if (j == 2) {
                        f.write("Modified Sequence\t");
                        f.write("Ion Coverage\t");
                        continue;
                    }
                    f.write(this.identificationsJTable.getColumnName(j) + "\t");
                }
                f.write(this.identificationsJTable.getColumnName(this.identificationsJTable.getColumnCount() - 1) + "\n");
                List<Integer> fixedModifications = this.omssaOmxFile.getParserResult().MSSearch_request.MSRequest.get((int)0).MSRequest_settings.MSSearchSettings.MSSearchSettings_fixed.MSMod;
                Iterator<MSSpectrum> iterator = this.spectrumHitSetMap.keySet().iterator();
                while (iterator.hasNext()) {
                    boolean allWantedHitsAdded = false;
                    MSHitSet msHitSet = this.spectrumHitSetMap.get(iterator.next());
                    List<MSHits> allMSHits = msHitSet.MSHitSet_hits.MSHits;
                    Iterator<MSHits> msHitIterator = allMSHits.iterator();
                    while (msHitIterator.hasNext() && !allWantedHitsAdded) {
                        MSHits tempMSHit = msHitIterator.next();
                        String sequence = tempMSHit.MSHits_pepstring;
                        String[] modifications = new String[sequence.length()];
                        for (int i = 0; i < modifications.length; ++i) {
                            modifications[i] = "";
                        }
                        String modifiedSequence = "";
                        String nTerminal = "";
                        String cTerminal = "";
                        if (this.omssaOmxFile.getModifications().size() > 0) {
                            if (fixedModifications.size() > 0) {
                                for (int i = 0; i < fixedModifications.size(); ++i) {
                                    Vector<String> modifiedResidues = this.omssaOmxFile.getModifications().get(fixedModifications.get(i)).getModResidues();
                                    for (int j = 0; j < modifiedResidues.size(); ++j) {
                                        int index = sequence.indexOf(modifiedResidues.get(j));
                                        while (index != -1) {
                                            int n = index;
                                            modifications[n] = modifications[n] + "<" + this.omssaOmxFile.getModifications().get(fixedModifications.get(i)).getModNumber() + ">";
                                            index = sequence.indexOf(modifiedResidues.get(j), index + 1);
                                        }
                                    }
                                }
                            }
                            for (MSModHit currentMSModHit : tempMSHit.MSHits_mods.MSModHit) {
                                int n = currentMSModHit.MSModHit_site;
                                modifications[n] = modifications[n] + "<" + currentMSModHit.MSModHit_modtype.MSMod + ">";
                            }
                            for (int i = 0; i < modifications.length; ++i) {
                                modifiedSequence = modifiedSequence + sequence.substring(i, i + 1);
                                if (modifications[i].equalsIgnoreCase("")) continue;
                                String[] residueMods = modifications[i].split(">");
                                for (int j = 0; j < residueMods.length; ++j) {
                                    String currentMod = residueMods[j] + ">";
                                    OmssaModification tempOmssaModification = this.omssaOmxFile.getModifications().get(Integer.valueOf(residueMods[j].substring(1)));
                                    if (tempOmssaModification != null) {
                                        if (tempOmssaModification.getModType() == 0) {
                                            modifiedSequence = modifiedSequence + currentMod;
                                            continue;
                                        }
                                        if (tempOmssaModification.getModType() == 1 || tempOmssaModification.getModType() == 2 || tempOmssaModification.getModType() == 5 || tempOmssaModification.getModType() == 6) {
                                            nTerminal = nTerminal + currentMod;
                                            continue;
                                        }
                                        if (tempOmssaModification.getModType() != 3 && tempOmssaModification.getModType() != 4 && tempOmssaModification.getModType() != 7 && tempOmssaModification.getModType() != 8) continue;
                                        cTerminal = cTerminal + currentMod;
                                        continue;
                                    }
                                    modifiedSequence = modifiedSequence + currentMod;
                                }
                            }
                        } else {
                            modifiedSequence = sequence;
                        }
                        nTerminal = nTerminal.length() == 0 ? "NH2-" : nTerminal + "-";
                        cTerminal = cTerminal.length() == 0 ? "-COOH" : "-" + cTerminal;
                        Iterator<MSMZHit> mzHits = tempMSHit.MSHits_mzhits.MSMZHit.iterator();
                        int[][] ionCoverage = new int[sequence.length()][2];
                        while (mzHits.hasNext()) {
                            MSMZHit tempMzHit = mzHits.next();
                            int ionType = tempMzHit.MSMZHit_ion.MSIonType;
                            int ionNumber = tempMzHit.MSMZHit_number;
                            if (ionType == 0) continue;
                            if (ionType == 1) {
                                int[] nArray = ionCoverage[ionNumber];
                                nArray[0] = nArray[0] + 1;
                                continue;
                            }
                            if (ionType == 5 || ionType == 3) continue;
                            if (ionType == 4) {
                                int[] nArray = ionCoverage[ionNumber];
                                nArray[1] = nArray[1] + 1;
                                continue;
                            }
                            if (ionType != 5) continue;
                        }
                        int[][] ionCoverageProcessed = new int[sequence.length()][2];
                        for (int i = 1; i < ionCoverage.length; ++i) {
                            ionCoverageProcessed[i][0] = ionCoverage[i][0] > 0 && ionCoverage[i - 1][0] > 0 ? 1 : 0;
                            ionCoverageProcessed[ionCoverage.length - 1 - i][1] = ionCoverage[i][1] > 0 && ionCoverage[i - 1][1] > 0 ? 1 : 0;
                        }
                        String modifiedSequenceColorCoded = "<html>";
                        if (!nTerminal.startsWith("<")) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal;
                        } else {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal.substring(1, nTerminal.length() - 2);
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;-";
                        }
                        int aminoAcidCounter = 0;
                        for (int i = 0; i < modifiedSequence.length(); ++i) {
                            if (modifiedSequence.charAt(i) == '<') {
                                if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                                }
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                                ++i;
                                while (modifiedSequence.charAt(i) != '>') {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i++);
                                }
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                                if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                                }
                            } else {
                                if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                                }
                                modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i);
                                if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                                }
                                if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                                }
                                ++aminoAcidCounter;
                            }
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"black\">";
                        }
                        if (!cTerminal.startsWith("-<")) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal;
                        } else {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "-&lt;";
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal.substring(2, cTerminal.length() - 1);
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                        }
                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</html>";
                        modifiedSequence = nTerminal + modifiedSequence + cTerminal;
                        List<MSPepHit> pepHits = tempMSHit.MSHits_pephits.MSPepHit;
                        Iterator<MSPepHit> pepHitIterator = pepHits.iterator();
                        while (pepHitIterator.hasNext() && !allWantedHitsAdded) {
                            MSPepHit tempPepHit = pepHitIterator.next();
                            MSSpectrum tempSpectrum = this.spectra.get(msHitSet.MSHitSet_number);
                            String filename = "[no filename specified]";
                            if (!tempSpectrum.MSSpectrum_ids.MSSpectrum_ids_E.isEmpty()) {
                                filename = tempSpectrum.MSSpectrum_ids.MSSpectrum_ids_E.get(0);
                            }
                            f.write(msHitSet.MSHitSet_number + "\t" + filename + "\t" + sequence + "\t" + modifiedSequence + "\t" + modifiedSequenceColorCoded + "\t" + tempPepHit.MSPepHit_start + "\t" + tempPepHit.MSPepHit_stop + "\t" + Double.valueOf((double)tempMSHit.MSHits_mass / (double)this.omssaResponseScale) + "\t" + Double.valueOf((double)tempMSHit.MSHits_theomass / (double)this.omssaResponseScale) + "\t" + tempMSHit.MSHits_evalue + "\t" + tempMSHit.MSHits_pvalue + "\t" + tempPepHit.MSPepHit_accession + "\t" + tempPepHit.MSPepHit_defline + "\n");
                            if (!includeBestHitOnly) continue;
                            allWantedHitsAdded = true;
                        }
                        if (!includeBestHitOnly) continue;
                        allWantedHitsAdded = true;
                    }
                }
                f.close();
                this.lastSelectedFolder = selectedFile.getPath();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "An error occured when exporting the identifications.\nSee ../resources/conf/ErrorLog.txt for more details.", "Error Exporting Identifications", 0);
                Util.writeToErrorLog("Error when exporting identifications: ");
                ex.printStackTrace();
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void helpJMenuItemActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpWindow(this, this.getClass().getResource("/de/proteinms/omxparser/helpfiles/OmssaViewer.html"));
        this.setCursor(new Cursor(0));
    }

    private void aboutJMenuItemActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpWindow(this, this.getClass().getResource("/de/proteinms/omxparser/helpfiles/AboutOmssaViewer.html"));
        this.setCursor(new Cursor(0));
    }

    private void exportAllSpectraJMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.lastSelectedFolder);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Export All Spectra As DTA Files");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.setCursor(new Cursor(3));
            File selectedFolder = chooser.getSelectedFile();
            for (int j = 0; j < this.spectraJTable.getRowCount(); ++j) {
                List mzValues = this.allMzValues.get((Integer)this.spectraJTable.getValueAt(j, 0));
                List abundanceValues = this.allAbundanceValues.get((Integer)this.spectraJTable.getValueAt(j, 0));
                File currentFile = new File(selectedFolder, "" + this.spectraJTable.getValueAt(j, 1));
                try {
                    FileWriter f = new FileWriter(currentFile);
                    double precusorMz = (Double)this.spectraJTable.getValueAt(j, 2);
                    int precursorCharge = (Integer)this.spectraJTable.getValueAt(j, 3);
                    double precursorMh = precusorMz * (double)precursorCharge - (double)precursorCharge * 1.00794 + 1.00794;
                    f.write("" + precursorMh);
                    f.write(" " + precursorCharge + "\n");
                    for (int i = 0; i < mzValues.size(); ++i) {
                        f.write(mzValues.get(i) + " " + abundanceValues.get(i) + "\n");
                    }
                    f.close();
                    this.lastSelectedFolder = currentFile.getPath();
                    continue;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, "An error occured when exporting the spectra.\nSee ../resources/conf/ErrorLog.txt for more details.", "Error Exporting Spectra", 0);
                    Util.writeToErrorLog("Error when exporting spectra: ");
                    ex.printStackTrace();
                }
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void aIonsJCheckBoxActionPerformed(ActionEvent evt) {
        if (this.identificationsJTable.getRowCount() > 0) {
            int selectedRow = 0;
            if (this.identificationsJTable.getRowCount() > 1 && this.identificationsJTable.getSelectedRow() != -1) {
                selectedRow = this.identificationsJTable.getSelectedRow();
            }
            Vector<SpectrumAnnotation> currentAnnotations = this.allAnnotations.get(this.identificationsJTable.getValueAt(selectedRow, 1) + "_" + this.identificationsJTable.getValueAt(selectedRow, 8));
            this.spectrumPanel.setAnnotations(this.filterAnnotations(currentAnnotations));
            this.spectrumPanel.validate();
            this.spectrumPanel.repaint();
        }
    }

    private void bIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void cIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void xIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void yIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void zIonsJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeOneJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeTwoJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void chargeOverTwoJCheckBoxActionPerformed(ActionEvent evt) {
        this.aIonsJCheckBoxActionPerformed(null);
    }

    private void exportBestIdentificationsJMenuItemActionPerformed(ActionEvent evt) {
        this.exportAllIdentifications(true);
    }

    private void spectraJTableKeyReleased(KeyEvent evt) {
        this.spectraJTableMouseClicked(null);
    }

    private void spectraJTableMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        int row = this.spectraJTable.getSelectedRow();
        if (row != -1) {
            List mzValues = this.allMzValues.get((Integer)this.spectraJTable.getValueAt(row, 0));
            List abundanceValues = this.allAbundanceValues.get((Integer)this.spectraJTable.getValueAt(row, 0));
            while (this.spectrumJTable.getRowCount() > 0) {
                ((DefaultTableModel)this.spectrumJTable.getModel()).removeRow(0);
            }
            this.spectrumJTable.scrollRectToVisible(this.spectrumJTable.getCellRect(0, 0, false));
            while (this.spectrumJPanel.getComponents().length > 0) {
                this.spectrumJPanel.remove(0);
            }
            double[] mzValuesAsDouble = new double[mzValues.size()];
            double[] abundanceValuesAsDouble = new double[mzValues.size()];
            for (int i = 0; i < mzValues.size(); ++i) {
                ((DefaultTableModel)this.spectrumJTable.getModel()).addRow(new Object[]{i + 1, mzValues.get(i), abundanceValues.get(i)});
                mzValuesAsDouble[i] = (Double)mzValues.get(i);
                abundanceValuesAsDouble[i] = (Double)abundanceValues.get(i);
            }
            this.exportSelectedSpectrumJMenuItem.setEnabled(true);
            this.spectrumPanel = new SpectrumPanel(mzValuesAsDouble, abundanceValuesAsDouble, ((Double)this.spectraJTable.getValueAt(row, 2)).doubleValue(), "" + this.spectraJTable.getValueAt(row, 3), (String)this.spectraJTable.getValueAt(row, 1), 60, false);
            this.spectrumPanel.showAnnotatedPeaksOnly(true);
            this.spectrumPanel.setBorder(null);
            this.spectrumJPanel.add((Component)this.spectrumPanel);
            this.spectrumJPanel.validate();
            this.spectrumJPanel.repaint();
            while (this.identificationsJTable.getRowCount() > 0) {
                ((DefaultTableModel)this.identificationsJTable.getModel()).removeRow(0);
            }
            this.legendJLabel.setText("");
            this.ptmsJTextField.setText("");
            List<Integer> fixedModifications = this.omssaOmxFile.getParserResult().MSSearch_request.MSRequest.get((int)0).MSRequest_settings.MSSearchSettings.MSSearchSettings_fixed.MSMod;
            MSHitSet msHitSet = this.spectrumHitSetMap.get(this.spectra.get((Integer)this.spectraJTable.getValueAt(row, 0)));
            this.allAnnotations = new HashMap();
            List<MSHits> allMSHits = msHitSet.MSHitSet_hits.MSHits;
            Iterator<MSHits> msHitIterator = allMSHits.iterator();
            String modificationDetails = "";
            while (msHitIterator.hasNext()) {
                MSHits tempMSHit = msHitIterator.next();
                String sequence = tempMSHit.MSHits_pepstring;
                String[] modifications = new String[sequence.length()];
                for (int i = 0; i < modifications.length; ++i) {
                    modifications[i] = "";
                }
                String modifiedSequence = "";
                String nTerminal = "";
                String cTerminal = "";
                if (this.omssaOmxFile.getModifications().size() > 0) {
                    int j;
                    if (fixedModifications.size() > 0) {
                        for (int i = 0; i < fixedModifications.size(); ++i) {
                            OmssaModification tempOmssaModification = this.omssaOmxFile.getModifications().get(fixedModifications.get(i));
                            if (tempOmssaModification.getModType() == 0) {
                                Vector<String> modifiedResidues = tempOmssaModification.getModResidues();
                                for (j = 0; j < modifiedResidues.size(); ++j) {
                                    int index = sequence.indexOf(modifiedResidues.get(j));
                                    while (index != -1) {
                                        int n = index;
                                        modifications[n] = modifications[n] + "<" + tempOmssaModification.getModNumber() + ">";
                                        index = sequence.indexOf(modifiedResidues.get(j), index + 1);
                                    }
                                }
                                continue;
                            }
                            if (tempOmssaModification.getModType() == 1 || tempOmssaModification.getModType() == 2 || tempOmssaModification.getModType() == 5 || tempOmssaModification.getModType() == 6) {
                                nTerminal = nTerminal + "<" + tempOmssaModification.getModNumber() + ">";
                                if (modificationDetails.lastIndexOf("<" + tempOmssaModification.getModNumber() + ">") != -1) continue;
                                modificationDetails = modificationDetails + "<" + tempOmssaModification.getModNumber() + "> " + tempOmssaModification.getModName() + " (" + tempOmssaModification.getModMonoMass() + "), ";
                                continue;
                            }
                            if (tempOmssaModification.getModType() != 3 && tempOmssaModification.getModType() != 4 && tempOmssaModification.getModType() != 7 && tempOmssaModification.getModType() != 8) continue;
                            cTerminal = cTerminal + "<" + tempOmssaModification.getModNumber() + ">";
                            if (modificationDetails.lastIndexOf("<" + tempOmssaModification.getModNumber() + ">") != -1) continue;
                            modificationDetails = modificationDetails + "<" + tempOmssaModification.getModNumber() + "> " + tempOmssaModification.getModName() + " (" + tempOmssaModification.getModMonoMass() + "), ";
                        }
                    }
                    for (MSModHit currentMSModHit : tempMSHit.MSHits_mods.MSModHit) {
                        int n = currentMSModHit.MSModHit_site;
                        modifications[n] = modifications[n] + "<" + currentMSModHit.MSModHit_modtype.MSMod + ">";
                    }
                    for (int i = 0; i < modifications.length; ++i) {
                        modifiedSequence = modifiedSequence + sequence.substring(i, i + 1);
                        if (modifications[i].equalsIgnoreCase("")) continue;
                        String[] residueMods = modifications[i].split(">");
                        for (j = 0; j < residueMods.length; ++j) {
                            String currentMod = residueMods[j] + ">";
                            if (modificationDetails.lastIndexOf(currentMod) == -1) {
                                OmssaModification tempOmssaModification = this.omssaOmxFile.getModifications().get(Integer.valueOf(residueMods[j].substring(1)));
                                if (tempOmssaModification != null) {
                                    modificationDetails = modificationDetails + currentMod + " " + tempOmssaModification.getModName() + " (" + tempOmssaModification.getModMonoMass() + "), ";
                                    if (tempOmssaModification.getModType() == 0) {
                                        modifiedSequence = modifiedSequence + currentMod;
                                        continue;
                                    }
                                    if (tempOmssaModification.getModType() == 1 || tempOmssaModification.getModType() == 2 || tempOmssaModification.getModType() == 5 || tempOmssaModification.getModType() == 6) {
                                        nTerminal = nTerminal + currentMod;
                                        continue;
                                    }
                                    if (tempOmssaModification.getModType() != 3 && tempOmssaModification.getModType() != 4 && tempOmssaModification.getModType() != 7 && tempOmssaModification.getModType() != 8) continue;
                                    cTerminal = cTerminal + currentMod;
                                    continue;
                                }
                                modifiedSequence = modifiedSequence + currentMod;
                                modificationDetails = modificationDetails + currentMod + " unknown, ";
                                continue;
                            }
                            modifiedSequence = modifiedSequence + currentMod;
                        }
                    }
                } else {
                    this.ptmsJTextField.setText("(Files with modification details were not provided. No modifications are shown.)");
                    this.legendJLabel.setText(this.ionCoverageLegend);
                    modifiedSequence = sequence;
                }
                nTerminal = nTerminal.length() == 0 ? "NH2-" : nTerminal + "-";
                cTerminal = cTerminal.length() == 0 ? "-COOH" : "-" + cTerminal;
                Iterator<MSMZHit> mzHits = tempMSHit.MSHits_mzhits.MSMZHit.iterator();
                Vector<SpectrumAnnotation> currentAnnotations = new Vector<SpectrumAnnotation>();
                int[][] ionCoverage = new int[sequence.length()][2];
                while (mzHits.hasNext()) {
                    MSMZHit tempMzHit = mzHits.next();
                    int ionType = tempMzHit.MSMZHit_ion.MSIonType;
                    int msIonNeutralLossType = tempMzHit.MSMZHit_moreion.MSIon.MSIon_neutralloss.MSIonNeutralLoss;
                    String neturalLossTag = "";
                    String immoniumTag = "";
                    if (msIonNeutralLossType == -1) {
                        if (tempMzHit.MSMZHit_moreion.MSIon.MSIon_immonium.MSImmonium.MSImmonium_parent != null) {
                            immoniumTag = "i" + tempMzHit.MSMZHit_moreion.MSIon.MSIon_immonium.MSImmonium.MSImmonium_parent;
                        }
                    } else if (msIonNeutralLossType == 0) {
                        neturalLossTag = " -H2O";
                    } else if (msIonNeutralLossType == 1) {
                        neturalLossTag = " -NH3";
                    }
                    int charge = tempMzHit.MSMZHit_charge;
                    int ionNumber = tempMzHit.MSMZHit_number;
                    double mzValue = (double)tempMzHit.MSMZHit_mz / (double)this.omssaResponseScale;
                    String chargeAsString = "";
                    if (charge > 1) {
                        for (int i = 0; i < charge; ++i) {
                            chargeAsString = chargeAsString + "+";
                        }
                    }
                    String unusedIon = "";
                    if (!this.usedIonTypes.contains(ionType)) {
                        unusedIon = "#";
                    }
                    if (ionType == 0) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.BLUE, unusedIon + "a" + (ionNumber + 1) + chargeAsString + neturalLossTag));
                    } else if (ionType == 1) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.BLUE, unusedIon + "b" + (ionNumber + 1) + chargeAsString + neturalLossTag));
                        int[] nArray = ionCoverage[ionNumber];
                        nArray[0] = nArray[0] + 1;
                    } else if (ionType == 2) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.BLUE, unusedIon + "c" + (ionNumber + 1) + chargeAsString + neturalLossTag));
                    } else if (ionType == 3) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.BLACK, unusedIon + "x" + (ionNumber + 1) + chargeAsString + neturalLossTag));
                    } else if (ionType == 4) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.BLACK, unusedIon + "y" + (ionNumber + 1) + chargeAsString + neturalLossTag));
                        int[] nArray = ionCoverage[ionNumber];
                        nArray[1] = nArray[1] + 1;
                    } else if (ionType == 5) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.BLACK, unusedIon + "z" + (ionNumber + 1) + chargeAsString + neturalLossTag));
                    } else if (ionType == 6) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.GRAY, unusedIon + "parent" + chargeAsString + neturalLossTag));
                    } else if (ionType == 7) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.GRAY, unusedIon + "internal" + chargeAsString + neturalLossTag));
                    } else if (ionType == 8) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.GRAY, unusedIon + immoniumTag));
                    } else if (ionType == 9) {
                        currentAnnotations.add((SpectrumAnnotation)new DefaultSpectrumAnnotation(mzValue, this.ionCoverageErrorMargin, Color.GRAY, unusedIon + "unknown" + chargeAsString + neturalLossTag));
                    }
                    this.allAnnotations.put(sequence + "_" + Float.valueOf((float)tempMSHit.MSHits_pvalue), currentAnnotations);
                    if (this.allAnnotations.size() != 1) continue;
                    this.spectrumPanel.setAnnotations(this.filterAnnotations(currentAnnotations));
                    this.spectrumPanel.validate();
                    this.spectrumPanel.repaint();
                }
                int[][] ionCoverageProcessed = new int[sequence.length()][2];
                for (int i = 1; i < ionCoverage.length; ++i) {
                    ionCoverageProcessed[i][0] = ionCoverage[i][0] > 0 && ionCoverage[i - 1][0] > 0 ? 1 : 0;
                    ionCoverageProcessed[ionCoverage.length - 1 - i][1] = ionCoverage[i][1] > 0 && ionCoverage[i - 1][1] > 0 ? 1 : 0;
                }
                String modifiedSequenceColorCoded = "<html><font color=\"black\">";
                if (!nTerminal.startsWith("<")) {
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal;
                } else {
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + nTerminal.substring(1, nTerminal.length() - 2);
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;-";
                }
                int aminoAcidCounter = 0;
                for (int i = 0; i < modifiedSequence.length(); ++i) {
                    if (modifiedSequence.charAt(i) == '<') {
                        if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                        }
                        if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                        }
                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&lt;";
                        ++i;
                        while (modifiedSequence.charAt(i) != '>') {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i++);
                        }
                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                        if (ionCoverageProcessed[aminoAcidCounter - 1][0] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                        }
                        if (ionCoverageProcessed[aminoAcidCounter - 1][1] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                        }
                    } else {
                        if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<u>";
                        }
                        if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"red\">";
                        }
                        modifiedSequenceColorCoded = modifiedSequenceColorCoded + modifiedSequence.charAt(i);
                        if (ionCoverageProcessed[aminoAcidCounter][0] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</u>";
                        }
                        if (ionCoverageProcessed[aminoAcidCounter][1] > 0) {
                            modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font>";
                        }
                        ++aminoAcidCounter;
                    }
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "<font color=\"black\">";
                }
                if (!cTerminal.startsWith("-<")) {
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal;
                } else {
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "-&lt;";
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + cTerminal.substring(2, cTerminal.length() - 1);
                    modifiedSequenceColorCoded = modifiedSequenceColorCoded + "&gt;";
                }
                modifiedSequenceColorCoded = modifiedSequenceColorCoded + "</font></html>";
                List<MSPepHit> pepHits = tempMSHit.MSHits_pephits.MSPepHit;
                for (MSPepHit tempPepHit : pepHits) {
                    String description;
                    String accession;
                    if (tempPepHit.MSPepHit_accession.startsWith("BL_ORD_ID:")) {
                        Header header = Header.parseFromFASTA((String)tempPepHit.MSPepHit_defline);
                        accession = header.getAccession();
                        description = header.getDescription();
                    } else {
                        accession = tempPepHit.MSPepHit_accession;
                        description = tempPepHit.MSPepHit_defline;
                    }
                    ((DefaultTableModel)this.identificationsJTable.getModel()).addRow(new Object[]{msHitSet.MSHitSet_number, sequence, modifiedSequenceColorCoded, tempPepHit.MSPepHit_start, tempPepHit.MSPepHit_stop, (double)tempMSHit.MSHits_mass / (double)this.omssaResponseScale, (double)tempMSHit.MSHits_theomass / (double)this.omssaResponseScale, Float.valueOf((float)tempMSHit.MSHits_evalue), Float.valueOf((float)tempMSHit.MSHits_pvalue), accession, description});
                }
            }
            if (modificationDetails.endsWith(", ")) {
                modificationDetails = modificationDetails.substring(0, modificationDetails.length() - 2);
            }
            if (modificationDetails.length() > 0) {
                this.ptmsJTextField.setText(modificationDetails);
            } else {
                this.legendJLabel.setText(this.ionCoverageLegend);
            }
            this.legendJLabel.setText(this.ionCoverageLegend);
            if (evt != null && evt.getButton() == 3) {
                this.copySpectraJPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
        if (this.identificationsJTable.getRowCount() > 1) {
            this.identificationsJTable.setRowSelectionInterval(0, 0);
        }
        this.setCursor(new Cursor(0));
    }

    private void spectrumJTableMouseClicked(MouseEvent evt) {
        if (this.spectrumJTable.getSelectedRow() != -1 && evt.getButton() == 3) {
            this.copySpectrumJPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void identificationsJTableMouseClicked(MouseEvent evt) {
        if (this.identificationsJTable.getSelectedRow() != -1) {
            if (evt.getButton() == 3) {
                this.copyIdentificationsJPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            } else if (this.identificationsJTable.getRowCount() > 1) {
                Vector<SpectrumAnnotation> currentAnnotations = this.allAnnotations.get(this.identificationsJTable.getValueAt(this.identificationsJTable.getSelectedRow(), 1) + "_" + this.identificationsJTable.getValueAt(this.identificationsJTable.getSelectedRow(), 8));
                this.spectrumPanel.setAnnotations(this.filterAnnotations(currentAnnotations));
                this.spectrumPanel.validate();
                this.spectrumPanel.repaint();
            }
        }
    }

    private void identificationsJTableKeyReleased(KeyEvent evt) {
        this.setCursor(new Cursor(3));
        this.spectrumPanel.setAnnotations(this.filterAnnotations(this.allAnnotations.get(this.identificationsJTable.getValueAt(this.identificationsJTable.getSelectedRow(), 1) + "_" + this.identificationsJTable.getValueAt(this.identificationsJTable.getSelectedRow(), 8))));
        this.spectrumPanel.validate();
        this.spectrumPanel.repaint();
        this.setCursor(new Cursor(0));
    }
}

