/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.omxparser.tools;

import de.proteinms.omxparser.tools.HelpWindow;
import de.proteinms.omxparser.tools.OmssaViewer;
import de.proteinms.omxparser.tools.OmxFileFilter;
import de.proteinms.omxparser.tools.XmlFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class OmssaViewerFileSelection
extends JDialog {
    private String lastSelectedFolder = "user.home";
    private Frame parent;
    private JButton aboutJButton;
    private JButton cancelJButton;
    private JPanel filesPanel;
    private JButton findModsFileJButton;
    private JButton findOmxFileJButton;
    private JButton findUserModsFileJButton;
    private JButton helpJButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField modsFileJTextField;
    private JButton okJButton;
    private JTextField omxFileJTextField;
    private JTextField userModsJTextField;

    public OmssaViewerFileSelection(Frame parent, boolean modal, String omxFile, String modsFile, String userModsFile, String lastSelectedFolder) {
        super(parent, modal);
        this.initComponents();
        this.lastSelectedFolder = lastSelectedFolder;
        if (omxFile != null) {
            this.omxFileJTextField.setText(omxFile);
        }
        if (modsFile != null) {
            this.modsFileJTextField.setText(modsFile);
        }
        if (userModsFile != null) {
            this.userModsJTextField.setText(userModsFile);
        }
        if (this.omxFileJTextField.getText().length() > 0) {
            this.okJButton.setEnabled(true);
        }
        this.parent = parent;
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.helpJButton = new JButton();
        this.aboutJButton = new JButton();
        this.filesPanel = new JPanel();
        this.omxFileJTextField = new JTextField();
        this.findUserModsFileJButton = new JButton();
        this.findModsFileJButton = new JButton();
        this.userModsJTextField = new JTextField();
        this.modsFileJTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.findOmxFileJButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okJButton = new JButton();
        this.cancelJButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("OMSSA Viewer - File Selection");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                OmssaViewerFileSelection.this.formWindowClosing(evt);
            }
        });
        this.helpJButton.setIcon(new ImageIcon(this.getClass().getResource("/de/proteinms/omxparser/icons/help.GIF")));
        this.helpJButton.setToolTipText("Help");
        this.helpJButton.setBorderPainted(false);
        this.helpJButton.setContentAreaFilled(false);
        this.helpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewerFileSelection.this.helpJButtonActionPerformed(evt);
            }
        });
        this.aboutJButton.setIcon(new ImageIcon(this.getClass().getResource("/de/proteinms/omxparser/icons/omssaviewer16.GIF")));
        this.aboutJButton.setToolTipText("About");
        this.aboutJButton.setBorderPainted(false);
        this.aboutJButton.setContentAreaFilled(false);
        this.aboutJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewerFileSelection.this.aboutJButtonActionPerformed(evt);
            }
        });
        this.filesPanel.setBorder(BorderFactory.createTitledBorder("Input Files"));
        this.omxFileJTextField.setEditable(false);
        this.omxFileJTextField.setHorizontalAlignment(0);
        this.omxFileJTextField.setToolTipText("The OMSSA omx file");
        this.findUserModsFileJButton.setText("Browse");
        this.findUserModsFileJButton.setToolTipText("Select File");
        this.findUserModsFileJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewerFileSelection.this.findUserModsFileJButtonActionPerformed(evt);
            }
        });
        this.findModsFileJButton.setText("Browse");
        this.findModsFileJButton.setToolTipText("Select File");
        this.findModsFileJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewerFileSelection.this.findModsFileJButtonActionPerformed(evt);
            }
        });
        this.userModsJTextField.setEditable(false);
        this.userModsJTextField.setHorizontalAlignment(0);
        this.userModsJTextField.setText("(optional)");
        this.userModsJTextField.setToolTipText("The OMSSA usermods.xml file");
        this.modsFileJTextField.setEditable(false);
        this.modsFileJTextField.setHorizontalAlignment(0);
        this.modsFileJTextField.setText("(optional)");
        this.modsFileJTextField.setToolTipText("The OMSSA mods.xml file");
        this.jLabel3.setText("User Modifications File:");
        this.jLabel3.setToolTipText("The OMSSA usermods.xml file");
        this.jLabel2.setText("Modifications File:");
        this.jLabel2.setToolTipText("The OMSSA mods.xml file");
        this.findOmxFileJButton.setText("Browse");
        this.findOmxFileJButton.setToolTipText("Select File");
        this.findOmxFileJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewerFileSelection.this.findOmxFileJButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Search Results File:");
        this.jLabel1.setToolTipText("The OMSSA omx file");
        GroupLayout filesPanelLayout = new GroupLayout((Container)this.filesPanel);
        this.filesPanel.setLayout((LayoutManager)filesPanelLayout);
        filesPanelLayout.setHorizontalGroup((GroupLayout.Group)filesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)filesPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)filesPanelLayout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)filesPanelLayout.createParallelGroup(1).add(2, (Component)this.jLabel3).add((Component)this.jLabel2))).add(18, 18, 18).add((GroupLayout.Group)filesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)filesPanelLayout.createSequentialGroup().add((Component)this.userModsJTextField, -2, 381, -2).addPreferredGap(0).add((Component)this.findUserModsFileJButton)).add((GroupLayout.Group)filesPanelLayout.createSequentialGroup().add((Component)this.modsFileJTextField, -2, 383, -2).addPreferredGap(0).add((Component)this.findModsFileJButton)).add((GroupLayout.Group)filesPanelLayout.createSequentialGroup().add((Component)this.omxFileJTextField, -2, 383, -2).addPreferredGap(0).add((Component)this.findOmxFileJButton))).addContainerGap()));
        filesPanelLayout.linkSize(new Component[]{this.modsFileJTextField, this.omxFileJTextField, this.userModsJTextField}, 1);
        filesPanelLayout.setVerticalGroup((GroupLayout.Group)filesPanelLayout.createParallelGroup(1).add((GroupLayout.Group)filesPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)filesPanelLayout.createParallelGroup(3).add((Component)this.omxFileJTextField, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.findOmxFileJButton)).add(7, 7, 7).add((GroupLayout.Group)filesPanelLayout.createParallelGroup(3).add((Component)this.findModsFileJButton).add((Component)this.modsFileJTextField, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)filesPanelLayout.createParallelGroup(3).add((Component)this.findUserModsFileJButton).add((Component)this.userModsJTextField, -2, -1, -2).add((Component)this.jLabel3)).addContainerGap()));
        this.okJButton.setText("OK");
        this.okJButton.setEnabled(false);
        this.okJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewerFileSelection.this.okJButtonActionPerformed(evt);
            }
        });
        this.cancelJButton.setText("Cancel");
        this.cancelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OmssaViewerFileSelection.this.cancelJButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.filesPanel, -2, -1, -2).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.helpJButton, -2, 23, -2).addPreferredGap(0).add((Component)this.aboutJButton, -2, 25, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.okJButton).addPreferredGap(0).add((Component)this.cancelJButton))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.cancelJButton, this.okJButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.filesPanel, -2, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.helpJButton, -2, 24, -2).add((Component)this.aboutJButton, -2, 24, -2).add((Component)this.okJButton).add((Component)this.cancelJButton)).addContainerGap()));
        this.pack();
    }

    private void findUserModsFileJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        JFileChooser chooser = this.userModsJTextField.getText().equalsIgnoreCase("(optional)") ? new JFileChooser(this.lastSelectedFolder) : new JFileChooser(this.userModsJTextField.getText());
        chooser.setFileFilter(new XmlFileFilter());
        chooser.setDialogTitle("Locate the usermods.xml file");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getAbsoluteFile().getPath();
            if (!chooser.getSelectedFile().getName().toLowerCase().equalsIgnoreCase("usermods.xml")) {
                JOptionPane.showMessageDialog(this, "This is not the usermods.xml file. Please select the usermods.xml file in the OMMSA installation folder.", "Wrong File!", 0);
                this.userModsJTextField.setText(path);
                this.findUserModsFileJButtonActionPerformed(null);
            } else {
                this.userModsJTextField.setText(path);
                this.lastSelectedFolder = path;
                if (this.omxFileJTextField.getText().length() > 0) {
                    this.okJButton.setEnabled(true);
                }
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void findModsFileJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        JFileChooser chooser = this.modsFileJTextField.getText().equalsIgnoreCase("(optional)") ? new JFileChooser(this.lastSelectedFolder) : new JFileChooser(this.modsFileJTextField.getText());
        chooser.setFileFilter(new XmlFileFilter());
        chooser.setDialogTitle("Locate the mods.xml file");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getAbsoluteFile().getPath();
            if (!chooser.getSelectedFile().getName().toLowerCase().equalsIgnoreCase("mods.xml")) {
                JOptionPane.showMessageDialog(this, "This is not the mods.xml file. Please select the mods.xml file in the OMMSA installation folder.", "Wrong File!", 0);
                this.modsFileJTextField.setText(path);
                this.findModsFileJButtonActionPerformed(null);
            } else {
                this.modsFileJTextField.setText(path);
                this.lastSelectedFolder = path;
                if (this.omxFileJTextField.getText().length() > 0) {
                    this.okJButton.setEnabled(true);
                }
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void findOmxFileJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        JFileChooser chooser = this.omxFileJTextField.getText().length() == 0 ? new JFileChooser(this.lastSelectedFolder) : new JFileChooser(this.omxFileJTextField.getText());
        chooser.setFileFilter(new OmxFileFilter());
        chooser.setDialogTitle("Locate the OMSSA omx file");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            String path = chooser.getSelectedFile().getAbsoluteFile().getPath();
            if (!chooser.getSelectedFile().getName().toLowerCase().endsWith(".omx")) {
                JOptionPane.showMessageDialog(this, "This is not an omx file. Please select an OMSSA omx file.", "Wrong File!", 0);
                this.omxFileJTextField.setText(path);
                this.findOmxFileJButtonActionPerformed(null);
            } else {
                this.omxFileJTextField.setText(path);
                this.lastSelectedFolder = path;
                if (this.omxFileJTextField.getText().length() > 0) {
                    this.okJButton.setEnabled(true);
                }
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelJButtonActionPerformed(null);
    }

    private void helpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpWindow(this, this.getClass().getResource("/de/proteinms/omxparser/helpfiles/OmssaViewer.html"));
        this.setCursor(new Cursor(0));
    }

    private void aboutJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpWindow(this, this.getClass().getResource("/de/proteinms/omxparser/helpfiles/AboutOmssaViewer.html"));
        this.setCursor(new Cursor(0));
    }

    private void okJButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        String modsFile = null;
        String userModsFile = null;
        if (!this.modsFileJTextField.getText().equalsIgnoreCase("(optional)")) {
            modsFile = this.modsFileJTextField.getText();
        }
        if (!this.userModsJTextField.getText().equalsIgnoreCase("(optional)")) {
            userModsFile = this.userModsJTextField.getText();
        }
        if (this.parent != null) {
            this.parent.setVisible(true);
            ((OmssaViewer)this.parent).insertOmxFile(this.omxFileJTextField.getText(), modsFile, userModsFile, this.lastSelectedFolder);
        } else {
            new OmssaViewer(this.omxFileJTextField.getText(), modsFile, userModsFile, this.lastSelectedFolder);
        }
        this.dispose();
    }

    private void cancelJButtonActionPerformed(ActionEvent evt) {
        if (this.parent == null) {
            System.exit(0);
        } else if (!this.parent.isVisible()) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }
}

