/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.omxparser.util;

import de.proteinms.omxparser.util.MSChargeHandle;
import de.proteinms.omxparser.util.MSChargeHandle_calccharge;
import de.proteinms.omxparser.util.MSChargeHandle_calcplusone;
import de.proteinms.omxparser.util.MSHitSet;
import de.proteinms.omxparser.util.MSHitSet_error;
import de.proteinms.omxparser.util.MSHitSet_hits;
import de.proteinms.omxparser.util.MSHitSet_ids;
import de.proteinms.omxparser.util.MSHitSet_namevalue;
import de.proteinms.omxparser.util.MSHitSet_userannotation;
import de.proteinms.omxparser.util.MSHits;
import de.proteinms.omxparser.util.MSHits_mods;
import de.proteinms.omxparser.util.MSHits_mzhits;
import de.proteinms.omxparser.util.MSHits_pephits;
import de.proteinms.omxparser.util.MSHits_scores;
import de.proteinms.omxparser.util.MSImmonium;
import de.proteinms.omxparser.util.MSInFile;
import de.proteinms.omxparser.util.MSInFile_infiletype;
import de.proteinms.omxparser.util.MSIon;
import de.proteinms.omxparser.util.MSIonAnnot;
import de.proteinms.omxparser.util.MSIon_immonium;
import de.proteinms.omxparser.util.MSIon_isotope;
import de.proteinms.omxparser.util.MSIon_neutralloss;
import de.proteinms.omxparser.util.MSIterativeSettings;
import de.proteinms.omxparser.util.MSLibrarySettings;
import de.proteinms.omxparser.util.MSLibrarySettings_libnames;
import de.proteinms.omxparser.util.MSMZHit;
import de.proteinms.omxparser.util.MSMZHit_annotation;
import de.proteinms.omxparser.util.MSMZHit_ion;
import de.proteinms.omxparser.util.MSMZHit_moreion;
import de.proteinms.omxparser.util.MSMassSet;
import de.proteinms.omxparser.util.MSModHit;
import de.proteinms.omxparser.util.MSModHit_modtype;
import de.proteinms.omxparser.util.MSModSpec;
import de.proteinms.omxparser.util.MSModSpecSet;
import de.proteinms.omxparser.util.MSModSpec_mod;
import de.proteinms.omxparser.util.MSModSpec_neutralloss;
import de.proteinms.omxparser.util.MSModSpec_residues;
import de.proteinms.omxparser.util.MSOutFile;
import de.proteinms.omxparser.util.MSOutFile_outfiletype;
import de.proteinms.omxparser.util.MSPepHit;
import de.proteinms.omxparser.util.MSRequest;
import de.proteinms.omxparser.util.MSRequest_modset;
import de.proteinms.omxparser.util.MSRequest_moresettings;
import de.proteinms.omxparser.util.MSRequest_settings;
import de.proteinms.omxparser.util.MSRequest_spectra;
import de.proteinms.omxparser.util.MSResponse;
import de.proteinms.omxparser.util.MSResponse_error;
import de.proteinms.omxparser.util.MSResponse_hitsets;
import de.proteinms.omxparser.util.MSScoreSet;
import de.proteinms.omxparser.util.MSSearch;
import de.proteinms.omxparser.util.MSSearchSettings;
import de.proteinms.omxparser.util.MSSearchSettingsSet;
import de.proteinms.omxparser.util.MSSearchSettings_chargehandling;
import de.proteinms.omxparser.util.MSSearchSettings_enzyme;
import de.proteinms.omxparser.util.MSSearchSettings_fixed;
import de.proteinms.omxparser.util.MSSearchSettings_infiles;
import de.proteinms.omxparser.util.MSSearchSettings_ionstosearch;
import de.proteinms.omxparser.util.MSSearchSettings_iterativesettings;
import de.proteinms.omxparser.util.MSSearchSettings_libsearchsettings;
import de.proteinms.omxparser.util.MSSearchSettings_noprolineions;
import de.proteinms.omxparser.util.MSSearchSettings_othersettings;
import de.proteinms.omxparser.util.MSSearchSettings_outfiles;
import de.proteinms.omxparser.util.MSSearchSettings_precursorsearchtype;
import de.proteinms.omxparser.util.MSSearchSettings_productsearchtype;
import de.proteinms.omxparser.util.MSSearchSettings_taxids;
import de.proteinms.omxparser.util.MSSearchSettings_usermods;
import de.proteinms.omxparser.util.MSSearchSettings_variable;
import de.proteinms.omxparser.util.MSSearchSettings_zdep;
import de.proteinms.omxparser.util.MSSearch_request;
import de.proteinms.omxparser.util.MSSearch_response;
import de.proteinms.omxparser.util.MSSpectrum;
import de.proteinms.omxparser.util.MSSpectrum_abundance;
import de.proteinms.omxparser.util.MSSpectrum_charge;
import de.proteinms.omxparser.util.MSSpectrum_ids;
import de.proteinms.omxparser.util.MSSpectrum_mz;
import de.proteinms.omxparser.util.MSSpectrum_namevalue;
import de.proteinms.omxparser.util.MSSpectrumset;
import de.proteinms.omxparser.util.NameValue;
import de.proteinms.omxparser.util.OmssaModification;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class OmxParser {
    public static final String ENCODING = "UTF-8";
    private static Logger logger = LogManager.getLogger(OmxParser.class);
    private int[] indexBuffer = new int[2];
    private Stack<Object> objectStack = new Stack();
    private Stack<String> nameStack = new Stack();
    private Stack<Boolean> lockStack = new Stack();
    private static HashMap<String, Class<?>> classes = new HashMap();
    public MSSearch parserResult;
    private String attribute = "";
    private String value = "";
    private HashMap<Integer, OmssaModification> omssaModificationDetails;

    public static void initializeClasses(boolean importSpectra, boolean importIdDetails) {
        classes.put("MSChargeHandle_calccharge", MSChargeHandle_calccharge.class);
        classes.put("MSChargeHandle_calcplusone", MSChargeHandle_calcplusone.class);
        classes.put("MSChargeHandle", MSChargeHandle.class);
        classes.put("MSHits_mods", MSHits_mods.class);
        classes.put("MSHits_scores", MSHits_scores.class);
        classes.put("MSHits", MSHits.class);
        classes.put("MSHitSet_error", MSHitSet_error.class);
        classes.put("MSHitSet_hits", MSHitSet_hits.class);
        classes.put("MSHitSet_ids", MSHitSet_ids.class);
        classes.put("MSHitSet_namevalue", MSHitSet_namevalue.class);
        classes.put("MSHitSet_userannotation", MSHitSet_userannotation.class);
        classes.put("MSHitSet", MSHitSet.class);
        classes.put("MSImmonium", MSImmonium.class);
        classes.put("MSInFile_infiletype", MSInFile_infiletype.class);
        classes.put("MSInFile", MSInFile.class);
        classes.put("MSIon_immonium", MSIon_immonium.class);
        classes.put("MSIon_isotope", MSIon_isotope.class);
        classes.put("MSIon_neutralloss", MSIon_neutralloss.class);
        classes.put("MSIon", MSIon.class);
        classes.put("MSIonAnnot", MSIonAnnot.class);
        classes.put("MSIterativeSettings", MSIterativeSettings.class);
        classes.put("MSLibrarySettings_libnames", MSLibrarySettings_libnames.class);
        classes.put("MSLibrarySettings", MSLibrarySettings.class);
        classes.put("MSMassSet", MSMassSet.class);
        classes.put("MSModHit_modtype", MSModHit_modtype.class);
        classes.put("MSModHit", MSModHit.class);
        classes.put("MSModSpec_mod", MSModSpec_mod.class);
        classes.put("MSModSpec_neutralloss", MSModSpec_neutralloss.class);
        classes.put("MSModSpec_residues", MSModSpec_residues.class);
        classes.put("MSModSpec", MSModSpec.class);
        classes.put("MSModSpecSet", MSModSpecSet.class);
        classes.put("MSOutFile_outfiletype", MSOutFile_outfiletype.class);
        classes.put("MSOutFile", MSOutFile.class);
        classes.put("MSRequest_modset", MSRequest_modset.class);
        classes.put("MSRequest_moresettings", MSRequest_moresettings.class);
        classes.put("MSRequest_settings", MSRequest_settings.class);
        classes.put("MSRequest", MSRequest.class);
        classes.put("MSResponse_error", MSResponse_error.class);
        classes.put("MSResponse_hitsets", MSResponse_hitsets.class);
        classes.put("MSResponse", MSResponse.class);
        classes.put("MSScoreSet", MSScoreSet.class);
        classes.put("MSSearch_request", MSSearch_request.class);
        classes.put("MSSearch_response", MSSearch_response.class);
        classes.put("MSSearch", MSSearch.class);
        classes.put("MSSearchSettings_chargehandling", MSSearchSettings_chargehandling.class);
        classes.put("MSSearchSettings_enzyme", MSSearchSettings_enzyme.class);
        classes.put("MSSearchSettings_fixed", MSSearchSettings_fixed.class);
        classes.put("MSSearchSettings_infiles", MSSearchSettings_infiles.class);
        classes.put("MSSearchSettings_ionstosearch", MSSearchSettings_ionstosearch.class);
        classes.put("MSSearchSettings_iterativesettings", MSSearchSettings_iterativesettings.class);
        classes.put("MSSearchSettings_libsearchsettings", MSSearchSettings_libsearchsettings.class);
        classes.put("MSSearchSettings_noprolineions", MSSearchSettings_noprolineions.class);
        classes.put("MSSearchSettings_othersettings", MSSearchSettings_othersettings.class);
        classes.put("MSSearchSettings_outfiles", MSSearchSettings_outfiles.class);
        classes.put("MSSearchSettings_precursorsearchtype", MSSearchSettings_precursorsearchtype.class);
        classes.put("MSSearchSettings_productsearchtype", MSSearchSettings_productsearchtype.class);
        classes.put("MSSearchSettings_taxids", MSSearchSettings_taxids.class);
        classes.put("MSSearchSettings_usermods", MSSearchSettings_usermods.class);
        classes.put("MSSearchSettings_variable", MSSearchSettings_variable.class);
        classes.put("MSSearchSettings_zdep", MSSearchSettings_zdep.class);
        classes.put("MSSearchSettings", MSSearchSettings.class);
        classes.put("MSSearchSettingsSet", MSSearchSettingsSet.class);
        classes.put("MSSpectrum_namevalue", MSSpectrum_namevalue.class);
        classes.put("NameValue", NameValue.class);
        if (importSpectra) {
            classes.put("MSRequest_spectra", MSRequest_spectra.class);
            classes.put("MSSpectrumset", MSSpectrumset.class);
            classes.put("MSSpectrum", MSSpectrum.class);
            classes.put("MSSpectrum_charge", MSSpectrum_charge.class);
            classes.put("MSSpectrum_mz", MSSpectrum_mz.class);
            classes.put("MSSpectrum_abundance", MSSpectrum_abundance.class);
            classes.put("MSSpectrum_ids", MSSpectrum_ids.class);
        }
        if (importIdDetails) {
            classes.put("MSHits_pephits", MSHits_pephits.class);
            classes.put("MSPepHit", MSPepHit.class);
            classes.put("MSHits_mzhits", MSHits_mzhits.class);
            classes.put("MSMZHit_annotation", MSMZHit_annotation.class);
            classes.put("MSMZHit_ion", MSMZHit_ion.class);
            classes.put("MSMZHit_moreion", MSMZHit_moreion.class);
            classes.put("MSMZHit", MSMZHit.class);
        }
    }

    public OmxParser(File omxFile, File modsFile, File userModsFile) {
        this(omxFile.getAbsolutePath(), modsFile.getAbsolutePath(), userModsFile.getAbsolutePath(), true);
    }

    public OmxParser(File omxFile, File modsFile, File userModsFile, boolean importSpectra) {
        this(omxFile.getAbsolutePath(), modsFile.getAbsolutePath(), userModsFile.getAbsolutePath(), importSpectra);
    }

    public OmxParser(String omxFilePath, String modsFilePath, String userModsFilePath, boolean importSpectra) {
        this(omxFilePath, modsFilePath, userModsFilePath, importSpectra, false);
    }

    public OmxParser(String omxFilePath, String modsFilePath, String userModsFilePath, boolean importSpectra, boolean importIdDetails) {
        File omxFile = null;
        File modsFile = null;
        File userModsFile = null;
        if (omxFilePath != null) {
            omxFile = new File(omxFilePath);
        }
        if (modsFilePath != null) {
            modsFile = new File(modsFilePath);
        }
        if (userModsFilePath != null) {
            userModsFile = new File(userModsFilePath);
        }
        this.omssaModificationDetails = new HashMap();
        if (modsFile != null && modsFile.getAbsolutePath().endsWith(".xml")) {
            this.parseModificationFile(modsFile);
        }
        if (userModsFile != null && userModsFile.getAbsolutePath().endsWith(".xml")) {
            this.parseModificationFile(userModsFile);
        }
        try {
            BufferedReader reader;
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            factory.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            XmlPullParser xpp = factory.newPullParser();
            OmxParser.initializeClasses(importSpectra, importIdDetails);
            logger.debug("Parsing file: " + omxFile);
            if (omxFile.getName().endsWith(".gz")) {
                FileInputStream fileStream = new FileInputStream(omxFile);
                GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
                InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, ENCODING);
                reader = new BufferedReader(decoder);
            } else {
                reader = new BufferedReader(new FileReader(omxFile));
            }
            xpp.setInput((Reader)reader);
            long t1 = System.currentTimeMillis();
            this.processDocument(xpp, !importSpectra, !importIdDetails);
            long t2 = System.currentTimeMillis();
            long t3 = (t2 - t1) / 1000L;
            logger.debug("finished after " + t3 + " seconds");
        }
        catch (XmlPullParserException e) {
            logger.error("Error parsing file: " + omxFile + " " + e.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.error("Error parsing file: " + omxFile + " " + e.toString());
            e.printStackTrace();
        }
    }

    public OmxParser(String omxFile, String modsFile, String userModsFile) {
        this(omxFile, modsFile, userModsFile, true);
    }

    private void parseModificationFile(File modsFile) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setAttribute("http://xml.org/sax/features/validation", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(modsFile);
            Element docEle = dom.getDocumentElement();
            NodeList nodes = docEle.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (!nodes.item(i).getNodeName().equalsIgnoreCase("MSModSpec")) continue;
                NodeList modNodes = nodes.item(i).getChildNodes();
                int modNumber = -1;
                int modType = 0;
                String modName = "";
                Double modMonoMass = 0.0;
                Vector<String> modResidues = new Vector<String>();
                for (int j = 0; j < modNodes.getLength(); ++j) {
                    int m;
                    NodeList tempNodes;
                    if (modNodes.item(j).getNodeName().equalsIgnoreCase("MSModSpec_mod")) {
                        tempNodes = modNodes.item(j).getChildNodes();
                        for (m = 0; m < tempNodes.getLength(); ++m) {
                            if (!tempNodes.item(m).getNodeName().equalsIgnoreCase("MSMod")) continue;
                            modNumber = Integer.valueOf(tempNodes.item(m).getTextContent());
                        }
                        continue;
                    }
                    if (modNodes.item(j).getNodeName().equalsIgnoreCase("MSModSpec_type")) {
                        tempNodes = modNodes.item(j).getChildNodes();
                        for (m = 0; m < tempNodes.getLength(); ++m) {
                            if (!tempNodes.item(m).getNodeName().equalsIgnoreCase("MSModType")) continue;
                            modType = Integer.valueOf(tempNodes.item(m).getTextContent());
                        }
                        continue;
                    }
                    if (modNodes.item(j).getNodeName().equalsIgnoreCase("MSModSpec_name")) {
                        modName = modNodes.item(j).getTextContent();
                        continue;
                    }
                    if (modNodes.item(j).getNodeName().equalsIgnoreCase("MSModSpec_monomass")) {
                        modMonoMass = Double.valueOf(modNodes.item(j).getTextContent());
                        continue;
                    }
                    if (!modNodes.item(j).getNodeName().equalsIgnoreCase("MSModSpec_residues")) continue;
                    NodeList residueNodes = modNodes.item(j).getChildNodes();
                    modResidues = new Vector();
                    for (m = 0; m < residueNodes.getLength(); ++m) {
                        if (!residueNodes.item(m).getNodeName().equalsIgnoreCase("MSModSpec_residues_E")) continue;
                        modResidues.add(residueNodes.item(m).getTextContent());
                    }
                }
                if (modMonoMass == 0.0) {
                    modMonoMass = null;
                }
                this.omssaModificationDetails.put(modNumber, new OmssaModification(modNumber, modName, modMonoMass, modResidues, modType));
            }
        }
        catch (Exception e) {
            logger.error("Error parsing the modification file: " + e.toString());
            e.printStackTrace();
        }
    }

    public void processDocument(XmlPullParser xpp, boolean skipMSRequest_spectra, boolean skipPeptideDetails) throws XmlPullParserException, IOException {
        int eventType;
        this.lockStack.add(false);
        while ((eventType = xpp.next()) != 1) {
            if (eventType == 2) {
                String name = xpp.getName();
                if (skipMSRequest_spectra && name.equals("MSRequest_spectra")) {
                    while (eventType != 3 || !name.equals("MSRequest_spectra")) {
                        eventType = xpp.next();
                        name = xpp.getName();
                    }
                    continue;
                }
                if (skipPeptideDetails && name.equals("MSHits_pephits")) {
                    while (eventType != 3 || !name.equals("MSHits_pephits")) {
                        eventType = xpp.next();
                        name = xpp.getName();
                    }
                    continue;
                }
                if (skipPeptideDetails && name.equals("MSHits_mzhits")) {
                    while (eventType != 3 || !name.equals("MSHits_mzhits")) {
                        eventType = xpp.next();
                        name = xpp.getName();
                    }
                    continue;
                }
                this.processStartElement(xpp, !skipPeptideDetails);
                continue;
            }
            if (eventType == 3) {
                this.processEndElement(xpp, !skipPeptideDetails);
                continue;
            }
            if (eventType != 4) continue;
            this.processText(xpp, !skipPeptideDetails);
        }
    }

    public void processEndElement(XmlPullParser xpp, boolean importDetails) {
        if (!this.objectStack.isEmpty() && !this.lockStack.peek().booleanValue()) {
            Object pop = this.objectStack.pop();
            if (!this.objectStack.isEmpty()) {
                try {
                    Object peek = this.objectStack.peek();
                    Class<?> c = peek.getClass();
                    String method = "set" + this.nameStack.peek();
                    if (importDetails || this.shallExecute(c, method, pop)) {
                        Method setX = c.getDeclaredMethod(method, pop.getClass());
                        setX.invoke(peek, pop);
                    }
                }
                catch (EmptyStackException e) {
                    logger.error("Error processing the end element: " + e.toString());
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    logger.error("Error processing the end element: " + e.toString());
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    logger.error("Error processing the end element: " + e.toString());
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    logger.error("Error processing the end element: " + e.toString());
                    e.printStackTrace();
                }
                catch (ClassCastException e) {
                    logger.error("Error processing the end element: " + e.toString());
                    e.printStackTrace();
                }
            }
            if (pop.getClass().equals(MSSearch.class)) {
                this.parserResult = (MSSearch)pop;
            }
        }
        this.lockStack.pop();
        this.nameStack.pop();
    }

    public void processStartElement(XmlPullParser xpp, boolean importDetails) {
        this.nameStack.push(xpp.getName());
        try {
            if (!classes.containsKey(this.nameStack.peek())) {
                this.lockStack.add(true);
            } else {
                Class<?> c = classes.get(this.nameStack.peek());
                Object neu = c.newInstance();
                this.objectStack.push(neu);
                this.lockStack.add(false);
            }
        }
        catch (InstantiationException e) {
            logger.error("Error processing the start element: " + e.toString());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            logger.error("Error processing the start element: " + e.toString());
            e.printStackTrace();
        }
        if (!this.lockStack.peek().booleanValue() && xpp.getAttributeCount() > 0) {
            this.attribute = xpp.getAttributeName(0);
            if (this.attribute.equals("value")) {
                this.value = xpp.getAttributeValue(0);
                try {
                    Object peek = this.objectStack.peek();
                    Class<?> c = peek.getClass();
                    String method = "set" + this.nameStack.peek();
                    if (importDetails || this.shallExecute(c, method, peek)) {
                        Method setX = c.getDeclaredMethod(method, String.class);
                        setX.invoke(peek, this.value);
                        this.attribute = "";
                        this.value = "";
                    }
                }
                catch (EmptyStackException e) {
                    logger.error("Error processing the start element: " + e.toString());
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    logger.error("Error processing the start element: " + e.toString());
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    logger.error("Error processing the start element: " + e.toString());
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    logger.error("Error processing the start element: " + e.toString());
                    e.printStackTrace();
                }
            }
        }
    }

    public void processText(XmlPullParser xpp, boolean importDetails) throws XmlPullParserException {
        String text;
        Boolean lockStackBuffer = this.lockStack.pop();
        if (!this.lockStack.peek().booleanValue() && !(text = xpp.getText().trim()).equals("")) {
            try {
                Object peek = this.objectStack.peek();
                Class<?> c = peek.getClass();
                String method = "set" + this.nameStack.peek();
                if (importDetails || this.shallExecute(c, method, peek)) {
                    Method setX = c.getDeclaredMethod(method, String.class);
                    setX.invoke(peek, text);
                }
            }
            catch (EmptyStackException e) {
                logger.error("Error processing the text element: " + e.toString());
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                logger.error("Error processing the text element: " + e.toString());
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                logger.error("Error processing the text element: " + e.toString());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                logger.error("Error processing the text element: " + e.toString());
                e.printStackTrace();
            }
        }
        this.lockStack.push(lockStackBuffer);
    }

    public HashMap<Integer, OmssaModification> getOmssaModificationDetails() {
        return this.omssaModificationDetails;
    }

    private boolean shallExecute(Class<?> c, String method, Object object) {
        if (c == MSSearch.class && method.equals("setMSSearch_request")) {
            return true;
        }
        if (c == MSSearch_request.class && method.equals("setMSRequest")) {
            return true;
        }
        if (c == MSRequest.class && method.equals("setMSRequest_settings")) {
            return true;
        }
        if (c == MSRequest_settings.class && method.equals("setMSSearchSettings")) {
            return true;
        }
        if (c == MSSearchSettings.class && method.equals("setMSSearchSettings_infiles")) {
            return true;
        }
        if (c == MSSearchSettings_infiles.class && method.equals("setMSSearchSettings_infiles")) {
            return true;
        }
        if (c == MSSearchSettings_infiles.class && method.equals("setMSInFile")) {
            return true;
        }
        if (c == MSInFile.class && method.equals("setMSInFile_infile")) {
            return true;
        }
        if (c == MSSearch.class && method.equals("setMSSearch_response")) {
            return true;
        }
        if (c == MSSearch_response.class && method.equals("setMSResponse")) {
            return true;
        }
        if (c == MSResponse.class && method.equals("setMSResponse_hitsets")) {
            return true;
        }
        if (c == MSResponse_hitsets.class && method.equals("setMSHitSet")) {
            MSHitSet msHitSet = (MSHitSet)object;
            return !msHitSet.MSHitSet_hits.MSHits.isEmpty();
        }
        if (c == MSHitSet.class && method.equals("setMSHitSet_number")) {
            return true;
        }
        if (c == MSHitSet.class && method.equals("setMSHitSet_hits")) {
            return true;
        }
        if (c == MSHitSet_hits.class && method.equals("setMSHits")) {
            return true;
        }
        if (c == MSHitSet.class && method.equals("setMSHitSet_ids")) {
            return true;
        }
        if (c == MSHits.class && method.equals("setMSHits_evalue")) {
            return true;
        }
        if (c == MSHits.class && method.equals("setMSHits_charge")) {
            return true;
        }
        if (c == MSHits.class && method.equals("setMSHits_pepstring")) {
            return true;
        }
        if (c == MSHits.class && method.equals("setMSHits_mods")) {
            return true;
        }
        if (c == MSHits_mods.class && method.equals("setMSModHit")) {
            return true;
        }
        if (c == MSModHit.class && method.equals("setMSModHit_site")) {
            return true;
        }
        if (c == MSModHit.class && method.equals("setMSModHit_modtype")) {
            return true;
        }
        if (c == MSModHit_modtype.class && method.equals("setMSMod")) {
            return true;
        }
        return c == MSHitSet_ids.class && method.equals("setMSHitSet_ids_E");
    }
}

