/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.inputdevice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.jmol.api.JmolTouchSimulatorInterface;
import org.jmol.util.Logger;

public class JmolTouchSimulator
implements JmolTouchSimulatorInterface {
    private TreeSet _events = new TreeSet(new TouchDataComparator());
    protected HashMap _active = new HashMap();
    private boolean _recording = false;
    private int _touchID = 0;
    private long _when = 0L;
    private Timer _timer;
    private Component _display;
    private DataOutputStream _out;

    public void dispose() {
        try {
            this._out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean startSimulator(Component component) {
        this._display = component;
        String string = "localhost";
        this._timer = new Timer();
        try {
            Socket socket = new Socket(string, 5947);
            this._out = new DataOutputStream(socket.getOutputStream());
            this._out.writeByte(1);
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            Logger.error("Could not locate a server at " + string);
        }
        catch (IOException iOException) {
            Logger.error("Failed to connect to server at " + string);
        }
        return false;
    }

    public void toggleMode() {
        if (this._recording) {
            this.endRecording();
        } else {
            this.startRecording();
        }
    }

    public void startRecording() {
        this._recording = true;
        this._active.clear();
    }

    public void endRecording() {
        this._recording = false;
        this.dispatchTouchEvents();
    }

    public void mousePressed(long l, int n, int n2) {
        this.handleMouseEvent(l, n, n2, 0);
    }

    public void mouseReleased(long l, int n, int n2) {
        this.handleMouseEvent(l, n, n2, 1);
    }

    public void mouseDragged(long l, int n, int n2) {
        this.handleMouseEvent(l, n, n2, 2);
    }

    private void handleMouseEvent(long l, int n, int n2, int n3) {
        TouchData touchData = new TouchData();
        touchData.id = n3 == 0 ? (this._touchID = this._touchID + 1) : this._touchID;
        Point point = new Point(n, n2);
        SwingUtilities.convertPointToScreen(point, this._display);
        touchData.x = point.x;
        touchData.y = point.y;
        touchData.type = n3;
        touchData.when = l;
        if (this._recording) {
            if (n3 == 0) {
                touchData.delay = 0L;
                this._when = touchData.when;
            } else {
                touchData.delay = touchData.when - this._when;
            }
            this._events.add(touchData);
        } else {
            this.dispatchTouchEvent(touchData);
            if (Logger.debugging) {
                Logger.debug("[JmolTouchSimulator] dispatchTouchEvent(" + touchData.id + ", " + touchData.x + ", " + touchData.y + ", " + touchData.type + ")");
            }
        }
    }

    private void dispatchTouchEvents() {
        for (TouchData touchData : this._events) {
            TouchTimerTask touchTimerTask = new TouchTimerTask(touchData);
            this._timer.schedule((TimerTask)touchTimerTask, touchData.delay + 250L);
        }
        this._events.clear();
        this._touchID = 0;
    }

    protected void dispatchTouchEvent(TouchData touchData) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (Logger.debugging) {
            Logger.debug("[JmolTouchSimulator] dispatchTouchEvent(" + touchData.id + ", " + touchData.x + ", " + touchData.y + ", " + touchData.type + ")");
        }
        try {
            this._out.writeInt(-1);
            this._out.writeInt(21);
            this._out.writeInt(touchData.id);
            this._out.writeFloat((float)touchData.x / (float)dimension.width);
            this._out.writeFloat((float)touchData.y / (float)dimension.height);
            this._out.writeByte((byte)touchData.type);
            this._out.writeLong(touchData.when);
        }
        catch (IOException iOException) {
            System.err.println("Failed to send event to server.");
        }
    }

    private class TouchTimerTask
    extends TimerTask {
        private TouchData e;

        TouchTimerTask(TouchData touchData) {
            this.e = touchData;
        }

        public void run() {
            Thread.currentThread().setName("JmolTouchSimulator for type " + this.e.id);
            JmolTouchSimulator.this.dispatchTouchEvent(this.e);
            Integer n = new Integer(this.e.id);
            if (this.e.type == 1) {
                JmolTouchSimulator.this._active.remove(n);
            } else {
                JmolTouchSimulator.this._active.put(n, this.e);
            }
            Thread.currentThread().setName("JmolTouchSimulator idle");
        }
    }

    protected class TouchDataComparator
    implements Comparator {
        protected TouchDataComparator() {
        }

        public int compare(Object object, Object object2) {
            TouchData touchData = (TouchData)object;
            TouchData touchData2 = (TouchData)object2;
            return touchData.delay == touchData2.delay ? (touchData.when < touchData2.when ? -1 : 1) : (touchData.delay < touchData2.delay ? -1 : 1);
        }
    }

    protected class TouchData {
        public int type;
        public int id;
        public int x;
        public int y;
        public long when;
        public long delay;

        protected TouchData() {
        }
    }
}

