/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.export.__CartesianExporter;

public class _MayaExporter
extends __CartesianExporter {
    private int nBalls = 0;
    private int nCyl = 0;
    private String name;
    private String id;

    public _MayaExporter() {
        this.commentChar = "// ";
    }

    protected void outputHeader() {
        this.output("//  Maya ASCII 8.5 scene\n");
        this.output("//  Name: ball_stripped.ma\n");
        this.output("//  Last modified: Thu, Jul 5, 2007 10:25:55 PM\n");
        this.output("//  Codeset: UTF-8\n");
        this.output("requires maya \"8.5\";\n");
        this.output("currentUnit -l centimeter -a degree -t film;\n");
        this.output("fileInfo \"application\" \"maya\";\n");
        this.output("fileInfo \"product\" \"Maya Unlimited 8.5\";\n");
        this.output("fileInfo \"version\" \"8.5\";\n");
        this.output("fileInfo \"cutIdentifier\" \"200612170012-692032\";\n");
        this.output("fileInfo \"osv\" \"Mac OS X 10.4.9\";  \n");
    }

    private void addAttr() {
        this.output(" setAttr -k off \".v\";\n");
        this.output(" setAttr \".vir\" yes;\n");
        this.output(" setAttr \".vif\" yes;\n");
        this.output(" setAttr \".tw\" yes;\n");
        this.output(" setAttr \".covm[0]\"  0 1 1;\n");
        this.output(" setAttr \".cdvm[0]\"  0 1 1;\n");
    }

    private void addConnect() {
        this.output(" connectAttr \"make" + this.name + ".os\" \"" + this.id + ".cr\";\n");
        this.output("connectAttr \"" + this.id + ".iog\" \":initialShadingGroup.dsm\" -na;\n");
    }

    private void setAttr(String string, float f) {
        this.output(" setAttr \"." + string + "\" " + f + ";\n");
    }

    private void setAttr(String string, int n) {
        this.output(" setAttr \"." + string + "\" " + n + ";\n");
    }

    private void setAttr(String string, Tuple3f tuple3f) {
        this.output(" setAttr \"." + string + "\" -type \"double3\" " + tuple3f.x + " " + tuple3f.y + " " + tuple3f.z + ";\n");
    }

    protected boolean outputCylinder(Point3f point3f, Point3f point3f2, Point3f point3f3, short s, byte by, float f, Point3f point3f4, Point3f point3f5) {
        if (point3f4 != null) {
            return false;
        }
        ++this.nCyl;
        this.name = "nurbsCylinder" + this.nCyl;
        this.id = "nurbsCylinderShape" + this.nCyl;
        this.output(" createNode transform -n \"" + this.name + "\";\n");
        float f2 = point3f2.distance(point3f3);
        this.tempV1.set(point3f3);
        this.tempV1.add(point3f2);
        this.tempV1.scale(0.5f);
        this.setAttr("t", this.tempV1);
        this.tempV1.sub(point3f2);
        this.tempV2.set(this.tempV1);
        this.tempV2.normalize();
        float f3 = this.tempV1.length();
        float f4 = (float)Math.acos(this.tempV1.y / f3) * 57.29578f;
        if (this.tempV1.x < 0.0f) {
            f4 += 180.0f;
        }
        float f5 = (float)Math.atan2(this.tempV1.x, this.tempV1.z) * 57.29578f;
        this.tempV2.set(f4, f5, 0.0f);
        this.setAttr("r", this.tempV2);
        this.output(" createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output("createNode makeNurbCylinder -n \"make" + this.name + "\";\n");
        this.output(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", f);
        this.setAttr("s", 4);
        this.setAttr("hr", f2 / f);
        this.addConnect();
        return true;
    }

    protected static void getRotation(Vector3f vector3f, Vector3f vector3f2) {
    }

    protected void outputSphere(Point3f point3f, float f, short s) {
        ++this.nBalls;
        this.name = "nurbsSphere" + this.nBalls;
        this.id = "nurbsSphereShape" + this.nBalls;
        this.output("createNode transform -n \"" + this.name + "\";\n");
        this.setAttr("t", point3f);
        this.output("createNode nurbsSurface -n \"" + this.id + "\" -p \"" + this.name + "\";\n");
        this.addAttr();
        this.output("createNode makeNurbSphere -n \"make" + this.name + "\";\n");
        this.output(" setAttr \".ax\" -type \"double3\" 0 1 0;\n");
        this.setAttr("r", f);
        this.setAttr("s", 4);
        this.setAttr("nsp", 3);
        this.addConnect();
    }

    void drawTextPixel(int n, int n2, int n3, int n4) {
    }

    protected void outputTextPixel(Point3f point3f, int n) {
    }

    protected void outputSurface(Point3f[] point3fArray, Vector3f[] vector3fArray, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BitSet bitSet, int n4, short s, List list, Hashtable hashtable, Point3f point3f) {
    }

    protected void outputTriangle(Point3f point3f, Point3f point3f2, Point3f point3f3, short s) {
    }

    protected void outputCircle(Point3f point3f, Point3f point3f2, float f, short s, boolean bl) {
    }

    protected void outputCone(Point3f point3f, Point3f point3f2, float f, short s) {
    }

    protected void outputEllipsoid(Point3f point3f, Point3f[] point3fArray, short s) {
    }

    protected void outputFace(int[] nArray, int[] nArray2, int n) {
    }

    protected void output(Tuple3f tuple3f) {
    }
}

