/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;

public class Mesh
extends MeshSurface {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    public String[] title;
    public short meshColix;
    public short[] normixes;
    private int normixCount;
    public BitSet[] bitsets;
    public List lineData;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public Point3f lattice;
    public boolean visible = true;
    public int lighting = 1073741958;
    public float scale = 1.0f;
    public boolean haveXyPoints;
    public boolean isPolygonSet;
    public int diameter;
    public float width;
    public Point3f ptCenter = new Point3f(0.0f, 0.0f, 0.0f);
    public String meshType;
    public Mesh linkedMesh;
    public int index;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public boolean insideOut;
    public int checkByteCount;
    public boolean showContourLines = false;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isTwoSided = true;
    public boolean havePlanarContours = false;
    public final Vector3f vAB = new Vector3f();
    public final Vector3f vAC = new Vector3f();
    public final Vector3f vTemp = new Vector3f();
    public List xmlProperties;
    public boolean colorDensity;
    public Object cappingObject;
    public Object slabbingObject;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh(String string, JmolRendererInterface jmolRendererInterface, short s, int n) {
        if (PREVIOUS_MESH_ID.equals(string)) {
            string = null;
        }
        this.thisID = string;
        this.colix = s;
        this.index = n;
    }

    public void clear(String string) {
        this.polygonCount = 0;
        this.vertexCount = 0;
        this.scale = 1.0f;
        this.havePlanarContours = false;
        this.haveXyPoints = false;
        this.showPoints = false;
        this.showContourLines = false;
        this.colorDensity = false;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.showTriangles = false;
        this.isPolygonSet = false;
        this.frontOnly = false;
        this.title = null;
        this.normixes = null;
        this.bitsets = null;
        this.vertices = null;
        this.offsetVertices = null;
        this.polygonIndexes = null;
        this.slabbingObject = null;
        this.cappingObject = null;
        this.meshType = string;
    }

    public void initialize(int n, Point3f[] point3fArray, Point4f point4f) {
        if (point3fArray == null) {
            point3fArray = this.vertices;
        }
        Vector3f[] vector3fArray = this.getNormals(point3fArray, point4f);
        this.normixes = new short[this.normixCount];
        this.isTwoSided = n == 1073741964;
        BitSet bitSet = new BitSet();
        if (this.haveXyPoints) {
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                this.normixes[n2] = 9999;
            }
        } else {
            int n3 = this.normixCount;
            while (--n3 >= 0) {
                this.normixes[n3] = Graphics3D.getNormix(vector3fArray[n3], bitSet);
            }
        }
        this.lighting = 1073741958;
        if (this.insideOut) {
            this.invertNormixes();
        }
        this.setLighting(n);
    }

    public Vector3f[] getNormals(Point3f[] point3fArray, Point4f point4f) {
        this.normixCount = this.isPolygonSet ? this.polygonCount : this.vertexCount;
        Vector3f[] vector3fArray = new Vector3f[this.normixCount];
        int n = this.normixCount;
        while (--n >= 0) {
            vector3fArray[n] = new Vector3f();
        }
        if (point4f == null) {
            this.sumVertexNormals(point3fArray, vector3fArray);
        } else {
            Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                vector3fArray[n2] = vector3f;
            }
        }
        if (!this.isPolygonSet) {
            int n3 = this.normixCount;
            while (--n3 >= 0) {
                vector3fArray[n3].normalize();
            }
        }
        return vector3fArray;
    }

    public void setLighting(int n) {
        if (n == this.lighting) {
            return;
        }
        this.flipLighting(this.lighting);
        this.lighting = n;
        this.flipLighting(this.lighting);
    }

    private void flipLighting(int n) {
        if (n == 1073741964) {
            int n2 = this.normixCount;
            while (--n2 >= 0) {
                this.normixes[n2] = ~this.normixes[n2];
            }
        } else if (n == 1073741958 == this.insideOut) {
            this.invertNormixes();
        }
    }

    private void invertNormixes() {
        int n = this.normixCount;
        while (--n >= 0) {
            this.normixes[n] = Graphics3D.getInverseNormix(this.normixes[n]);
        }
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = Graphics3D.getColixTranslucent(this.colix, bl, f);
    }

    protected void sumVertexNormals(Point3f[] point3fArray, Vector3f[] vector3fArray) {
        int n = this.checkByteCount;
        int n2 = this.polygonCount;
        while (--n2 >= 0) {
            int[] nArray = this.polygonIndexes[n2];
            if (nArray == null) continue;
            try {
                Point3f point3f = point3fArray[nArray[0]];
                Point3f point3f2 = point3fArray[nArray[1]];
                Point3f point3f3 = point3fArray[nArray[2]];
                if ((double)point3f.distanceSquared(point3f2) < 1.0E-4 || (double)point3f2.distanceSquared(point3f3) < 1.0E-4 || (double)point3f.distanceSquared(point3f3) < 1.0E-4) continue;
                Measure.calcNormalizedNormal(point3f, point3f2, point3f3, this.vTemp, this.vAB, this.vAC);
                if (this.isPolygonSet) {
                    vector3fArray[n2].set(this.vTemp);
                    continue;
                }
                float f = this.vTemp.length();
                if (!((double)f > 0.9) || !((double)f < 1.1)) continue;
                int n3 = nArray.length - n;
                while (--n3 >= 0) {
                    int n4 = nArray[n3];
                    vector3fArray[n4].add(this.vTemp);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    public String getState(String string) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append("/** XML ** ").append(string2).append(" ** XML **/\n");
        }
        stringBuffer.append(string);
        if (!string.equals("mo")) {
            stringBuffer.append(" ID ").append(Escape.escape(this.thisID));
        }
        if (this.lattice != null) {
            stringBuffer.append(" lattice ").append(Escape.escape(this.lattice));
        }
        if (this.meshColix != 0) {
            stringBuffer.append(" color mesh ").append(Graphics3D.getHexCode(this.meshColix));
        }
        stringBuffer.append(this.fillTriangles ? " fill" : " noFill");
        stringBuffer.append(this.drawTriangles ? " mesh" : " noMesh");
        stringBuffer.append(this.showPoints ? " dots" : " noDots");
        stringBuffer.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showContourLines) {
            stringBuffer.append(" contourlines");
        }
        if (this.showTriangles) {
            stringBuffer.append(" triangles");
        }
        stringBuffer.append(this.lighting == 1073741862 ? " backlit" : (this.lighting == 1073741964 ? " fullylit" : " frontlit"));
        if (!this.visible) {
            stringBuffer.append(" hidden");
        }
        return stringBuffer.toString();
    }

    public Point3f[] getOffsetVertices(Point4f point4f) {
        if (this.offsetVertices != null) {
            return this.offsetVertices;
        }
        this.offsetVertices = new Point3f[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            this.offsetVertices[i] = new Point3f(this.vertices[i]);
        }
        Vector3f vector3f = null;
        float f = 0.0f;
        if (this.scale3d != 0.0f && this.vertexValues != null && point4f != null) {
            vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
            vector3f.normalize();
            vector3f.scale(this.scale3d);
        }
        for (int i = 0; i < this.vertexCount; ++i) {
            if (this.vertexValues != null && Float.isNaN(f = this.vertexValues[i])) continue;
            Point3f point3f = this.offsetVertices[i];
            if (this.ptOffset != null) {
                point3f.add(this.ptOffset);
            }
            if (vector3f == null || f == 0.0f) continue;
            point3f.scaleAdd(f, vector3f, point3f);
        }
        this.initialize(this.lighting, this.offsetVertices, null);
        return this.offsetVertices;
    }

    public int getVertexIndexFromNumber(int n) {
        if (--n < 0) {
            n = this.vertexCount + n;
        }
        return this.vertexCount <= n ? this.vertexCount - 1 : (n < 0 ? 0 : n);
    }
}

