/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.TextFormat;
import org.openscience.jmol.app.webexport.JmolInstance;
import org.openscience.jmol.app.webexport.WebExport;
import org.openscience.jmol.app.webexport.WebPanel;

class PopInJmol
extends WebPanel
implements ChangeListener {
    PopInJmol(JmolViewer jmolViewer, JFileChooser jFileChooser, WebPanel[] webPanelArray, int n) {
        super(jmolViewer, jFileChooser, webPanelArray, n);
        this.panelName = "pop_in";
        this.listLabel = GT._("These names will be used as filenames for the applets");
    }

    JPanel appletParamPanel() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(WebExport.getPopInWidth(), 50, 1000, 25);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(WebExport.getPopInHeight(), 50, 1000, 25);
        this.appletSizeSpinnerW = new JSpinner(spinnerNumberModel);
        this.appletSizeSpinnerW.addChangeListener(this);
        this.appletSizeSpinnerH = new JSpinner(spinnerNumberModel2);
        this.appletSizeSpinnerH.addChangeListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(GT._("Applet width:")));
        jPanel.add(this.appletSizeSpinnerW);
        jPanel.add(new JLabel(GT._("height:")));
        jPanel.add(this.appletSizeSpinnerH);
        return jPanel;
    }

    String fixHtml(String string) {
        return string;
    }

    String getAppletDefs(int n, String string, StringBuffer stringBuffer, JmolInstance jmolInstance) {
        String string2 = n % 2 == 0 ? "floatRightDiv" : "floatLeftDiv";
        String string3 = jmolInstance.name;
        String string4 = jmolInstance.javaname;
        int n2 = jmolInstance.width;
        int n3 = jmolInstance.height;
        String string5 = "";
        if (!jmolInstance.whichWidgets.isEmpty()) {
            string5 = string5 + "<div id=\"JmolCntl" + n + "\" style=\"display:none;\">";
            for (int i = 0; i < this.nWidgets; ++i) {
                if (!jmolInstance.whichWidgets.get(i)) continue;
                string5 = string5 + "\n<div>" + this.theWidgets.widgetList[i].getJavaScript(n, jmolInstance) + "</div>\n";
            }
            string5 = string5 + "</div>";
        }
        if (this.useAppletJS) {
            this.appletInfoDivs = this.appletInfoDivs + "\n<div id=\"" + string4 + "_caption\">\n" + GT.escapeHTML(GT._("insert a caption for {0} here.", string3)) + "\n</div>";
            this.appletInfoDivs = this.appletInfoDivs + "\n<div id=\"" + string4 + "_note\">\n" + GT.escapeHTML(GT._("insert a note for {0} here.", string3)) + "\n</div>";
            stringBuffer.append("\naddJmolDiv(" + n + ",'" + string2 + "','" + string4 + "'," + n2 + "," + n3 + ")");
        } else {
            String string6 = this.htmlAppletTemplate;
            string6 = TextFormat.simpleReplace(string6, "@CLASS@", "" + string2);
            string6 = TextFormat.simpleReplace(string6, "@I@", "" + n);
            string6 = TextFormat.simpleReplace(string6, "@WIDTH@", "" + n2);
            string6 = TextFormat.simpleReplace(string6, "@HEIGHT@", "" + n3);
            string6 = TextFormat.simpleReplace(string6, "@NAME@", GT.escapeHTML(string3));
            string6 = TextFormat.simpleReplace(string6, "@APPLETNAME@", GT.escapeHTML(string4));
            string6 = TextFormat.simpleReplace(string6, "@LEFTWIDGETS@", "");
            string6 = TextFormat.simpleReplace(string6, "@RIGHTWIDGETS@", string5);
            stringBuffer.append(string6);
        }
        return string;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.appletSizeSpinnerW || changeEvent.getSource() == this.appletSizeSpinnerH) {
            int n = ((SpinnerNumberModel)this.appletSizeSpinnerW.getModel()).getNumber().intValue();
            int n2 = ((SpinnerNumberModel)this.appletSizeSpinnerH.getModel()).getNumber().intValue();
            WebExport.setPopInDim(n, n2);
            JList jList = this.getInstanceList();
            int[] nArray = jList.getSelectedIndices();
            if (nArray.length != 1) {
                return;
            }
            int n3 = jList.getSelectedIndex();
            JmolInstance jmolInstance = (JmolInstance)jList.getModel().getElementAt(n3);
            jmolInstance.width = n;
            jmolInstance.height = n2;
            this.viewer.createImage(jmolInstance.pictFile, "PNG", null, 2, n, n2);
            return;
        }
        if (changeEvent.getSource() == this.appletSizeSpinnerP) {
            int n = ((SpinnerNumberModel)this.appletSizeSpinnerP.getModel()).getNumber().intValue();
            WebExport.setScriptButtonPercent(n);
            return;
        }
    }
}

