/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.modifications;

import com.compomics.cli.modifications.ModificationsCLIInputBean;
import com.compomics.cli.modifications.ModificationsCLIParams;
import com.compomics.cli.paths.PathSettingsCLI;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;

public class ModificationsCLI {
    private final ModificationsCLIInputBean modificationsCLIInputBean;

    public ModificationsCLI(ModificationsCLIInputBean modificationsCLIInputBean) {
        this.modificationsCLIInputBean = modificationsCLIInputBean;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The ModificationsCLI command line allows the command line management of modifications. It can be used to create and edit json files containing modifications compatible with CompOmics tools." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    public static void main(String[] args) {
        try {
            String[] nonPathSettingArgsAsList = PathSettingsCLI.extractAndUpdatePathOptions(args);
            Options nonPathOptions = new Options();
            ModificationsCLIParams.createOptionsCLI(nonPathOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(nonPathOptions, nonPathSettingArgsAsList);
            if (!ModificationsCLIInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "========================================" + System.getProperty("line.separator"));
                lPrintWriter.print("Compomics Modifications - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("========================================" + System.getProperty("line.separator"));
                lPrintWriter.print(ModificationsCLI.getHeader());
                lPrintWriter.print(ModificationsCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                ModificationsCLIInputBean inputBean = new ModificationsCLIInputBean(line);
                ModificationsCLI cli = new ModificationsCLI(inputBean);
                cli.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("<CompomicsError>ModificationsCLI used up all the memory and had to be stopped.</CompomicsError>");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.print("<CompomicsError>ModificationsCLI processing failed.</CompomicsError>");
            e.printStackTrace();
        }
    }

    public String toString() {
        return "ModificationsCLI{, cliInputBean=" + this.modificationsCLIInputBean + '}';
    }

    public Object call() {
        File outputFile;
        Modification modificationToAdd;
        ModificationFactory modificationFactory;
        File inputFile = this.modificationsCLIInputBean.getFileIn();
        if (inputFile != null) {
            try {
                modificationFactory = ModificationFactory.loadFromFile(inputFile);
            }
            catch (IOException e) {
                System.out.println("An error occurred while reading modifications from " + inputFile + ".");
                return 1;
            }
        } else {
            modificationFactory = ModificationFactory.getInstance();
        }
        if (this.modificationsCLIInputBean.isList()) {
            for (String ptmName : modificationFactory.getModifications()) {
                Modification ptm = modificationFactory.getModification(ptmName);
                System.out.println(ptm);
                System.out.println();
            }
            return 0;
        }
        String modificationToRemove = this.modificationsCLIInputBean.getModificationToRemove();
        if (modificationToRemove != null) {
            modificationFactory.removeUserPtm(modificationToRemove);
        }
        if ((modificationToAdd = this.modificationsCLIInputBean.getModificationToAdd()) != null) {
            modificationFactory.addUserModification(modificationToAdd);
        }
        if ((outputFile = this.modificationsCLIInputBean.getFileOut()) != null) {
            try {
                ModificationFactory.saveToFile(modificationFactory, outputFile);
            }
            catch (IOException e) {
                System.out.println("An error occurred while saving the modifications to " + outputFile + ".");
                return 1;
            }
        }
        return 0;
    }
}

