/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.db.ColumnTypeConverter;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DBMetaData {
    Logger logger = LogManager.getLogger(DBMetaData.class);
    private String iTable = null;
    private String[] iColumns = null;
    private int[] iColTypes = null;
    private String[] iConColTypes = null;
    private int[] iColSizes = null;
    private String[] iPKColumns = null;

    public DBMetaData() {
    }

    public DBMetaData(String aTable, String[] aColumns, int[] aColTypes, int[] aColSizes) {
        this(aTable, aColumns, aColTypes, aColSizes, new String[0]);
    }

    public DBMetaData(String aTable, String[] aColumns, int[] aColTypes, int[] aColSizes, String[] aPKColumns) {
        if (aTable == null) {
            throw new IllegalArgumentException("Tablename was 'null'!");
        }
        if (aColumns.length != aColTypes.length) {
            throw new IllegalArgumentException("Columnnames count does not equal column types count: names (" + aColumns.length + ") <> types (" + aColTypes.length + ")!");
        }
        this.iTable = aTable;
        this.iColumns = aColumns;
        this.iColTypes = aColTypes;
        this.iColSizes = aColSizes;
        this.iConColTypes = ColumnTypeConverter.convertTypes(this.iColTypes, this.iColSizes);
        this.iPKColumns = aPKColumns;
    }

    public DBMetaData(String aTable, Vector aColumns, Vector aColTypes, Vector aColSizes) {
        this(aTable, aColumns, aColTypes, aColSizes, new Vector());
    }

    public DBMetaData(String aTable, Vector aColumns, Vector aColTypes, Vector aColSizes, Vector aPKColumns) {
        int i;
        if (aTable == null) {
            throw new IllegalArgumentException("Tablename was 'null'!");
        }
        if (aColumns.size() != aColTypes.size() || aColTypes.size() != aColSizes.size()) {
            throw new IllegalArgumentException("Columnnames count does not equal column types count and/or column size count: names (" + aColumns.size() + ") <> types (" + aColTypes.size() + ") <> sizes (" + aColSizes.size() + ")!");
        }
        String[] names = new String[aColumns.size()];
        aColumns.toArray(names);
        int liSize = aColTypes.size();
        int[] types = new int[liSize];
        int[] sizes = new int[liSize];
        for (i = 0; i < liSize; ++i) {
            Integer lInteger = (Integer)aColTypes.elementAt(i);
            types[i] = lInteger;
            sizes[i] = (Integer)aColSizes.elementAt(i);
        }
        liSize = aPKColumns.size();
        this.iPKColumns = new String[liSize];
        for (i = 0; i < liSize; ++i) {
            this.iPKColumns[i] = (String)aPKColumns.elementAt(i);
        }
        this.iTable = aTable;
        this.iColumns = names;
        this.iColTypes = types;
        this.iColSizes = sizes;
        this.iConColTypes = ColumnTypeConverter.convertTypes(this.iColTypes, this.iColSizes);
    }

    public String getTableName() {
        return this.iTable;
    }

    public String[] getColumnNames() {
        return this.iColumns;
    }

    public int[] getCodedColumnTypes() {
        return this.iColTypes;
    }

    public int[] getColumnSizes() {
        return this.iColSizes;
    }

    public String[] getConvertedColumnTypes() {
        return this.iConColTypes;
    }

    public int getColumnCount() {
        return this.iColumns.length;
    }

    public String getColumnName(int aColumnIndex) {
        String result = null;
        try {
            result = this.iColumns[aColumnIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public int getCodedColumnType(String aColumnName) {
        int result = -1;
        for (int i = 0; i < this.iColumns.length; ++i) {
            String lColumn = this.iColumns[i].trim();
            if (!aColumnName.trim().equalsIgnoreCase(lColumn)) continue;
            result = this.iColTypes[i];
            break;
        }
        return result;
    }

    public int getColumnSize(String aColumnName) {
        int result = -1;
        for (int i = 0; i < this.iColumns.length; ++i) {
            String lColumn = this.iColumns[i].trim();
            if (!aColumnName.trim().equalsIgnoreCase(lColumn)) continue;
            result = this.iColSizes[i];
            break;
        }
        return result;
    }

    public String getConvertedColumnType(String aColumnName) {
        String result = null;
        for (int i = 0; i < this.iColumns.length; ++i) {
            String lColumn = this.iColumns[i].trim();
            if (!aColumnName.trim().equalsIgnoreCase(lColumn)) continue;
            result = this.iConColTypes[i];
            break;
        }
        return result;
    }

    public int getCodedColumnType(int aColumnIndex) {
        int result = -1;
        try {
            result = this.iColTypes[aColumnIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public int getColumnSize(int aColumnIndex) {
        int result = -1;
        try {
            result = this.iColSizes[aColumnIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public String getConvertedColumnType(int aColumnIndex) {
        String result = null;
        try {
            result = this.iConColTypes[aColumnIndex];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public String[] getPrimaryKeyColumns() {
        return this.iPKColumns;
    }

    public String toString() {
        int i;
        StringBuffer lsb = new StringBuffer("---------------------------------------------------\n  This is the metadata for the table '" + this.iTable + "':\n\n");
        for (i = 0; i < this.iColumns.length; ++i) {
            lsb.append("\t- " + this.iColumns[i] + " : ");
            lsb.append(this.iColTypes[i] + " (" + this.iConColTypes[i] + ")\n");
        }
        lsb.append("\n\n  Primary keys:\n\n");
        for (i = 0; i < this.iPKColumns.length; ++i) {
            lsb.append("\t- " + this.iPKColumns[i] + "\n");
        }
        lsb.append("---------------------------------------------------\n");
        return lsb.toString();
    }
}

