/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.atoms;

import com.compomics.util.experiment.biology.atoms.impl.Calcium;
import com.compomics.util.experiment.biology.atoms.impl.Carbon;
import com.compomics.util.experiment.biology.atoms.impl.Chlorine;
import com.compomics.util.experiment.biology.atoms.impl.Cobalt;
import com.compomics.util.experiment.biology.atoms.impl.Copper;
import com.compomics.util.experiment.biology.atoms.impl.Fluorine;
import com.compomics.util.experiment.biology.atoms.impl.Helium;
import com.compomics.util.experiment.biology.atoms.impl.Hydrogen;
import com.compomics.util.experiment.biology.atoms.impl.Iodine;
import com.compomics.util.experiment.biology.atoms.impl.Iron;
import com.compomics.util.experiment.biology.atoms.impl.Lithium;
import com.compomics.util.experiment.biology.atoms.impl.Magnesium;
import com.compomics.util.experiment.biology.atoms.impl.Manganese;
import com.compomics.util.experiment.biology.atoms.impl.Nickel;
import com.compomics.util.experiment.biology.atoms.impl.Nitrogen;
import com.compomics.util.experiment.biology.atoms.impl.Oxygen;
import com.compomics.util.experiment.biology.atoms.impl.Phosphorus;
import com.compomics.util.experiment.biology.atoms.impl.Potassium;
import com.compomics.util.experiment.biology.atoms.impl.Selenium;
import com.compomics.util.experiment.biology.atoms.impl.Sodium;
import com.compomics.util.experiment.biology.atoms.impl.Sulfur;
import com.compomics.util.experiment.biology.atoms.impl.Zinc;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Atom
extends ExperimentObject {
    static final long serialVersionUID = 1059024301538472131L;
    public static final Atom H = new Hydrogen();
    public static final Atom N = new Nitrogen();
    public static final Atom O = new Oxygen();
    public static final Atom C = new Carbon();
    public static final Atom S = new Sulfur();
    public static final Atom P = new Phosphorus();
    public static final Atom He = new Helium();
    public static final Atom Li = new Lithium();
    public static final Atom Na = new Sodium();
    public static final Atom Se = new Selenium();
    public static final Atom I = new Iodine();
    public static final Atom F = new Fluorine();
    public static final Atom Fe = new Iron();
    public static final Atom K = new Potassium();
    public static final Atom Ca = new Calcium();
    public static final Atom Zn = new Zinc();
    public static final Atom Mg = new Magnesium();
    public static final Atom Cu = new Copper();
    public static final Atom Cl = new Chlorine();
    public static final Atom Co = new Cobalt();
    public static final Atom Ni = new Nickel();
    public static final Atom Mn = new Manganese();
    protected double monoisotopicMass;
    protected HashMap<Integer, Double> isotopeMap;
    protected HashMap<Integer, Double> representativeComposition;
    protected String name;
    protected String letter;

    public static String[] getImplementedAtoms(boolean includeSelect) {
        if (includeSelect) {
            return new String[]{"- Select -", "C", "H", "I", "N", "O", "S", "P", "He", "Li", "Na", "Se", "F", "Fe", "K", "Ca", "Zn", "Mg", "Cu", "Cl", "Co", "Ni", "Mn"};
        }
        return new String[]{"C", "H", "I", "N", "O", "S", "P", "He", "Li", "Na", "Se", "F", "Fe", "K", "Ca", "Zn", "Mg", "Cu", "Cl", "Co", "Ni", "Mn"};
    }

    public static Atom getAtom(String shortName) {
        switch (shortName) {
            case "H": {
                return H;
            }
            case "I": {
                return I;
            }
            case "N": {
                return N;
            }
            case "O": {
                return O;
            }
            case "C": {
                return C;
            }
            case "S": {
                return S;
            }
            case "P": {
                return P;
            }
            case "He": {
                return He;
            }
            case "Li": {
                return Li;
            }
            case "Na": {
                return Na;
            }
            case "Se": {
                return Se;
            }
            case "F": {
                return F;
            }
            case "Fe": {
                return Fe;
            }
            case "K": {
                return K;
            }
            case "Ca": {
                return Ca;
            }
            case "Zn": {
                return Zn;
            }
            case "Mg": {
                return Mg;
            }
            case "Cu": {
                return Cu;
            }
            case "Cl": {
                return Cl;
            }
            case "Co": {
                return Co;
            }
            case "Ni": {
                return Ni;
            }
            case "Mn": {
                return Mn;
            }
        }
        throw new UnsupportedOperationException("Atom " + shortName + " not implemented.");
    }

    public double getMonoisotopicMass() {
        return this.monoisotopicMass;
    }

    public String getName() {
        return this.name;
    }

    public String getLetter() {
        return this.letter;
    }

    public ArrayList<Integer> getImplementedIsotopes() {
        if (this.isotopeMap != null) {
            return new ArrayList<Integer>(this.isotopeMap.keySet());
        }
        return new ArrayList<Integer>();
    }

    public Double getIsotopeMass(int isotopeNumber) {
        if (this.isotopeMap != null) {
            return this.isotopeMap.get(isotopeNumber);
        }
        return null;
    }

    public double getDifferenceToMonoisotopic(int isotopeNumber) {
        if (!this.isotopeMap.containsKey(isotopeNumber)) {
            throw new IllegalArgumentException("No isotope mass found for isotope " + isotopeNumber + " of atom " + this.name + ".");
        }
        double isotopeMass = this.isotopeMap.get(isotopeNumber);
        return isotopeMass - this.getMonoisotopicMass();
    }

    public String toString() {
        return this.getLetter();
    }
}

