/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.atoms;

import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.personalization.ExperimentObject;

public class AtomImpl
extends ExperimentObject {
    static final long serialVersionUID = 3269643086590455656L;
    private Atom atom;
    private String atomSymbol;
    private Integer isotope;

    public AtomImpl() {
    }

    public AtomImpl(String atomSymbol, Integer isotope) {
        this.atomSymbol = atomSymbol;
        this.isotope = isotope;
    }

    public AtomImpl(Atom atom, Integer isotope) {
        this.atomSymbol = atom.getLetter();
        this.isotope = isotope;
    }

    public Double getMass() {
        Atom tempAtom = Atom.getAtom(this.atomSymbol);
        return tempAtom.getIsotopeMass(this.isotope);
    }

    public Integer getIsotopeNumber(Integer roundedMass) {
        Atom tempAtom = Atom.getAtom(this.atomSymbol);
        for (Integer isotopeNumber : tempAtom.getImplementedIsotopes()) {
            Double isotopeMass = tempAtom.getIsotopeMass(isotopeNumber);
            Integer isotopeRoundedMass = (int)Math.round(isotopeMass);
            if (!roundedMass.equals(isotopeRoundedMass)) continue;
            return isotopeNumber;
        }
        return null;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean isotopeCurlyBrackets) {
        Atom tempAtom = Atom.getAtom(this.atomSymbol);
        if (this.isotope == 0) {
            return tempAtom.getLetter();
        }
        if (this.getMass() == null) {
            throw new UnsupportedOperationException("Isotope " + this.isotope + " not implemented for atom " + tempAtom + ".");
        }
        if (isotopeCurlyBrackets) {
            return tempAtom.getLetter() + "{" + Math.round(this.getMass()) + "}";
        }
        return Math.round(this.getMass()) + tempAtom.getLetter();
    }

    public boolean isSameAs(AtomImpl anotherAtom) {
        return this.toString().equals(anotherAtom.toString());
    }

    public String getAtomSymbol() {
        if (this.atomSymbol == null) {
            this.atomSymbol = this.atom.getLetter();
        }
        return this.atomSymbol;
    }

    public void setAtomSymbol(String atomSymbol) {
        this.atomSymbol = atomSymbol;
    }

    public Integer getIsotope() {
        return this.isotope;
    }

    public void setIsotope(Integer isotope) {
        this.isotope = isotope;
    }
}

