/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.enzymes;

import com.compomics.util.experiment.biology.aminoacids.AminoAcid;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.stream.Collectors;

public class Enzyme
extends ExperimentObject {
    private final String name;
    private final HashSet<Character> aminoAcidBefore = new HashSet(0);
    private final HashSet<Character> aminoAcidAfter = new HashSet(0);
    private final HashSet<Character> restrictionBefore = new HashSet(0);
    private final HashSet<Character> restrictionAfter = new HashSet(0);
    private CvTerm cvTerm;

    public Enzyme() {
        this.name = "";
    }

    public Enzyme(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addAminoAcidAfter(Character aminoAcid) {
        this.aminoAcidAfter.add(aminoAcid);
    }

    public HashSet<Character> getAminoAcidAfter() {
        return this.aminoAcidAfter;
    }

    public void addAminoAcidBefore(Character aminoAcid) {
        this.aminoAcidBefore.add(aminoAcid);
    }

    public HashSet<Character> getAminoAcidBefore() {
        return this.aminoAcidBefore;
    }

    public void addRestrictionAfter(Character aminoAcid) {
        this.restrictionAfter.add(aminoAcid);
    }

    public HashSet<Character> getRestrictionAfter() {
        return this.restrictionAfter;
    }

    public void addRestrictionBefore(Character aminoAcid) {
        this.restrictionBefore.add(aminoAcid);
    }

    public HashSet<Character> getRestrictionBefore() {
        return this.restrictionBefore;
    }

    public boolean isCleavageSite(String aaBefore, String aaAfter) {
        if (aaBefore.length() == 0 || aaAfter.length() == 0) {
            return true;
        }
        return this.isCleavageSite(aaBefore.charAt(aaBefore.length() - 1), aaAfter.charAt(0));
    }

    public boolean isCleavageSite(char aaBefore, char aaAfter) {
        boolean restriction;
        AminoAcid aminoAcid1 = AminoAcid.getAminoAcid(aaBefore);
        AminoAcid aminoAcid2 = AminoAcid.getAminoAcid(aaAfter);
        for (char possibleAaBefore : aminoAcid1.getSubAminoAcids()) {
            if (!this.aminoAcidBefore.contains(Character.valueOf(possibleAaBefore))) continue;
            restriction = false;
            for (char possibleAaAfter : aminoAcid2.getSubAminoAcids()) {
                if (!this.restrictionAfter.contains(Character.valueOf(possibleAaAfter))) continue;
                restriction = true;
                break;
            }
            if (restriction) continue;
            return true;
        }
        for (char possibleAaAfter : aminoAcid2.getSubAminoAcids()) {
            if (!this.aminoAcidAfter.contains(Character.valueOf(possibleAaAfter))) continue;
            restriction = false;
            for (char possibleAaBefore : aminoAcid1.getSubAminoAcids()) {
                if (!this.restrictionBefore.contains(Character.valueOf(possibleAaBefore))) continue;
                restriction = true;
                break;
            }
            if (restriction) continue;
            return true;
        }
        return false;
    }

    public boolean isCleavageSiteNoCombination(Character aaBefore, Character aaAfter) {
        return this.aminoAcidBefore.contains(aaBefore) && !this.restrictionAfter.contains(aaAfter) || this.aminoAcidAfter.contains(aaAfter) && !this.restrictionBefore.contains(aaBefore);
    }

    public int getNmissedCleavages(String sequence) {
        int result = 0;
        if (sequence.length() > 1) {
            for (int i = 0; i < sequence.length() - 1; ++i) {
                if (!this.isCleavageSite(sequence.charAt(i), sequence.charAt(i + 1))) continue;
                ++result;
            }
        }
        return result;
    }

    public HashSet<String> digest(String sequence, int nMissedCleavages, Integer nMin, Integer nMax) {
        int i;
        char aaAfter = sequence.charAt(0);
        StringBuilder currentPeptide = new StringBuilder();
        currentPeptide.append(aaAfter);
        HashSet<String> results = new HashSet<String>();
        HashMap mc = new HashMap();
        for (i = 1; i <= nMissedCleavages; ++i) {
            mc.put(i, new ArrayList(nMissedCleavages));
        }
        for (i = 1; i < sequence.length(); ++i) {
            char aaBefore = aaAfter;
            char aa = sequence.charAt(i);
            if (this.isCleavageSite(aaBefore, aaAfter = aa) && currentPeptide.length() != 0) {
                String currentPeptideString = currentPeptide.toString();
                if (!(nMin != null && currentPeptide.length() < nMin || nMax != null && currentPeptide.length() > nMax)) {
                    results.add(currentPeptideString);
                }
                Iterator iterator = mc.keySet().iterator();
                while (iterator.hasNext()) {
                    int nMc = (Integer)iterator.next();
                    ((ArrayList)mc.get(nMc)).add(currentPeptideString);
                    while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                        ((ArrayList)mc.get(nMc)).remove(0);
                    }
                    StringBuilder mcSequence = new StringBuilder();
                    for (String subPeptide : (ArrayList)mc.get(nMc)) {
                        mcSequence.append(subPeptide);
                    }
                    if (nMin != null && mcSequence.length() < nMin || nMax != null && mcSequence.length() > nMax) continue;
                    results.add(mcSequence.toString());
                }
                currentPeptide = new StringBuilder();
            }
            currentPeptide.append(aa);
        }
        String currentPeptideString = currentPeptide.toString();
        if (!(nMin != null && currentPeptide.length() < nMin || nMax != null && currentPeptide.length() > nMax)) {
            results.add(currentPeptideString);
        }
        Iterator iterator = mc.keySet().iterator();
        while (iterator.hasNext()) {
            int nMc = (Integer)iterator.next();
            ((ArrayList)mc.get(nMc)).add(currentPeptideString);
            while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                ((ArrayList)mc.get(nMc)).remove(0);
            }
            StringBuilder mcSequence = new StringBuilder();
            for (String subPeptide : (ArrayList)mc.get(nMc)) {
                mcSequence.append(subPeptide);
            }
            if (nMin != null && mcSequence.length() < nMin || nMax != null && mcSequence.length() > nMax) continue;
            results.add(mcSequence.toString());
        }
        return results;
    }

    public HashSet<String> digest(String sequence, int nMissedCleavages, Double massMin, Double massMax) {
        char aaAfter = sequence.charAt(0);
        StringBuilder currentPeptide = new StringBuilder();
        currentPeptide.append(aaAfter);
        Double currentMass = AminoAcid.getAminoAcid(aaAfter).getMonoisotopicMass();
        HashSet<String> results = new HashSet<String>();
        HashMap mc = new HashMap();
        for (int i = 1; i <= nMissedCleavages; ++i) {
            mc.put(i, new ArrayList(nMissedCleavages));
        }
        HashMap<String, Double> peptideMasses = new HashMap<String, Double>();
        for (int i = 1; i < sequence.length(); ++i) {
            char aaBefore = aaAfter;
            char aa = sequence.charAt(i);
            if (this.isCleavageSite(aaBefore, aaAfter = aa) && currentPeptide.length() > 0) {
                String currentPeptideString = currentPeptide.toString();
                if ((massMin == null || currentMass >= massMin) && (massMax == null || currentMass <= massMax)) {
                    results.add(currentPeptideString);
                }
                Iterator iterator = mc.keySet().iterator();
                while (iterator.hasNext()) {
                    int nMc = (Integer)iterator.next();
                    ((ArrayList)mc.get(nMc)).add(currentPeptideString);
                    peptideMasses.put(currentPeptideString, currentMass);
                    while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                        ((ArrayList)mc.get(nMc)).remove(0);
                    }
                    StringBuilder mcSequence = new StringBuilder();
                    double mcMass = 0.0;
                    for (String subPeptide : (ArrayList)mc.get(nMc)) {
                        mcSequence.append(subPeptide);
                        mcMass += ((Double)peptideMasses.get(subPeptide)).doubleValue();
                    }
                    if (massMin != null && !(mcMass >= massMin) || massMax != null && !(mcMass <= massMax)) continue;
                    results.add(mcSequence.toString());
                }
                currentPeptide = new StringBuilder();
            }
            currentPeptide.append(aa);
            currentMass = currentMass + AminoAcid.getAminoAcid(aa).getMonoisotopicMass();
        }
        String currentPeptideString = currentPeptide.toString();
        if ((massMin == null || currentMass >= massMin) && (massMax == null || currentMass <= massMax)) {
            results.add(currentPeptideString);
        }
        Iterator iterator = mc.keySet().iterator();
        while (iterator.hasNext()) {
            int nMc = (Integer)iterator.next();
            ((ArrayList)mc.get(nMc)).add(currentPeptideString);
            peptideMasses.put(currentPeptideString, currentMass);
            while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                ((ArrayList)mc.get(nMc)).remove(0);
            }
            StringBuilder mcSequence = new StringBuilder();
            double mcMass = 0.0;
            for (String subPeptide : (ArrayList)mc.get(nMc)) {
                mcSequence.append(subPeptide);
                mcMass += ((Double)peptideMasses.get(subPeptide)).doubleValue();
            }
            if (massMin != null && !(mcMass >= massMin) || massMax != null && !(mcMass <= massMax)) continue;
            results.add(mcSequence.toString());
        }
        return results;
    }

    public boolean equals(Enzyme otherEnzyme) {
        if (otherEnzyme == null) {
            return false;
        }
        if (!this.getName().equalsIgnoreCase(otherEnzyme.getName())) {
            return false;
        }
        if (!this.getAminoAcidBefore().equals(otherEnzyme.getAminoAcidBefore())) {
            return false;
        }
        if (!this.getRestrictionBefore().equals(otherEnzyme.getRestrictionBefore())) {
            return false;
        }
        if (!this.getAminoAcidAfter().equals(otherEnzyme.getAminoAcidAfter())) {
            return false;
        }
        return this.getRestrictionAfter().equals(otherEnzyme.getRestrictionAfter());
    }

    public String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append("Cleaves ");
        if (!this.getAminoAcidBefore().isEmpty()) {
            description.append("after ");
            description.append(this.getAminoAcidBefore().stream().sorted().map(aa -> aa.toString()).collect(Collectors.joining()));
            if (!this.getAminoAcidAfter().isEmpty()) {
                description.append(" and ");
            }
        }
        if (!this.getAminoAcidAfter().isEmpty()) {
            description.append("before ");
            description.append(this.getAminoAcidAfter().stream().sorted().map(aa -> aa.toString()).collect(Collectors.joining()));
        }
        if (!this.getRestrictionBefore().isEmpty()) {
            description.append(" not preceeded by ");
            description.append(this.getRestrictionBefore().stream().sorted().map(aa -> aa.toString()).collect(Collectors.joining()));
            if (!this.getRestrictionAfter().isEmpty()) {
                description.append(" and ");
            }
        }
        if (!this.getRestrictionAfter().isEmpty()) {
            description.append(" not followed by ");
            description.append(this.getRestrictionAfter().stream().sorted().map(aa -> aa.toString()).collect(Collectors.joining()));
        }
        return description.toString();
    }

    public CvTerm getCvTerm() {
        return this.cvTerm;
    }

    public void setCvTerm(CvTerm cvTerm) {
        this.cvTerm = cvTerm;
    }
}

