/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.genes;

import com.compomics.util.experiment.biology.genes.ensembl.GeneMapping;
import com.compomics.util.experiment.biology.genes.go.GoMapping;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class GeneMaps
extends ExperimentObject {
    private HashMap<String, String> ensemblVersionsMap = new HashMap();
    private HashMap<String, String> geneNameToEnsemblIdMap = new HashMap();
    private HashMap<String, String> geneNameToChromosomeMap = new HashMap();
    private HashMap<String, HashSet<String>> proteinToGoMap = new HashMap();
    private HashMap<String, HashSet<String>> goAccessionToProteinMap = new HashMap();
    private HashMap<String, String> goNamesMap = new HashMap();

    public void importMaps(GeneMapping geneMapping) {
        this.geneNameToChromosomeMap.putAll(geneMapping.getGeneNameToChromosome());
        this.geneNameToEnsemblIdMap.putAll(geneMapping.getGeneNameToAccession());
    }

    public void setMaps(GoMapping goMapping) {
        this.goNamesMap.putAll(goMapping.getGoNamesMap());
        HashMap<String, HashSet<String>> otherMap = goMapping.getProteinToGoMap();
        for (String accession : otherMap.keySet()) {
            HashSet<String> goTerms = this.proteinToGoMap.get(accession);
            if (goTerms == null) {
                goTerms = new HashSet();
                this.proteinToGoMap.put(accession, goTerms);
            }
            goTerms.addAll((Collection<String>)otherMap.get(accession));
        }
        otherMap = goMapping.getGoToProteinMap();
        for (String accession : otherMap.keySet()) {
            HashSet<String> proteins = this.goAccessionToProteinMap.get(accession);
            if (proteins == null) {
                proteins = new HashSet();
                this.proteinToGoMap.put(accession, proteins);
            }
            proteins.addAll((Collection<String>)otherMap.get(accession));
        }
    }

    public HashMap<String, String> getEnsemblVersionsMap() {
        return this.ensemblVersionsMap;
    }

    public void setEnsemblVersionsMap(HashMap<String, String> ensemblVersionsMap) {
        this.ensemblVersionsMap = ensemblVersionsMap;
    }

    public HashMap<String, String> getGeneNameToEnsemblIdMap() {
        return this.geneNameToEnsemblIdMap;
    }

    public void setGeneNameToEnsemblIdMap(HashMap<String, String> geneNameToEnsemblIdMap) {
        this.geneNameToEnsemblIdMap = geneNameToEnsemblIdMap;
    }

    public HashMap<String, String> getGeneNameToChromosomeMap() {
        return this.geneNameToChromosomeMap;
    }

    public void setGeneNameToChromosomeMap(HashMap<String, String> geneNameToChromosomeMap) {
        this.geneNameToChromosomeMap = geneNameToChromosomeMap;
    }

    public HashMap<String, HashSet<String>> getProteinToGoMap() {
        return this.proteinToGoMap;
    }

    public void setProteinToGoMap(HashMap<String, HashSet<String>> proteinToGoMap) {
        this.proteinToGoMap = proteinToGoMap;
    }

    public HashMap<String, HashSet<String>> getGoAccessionToProteinMap() {
        return this.goAccessionToProteinMap;
    }

    public void setGoAccessionToProteinMap(HashMap<String, HashSet<String>> goAccessionToProteinMap) {
        this.goAccessionToProteinMap = goAccessionToProteinMap;
    }

    public HashMap<String, String> getGoNamesMap() {
        return this.goNamesMap;
    }

    public void setGoNamesMap(HashMap<String, String> goNamesMap) {
        this.goNamesMap = goNamesMap;
    }

    public String getEnsemblId(String geneName) {
        return this.geneNameToEnsemblIdMap.get(geneName);
    }

    public String getChromosome(String geneName) {
        return this.geneNameToChromosomeMap.get(geneName);
    }

    public HashSet<String> getGoTermsForProtein(String proteinAccession) {
        return this.proteinToGoMap.get(proteinAccession);
    }

    public HashSet<String> getProteinsForGoTerm(String goAccession) {
        return this.goAccessionToProteinMap.get(goAccession);
    }

    public String getNameForGoTerm(String goAccession) {
        return this.goNamesMap.get(goAccession);
    }

    public String getGoAccession(String goName) {
        for (String goAccession : this.goNamesMap.keySet()) {
            if (!this.goNamesMap.get(goAccession).equals(goName)) continue;
            return goAccession;
        }
        return null;
    }

    public HashSet<String> getGoNamesForProtein(String proteinAccession) {
        HashSet<String> goTerms = this.getGoTermsForProtein(proteinAccession);
        if (goTerms != null) {
            HashSet<String> goNames = new HashSet<String>(goTerms.size());
            for (String goTerm : goTerms) {
                String goName = this.getNameForGoTerm(goTerm);
                if (goName == null) continue;
                goNames.add(goName);
            }
            return goNames;
        }
        return null;
    }

    public boolean hasGoMappings() {
        return !this.goNamesMap.isEmpty() && !this.proteinToGoMap.isEmpty();
    }
}

