/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.genes;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.biology.genes.ensembl.EnsemblVersion;
import com.compomics.util.experiment.biology.genes.ensembl.GeneMapping;
import com.compomics.util.experiment.biology.genes.go.GoMapping;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblSpecies;
import com.compomics.util.experiment.io.biology.protein.FastaSummary;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.parameters.identification.advanced.GeneParameters;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ProteinGeneDetailsProvider {
    public static final String SEPARATOR = "\t";
    private static String GENE_MAPPING_FOLDER = System.getProperty("user.home") + "/.compomics/gene_mappings/";
    private static final String TOOL_GENE_MAPPING_SUBFOLDER = "resources/conf/gene_mappings/";
    private static final String ENSEMBL_VERSIONS = "ensembl_versions";
    private static final String GO_DOMAINS = "go_domains";
    public static final String GENE_MAPPING_FILE_SUFFIX = "_gene_mappings";
    public static final String GO_MAPPING_FILE_SUFFIX = "_go_mappings";
    private HashMap<String, String> ensemblVersionsMap;
    private final String PADDING = "    ";

    public void initialize(File configFolder) throws IOException {
        File ensemblVersionsFile = ProteinGeneDetailsProvider.getEnsemblVersionsFile();
        if (ensemblVersionsFile.exists()) {
            this.loadEnsemblSpeciesVersions(ensemblVersionsFile);
        } else {
            this.ensemblVersionsMap = new HashMap();
        }
        this.createDefaultGeneMappingFilesGeneric(configFolder, new File(configFolder, "resources/conf/gene_mappings/ensembl_versions"), new File(configFolder, "resources/conf/gene_mappings/go_domains"), true);
    }

    public GeneMaps getGeneMaps(GeneParameters genePreferences, FastaSummary fastaSummary, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider, WaitingHandler waitingHandler) {
        Collection<String> accessions = sequenceProvider.getAccessions();
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        HashMap<String, GeneMapping> geneMappings = new HashMap<String, GeneMapping>(accessions.size());
        HashMap<String, GoMapping> goMappings = new HashMap<String, GoMapping>(accessions.size());
        for (String organismName : fastaSummary.speciesOccurrence.keySet()) {
            if (organismName.equals("Unknown")) continue;
            try {
                String speciesSynonym;
                String organismNameLowerCase = organismName.toLowerCase();
                if (organismNameLowerCase.lastIndexOf("(") != -1) {
                    organismNameLowerCase = organismNameLowerCase.substring(0, organismNameLowerCase.indexOf("(") - 1);
                }
                organismNameLowerCase = organismNameLowerCase.toLowerCase().replaceAll(" ", "_");
                if (!speciesFactory.getEnsemblSpecies().getLatinNames().contains(organismNameLowerCase) && (speciesSynonym = speciesFactory.getUniprotTaxonomy().getSynonym(organismName)) != null) {
                    organismNameLowerCase = speciesSynonym.toLowerCase().replaceAll(" ", "_");
                }
                if (speciesFactory.getEnsemblSpecies().getLatinNames().contains(organismNameLowerCase)) {
                    EnsemblSpecies.EnsemblDivision ensemblDivision = speciesFactory.getEnsemblSpecies().getDivision(organismNameLowerCase);
                    String ensemblDatasetName = speciesFactory.getEnsemblDatasetName(organismNameLowerCase, ensemblDivision);
                    String ensemblDataset = speciesFactory.getBiomartMapping().getDataset(ensemblDatasetName);
                    if (ensemblDataset != null) {
                        File geneMappingFile = ProteinGeneDetailsProvider.getGeneMappingFile(ensemblDatasetName);
                        File goMappingFile = ProteinGeneDetailsProvider.getGoMappingFile(ensemblDatasetName);
                        if (genePreferences.getAutoUpdate().booleanValue()) {
                            boolean success = true;
                            try {
                                if (!geneMappingFile.exists() || this.newVersionExists(organismNameLowerCase)) {
                                    success = this.downloadMappings(waitingHandler, organismName, ensemblDatasetName, ensemblDivision);
                                }
                                if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                                    return null;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                success = false;
                            }
                            if (!success) {
                                waitingHandler.appendReport("    Update of gene information for '" + organismName + "' failed.", true, true);
                            }
                        }
                        if (geneMappingFile.exists()) {
                            GeneMapping geneMapping = new GeneMapping();
                            try {
                                geneMapping.importFromFile(geneMappingFile, waitingHandler);
                                geneMappings.put(organismName, geneMapping);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                waitingHandler.appendReport("    Import of gene mappings for '" + organismName + "' failed.", true, true);
                            }
                        } else {
                            waitingHandler.appendReport("    Gene mapping for '" + organismName + "' not available.", true, true);
                        }
                        if (goMappingFile.exists()) {
                            GoMapping goMapping = new GoMapping();
                            try {
                                goMapping.loadMappingsFromFile(goMappingFile, waitingHandler);
                                goMappings.put(organismName, goMapping);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                waitingHandler.appendReport("    Import of the GO mappings for '" + organismName + "' failed.", true, true);
                            }
                            continue;
                        }
                        waitingHandler.appendReport("    GO mappings for '" + organismName + "' not available.", true, true);
                        continue;
                    }
                    waitingHandler.appendReport("    No taxonomy found for '" + organismName + "'.", true, true);
                    continue;
                }
                waitingHandler.appendReport("    No taxonomy found for '" + organismName + "'.", true, true);
            }
            catch (Exception e) {
                waitingHandler.appendReport("    No taxonomy found for '" + organismName + "'.", true, true);
            }
        }
        GeneMaps geneMaps = new GeneMaps();
        if (this.ensemblVersionsMap == null) {
            this.ensemblVersionsMap = new HashMap(1);
        }
        HashMap<String, String> ensemblVersionsUsed = new HashMap<String, String>(this.ensemblVersionsMap);
        HashMap<String, String> geneNameToEnsemblIdMap = new HashMap<String, String>(accessions.size());
        HashMap<String, String> geneNameToChromosomeMap = new HashMap<String, String>(accessions.size());
        HashMap<String, HashSet<String>> proteinToGoMap = new HashMap<String, HashSet<String>>(accessions.size());
        HashMap<String, HashSet<String>> goToProteinMap = new HashMap<String, HashSet<String>>(accessions.size());
        HashMap<String, String> goNamesMap = new HashMap<String, String>(accessions.size());
        for (String accession : accessions) {
            String organismName = proteinDetailsProvider.getTaxonomy(accession);
            if (organismName == null || organismName.equals("")) continue;
            try {
                HashSet<String> newTerms;
                GoMapping goMapping;
                GeneMapping geneMapping;
                String geneName = proteinDetailsProvider.getGeneName(accession);
                if (geneName != null && (geneMapping = (GeneMapping)geneMappings.get(organismName)) != null) {
                    String ensemblId;
                    String chromosome = geneMapping.getChromosome(geneName);
                    if (chromosome != null) {
                        geneNameToChromosomeMap.put(geneName, chromosome);
                    }
                    if ((ensemblId = geneMapping.getEnsemblAccession(geneName)) != null) {
                        geneNameToEnsemblIdMap.put(geneName, ensemblId);
                    }
                }
                if ((goMapping = (GoMapping)goMappings.get(organismName)) == null) continue;
                HashSet<String> goTerms = proteinToGoMap.get(accession);
                if (goTerms == null) {
                    goTerms = new HashSet(1);
                    proteinToGoMap.put(accession, goTerms);
                }
                if ((newTerms = goMapping.getGoAccessions(accession)) == null) continue;
                goTerms.addAll(newTerms);
                for (String goTerm : newTerms) {
                    HashSet<String> proteins;
                    String goName = goMapping.getTermName(goTerm);
                    if (goName != null) {
                        goNamesMap.put(goTerm, goName);
                    }
                    if ((proteins = goToProteinMap.get(goTerm)) == null) {
                        proteins = new HashSet(1);
                        goToProteinMap.put(goTerm, proteins);
                    }
                    proteins.add(accession);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        geneMaps.setEnsemblVersionsMap(ensemblVersionsUsed);
        geneMaps.setGeneNameToEnsemblIdMap(geneNameToEnsemblIdMap);
        geneMaps.setGeneNameToChromosomeMap(geneNameToChromosomeMap);
        geneMaps.setProteinToGoMap(proteinToGoMap);
        geneMaps.setGoAccessionToProteinMap(goToProteinMap);
        geneMaps.setGoNamesMap(goNamesMap);
        return geneMaps;
    }

    public boolean downloadGeneSequences(File destinationFile, String ensemblType, String ensemblSchemaName, String ensemblDbName, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"FASTA\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDbName + "\" interface = \"default\" ><Attribute name = \"ensembl_gene_id\" />\n<Attribute name = \"coding\" /></Dataset>\n</Query></Query>";
        String waitingText = "Downloading gene sequences. Please Wait...";
        return this.queryEnsembl(requestXml, waitingText, destinationFile, ensemblType, waitingHandler);
    }

    public boolean downloadGoMappings(String ensemblType, String ensemblSchemaName, String ensemblDbName, boolean swissProtMapping, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        String accessionMapping = swissProtMapping ? "\"uniprotswissprot\"" : "\"uniprotsptrembl\"";
        String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDbName + "\" interface = \"default\" ><Attribute name = " + accessionMapping + " />";
        requestXml = requestXml + "<Attribute name = \"goslim_goa_accession\" /><Attribute name = \"goslim_goa_description\" />";
        requestXml = requestXml + "</Dataset></Query>";
        File tempFile = ProteinGeneDetailsProvider.getGoMappingFile(ensemblDbName);
        String waitingText = "Downloading GO Mappings. Please Wait...";
        return this.queryEnsembl(requestXml, waitingText, tempFile, ensemblType, waitingHandler);
    }

    public boolean queryEnsembl(String requestXml, File destinationFile, String ensemblType) throws MalformedURLException, IOException {
        return this.queryEnsembl(requestXml, destinationFile, ensemblType, null);
    }

    public boolean queryEnsembl(String requestXml, File destinationFile, String ensemblType, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        return this.queryEnsembl(requestXml, null, destinationFile, ensemblType, waitingHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryEnsembl(String requestXml, String waitingText, File destinationFile, String ensemblType, WaitingHandler waitingHandler) throws MalformedURLException, IOException {
        boolean success;
        block29: {
            if (waitingHandler != null && waitingHandler instanceof ProgressDialogX && waitingText == null) {
                waitingText = "Downloading from Ensembl. Please wait...";
            }
            success = true;
            int lastThousand = 0;
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                String lineBreak = System.getProperty("line.separator");
                try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler != null && waitingHandler.isRunCanceled()) break block29;
                    if (waitingHandler != null) {
                        waitingHandler.setWaitingText(waitingText);
                    } else {
                        System.out.println(waitingText);
                    }
                    int counter = 0;
                    boolean fileCreated = destinationFile.createNewFile();
                    if (fileCreated || destinationFile.exists()) {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                             FileWriter w = new FileWriter(destinationFile);
                             BufferedWriter bw = new BufferedWriter(w);){
                            String rowLine = br.readLine();
                            if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                                if (rowLine.lastIndexOf("Attribute goslim_goa_accession NOT FOUND") != -1) {
                                    success = false;
                                    break block29;
                                }
                                if (rowLine.lastIndexOf("Attribute uniprotswissprot_accession NOT FOUND") != -1) {
                                    success = false;
                                    break block29;
                                }
                                if (rowLine.lastIndexOf("Attribute uniprotswissprot NOT FOUND") != -1) {
                                    success = false;
                                    break block29;
                                }
                                if (rowLine.lastIndexOf("Attribute uniprotsptrembl NOT FOUND") != -1) {
                                    success = false;
                                    break block29;
                                }
                                throw new IllegalArgumentException("Query error: " + rowLine);
                            }
                            while (rowLine != null && success) {
                                int thousand;
                                if (waitingHandler != null) {
                                    if (waitingHandler.isRunCanceled()) {
                                        break block29;
                                    }
                                    if (waitingHandler instanceof ProgressDialogX) {
                                        waitingHandler.setWaitingText(waitingText + " (" + counter++ + " rows downloaded)");
                                    }
                                } else if ((thousand = ++counter / 10000) > lastThousand) {
                                    System.out.println(waitingText + " (" + counter + " rows downloaded)");
                                    lastThousand = thousand;
                                }
                                bw.write(rowLine + lineBreak);
                                rowLine = br.readLine();
                            }
                            break block29;
                        }
                    }
                    if (waitingHandler != null) {
                        waitingHandler.setRunCanceled();
                    }
                    throw new IllegalArgumentException("The mapping file could not be created.");
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadGeneMappings(String ensemblType, String ensemblSchemaName, String ensemblDatasetName, String ensemblVersion, WaitingHandler waitingHandler) throws MalformedURLException, IOException, IllegalArgumentException {
        boolean success;
        block19: {
            String requestXml = "query=<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE Query><Query  virtualSchemaName = \"" + ensemblSchemaName + "\" formatter = \"TSV\" header = \"0\" uniqueRows = \"1\" count = \"\" datasetConfigVersion = \"0.7\" ><Dataset name = \"" + ensemblDatasetName + "\" interface = \"default\" ><Attribute name = \"ensembl_gene_id\" /><Attribute name = \"external_gene_name\" /><Attribute name = \"chromosome_name\" /></Dataset></Query>";
            success = true;
            if (!waitingHandler.isRunCanceled()) {
                URL url = this.getEnsemblUrl(ensemblType);
                URLConnection conn = url.openConnection();
                conn.setDoOutput(true);
                String lineBreak = System.getProperty("line.separator");
                try (OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());){
                    wr.write(requestXml);
                    wr.flush();
                    if (waitingHandler.isRunCanceled()) break block19;
                    waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait...");
                    int counter = 0;
                    File tempFile = ProteinGeneDetailsProvider.getGeneMappingFile(ensemblDatasetName);
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                         FileWriter w = new FileWriter(tempFile);
                         BufferedWriter bw = new BufferedWriter(w);){
                        String rowLine = br.readLine();
                        if (rowLine.lastIndexOf("Attribute external_gene_name NOT FOUND") != -1) {
                            success = false;
                        } else {
                            if (rowLine != null && rowLine.startsWith("Query ERROR")) {
                                throw new IllegalArgumentException("Query error on line: " + rowLine);
                            }
                            while (rowLine != null && !waitingHandler.isRunCanceled()) {
                                if (waitingHandler instanceof ProgressDialogX) {
                                    waitingHandler.setWaitingText("Downloading Gene Mappings. Please Wait... (" + counter++ + " rows downloaded)");
                                }
                                bw.write(rowLine + lineBreak);
                                rowLine = br.readLine();
                            }
                        }
                    }
                    if (!waitingHandler.isRunCanceled()) {
                        this.updateEnsemblVersion(ensemblDatasetName, "Ensembl " + ensemblVersion);
                    }
                }
            }
        }
        return success;
    }

    public static File getGeneMappingFolder() {
        return new File(GENE_MAPPING_FOLDER);
    }

    public static void setGeneMappingFolder(String geneMappingFolder) {
        GENE_MAPPING_FOLDER = geneMappingFolder;
    }

    public void createDefaultGeneMappingFilesGeneric(File configFolder, File sourceEnsemblVersionsFile, File sourceGoDomainsFile, boolean updateEqualVersion) {
        boolean fileCreated;
        boolean folderCreated;
        if (!ProteinGeneDetailsProvider.getGeneMappingFolder().exists() && !(folderCreated = ProteinGeneDetailsProvider.getGeneMappingFolder().mkdirs())) {
            throw new IllegalArgumentException("Could not create the gene mapping folder.");
        }
        File targetEnsemblVersionsFile = ProteinGeneDetailsProvider.getEnsemblVersionsFile();
        File targetGoDomainsFile = ProteinGeneDetailsProvider.getGoDomainsFile();
        HashMap<Object, Object> localEnsemblVersionsMap = new HashMap();
        HashMap<String, Boolean> localUpdateSpeciesEnsembl = new HashMap<String, Boolean>();
        try {
            if (!targetEnsemblVersionsFile.exists()) {
                fileCreated = targetEnsemblVersionsFile.createNewFile();
                if (!fileCreated) {
                    throw new IllegalArgumentException("Could not create the Ensembl versions file.");
                }
                IoUtil.copyFile(sourceEnsemblVersionsFile, targetEnsemblVersionsFile);
                localEnsemblVersionsMap = this.getEnsemblSpeciesVersions(targetEnsemblVersionsFile);
                for (Map.Entry<Object, Object> entry : localEnsemblVersionsMap.entrySet()) {
                    Integer speciesEnsemblVersionNew = this.getEnsemblVersionFromFile(sourceEnsemblVersionsFile, (String)entry.getKey());
                    this.updateEnsemblVersion((String)entry.getKey(), "Ensembl " + speciesEnsemblVersionNew);
                    localUpdateSpeciesEnsembl.put((String)entry.getKey(), true);
                }
            } else {
                localEnsemblVersionsMap = this.getEnsemblSpeciesVersions(targetEnsemblVersionsFile);
                for (Map.Entry<Object, Object> entry : localEnsemblVersionsMap.entrySet()) {
                    Integer speciesEnsemblVersionNew = this.getEnsemblVersionFromFile(sourceEnsemblVersionsFile, (String)entry.getKey());
                    if (speciesEnsemblVersionNew != null) {
                        Integer speciesEnsemblVersionOld = this.getEnsemblVersionFromFile(targetEnsemblVersionsFile, (String)entry.getKey());
                        if (speciesEnsemblVersionOld == null || speciesEnsemblVersionOld.equals(speciesEnsemblVersionNew) && updateEqualVersion || speciesEnsemblVersionOld < speciesEnsemblVersionNew) {
                            localUpdateSpeciesEnsembl.put((String)entry.getKey(), true);
                            this.updateEnsemblVersion((String)entry.getKey(), "Ensembl " + speciesEnsemblVersionNew);
                            continue;
                        }
                        localUpdateSpeciesEnsembl.put((String)entry.getKey(), false);
                        continue;
                    }
                    localUpdateSpeciesEnsembl.put((String)entry.getKey(), false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create or update the Ensembl versions file.");
        }
        try {
            if (!targetGoDomainsFile.exists() && !(fileCreated = targetGoDomainsFile.createNewFile())) {
                throw new IllegalArgumentException("Could not create the GO domains file.");
            }
            IoUtil.copyFile(sourceGoDomainsFile, targetGoDomainsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create the GO domains file.");
        }
        for (Map.Entry entry : localUpdateSpeciesEnsembl.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            File sourceSpeciesGoMappingsFile = new File(configFolder, TOOL_GENE_MAPPING_SUBFOLDER + (String)entry.getKey() + GO_MAPPING_FILE_SUFFIX);
            File sourceSpeciesGeneMappingFile = new File(configFolder, TOOL_GENE_MAPPING_SUBFOLDER + (String)entry.getKey() + GENE_MAPPING_FILE_SUFFIX);
            File targetSpeciesGoMappingsFile = new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), sourceSpeciesGoMappingsFile.getName());
            File targetSpeciesGeneMappingFile = new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), sourceSpeciesGeneMappingFile.getName());
            try {
                boolean fileCreated2;
                if (!targetSpeciesGoMappingsFile.exists() && !(fileCreated2 = targetSpeciesGoMappingsFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species GO mapping file.");
                }
                IoUtil.copyFile(sourceSpeciesGoMappingsFile, targetSpeciesGoMappingsFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species GO mapping file.");
            }
            try {
                boolean fileCreated2;
                if (!targetSpeciesGeneMappingFile.exists() && !(fileCreated2 = targetSpeciesGeneMappingFile.createNewFile())) {
                    throw new IllegalArgumentException("Could not create the default species gene mapping file.");
                }
                IoUtil.copyFile(sourceSpeciesGeneMappingFile, targetSpeciesGeneMappingFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Could not create the default species gene mapping file.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnsemblVersion(String ensemblDatasetName, String ensemblVersion) throws IOException {
        if (this.ensemblVersionsMap == null) {
            this.ensemblVersionsMap = new HashMap();
        }
        this.ensemblVersionsMap.put(ensemblDatasetName, ensemblVersion);
        try (FileWriter w = new FileWriter(ProteinGeneDetailsProvider.getEnsemblVersionsFile());
             BufferedWriter bw = new BufferedWriter(w);){
            for (String key : this.ensemblVersionsMap.keySet()) {
                bw.write(key + SEPARATOR + this.ensemblVersionsMap.get(key));
                bw.newLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getEnsemblVersionFromFile(File ensemblVersionsFile, String species) throws IOException {
        Integer version = null;
        try (FileReader r = new FileReader(ensemblVersionsFile);
             BufferedReader br = new BufferedReader(r);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] splittedLine = line.split(SEPARATOR);
                String speciesAtLine = splittedLine[0];
                if (!speciesAtLine.equals(species)) continue;
                String[] ensemblVersionSplit = splittedLine[1].split(" ");
                version = Integer.valueOf(ensemblVersionSplit[1]);
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getEnsemblSpeciesVersions(File ensemblVersionsFile) throws FileNotFoundException, IOException {
        HashMap<String, String> localEnsemblVersionsMap = new HashMap<String, String>();
        try (FileReader r = new FileReader(ensemblVersionsFile);
             BufferedReader br = new BufferedReader(r);){
            String line = br.readLine();
            while (line != null) {
                String[] elements = line.split("\\t");
                localEnsemblVersionsMap.put(elements[0], elements[1]);
                line = br.readLine();
            }
        }
        return localEnsemblVersionsMap;
    }

    public void loadEnsemblSpeciesVersions(File ensemblVersionsFile) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(ensemblVersionsFile));){
            this.ensemblVersionsMap = new HashMap();
            String line = br.readLine();
            while (line != null) {
                String[] elements = line.split("\\t");
                this.ensemblVersionsMap.put(elements[0], elements[1]);
                line = br.readLine();
            }
        }
    }

    private URL getEnsemblUrl(String ensemblType) throws MalformedURLException {
        if (ensemblType.equalsIgnoreCase("fungi")) {
            return new URL("https://fungi.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("plants")) {
            return new URL("https://plants.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("protists")) {
            return new URL("https://protists.ensembl.org/biomart/martservice/result");
        }
        if (ensemblType.equalsIgnoreCase("metazoa")) {
            return new URL("https://metazoa.ensembl.org/biomart/martservice/result");
        }
        return new URL("https://www.ensembl.org/biomart/martservice/result");
    }

    public boolean downloadMappings(WaitingHandler waitingHandler, String speciesName, String ensemblDatasetName, EnsemblSpecies.EnsemblDivision ensemblDivision) throws IOException {
        boolean canceled;
        if (waitingHandler.isReport()) {
            waitingHandler.appendReport("    Downloading GO and gene mappings for species " + speciesName + ".", true, true);
        }
        String ensemblType = ensemblDivision.ensemblType;
        String schemaName = EnsemblVersion.getEnsemblSchemaName(ensemblDivision);
        if (schemaName == null) {
            return false;
        }
        if (ensemblDatasetName == null) {
            return false;
        }
        if (!waitingHandler.isRunCanceled()) {
            boolean goMappingsDownloaded = this.downloadGoMappings(ensemblType, schemaName, ensemblDatasetName, true, waitingHandler);
            if (!goMappingsDownloaded) {
                goMappingsDownloaded = this.downloadGoMappings(ensemblType, schemaName, ensemblDatasetName, false, waitingHandler);
            }
            if (!goMappingsDownloaded) {
                waitingHandler.appendReport("        GO mappings not available. Downloading gene mappings only.", true, true);
            } else if (waitingHandler.isReport()) {
                waitingHandler.appendReport("        GO mappings downloaded.", true, true);
            }
        }
        if (!waitingHandler.isRunCanceled()) {
            boolean geneMappingsDownloaded = this.downloadGeneMappings(ensemblType, schemaName, ensemblDatasetName, EnsemblVersion.getCurrentEnsemblVersion(ensemblDivision).toString(), waitingHandler);
            if (!waitingHandler.isRunCanceled()) {
                if (!geneMappingsDownloaded) {
                    waitingHandler.appendReport("        Gene mappings not available.", true, true);
                } else if (waitingHandler.isReport()) {
                    waitingHandler.appendReport("        Gene mappings downloaded.", true, true);
                }
            }
        }
        return !(canceled = waitingHandler.isRunCanceled());
    }

    public static File getGeneMappingFile(String ensemblDatasetName) {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), ensemblDatasetName + GENE_MAPPING_FILE_SUFFIX);
    }

    public static File getGoMappingFile(String ensemblDatasetName) {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), ensemblDatasetName + GO_MAPPING_FILE_SUFFIX);
    }

    public static File getEnsemblVersionsFile() {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), ENSEMBL_VERSIONS);
    }

    public static File getGoDomainsFile() {
        return new File(ProteinGeneDetailsProvider.getGeneMappingFolder(), GO_DOMAINS);
    }

    public String getEnsemblVersion(String latinName) {
        SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
        String ensemblDatasetName = speciesFactory.getEnsemblDatasetName(latinName, speciesFactory.getEnsemblSpecies().getDivision(latinName));
        if (this.ensemblVersionsMap == null) {
            return null;
        }
        return this.ensemblVersionsMap.get(ensemblDatasetName);
    }

    public boolean newVersionExists(String latinName) {
        EnsemblSpecies.EnsemblDivision ensemblDivision = SpeciesFactory.getInstance().getEnsemblSpecies().getDivision(latinName);
        Integer latestEnsemblVersion = EnsemblVersion.getCurrentEnsemblVersion(ensemblDivision);
        String currentEnsemblVersionAsString = this.getEnsemblVersion(latinName);
        if (currentEnsemblVersionAsString != null) {
            Integer currentEnsemblVersion;
            currentEnsemblVersionAsString = currentEnsemblVersionAsString.substring(currentEnsemblVersionAsString.indexOf(" ") + 1);
            try {
                currentEnsemblVersion = Integer.valueOf(currentEnsemblVersionAsString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                currentEnsemblVersion = latestEnsemblVersion;
            }
            return currentEnsemblVersion < latestEnsemblVersion;
        }
        return true;
    }
}

