/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions.impl;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.pride.CvTerm;

public class ElementaryIon
extends Ion {
    static final long serialVersionUID = -1578136397635015592L;
    public static final int PROTON = 0;
    public static final ElementaryIon proton = new ElementaryIon("Proton", 1.007276466812, 0);
    private final String name;
    private final int subType;
    public static double[] protonMassMultiples = new double[]{0.0, proton.getTheoreticMass(), 2.0 * proton.getTheoreticMass(), 3.0 * proton.getTheoreticMass(), 4.0 * proton.getTheoreticMass(), 5.0 * proton.getTheoreticMass(), 6.0 * proton.getTheoreticMass(), 7.0 * proton.getTheoreticMass(), 8.0 * proton.getTheoreticMass(), 9.0 * proton.getTheoreticMass(), 10.0 * proton.getTheoreticMass()};

    public ElementaryIon() {
        this.name = "";
        this.subType = 0;
    }

    public static double getProtonMassMultiple(int i) {
        return i <= 10 ? protonMassMultiples[i] : (double)i * proton.getTheoreticMass();
    }

    public ElementaryIon(String name, double theoreticMass, int subType) {
        this.name = name;
        this.theoreticMass1 = theoreticMass;
        this.type = Ion.IonType.ELEMENTARY_ION;
        this.subType = subType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CvTerm getPrideCvTerm() {
        return null;
    }

    @Override
    public CvTerm getPsiMsCvTerm() {
        return null;
    }

    @Override
    public int getSubType() {
        return this.subType;
    }

    @Override
    public String getSubTypeAsString() {
        switch (this.subType) {
            case 0: {
                return "Proton";
            }
        }
        throw new UnsupportedOperationException("No name for subtype: " + this.subType + " of " + this.getTypeAsString() + ".");
    }

    public static int[] getPossibleSubtypes() {
        return new int[]{0};
    }

    @Override
    public NeutralLoss[] getNeutralLosses() {
        return null;
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.ELEMENTARY_ION && anotherIon.getSubType() == this.subType && anotherIon.getTheoreticMass() == this.theoreticMass1 && anotherIon.getNeutralLossesAsString().equals(this.getNeutralLossesAsString());
    }
}

