/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions.impl;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.pride.CvTerm;

public class PeptideFragmentIon
extends Ion {
    static final long serialVersionUID = 8283809283803740651L;
    public static final int A_ION = 0;
    public static final int B_ION = 1;
    public static final int C_ION = 2;
    public static final int X_ION = 3;
    public static final int Y_ION = 4;
    public static final int Z_ION = 5;
    private NeutralLoss[] neutralLosses = null;
    private int number = -1;
    private int subType;
    private CvTerm cvTerm = null;
    private CvTerm psiCvTerm = null;

    public PeptideFragmentIon() {
    }

    public PeptideFragmentIon(int fragmentType, int number, double mass, NeutralLoss[] neutralLosses) {
        if (neutralLosses != null) {
            this.neutralLosses = neutralLosses;
        }
        this.subType = fragmentType;
        this.type = Ion.IonType.PEPTIDE_FRAGMENT_ION;
        this.theoreticMass1 = mass;
        this.number = number;
    }

    public PeptideFragmentIon(int fragmentType, NeutralLoss[] neutralLosses) {
        if (neutralLosses != null) {
            this.neutralLosses = neutralLosses;
        }
        this.subType = fragmentType;
        this.type = Ion.IonType.PEPTIDE_FRAGMENT_ION;
    }

    public PeptideFragmentIon(int fragmentType) {
        this.subType = fragmentType;
        this.type = Ion.IonType.PEPTIDE_FRAGMENT_ION;
    }

    public int getNumber() {
        return this.number;
    }

    public int getAaNumber(int peptideLength) {
        switch (this.subType) {
            case 0: 
            case 1: 
            case 2: {
                return this.number;
            }
            case 3: 
            case 4: 
            case 5: {
                return peptideLength + 1 - this.number;
            }
        }
        throw new UnsupportedOperationException("Peptide fragment ion of type " + this.subType + " not implemented.");
    }

    @Override
    public NeutralLoss[] getNeutralLosses() {
        return this.neutralLosses;
    }

    @Override
    public String getName() {
        return this.getSubTypeAsString() + this.getNeutralLossesAsString();
    }

    public String getNameWithNumber() {
        return this.getSubTypeAsString() + this.getNumber() + this.getNeutralLossesAsString();
    }

    @Override
    public CvTerm getPrideCvTerm() {
        if (this.cvTerm == null) {
            switch (this.subType) {
                case 0: {
                    if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001229", "frag: a ion", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001234", "frag: a ion - H2O", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001235", "frag: a ion - NH3", "" + this.getNumber());
                    break;
                }
                case 1: {
                    if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001224", "frag: b ion", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001222", "frag: b ion - H2O", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001232", "frag: b ion - NH3", "" + this.getNumber());
                    break;
                }
                case 2: {
                    if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001231", "frag: c ion", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001515", "frag: c ion - H2O", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001516", "frag: c ion - NH3", "" + this.getNumber());
                    break;
                }
                case 3: {
                    if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001228", "frag: x ion", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001519", "frag: x ion - H2O", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001520", "frag: x ion - NH3", "" + this.getNumber());
                    break;
                }
                case 4: {
                    if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001220", "frag: y ion", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001223", "frag: y ion - H2O", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001233", "frag: y ion - NH3", "" + this.getNumber());
                    break;
                }
                case 5: {
                    if (this.neutralLosses == null || this.neutralLosses.length == 0) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001230", "frag: z ion", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
                        this.cvTerm = new CvTerm("PSI-MS", "MS:1001517", "frag: z ion - H2O", "" + this.getNumber());
                        break;
                    }
                    if (this.neutralLosses.length != 1 || !this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) break;
                    this.cvTerm = new CvTerm("PSI-MS", "MS:1001518", "frag: z ion - NH3", "" + this.getNumber());
                }
            }
        }
        return this.cvTerm;
    }

    @Override
    public CvTerm getPsiMsCvTerm() {
        if (this.psiCvTerm != null) {
            return this.psiCvTerm;
        }
        switch (this.subType) {
            case 0: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001229", "frag: a ion", null);
                break;
            }
            case 1: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001224", "frag: b ion", null);
                break;
            }
            case 2: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001231", "frag: c ion", null);
                break;
            }
            case 3: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001228", "frag: x ion", null);
                break;
            }
            case 4: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001220", "frag: y ion", null);
                break;
            }
            case 5: {
                this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001230", "frag: z ion", null);
            }
        }
        return this.psiCvTerm;
    }

    @Override
    public int getSubType() {
        return this.subType;
    }

    @Override
    public String getSubTypeAsString() {
        try {
            return PeptideFragmentIon.getSubTypeAsString(this.subType);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("No name for subtype: " + this.subType + " of " + this.getTypeAsString() + ".");
        }
    }

    public static String getSubTypeAsString(int subType) {
        switch (subType) {
            case 0: {
                return "a";
            }
            case 1: {
                return "b";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "x";
            }
            case 4: {
                return "y";
            }
            case 5: {
                return "z";
            }
        }
        throw new UnsupportedOperationException("No name for subtype: " + subType + ".");
    }

    public static Integer getIonType(String ionSymbol) {
        switch (ionSymbol) {
            case "a": {
                return 0;
            }
            case "b": {
                return 1;
            }
            case "c": {
                return 2;
            }
            case "x": {
                return 3;
            }
            case "y": {
                return 4;
            }
            case "z": {
                return 5;
            }
        }
        throw new UnsupportedOperationException("Ion of type " + ionSymbol + " not supported.");
    }

    public static int[] getPossibleSubtypes() {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public static boolean isForward(int subType) {
        switch (subType) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new UnsupportedOperationException("Subtype: " + subType + " not found.");
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.PEPTIDE_FRAGMENT_ION && anotherIon.getSubType() == this.subType && ((PeptideFragmentIon)anotherIon).getNumber() == this.number && anotherIon.getNeutralLossesAsString().equals(this.getNeutralLossesAsString());
    }
}

