/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions.impl;

import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.pride.CvTerm;

public class PrecursorIon
extends Ion {
    static final long serialVersionUID = -2630586959372309153L;
    public static final int PRECURSOR = 0;
    private NeutralLoss[] neutralLosses = null;
    private CvTerm cvTerm = null;
    private CvTerm psiCvTerm = null;

    public PrecursorIon(double theoreticMass, NeutralLoss[] neutralLosses) {
        this.neutralLosses = neutralLosses;
        this.type = Ion.IonType.PRECURSOR_ION;
        this.theoreticMass1 = theoreticMass;
    }

    public PrecursorIon(NeutralLoss[] neutralLosses) {
        this.neutralLosses = neutralLosses;
        this.type = Ion.IonType.PRECURSOR_ION;
    }

    public PrecursorIon() {
        this.type = Ion.IonType.PRECURSOR_ION;
    }

    public PrecursorIon(double theoreticMass) {
        this.theoreticMass1 = theoreticMass;
        this.type = Ion.IonType.PRECURSOR_ION;
    }

    @Override
    public String getName() {
        return this.getSubTypeAsString() + this.getNeutralLossesAsString();
    }

    @Override
    public CvTerm getPrideCvTerm() {
        if (this.cvTerm != null) {
            return this.cvTerm;
        }
        if (this.neutralLosses == null || this.neutralLosses.length == 0) {
            this.cvTerm = new CvTerm("PSI-MS", "MS:1001523", "frag: precursor ion", "0");
        } else if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.H2O)) {
            this.cvTerm = new CvTerm("PSI-MS", "MS:1001521", "frag: precursor ion - H2O", "0");
        } else if (this.neutralLosses.length == 1 && this.neutralLosses[0].isSameAs(NeutralLoss.NH3)) {
            this.cvTerm = new CvTerm("PSI-MS", "MS:1001522", "frag: precursor ion - NH3", "0");
        }
        return this.cvTerm;
    }

    @Override
    public CvTerm getPsiMsCvTerm() {
        if (this.psiCvTerm != null) {
            return this.psiCvTerm;
        }
        this.psiCvTerm = new CvTerm("PSI-MS", "MS:1001523", "frag: precursor ion", null);
        return this.cvTerm;
    }

    @Override
    public int getSubType() {
        return 0;
    }

    @Override
    public String getSubTypeAsString() {
        return "Prec";
    }

    public static int[] getPossibleSubtypes() {
        return new int[]{0};
    }

    @Override
    public NeutralLoss[] getNeutralLosses() {
        return this.neutralLosses;
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.PRECURSOR_ION && anotherIon.getNeutralLossesAsString().equals(this.getNeutralLossesAsString());
    }
}

