/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions.impl;

import com.compomics.util.experiment.biology.atoms.Atom;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.atoms.AtomImpl;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class ReporterIon
extends Ion {
    static final long serialVersionUID = 1109011048958734120L;
    private static HashMap<String, ReporterIon> implementedIons = new HashMap();
    private static ArrayList<String> sortedImplementedIonsNames = null;
    private static int[] possibleSubtypes = null;
    public static final ReporterIon iTRAQ4Plex_114 = new ReporterIon("iTRAQ4Plex_114", ReporterIon.getComposition("iTRAQ4Plex_114"));
    public static final ReporterIon iTRAQ4Plex_115 = new ReporterIon("iTRAQ4Plex_115", ReporterIon.getComposition("iTRAQ4Plex_115"));
    public static final ReporterIon iTRAQ4Plex_116 = new ReporterIon("iTRAQ4Plex_116", ReporterIon.getComposition("iTRAQ4Plex_116"));
    public static final ReporterIon iTRAQ4Plex_117 = new ReporterIon("iTRAQ4Plex_117", ReporterIon.getComposition("iTRAQ4Plex_117"));
    public static final ReporterIon iTRAQ8Plex_113 = new ReporterIon("iTRAQ8Plex_113", ReporterIon.getComposition("iTRAQ8Plex_113"));
    public static final ReporterIon iTRAQ8Plex_114 = new ReporterIon("iTRAQ8Plex_114", ReporterIon.getComposition("iTRAQ8Plex_114"));
    public static final ReporterIon iTRAQ8Plex_115 = new ReporterIon("iTRAQ8Plex_115", ReporterIon.getComposition("iTRAQ8Plex_115"));
    public static final ReporterIon iTRAQ8Plex_116 = new ReporterIon("iTRAQ8Plex_116", ReporterIon.getComposition("iTRAQ8Plex_116"));
    public static final ReporterIon iTRAQ8Plex_117 = new ReporterIon("iTRAQ8Plex_117", ReporterIon.getComposition("iTRAQ8Plex_117"));
    public static final ReporterIon iTRAQ8Plex_118 = new ReporterIon("iTRAQ8Plex_118", ReporterIon.getComposition("iTRAQ8Plex_118"));
    public static final ReporterIon iTRAQ8Plex_119 = new ReporterIon("iTRAQ8Plex_119", ReporterIon.getComposition("iTRAQ8Plex_119"));
    public static final ReporterIon iTRAQ8Plex_121 = new ReporterIon("iTRAQ8Plex_121", ReporterIon.getComposition("iTRAQ8Plex_121"));
    public static final ReporterIon iTRAQ_145 = new ReporterIon("iTRAQ145", 144.1);
    public static final ReporterIon iTRAQ_305 = new ReporterIon("iTRAQ305", 304.2);
    public static final ReporterIon TMT_126 = new ReporterIon("TMT_126", ReporterIon.getComposition("TMT_126"));
    public static final ReporterIon TMT_127N = new ReporterIon("TMT_127N", ReporterIon.getComposition("TMT_127N"));
    public static final ReporterIon TMT_127C = new ReporterIon("TMT_127C", ReporterIon.getComposition("TMT_127C"));
    public static final ReporterIon TMT_128N = new ReporterIon("TMT_128N", ReporterIon.getComposition("TMT_128N"));
    public static final ReporterIon TMT_128C = new ReporterIon("TMT_128C", ReporterIon.getComposition("TMT_128C"));
    public static final ReporterIon TMT_129N = new ReporterIon("TMT_129N", ReporterIon.getComposition("TMT_129N"));
    public static final ReporterIon TMT_129C = new ReporterIon("TMT_129C", ReporterIon.getComposition("TMT_129C"));
    public static final ReporterIon TMT_130N = new ReporterIon("TMT_130N", ReporterIon.getComposition("TMT_130N"));
    public static final ReporterIon TMT_130C = new ReporterIon("TMT_130C", ReporterIon.getComposition("TMT_130C"));
    public static final ReporterIon TMT_131 = new ReporterIon("TMT_131", ReporterIon.getComposition("TMT_131"));
    public static final ReporterIon TMT_131C = new ReporterIon("TMT_131C", ReporterIon.getComposition("TMT_131C"));
    public static final ReporterIon TMT_126_ETD = new ReporterIon("TMT_126_ETD", ReporterIon.getComposition("TMT_126_ETD"));
    public static final ReporterIon TMT_127N_ETD = new ReporterIon("TMT_127N_ETD", ReporterIon.getComposition("TMT_127N_ETD"));
    public static final ReporterIon TMT_127C_ETD = new ReporterIon("TMT_127C_ETD", ReporterIon.getComposition("TMT_127C_ETD"));
    public static final ReporterIon TMT_128N_ETD = new ReporterIon("TMT_128N_ETD", ReporterIon.getComposition("TMT_128N_ETD"));
    public static final ReporterIon TMT_128C_ETD = new ReporterIon("TMT_128C_ETD", ReporterIon.getComposition("TMT_128C_ETD"));
    public static final ReporterIon TMT_129N_ETD = new ReporterIon("TMT_129N_ETD", ReporterIon.getComposition("TMT_129N_ETD"));
    public static final ReporterIon TMT_129C_ETD = new ReporterIon("TMT_129C_ETD", ReporterIon.getComposition("TMT_129C_ETD"));
    public static final ReporterIon TMT_130N_ETD = new ReporterIon("TMT_130N_ETD", ReporterIon.getComposition("TMT_130N_ETD"));
    public static final ReporterIon TMT_130C_ETD = new ReporterIon("TMT_130C_ETD", ReporterIon.getComposition("TMT_130C_ETD"));
    public static final ReporterIon TMT_131_ETD = new ReporterIon("TMT_131_ETD", ReporterIon.getComposition("TMT_131_ETD"));
    public static final ReporterIon TMT_131C_ETD = new ReporterIon("TMT_131C_ETD", ReporterIon.getComposition("TMT_131C_ETD"));
    public static final ReporterIon TMT_230 = new ReporterIon("TMT230", 229.2);
    public static final ReporterIon TMT_226 = new ReporterIon("TMT226", 225.2);
    public static final ReporterIon TMTpro_126 = new ReporterIon("TMTpro-126", ReporterIon.getComposition("TMTpro-126"));
    public static final ReporterIon TMTpro_127N = new ReporterIon("TMTpro-127N", ReporterIon.getComposition("TMTpro-127N"));
    public static final ReporterIon TMTpro_127C = new ReporterIon("TMTpro-127C", ReporterIon.getComposition("TMTpro-127C"));
    public static final ReporterIon TMTpro_128N = new ReporterIon("TMTpro-128N", ReporterIon.getComposition("TMTpro-128N"));
    public static final ReporterIon TMTpro_128C = new ReporterIon("TMTpro-128C", ReporterIon.getComposition("TMTpro-128C"));
    public static final ReporterIon TMTpro_129N = new ReporterIon("TMTpro-129N", ReporterIon.getComposition("TMTpro-129N"));
    public static final ReporterIon TMTpro_129C = new ReporterIon("TMTpro-129C", ReporterIon.getComposition("TMTpro-129C"));
    public static final ReporterIon TMTpro_130N = new ReporterIon("TMTpro-130N", ReporterIon.getComposition("TMTpro-130N"));
    public static final ReporterIon TMTpro_130C = new ReporterIon("TMTpro-130C", ReporterIon.getComposition("TMTpro-130C"));
    public static final ReporterIon TMTpro_131N = new ReporterIon("TMTpro-131N", ReporterIon.getComposition("TMTpro-131N"));
    public static final ReporterIon TMTpro_131C = new ReporterIon("TMTpro-131C", ReporterIon.getComposition("TMTpro-131C"));
    public static final ReporterIon TMTpro_132N = new ReporterIon("TMTpro-132N", ReporterIon.getComposition("TMTpro-132N"));
    public static final ReporterIon TMTpro_132C = new ReporterIon("TMTpro-132C", ReporterIon.getComposition("TMTpro-132C"));
    public static final ReporterIon TMTpro_133N = new ReporterIon("TMTpro-133N", ReporterIon.getComposition("TMTpro-133N"));
    public static final ReporterIon TMTpro_133C = new ReporterIon("TMTpro-133C", ReporterIon.getComposition("TMTpro-133C"));
    public static final ReporterIon TMTpro_134N = new ReporterIon("TMTpro-134N", ReporterIon.getComposition("TMTpro-134N"));
    public static final ReporterIon TMTpro_134C = new ReporterIon("TMTpro-134C", ReporterIon.getComposition("TMTpro-134C"));
    public static final ReporterIon TMTpro_135N = new ReporterIon("TMTpro-135N", ReporterIon.getComposition("TMTpro-135N"));
    public static final ReporterIon iodoTMT_zero = new ReporterIon("iodoTMT_zero", ReporterIon.getComposition("iodoTMT_zero"));
    public static final ReporterIon iodoTMT_126 = new ReporterIon("iodoTMT_126", ReporterIon.getComposition("iodoTMT_126"));
    public static final ReporterIon iodoTMT_127 = new ReporterIon("iodoTMT_127", ReporterIon.getComposition("iodoTMT_127"));
    public static final ReporterIon iodoTMT_128 = new ReporterIon("iodoTMT_128", ReporterIon.getComposition("iodoTMT_128"));
    public static final ReporterIon iodoTMT_129 = new ReporterIon("iodoTMT_129", ReporterIon.getComposition("iodoTMT_129"));
    public static final ReporterIon iodoTMT_130 = new ReporterIon("iodoTMT_130", ReporterIon.getComposition("iodoTMT_130"));
    public static final ReporterIon iodoTMT_131 = new ReporterIon("iodoTMT_131", ReporterIon.getComposition("iodoTMT_131"));
    public static final ReporterIon iodoTMT_zero_ETD = new ReporterIon("iodoTMT_zero_ETD", ReporterIon.getComposition("iodoTMT_zero_ETD"));
    public static final ReporterIon iodoTMT_126_ETD = new ReporterIon("iodoTMT_126_ETD", ReporterIon.getComposition("iodoTMT_126_ETD"));
    public static final ReporterIon iodoTMT_127_ETD = new ReporterIon("iodoTMT_127_ETD", ReporterIon.getComposition("iodoTMT_127_ETD"));
    public static final ReporterIon iodoTMT_128_ETD = new ReporterIon("iodoTMT_128_ETD", ReporterIon.getComposition("iodoTMT_128_ETD"));
    public static final ReporterIon iodoTMT_129_ETD = new ReporterIon("iodoTMT_129_ETD", ReporterIon.getComposition("iodoTMT_129_ETD"));
    public static final ReporterIon iodoTMT_130_ETD = new ReporterIon("iodoTMT_130_ETD", ReporterIon.getComposition("iodoTMT_130_ETD"));
    public static final ReporterIon iodoTMT_131_ETD = new ReporterIon("iodoTMT_131_ETD", ReporterIon.getComposition("iodoTMT_131_ETD"));
    public static final ReporterIon ACE_K_126 = new ReporterIon("aceK126", AtomChain.getAtomChain("C(7)H(11)ON"));
    public static final ReporterIon ACE_K_143 = new ReporterIon("aceK143", AtomChain.getAtomChain("C(7)H(14)ON(2)"));
    public static final ReporterIon PHOSPHO_Y = new ReporterIon("pY", AtomChain.getAtomChain("C(8)H(10)NPO(4)"));
    public static final ReporterIon FORMYL_K = new ReporterIon("fK112", AtomChain.getAtomChain("C(6)H(9)NO"));
    public static final ReporterIon METHYL_R_87 = new ReporterIon("metR87", AtomChain.getAtomChain("C(4)H(10)N(2)"));
    public static final ReporterIon METHYL_R_112 = new ReporterIon("metR112", AtomChain.getAtomChain("C(5)H(9)N(3)"));
    public static final ReporterIon METHYL_R_115 = new ReporterIon("metR115", AtomChain.getAtomChain("C(5)H(10)N(2)O"));
    public static final ReporterIon METHYL_R_143 = new ReporterIon("metR143", AtomChain.getAtomChain("C(6)H(14)N(4)"));
    public static final ReporterIon METHYL_R_70 = new ReporterIon("metR70", AtomChain.getAtomChain("C(4)H(7)N"));
    public static final ReporterIon DI_METHYL_R_112 = new ReporterIon("dimetR112", AtomChain.getAtomChain("C(5)H(9)N(3)"));
    public static final ReporterIon DI_METHYL_R_115 = new ReporterIon("dimetR115", AtomChain.getAtomChain("C(5)H(10)N(2)O"));
    public static final ReporterIon DI_METHYL_R_157 = new ReporterIon("metR157", AtomChain.getAtomChain("C(7)H(16)N(4)"));
    public static final ReporterIon QQ = new ReporterIon("QQ", AtomChain.getAtomChain("C(10)H(16)N(4)O(4)"));
    public static final ReporterIon QQ_H2O = new ReporterIon("QQ-H2O", AtomChain.getAtomChain("C(10)H(14)N(4)O(3)"));
    public static final ReporterIon QQT = new ReporterIon("QQT", AtomChain.getAtomChain("C(14)H(24)N(5)O(6)"));
    public static final ReporterIon QQT_H2O = new ReporterIon("QQT-H2O", AtomChain.getAtomChain("C(14)H(22)N(5)O(5)"));
    public static final ReporterIon QQTG = new ReporterIon("QQTG", AtomChain.getAtomChain("C(16)H(26)N(6)O(7)"));
    public static final ReporterIon QQTG_H2O = new ReporterIon("QQTG-H2O", AtomChain.getAtomChain("C(16)H(24)N(6)O(6)"));
    public static final ReporterIon QQTGG = new ReporterIon("QQTGG", AtomChain.getAtomChain("C(18)H(29)N(7)O(8)"));
    public static final ReporterIon QQTGG_H2O = new ReporterIon("QQTGG-H2O", AtomChain.getAtomChain("C(18)H(27)N(7)O(7)"));
    private String name;
    private CvTerm cvTerm = null;

    public ReporterIon() {
    }

    public ReporterIon(String name, double mass) {
        this(name, mass, true);
    }

    public ReporterIon(String name, double mass, boolean save) {
        this.type = Ion.IonType.REPORTER_ION;
        this.name = name;
        this.theoreticMass1 = mass;
        if (save) {
            implementedIons.put(name, this);
            sortedImplementedIonsNames = null;
            possibleSubtypes = null;
        }
    }

    public ReporterIon(String name, AtomChain atomChain) {
        this(name, atomChain, true);
    }

    public ReporterIon(String name, AtomChain atomChain, boolean save) {
        this.type = Ion.IonType.REPORTER_ION;
        this.name = name;
        this.atomChain = atomChain;
        if (save) {
            ReporterIon.addReporterIon(this);
        }
    }

    public static void addReporterIon(ReporterIon reporterIon) {
        if (implementedIons == null) {
            implementedIons = new HashMap();
        }
        implementedIons.put(reporterIon.name, reporterIon);
        sortedImplementedIonsNames = null;
        possibleSubtypes = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.cvTerm = null;
    }

    public void setMass(double referenceMass) {
        this.theoreticMass1 = referenceMass;
    }

    @Override
    public CvTerm getPrideCvTerm() {
        if (this.cvTerm != null) {
            return this.cvTerm;
        }
        if (this.name.contains("TMT")) {
            if (this.name.equalsIgnoreCase("TMT_126")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "126");
            } else if (this.name.equalsIgnoreCase("TMT_127N")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "127N");
            } else if (this.name.equalsIgnoreCase("TMT_127C")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "127C");
            } else if (this.name.equalsIgnoreCase("TMT_128N")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "128N");
            } else if (this.name.equalsIgnoreCase("TMT_128C")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "128C");
            } else if (this.name.equalsIgnoreCase("TMT_129N")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "129N");
            } else if (this.name.equalsIgnoreCase("TMT_129C")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "129C");
            } else if (this.name.equalsIgnoreCase("TMT_130N")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "130N");
            } else if (this.name.equalsIgnoreCase("TMT_130C")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "130C");
            } else if (this.name.equalsIgnoreCase("TMT_131")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "131");
            } else if (this.name.equalsIgnoreCase("TMT_131C")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002670", "frag: TMT reporter ion", "131C");
            } else if (this.name.equalsIgnoreCase("TMT_126_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "126");
            } else if (this.name.equalsIgnoreCase("TMT_127N_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "127N");
            } else if (this.name.equalsIgnoreCase("TMT_127C_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "127C");
            } else if (this.name.equalsIgnoreCase("TMT_128N_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "128N");
            } else if (this.name.equalsIgnoreCase("TMT_128C_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "128C");
            } else if (this.name.equalsIgnoreCase("TMT_129N_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "129N");
            } else if (this.name.equalsIgnoreCase("TMT_129C_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "129C");
            } else if (this.name.equalsIgnoreCase("TMT_130N_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "130N");
            } else if (this.name.equalsIgnoreCase("TMT_130C_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "130C");
            } else if (this.name.equalsIgnoreCase("TMT_131_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "131");
            } else if (this.name.equalsIgnoreCase("TMT_131C_ETD")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002671", "frag: TMT ETD reporter ion", "131C");
            }
        } else if (this.name.contains("iTRAQ")) {
            if (this.name.equalsIgnoreCase("iTRAQ4Plex_114")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002668", "frag: iTRAQ 4plex reporter ion", "114");
            } else if (this.name.equalsIgnoreCase("iTRAQ4Plex_115")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002668", "frag: iTRAQ 4plex reporter ion", "115");
            } else if (this.name.equalsIgnoreCase("iTRAQ4Plex_116")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002668", "frag: iTRAQ 4plex reporter ion", "116");
            } else if (this.name.equalsIgnoreCase("iTRAQ4Plex_117")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002668", "frag: iTRAQ 4plex reporter ion", "117");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_113")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "113");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_114")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "114");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_115")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "115");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_116")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "116");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_117")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "117");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_118")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "118");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_119")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "119");
            } else if (this.name.equalsIgnoreCase("iTRAQ8Plex_121")) {
                this.cvTerm = new CvTerm("PSI-MS", "MS:1002669", "frag: iTRAQ 8plex reporter ion", "121");
            }
        }
        return this.cvTerm;
    }

    @Override
    public CvTerm getPsiMsCvTerm() {
        return this.getPrideCvTerm();
    }

    public boolean isSameAs(ReporterIon anotherReporterIon) {
        if (this.atomChain != null && anotherReporterIon.getAtomicComposition() != null) {
            return this.atomChain.isSameCompositionAs(anotherReporterIon.getAtomicComposition());
        }
        return false;
    }

    public int getIndex() {
        return (int)this.getTheoreticMass();
    }

    @Override
    public int getSubType() {
        ArrayList<String> ionList = ReporterIon.getSortedImplementedIons();
        return ionList.indexOf(this.name);
    }

    @Override
    public String getSubTypeAsString() {
        return this.getName();
    }

    public static ReporterIon getReporterIon(int subType) {
        ArrayList<String> ionList = ReporterIon.getSortedImplementedIons();
        String name = ionList.get(subType);
        return ReporterIon.getReporterIon(name);
    }

    public static ReporterIon getReporterIon(String name) {
        return implementedIons.get(name);
    }

    public static Set<String> getImplementedIons() {
        return implementedIons.keySet();
    }

    public static ArrayList<String> getSortedImplementedIons() {
        if (sortedImplementedIonsNames == null) {
            ArrayList<String> tempList = new ArrayList<String>(ReporterIon.getImplementedIons());
            Collections.sort(tempList);
            sortedImplementedIonsNames = tempList;
        }
        return sortedImplementedIonsNames;
    }

    public static int[] getPossibleSubtypes() {
        if (possibleSubtypes == null) {
            int[] temp = new int[implementedIons.size()];
            for (int i = 0; i < implementedIons.size(); ++i) {
                temp[i] = i;
            }
            possibleSubtypes = temp;
        }
        return possibleSubtypes;
    }

    @Override
    public NeutralLoss[] getNeutralLosses() {
        return null;
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        if (anotherIon instanceof ReporterIon) {
            ReporterIon otherIon = (ReporterIon)anotherIon;
            return this.isSameAs(otherIon);
        }
        return false;
    }

    public ReporterIon clone() {
        return new ReporterIon(this.name, this.atomChain.clone(), false);
    }

    private static AtomChain getComposition(String reporterIonName) {
        switch (reporterIonName) {
            case "iTRAQ4Plex_114": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 2);
                return atomChain;
            }
            case "iTRAQ4Plex_115": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iTRAQ4Plex_116": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iTRAQ4Plex_117": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iTRAQ4Plex_118": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iTRAQ8Plex_113": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 6);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 2);
                return atomChain;
            }
            case "iTRAQ8Plex_114": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 2);
                return atomChain;
            }
            case "iTRAQ8Plex_115": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iTRAQ8Plex_116": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iTRAQ8Plex_117": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iTRAQ8Plex_118": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 2);
                return atomChain;
            }
            case "iTRAQ8Plex_119": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 2);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 2);
                return atomChain;
            }
            case "iTRAQ8Plex_121": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 6);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 12);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 2);
                return atomChain;
            }
            case "iTRAQ145": {
                break;
            }
            case "iTRAQ305": {
                break;
            }
            case "TMT_126": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_127N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_127C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_128N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_128C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 6);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_129N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 6);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_129C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_130N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_130C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_131": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_131C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 5);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_126_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_127N_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_127C_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_128N_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_128C_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_129N_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_129C_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_130N_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_130C_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMT_131_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMT_131C_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-126": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-127N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-127C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-128N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 1);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-128C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 6);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-129N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 6);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-129C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-130N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 3);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-130C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-131N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-131C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 5);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-132N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 5);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-132C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 2);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 6);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-133N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 2);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 6);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-133C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-134N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 1);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "TMTpro-134C": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "TMTpro-135N": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iodoTMT_zero": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_126": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_127": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 8);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iodoTMT_128": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 6);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_129": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 6);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iodoTMT_130": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_131": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 4);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iodoTMT_zero_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_126_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_127_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 7);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iodoTMT_128_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_129_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 5);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 2);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
            case "iodoTMT_130_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)0), 1);
                return atomChain;
            }
            case "iodoTMT_131_ETD": {
                AtomChain atomChain = new AtomChain();
                atomChain.append(new AtomImpl(Atom.C, (Integer)0), 3);
                atomChain.append(new AtomImpl(Atom.C, (Integer)1), 4);
                atomChain.append(new AtomImpl(Atom.H, (Integer)0), 15);
                atomChain.append(new AtomImpl(Atom.N, (Integer)1), 1);
                return atomChain;
            }
        }
        throw new UnsupportedOperationException("Atomic composition not implemented for reporter ion " + reporterIonName + ".");
    }
}

