/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.modifications;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.atoms.AtomChain;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.modifications.ModificationCategory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;

public class Modification
extends ExperimentObject {
    static final long serialVersionUID = -545472596243822505L;
    private ModificationType modificationType;
    private String name;
    private String shortName;
    private Double mass = null;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList(0);
    private ArrayList<ReporterIon> reporterIons = new ArrayList(0);
    private AminoAcidPattern pattern = null;
    private AtomChain atomChainAdded = null;
    private AtomChain atomChainRemoved = null;
    private CvTerm unimodCvTerm = null;
    private CvTerm psiModCvTerm = null;
    private String ambiguityKey = null;
    private static final int NUMBER_OF_ROUNDED_DECIMALS = 6;
    private ModificationCategory category = null;

    public Modification() {
    }

    public Modification(ModificationType modificationType, String name, String shortName, AtomChain atomChainAdded, AtomChain atomChainRemoved, AminoAcidPattern aminoAcidPattern, ModificationCategory category) {
        this.modificationType = modificationType;
        this.name = name;
        this.shortName = shortName;
        this.atomChainAdded = atomChainAdded;
        this.atomChainRemoved = atomChainRemoved;
        this.pattern = aminoAcidPattern;
        this.unimodCvTerm = null;
        this.psiModCvTerm = null;
        this.category = category;
    }

    public Modification(ModificationType modificationType, String name, String shortName, AtomChain atomChainAdded, AtomChain atomChainRemoved, AminoAcidPattern aminoAcidPattern, CvTerm unimodCvTerm, CvTerm psiModCvTerm, ModificationCategory category) {
        this.modificationType = modificationType;
        this.name = name;
        this.shortName = shortName;
        this.atomChainAdded = atomChainAdded;
        this.atomChainRemoved = atomChainRemoved;
        this.pattern = aminoAcidPattern;
        this.unimodCvTerm = unimodCvTerm;
        this.psiModCvTerm = psiModCvTerm;
        this.category = category;
    }

    public Modification(ModificationType modificationType, String name, Double mass, ArrayList<String> residues, ModificationCategory category) {
        this.modificationType = modificationType;
        this.name = name;
        this.mass = mass;
        if (residues != null) {
            this.pattern = new AminoAcidPattern(residues);
        }
        this.category = category;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public double getMass() {
        if (this.mass == null) {
            this.estimateMass();
        }
        return this.mass;
    }

    private synchronized void estimateMass() {
        if (this.mass == null) {
            Double tempMass = 0.0;
            if (this.atomChainAdded != null) {
                tempMass = tempMass + this.atomChainAdded.getMass();
            }
            if (this.atomChainRemoved != null) {
                tempMass = tempMass - this.atomChainRemoved.getMass();
            }
            this.mass = tempMass;
        }
    }

    public String getAmbiguityKey() {
        if (this.ambiguityKey == null) {
            this.setAmbiguityKey();
        }
        return this.ambiguityKey;
    }

    private void setAmbiguityKey() {
        this.ambiguityKey = Double.toString(this.getMass());
    }

    public double getRoundedMass(int numberOfDecimals) {
        double roundedMass = this.getMass();
        return Util.roundDouble(roundedMass, numberOfDecimals);
    }

    public double getRoundedMass() {
        return this.getRoundedMass(6);
    }

    public AtomChain getAtomChainAdded() {
        return this.atomChainAdded;
    }

    public void setAtomChainAdded(AtomChain atomChainAdded) {
        this.atomChainAdded = atomChainAdded;
        this.mass = null;
    }

    public AtomChain getAtomChainRemoved() {
        if (this.atomChainRemoved == null) {
            this.atomChainRemoved = new AtomChain();
        }
        return this.atomChainRemoved;
    }

    public void setAtomChainRemoved(AtomChain atomChainRemoved) {
        this.atomChainRemoved = atomChainRemoved;
        this.mass = null;
    }

    public boolean isSameAtomicComposition(Modification anotherModification) {
        if (this.atomChainAdded != null && !this.atomChainAdded.isSameCompositionAs(anotherModification.getAtomChainAdded()) || this.atomChainRemoved != null && !this.atomChainRemoved.isSameCompositionAs(anotherModification.getAtomChainRemoved())) {
            return false;
        }
        return (this.atomChainAdded != null || anotherModification.getAtomChainAdded() == null || anotherModification.getAtomChainAdded().getAtomChain().isEmpty()) && (this.atomChainRemoved != null || anotherModification.getAtomChainRemoved() == null || anotherModification.getAtomChainRemoved().getAtomChain().isEmpty());
    }

    public boolean isSamePattern(Modification anotherModification) {
        if (this.pattern == null && anotherModification.getPattern() != null && anotherModification.getPattern().length() > 0) {
            return false;
        }
        return this.pattern == null || this.pattern.isSameAs(anotherModification.getPattern(), SequenceMatchingParameters.DEFAULT_STRING_MATCHING);
    }

    public boolean isSameAs(Modification anotherModification) {
        if (this.modificationType != anotherModification.getModificationType()) {
            return false;
        }
        if (!this.isSamePattern(anotherModification)) {
            return false;
        }
        if (!this.isSameAtomicComposition(anotherModification)) {
            return false;
        }
        return this.category == anotherModification.getCategory();
    }

    public ArrayList<NeutralLoss> getNeutralLosses() {
        return this.neutralLosses;
    }

    public void setNeutralLosses(ArrayList<NeutralLoss> neutralLosses) {
        this.neutralLosses = neutralLosses;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        this.neutralLosses.add(neutralLoss);
    }

    public ArrayList<ReporterIon> getReporterIons() {
        return this.reporterIons;
    }

    public void setReporterIons(ArrayList<ReporterIon> reporterIons) {
        this.reporterIons = reporterIons;
    }

    public void addReporterIon(ReporterIon reporterIon) {
        this.reporterIons.add(reporterIon);
    }

    public AminoAcidPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(AminoAcidPattern pattern) {
        this.pattern = pattern;
    }

    public boolean isStandardSearch() {
        return this.pattern == null || this.pattern.length() == 0 || this.pattern.length() == 1;
    }

    public String getHtmlTooltip() {
        if (this.modificationType == null) {
            return null;
        }
        String tooltip = "<html>";
        tooltip = tooltip + "Name: " + this.name + "<br>";
        tooltip = tooltip + "Category: " + (Object)((Object)this.category) + "<br>";
        tooltip = tooltip + "Mass: " + this.getRoundedMass(4) + "<br>";
        tooltip = tooltip + "Type: ";
        switch (this.modificationType) {
            case modaa: {
                tooltip = tooltip + "Particular amino acid(s)";
                break;
            }
            case modn_protein: 
            case modnaa_protein: {
                tooltip = tooltip + "Protein N terminus";
                break;
            }
            case modc_protein: 
            case modcaa_protein: {
                tooltip = tooltip + "Protein C terminus";
                break;
            }
            case modn_peptide: 
            case modnaa_peptide: {
                tooltip = tooltip + "Peptide N terminus";
                break;
            }
            case modc_peptide: 
            case modcaa_peptide: {
                tooltip = tooltip + "Peptide C terminus";
                break;
            }
        }
        tooltip = tooltip + "<br>";
        if (this.pattern != null && !this.pattern.getAminoAcidsAtTarget().isEmpty()) {
            tooltip = tooltip + "Target: ";
            String patternAsString = this.pattern.toString();
            tooltip = tooltip + patternAsString;
        }
        tooltip = tooltip + "</html>";
        return tooltip;
    }

    public CvTerm getUnimodCvTerm() {
        return this.unimodCvTerm;
    }

    public void setUnimodCvTerm(CvTerm cvTerm) {
        this.unimodCvTerm = cvTerm;
    }

    public CvTerm getPsiModCvTerm() {
        return this.psiModCvTerm;
    }

    public void setPsiModCvTerm(CvTerm cvTerm) {
        this.psiModCvTerm = cvTerm;
    }

    public ModificationCategory getCategory() {
        return this.category;
    }

    public void setCategory(ModificationCategory category) {
        this.category = category;
    }

    public String toString() {
        double ptmMass;
        String target = "";
        switch (this.modificationType) {
            case modaa: {
                target = this.getPattern().toString();
                break;
            }
            case modc_protein: {
                target = "Protein C-terminus";
                break;
            }
            case modcaa_protein: {
                target = "Protein C-terminus ending with " + this.getPattern().toString();
                break;
            }
            case modc_peptide: {
                target = "Peptide C-terminus";
                break;
            }
            case modcaa_peptide: {
                target = "Peptide C-terminus ending with " + this.getPattern().toString();
                break;
            }
            case modn_protein: {
                target = "Protein N-terminus";
                break;
            }
            case modnaa_protein: {
                target = "Protein N-terminus starting with " + this.getPattern().toString();
                break;
            }
            case modn_peptide: {
                target = "Peptide N-terminus";
                break;
            }
            case modnaa_peptide: {
                target = "Peptide N-terminus starting with " + this.getPattern().toString();
            }
        }
        StringBuilder description = new StringBuilder();
        description.append(this.name);
        if (this.shortName != null && !this.shortName.equals("")) {
            description.append("(").append(this.shortName).append(")");
        }
        description.append("\t").append((Object)this.category).append("\t");
        if (this.atomChainAdded != null) {
            description.append("+{").append(this.atomChainAdded).append("}");
        }
        if (this.atomChainRemoved != null) {
            description.append("-{").append(this.atomChainRemoved).append("}");
        }
        String sign = (ptmMass = this.getRoundedMass()) > 0.0 ? "+" : "-";
        description.append(" (").append(sign).append(ptmMass).append(")");
        description.append(" targeting ").append(target);
        return description.toString();
    }
}

