/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.taxonomy.mappings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class EnsemblSpecies {
    public static final String SEPARATOR = "\t";
    private final HashMap<String, String> latinNameToCommonNameMap = new HashMap();
    private final HashMap<String, String> latinNameToDivisionMap = new HashMap();
    private final HashMap<String, String> latinNameToAssemblyMap = new HashMap();
    private final HashMap<String, String> latinNameToTaxonMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapping(File speciesFile) throws IOException {
        try (FileReader r = new FileReader(speciesFile);
             BufferedReader br = new BufferedReader(r);){
            br.readLine();
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    line = line.substring(1, line.length() - 1);
                    String[] elements = line.split(SEPARATOR);
                    String commonName = elements[1].trim();
                    String scientificName = elements[2].trim();
                    String division = elements[3].trim();
                    String taxon = elements[4].trim();
                    String assembly = elements[5].trim();
                    this.latinNameToCommonNameMap.put(scientificName, commonName);
                    this.latinNameToDivisionMap.put(scientificName, division);
                    this.latinNameToAssemblyMap.put(scientificName, assembly);
                    this.latinNameToTaxonMap.put(scientificName, taxon);
                }
                line = br.readLine();
            }
        }
    }

    public String getCommonName(String latinName) {
        return this.latinNameToCommonNameMap.get(latinName);
    }

    public EnsemblDivision getDivision(String latinName) {
        String ensemblDivisionName = this.latinNameToDivisionMap.get(latinName);
        if (ensemblDivisionName == null) {
            return null;
        }
        return EnsemblDivision.getEnsemblDivisionFromName(ensemblDivisionName);
    }

    public String getAssembly(String latinName) {
        return this.latinNameToAssemblyMap.get(latinName);
    }

    public String getTaxon(String latinName) {
        return this.latinNameToTaxonMap.get(latinName);
    }

    public HashSet<String> getLatinNames() {
        return new HashSet<String>(this.latinNameToAssemblyMap.keySet());
    }

    public static enum EnsemblDivision {
        vertebrates("EnsemblVertebrates", "vertebrates"),
        bacteria("EnsemblBacteria", "bacteria"),
        fungi("EnsemblFungi", "fungi"),
        metazoa("EnsemblMetazoa", "metazoa"),
        plants("EnsemblPlants", "plants"),
        protists("EnsemblProtists", "protists");

        public final String ensemblName;
        public final String ensemblType;

        private EnsemblDivision(String ensemblName, String ensemblType) {
            this.ensemblName = ensemblName;
            this.ensemblType = ensemblType;
        }

        public static EnsemblDivision getEnsemblDivisionFromName(String ensemblName) {
            for (EnsemblDivision ensemblDivision : EnsemblDivision.values()) {
                if (!ensemblDivision.ensemblName.equals(ensemblName)) continue;
                return ensemblDivision;
            }
            return null;
        }
    }
}

