/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.amino_acid_tags;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.identification.amino_acid_tags.MassGap;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.mass_spectrometry.utils.StandardMasses;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;

public class Tag
extends ExperimentObject {
    static final long serialVersionUID = 1625541843008045218L;
    private ArrayList<TagComponent> content = new ArrayList(1);

    public Tag() {
    }

    public Tag(Tag tag) {
        for (TagComponent tagComponent : tag.getContent()) {
            if (tagComponent instanceof MassGap) {
                MassGap massGap = (MassGap)tagComponent;
                this.addMassGap(massGap.getMass());
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = new AminoAcidSequence((AminoAcidSequence)tagComponent);
                this.addAminoAcidSequence(aminoAcidSequence);
                continue;
            }
            throw new UnsupportedOperationException("Tag constructor not implemeted for tag component " + tagComponent.getClass() + ".");
        }
    }

    public Tag(double nTermGap, AminoAcidSequence sequenceTag, double cTermGap) {
        this.addMassGap(nTermGap);
        this.addAminoAcidSequence(sequenceTag);
        this.addMassGap(cTermGap);
    }

    public ArrayList<TagComponent> getContent() {
        return this.content;
    }

    public void setContent(ArrayList<TagComponent> content) {
        this.content = content;
    }

    public void addMassGap(double massGap) {
        if (massGap != 0.0) {
            this.content.add(new MassGap(massGap));
        }
    }

    public void addAminoAcidSequence(AminoAcidSequence aminoAcidSequence) {
        if (aminoAcidSequence.length() > 0) {
            TagComponent lastComponent;
            if (!this.content.isEmpty() && (lastComponent = this.content.get(this.content.size() - 1)) instanceof AminoAcidSequence) {
                AminoAcidSequence sequence = (AminoAcidSequence)lastComponent;
                sequence.appendCTerm(aminoAcidSequence);
                return;
            }
            this.content.add(aminoAcidSequence);
        }
    }

    public String asSequence() {
        return this.content.stream().map(TagComponent::asSequence).collect(Collectors.joining());
    }

    public String getLongestAminoAcidSequence() {
        String result = "";
        AminoAcidSequence lastAminoAcidSequence = null;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof MassGap) {
                if (lastAminoAcidSequence != null && lastAminoAcidSequence.length() > result.length()) {
                    result = lastAminoAcidSequence.asSequence();
                }
                lastAminoAcidSequence = null;
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence currentSequence = (AminoAcidSequence)tagComponent;
                if (lastAminoAcidSequence == null) continue;
                lastAminoAcidSequence.appendCTerm(currentSequence);
                continue;
            }
            throw new UnsupportedOperationException("Longest amino acid sequence not implemented for tag component " + tagComponent.getClass() + ".");
        }
        if (lastAminoAcidSequence != null && lastAminoAcidSequence.length() > result.length()) {
            result = lastAminoAcidSequence.asSequence();
        }
        return result;
    }

    public double getMass() {
        return StandardMasses.h2o.mass + this.content.stream().mapToDouble(tagComponent -> tagComponent.getMass()).sum();
    }

    public double getMass(boolean includeCTermGap, boolean includeNTermGap) {
        double mass = this.getMass();
        if (!includeCTermGap) {
            mass -= this.getCTerminalGap();
        }
        if (!includeNTermGap) {
            mass -= this.getNTerminalGap();
        }
        return mass;
    }

    public double getNTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(0);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public double getCTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(this.content.size() - 1);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public String getTaggedModifiedSequence(ModificationParameters modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean includeTerminalGaps, SequenceMatchingParameters modificationsSequenceMatchingParameters, HashSet<String> displayedModifications) {
        return Tag.getTaggedModifiedSequence(modificationProfile, this, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, includeTerminalGaps, modificationsSequenceMatchingParameters, displayedModifications);
    }

    public static String getTaggedModifiedSequence(ModificationParameters modificationParameters, Tag tag, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean includeTerminalGaps, SequenceMatchingParameters modificationsSequenceMatchingParameters, HashSet<String> displayedModifications) {
        StringBuilder modifiedSequence = new StringBuilder();
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence.append("<html>");
        }
        modifiedSequence.append(tag.getNTerminal(includeTerminalGaps, modificationParameters, modificationsSequenceMatchingParameters)).append('-');
        for (int i = 0; i < tag.getContent().size(); ++i) {
            TagComponent tagComponent = tag.getContent().get(i);
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                String[] variableModifications = aminoAcidSequence.getIndexedVariableModifications();
                for (int j = 0; j < variableModifications.length; ++j) {
                    String tempMod = variableModifications[j];
                    if (tempMod == null || displayedModifications.contains(tempMod)) continue;
                    variableModifications[j] = null;
                }
                String[] fixedModifications = aminoAcidSequence.getFixedModifications(i == 0, i == tag.getContent().size() - 1, modificationParameters, modificationsSequenceMatchingParameters);
                for (int j = 0; j < fixedModifications.length; ++j) {
                    String tempMod = fixedModifications[j];
                    if (tempMod == null || displayedModifications.contains(tempMod)) continue;
                    fixedModifications[j] = null;
                }
                modifiedSequence.append(ModificationUtils.getTaggedModifiedSequence(modificationParameters, aminoAcidSequence.getSequence(), variableModifications, null, null, fixedModifications, useHtmlColorCoding, useShortName));
                continue;
            }
            if (tagComponent instanceof MassGap) {
                if (!includeTerminalGaps && (i <= 0 || i >= tag.getContent().size() - 1)) continue;
                modifiedSequence.append(tagComponent.asSequence());
                continue;
            }
            throw new UnsupportedOperationException("Tagged sequence not implemented for tag component " + tagComponent.getClass() + ".");
        }
        modifiedSequence.append('-').append(tag.getCTerminal(includeTerminalGaps, modificationParameters, modificationsSequenceMatchingParameters));
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence.append("</html>");
        }
        return modifiedSequence.toString();
    }

    public String getNTerminal(boolean includeTerminalGaps, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent firstComponent = this.content.get(0);
        if (firstComponent instanceof MassGap) {
            return includeTerminalGaps ? firstComponent.asSequence() : Double.toString(Util.roundDouble(firstComponent.getMass(), 2));
        }
        if (firstComponent instanceof AminoAcidSequence) {
            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)firstComponent;
            String nTermMod = aminoAcidSequence.getFixedModifications(true, false, modificationParameters, modificationsSequenceMatchingParameters)[0];
            if (nTermMod != null) {
                return Util.replaceAll(nTermMod, '-', ' ');
            }
            nTermMod = aminoAcidSequence.getIndexedVariableModifications()[0];
            if (nTermMod != null) {
                return Util.replaceAll(nTermMod, '-', ' ');
            }
            return "NH2";
        }
        throw new UnsupportedOperationException("N-terminal tag not implemented for tag component " + firstComponent.getClass() + ".");
    }

    public String getCTerminal(boolean includeTerminalGaps, ModificationParameters modificationParameters, SequenceMatchingParameters modificationsSequenceMatchingParameters) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent lastComponent = this.content.get(this.content.size() - 1);
        if (lastComponent instanceof MassGap) {
            return includeTerminalGaps ? lastComponent.asSequence() : Double.toString(Util.roundDouble(lastComponent.getMass(), 2));
        }
        if (lastComponent instanceof AminoAcidSequence) {
            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)lastComponent;
            String cTermMod = aminoAcidSequence.getFixedModifications(true, false, modificationParameters, modificationsSequenceMatchingParameters)[aminoAcidSequence.length() + 1];
            if (cTermMod != null) {
                return Util.replaceAll(cTermMod, '-', ' ');
            }
            cTermMod = aminoAcidSequence.getIndexedVariableModifications()[aminoAcidSequence.length() + 1];
            if (cTermMod != null) {
                return Util.replaceAll(cTermMod, '-', ' ');
            }
            return "COOH";
        }
        throw new UnsupportedOperationException("C-terminal tag not implemented for tag component " + lastComponent.getClass() + ".");
    }

    public int getLengthInAminoAcid() {
        int length = 0;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                length += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                ++length;
                continue;
            }
            throw new UnsupportedOperationException("Tag length in amino acid not implemented for tag component " + tagComponent.getClass() + ".");
        }
        return length;
    }

    public ArrayList<Integer> getPotentialModificationSites(Modification modification, SequenceMatchingParameters modificationSequenceMatchingPreferences) {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        AminoAcidPattern modificationPattern = modification.getPattern();
        int patternLength = modificationPattern.length();
        switch (modification.getModificationType()) {
            case modaa: {
                int offset = 0;
                for (TagComponent tagComponent : this.content) {
                    if (tagComponent instanceof AminoAcidSequence) {
                        AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                        for (int i : modificationPattern.getIndexes(aminoAcidSequence.getSequence(), modificationSequenceMatchingPreferences)) {
                            possibleSites.add(i + offset);
                        }
                        offset += aminoAcidSequence.length();
                        continue;
                    }
                    ++offset;
                }
                return possibleSites;
            }
            case modc_protein: 
            case modc_peptide: {
                possibleSites.add(patternLength);
                return possibleSites;
            }
            case modn_peptide: 
            case modn_protein: {
                possibleSites.add(1);
                return possibleSites;
            }
            case modcaa_peptide: 
            case modcaa_protein: {
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>(0);
                }
                TagComponent component = this.content.get(this.content.size() - 1);
                if (component instanceof AminoAcidSequence) {
                    AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)component;
                    if (modificationPattern.isEnding(aminoAcidSequence.getSequence(), modificationSequenceMatchingPreferences)) {
                        possibleSites.add(patternLength);
                    }
                } else if (component instanceof MassGap) {
                    possibleSites.add(patternLength);
                } else {
                    throw new UnsupportedOperationException("Possible modifications not implemnted for tag component " + component.getClass() + ".");
                }
                return possibleSites;
            }
            case modnaa_peptide: 
            case modnaa_protein: {
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>(0);
                }
                TagComponent component = this.content.get(0);
                if (component instanceof AminoAcidSequence) {
                    AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)component;
                    if (modificationPattern.isStarting(aminoAcidSequence.getSequence(), modificationSequenceMatchingPreferences)) {
                        possibleSites.add(patternLength);
                    }
                } else if (component instanceof MassGap) {
                    possibleSites.add(patternLength);
                } else {
                    throw new UnsupportedOperationException("Possible modifications not implemnted for tag component " + component.getClass() + ".");
                }
                return possibleSites;
            }
        }
        throw new IllegalArgumentException("Modification type " + (Object)((Object)modification.getModificationType()) + " not recognized.");
    }

    public boolean isSameAs(Tag anotherTag, SequenceMatchingParameters sequenceMatchingPreferences) {
        if (this.content.size() != anotherTag.getContent().size()) {
            return false;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            TagComponent component2;
            TagComponent component1 = this.content.get(i);
            if (component1.isSameAs(component2 = anotherTag.getContent().get(i), sequenceMatchingPreferences)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSequenceAndModificationStatusAs(Tag anotherTag, SequenceMatchingParameters sequenceMatchingPreferences) {
        if (this.content.size() != anotherTag.getContent().size()) {
            return false;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            TagComponent component2;
            TagComponent component1 = this.content.get(i);
            if (component1.isSameSequenceAndModificationStatusAs(component2 = anotherTag.getContent().get(i), sequenceMatchingPreferences)) continue;
            return false;
        }
        return true;
    }

    public static String getTagModificationsAsString(Tag tag) {
        HashMap modMap = new HashMap();
        int offset = 0;
        for (TagComponent tagComponent : tag.getContent()) {
            if (tagComponent instanceof MassGap) {
                ++offset;
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                ModificationMatch[] variableModifications;
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                for (ModificationMatch modificationMatch : variableModifications = aminoAcidSequence.getVariableModifications()) {
                    if (!modMap.containsKey(modificationMatch.getModification())) {
                        modMap.put(modificationMatch.getModification(), new ArrayList(1));
                    }
                    ((ArrayList)modMap.get(modificationMatch.getModification())).add(modificationMatch.getSite() + offset);
                }
                offset += aminoAcidSequence.length();
                continue;
            }
            throw new UnsupportedOperationException("Modification summary not implemented for TagComponent " + tagComponent.getClass() + ".");
        }
        return modMap.entrySet().stream().map(entry -> Tag.getModificationLine((String)entry.getKey(), (ArrayList)entry.getValue())).collect(Collectors.joining(","));
    }

    private static String getModificationLine(String modName, ArrayList<Integer> sites) {
        String sitesString = sites.stream().map(site -> site.toString()).collect(Collectors.joining(","));
        StringBuilder modLine = new StringBuilder(modName.length() + sitesString.length() + 2);
        modLine.append(modName).append("(").append(sitesString).append(")");
        return modLine.toString();
    }

    public Tag reverse(boolean yIon) {
        Tag newTag = new Tag();
        for (int i = this.content.size() - 1; i >= 0; --i) {
            TagComponent tagComponent = this.content.get(i);
            if (tagComponent instanceof MassGap) {
                double mass = tagComponent.getMass();
                if (i == this.content.size() - 1) {
                    mass = yIon ? (mass += StandardMasses.h2o.mass) : (mass -= StandardMasses.h2o.mass);
                } else if (i == 0) {
                    mass = yIon ? (mass -= StandardMasses.h2o.mass) : (mass += StandardMasses.h2o.mass);
                }
                newTag.addMassGap(mass);
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                newTag.addAminoAcidSequence(((AminoAcidSequence)tagComponent).reverse());
                continue;
            }
            throw new UnsupportedOperationException("Reverse method not implemented for tag component " + tagComponent.getClass() + ".");
        }
        return newTag;
    }

    public boolean canReverse() {
        MassGap terminalGap;
        TagComponent terminalComponent = this.content.get(0);
        return terminalComponent instanceof MassGap && (terminalGap = (MassGap)terminalComponent).getMass() >= StandardMasses.h2o.mass && (terminalComponent = this.content.get(this.content.size() - 1)) instanceof MassGap && (terminalGap = (MassGap)terminalComponent).getMass() >= StandardMasses.h2o.mass;
    }

    public String toString() {
        return this.asSequence();
    }
}

