/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering.items;

import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import java.util.ArrayList;
import java.util.Arrays;

public enum AssumptionFilterItem implements FilterItem
{
    minimalLength("Minimal length", "Minimal sequence length."),
    maximalLength("Maximal length", "Maximal sequence length."),
    precrusorMz("Precursor m/z", "Spectrum precursor m/z."),
    precrusorRT("Precursor RT", "Spectrum precursor retention time."),
    precrusorCharge("Precursor charge", "Spectrum precursor charge according to the identification."),
    precrusorMzErrorDa("Precursor m/z error (Da)", "Spectrum precursor m/z error in Dalton."),
    precrusorMzErrorPpm("Precursor m/z error (ppm)", "Spectrum precursor m/z error in ppm."),
    precrusorMzErrorStat("Precursor m/z error (%p)", "Probability in percent of getting the spectrum precursor m/z error in the spectrum file."),
    ptm("PTM", "Post-translational modification carried by the match."),
    sequenceCoverage("Sequence coverage", "Coverage of the sequence by fragment ions in percent."),
    algorithmScore("Algorithm score", "Score given by the identification algorithm."),
    confidence("Confidence", "Confidence in protein identification."),
    validationStatus("Validation", "Validation status."),
    stared("Stared", "Marked with a yellow star.");

    public final String name;
    public final String description;

    private AssumptionFilterItem(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static AssumptionFilterItem getItem(String itemName) {
        for (AssumptionFilterItem filterItem : AssumptionFilterItem.values()) {
            if (!filterItem.name.equals(itemName)) continue;
            return filterItem;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FilterItem[] getPossibleValues() {
        AssumptionFilterItem[] values = AssumptionFilterItem.values();
        FilterItem[] result = new FilterItem[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    @Override
    public boolean isNumber() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<String> getPossibilities() {
        switch (this.ordinal()) {
            case 12: {
                return new ArrayList<String>(Arrays.asList(MatchValidationLevel.getValidationLevelsNames()));
            }
            case 13: {
                ArrayList<String> starred = new ArrayList<String>(2);
                starred.add("Starred");
                starred.add("Not Starred");
                return starred;
            }
        }
        return null;
    }

    @Override
    public boolean needsModifications() {
        switch (this.ordinal()) {
            case 8: {
                return true;
            }
        }
        return false;
    }

    private AssumptionFilterItem() {
        this.name = "";
        this.description = "";
    }
}

