/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.filtering.items;

import com.compomics.util.experiment.filtering.FilterItem;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import java.util.ArrayList;
import java.util.Arrays;

public enum ProteinFilterItem implements FilterItem
{
    proteinAccession("Protein Accession", "Accession of the protein according to the sequence database."),
    proteinDescription("Protein Description", "Description of the protein according to the sequence database."),
    sequence("Potein Sequence", "Amino acid pattern which should be contained in the protein sequence."),
    chromosome("Chromosome", "Chromosome number."),
    gene("Gene", "Gene name."),
    GO("GO Term", "Gene Ontology term"),
    expectedCoverage("Expected Coverage", "Protein sequence coverage expected."),
    validatedCoverage("Validated Coverage", "Protein sequence coverage achieved using validated peptides."),
    confidentCoverage("Confident Coverage", "Protein sequence coverage achieved using confident peptides."),
    spectrumCounting("Spectrum Counting", "Spectrum counting quantification value."),
    modification("modification", "Modification carried by the protein."),
    nPeptides("#Peptides", "Number of peptides."),
    nValidatedPeptides("#Validated Peptides", "Number of validated peptides."),
    nConfidentPeptides("#Confident Peptides", "Number of confident peptides."),
    nPSMs("#PSMs", "Number of PSMs."),
    nValidatedPSMs("#Validated PSMs", "Number of Validated PSMs."),
    nConfidentPSMs("#Confident PSMs", "Number of Confident PSMs."),
    confidence("Confidence", "Confidence in protein identification."),
    proteinInference("PI", "Protein inference status."),
    validationStatus("Validation", "Validation status."),
    stared("Stared", "Marked with a yellow star.");

    public final String name;
    public final String description;

    private ProteinFilterItem() {
        this.name = "";
        this.description = "";
    }

    private ProteinFilterItem(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static ProteinFilterItem getItem(String itemName) {
        for (ProteinFilterItem filterItem : ProteinFilterItem.values()) {
            if (!filterItem.name.equals(itemName)) continue;
            return filterItem;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FilterItem[] getPossibleValues() {
        ProteinFilterItem[] values = ProteinFilterItem.values();
        FilterItem[] result = new FilterItem[values.length];
        System.arraycopy(values, 0, result, 0, values.length);
        return result;
    }

    @Override
    public boolean isNumber() {
        switch (this.ordinal()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    @Override
    public ArrayList<String> getPossibilities() {
        switch (this.ordinal()) {
            case 18: {
                ArrayList<String> pi = new ArrayList<String>(4);
                pi.add(PSParameter.getProteinInferenceClassAsString(0));
                pi.add(PSParameter.getProteinInferenceClassAsString(1));
                pi.add(PSParameter.getProteinInferenceClassAsString(2));
                pi.add(PSParameter.getProteinInferenceClassAsString(3));
                return pi;
            }
            case 19: {
                return new ArrayList<String>(Arrays.asList(MatchValidationLevel.getValidationLevelsNames()));
            }
            case 20: {
                ArrayList<String> starred = new ArrayList<String>(2);
                starred.add("Starred");
                starred.add("Not Starred");
                return starred;
            }
        }
        return null;
    }

    @Override
    public boolean needsModifications() {
        switch (this.ordinal()) {
            case 10: {
                return true;
            }
        }
        return false;
    }
}

