/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.modification.scores;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.ions.Ion;
import com.compomics.util.experiment.biology.ions.IonFactory;
import com.compomics.util.experiment.biology.ions.NeutralLoss;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.mass_spectrometry.spectra.SpectrumUtil;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.statistics.distributions.BinomialDistribution;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math.util.FastMath;

public class PhosphoRS {
    public static final double WINDOW_SIZE = 100.0;
    public static final int MAX_DEPTH = 8;
    public static final int MIN_DEPTH = 2;
    private static final int DISTRIBUTION_CACHE_SIZE = 1000;
    private static final HashMap<Double, HashMap<Integer, BinomialDistribution>> DISTRIBUTION_CACHE = new HashMap();

    public static HashMap<Integer, Double> getSequenceProbabilities(Peptide peptide, ArrayList<Modification> modifications, ModificationParameters modificationParameters, Spectrum spectrum, SequenceProvider sequenceProvider, AnnotationParameters annotationParameters, SpecificAnnotationParameters specificAnnotationSettings, boolean accountNeutralLosses, SequenceMatchingParameters sequenceMatchingParameters, SequenceMatchingParameters modificationSequenceMatchingParameters, PeptideSpectrumAnnotator spectrumAnnotator, ModificationProvider modificationProvider) {
        ModificationMatch[] modificationMatches;
        int nModification;
        if (modifications.isEmpty()) {
            throw new IllegalArgumentException("No modification given for PhosphoRS calculation.");
        }
        if (spectrumAnnotator == null) {
            spectrumAnnotator = new PeptideSpectrumAnnotator();
        }
        if ((nModification = (int)Arrays.stream(modificationMatches = peptide.getVariableModifications()).filter(modificationMatch -> modifications.stream().anyMatch(modification -> modification.getName().equals(modificationMatch.getModification()))).count()) == 0) {
            throw new IllegalArgumentException("Given modifications not found in the peptide for PhosphoRS calculation.");
        }
        double modificationMass = modifications.get(0).getMass();
        NeutralLossesMap annotationNeutralLosses = specificAnnotationSettings.getNeutralLossesMap();
        NeutralLossesMap scoringLossesMap = new NeutralLossesMap();
        if (accountNeutralLosses) {
            for (String neutralLossName : annotationNeutralLosses.getAccountedNeutralLosses()) {
                NeutralLoss neutralLoss = NeutralLoss.getNeutralLoss(neutralLossName);
                if (!(Math.abs(neutralLoss.getMass() - modificationMass) > specificAnnotationSettings.getFragmentIonAccuracyInDa(spectrum.getMaxMz()))) continue;
                scoringLossesMap.addNeutralLoss(neutralLoss, 1, 1);
            }
        }
        SpecificAnnotationParameters scoringAnnotationParameters = specificAnnotationSettings.clone();
        scoringAnnotationParameters.setNeutralLossesMap(scoringLossesMap);
        HashMap<Ion.IonType, HashSet<Integer>> ions = specificAnnotationSettings.getIonTypes();
        HashMap<Ion.IonType, HashSet<Integer>> newIons = new HashMap<Ion.IonType, HashSet<Integer>>(1);
        for (Ion.IonType ionType : ions.keySet()) {
            if (ionType != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
            newIons.put(ionType, ions.get((Object)ionType));
        }
        scoringAnnotationParameters.setSelectedIonsMap(newIons);
        int[] possibleSites = modifications.stream().flatMapToInt(modification -> Arrays.stream(ModificationUtils.getPossibleModificationSites(peptide, modification, sequenceProvider, modificationSequenceMatchingParameters, modificationProvider, true))).distinct().sorted().toArray();
        HashMap<Integer, Double> profileToScoreMap = new HashMap<Integer, Double>(possibleSites.length);
        HashMap<Integer, int[]> profileToSitesMap = new HashMap<Integer, int[]>(possibleSites.length);
        if (possibleSites.length > nModification) {
            int i2;
            Object intensityThresholds;
            Spectrum filteredSpectrum = PhosphoRS.filterSpectrum(spectrum, scoringAnnotationParameters);
            HashSet modNames = modifications.stream().map(modification -> modification.getName()).collect(Collectors.toCollection(HashSet::new));
            IonFactory fragmentFactory = IonFactory.getInstance();
            HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons = fragmentFactory.getFragmentIons(peptide, scoringAnnotationParameters, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            IonMatch[] ionMatches = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, scoringAnnotationParameters, "PhosphoRS", "Peptide", spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, possibleFragmentIons, false);
            ArrayList<int[]> possibleProfiles = PhosphoRS.getPossibleModificationProfiles(possibleSites, nModification);
            int[] possibleProfileKeys = new int[possibleProfiles.size()];
            for (int i3 = 0; i3 < possibleProfiles.size(); ++i3) {
                int profileKey;
                int[] profile = possibleProfiles.get(i3);
                possibleProfileKeys[i3] = profileKey = Arrays.hashCode(profile);
                profileToSitesMap.put(profileKey, profile);
            }
            HashMap<Integer, Peptide> profileToPeptide = PhosphoRS.getPossiblePeptidesMap(peptide, modNames, possibleProfileKeys, possibleProfiles);
            HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> profileToPossibleFragments = PhosphoRS.getPossiblePeptideFragments(profileToPeptide, scoringAnnotationParameters, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            HashMap<Integer, IonMatch[]> profileMatchedPeptideFragments = PhosphoRS.getMatchedFragments(spectrumAnnotator, profileToPeptide, filteredSpectrum, profileToPossibleFragments, annotationParameters, scoringAnnotationParameters, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            HashMap<Integer, Integer> profileToN = PhosphoRS.getPossiblePeptideToN(profileToPeptide, profileToPossibleFragments, spectrumAnnotator, scoringAnnotationParameters, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            HashMap<Double, ArrayList<Integer>> siteDeterminingIonsMap = PhosphoRS.getSiteDeterminingIons(profileToPeptide, spectrumAnnotator, scoringAnnotationParameters, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            ArrayList<Double> siteDeterminingIons = new ArrayList<Double>(siteDeterminingIonsMap.keySet());
            double minMz = filteredSpectrum.getMinMz();
            double maxMz = filteredSpectrum.getMaxMz();
            ArrayList<int[]> reducedSpectrumIndexes = new ArrayList<int[]>();
            int reducedSpectrumLength = 0;
            double d = specificAnnotationSettings.getFragmentIonAccuracy();
            double dOverW = d / 100.0;
            dOverW = -FastMath.log10((double)dOverW);
            int nDecimals = (int)dOverW + 1;
            double halfWindow = 50.0;
            while (minMz < maxMz) {
                int windowStartIndex;
                int[] windowIndexes;
                int windowEndIndex;
                double tempMax = minMz + 100.0;
                if (specificAnnotationSettings.isFragmentIonPpm()) {
                    double refMz = minMz + halfWindow;
                    d = specificAnnotationSettings.getFragmentIonAccuracyInDa(refMz);
                    dOverW = d / 100.0;
                    dOverW = -FastMath.log10((double)dOverW);
                    nDecimals = (int)dOverW + 1;
                }
                if ((windowEndIndex = (windowIndexes = SpectrumUtil.getWindowIndexes(filteredSpectrum, minMz, tempMax))[1]) - (windowStartIndex = windowIndexes[0]) > 0) {
                    int bestI;
                    intensityThresholds = PhosphoRS.getIntensityThresholds(filteredSpectrum, windowStartIndex, windowEndIndex);
                    HashMap<Integer, HashSet<Double>> profileToSiteDeterminingIonsMz = new HashMap<Integer, HashSet<Double>>(siteDeterminingIons.size());
                    for (Map.Entry<Double, ArrayList<Integer>> entry : siteDeterminingIonsMap.entrySet()) {
                        double ionMz = entry.getKey();
                        if (!(ionMz > minMz) || !(ionMz <= tempMax)) continue;
                        ArrayList<Integer> profiles = entry.getValue();
                        for (int profileKey : profiles) {
                            HashSet<Double> mzs = (HashSet<Double>)profileToSiteDeterminingIonsMz.get(profileKey);
                            if (mzs == null) {
                                mzs = new HashSet<Double>(1);
                                profileToSiteDeterminingIonsMz.put(profileKey, mzs);
                            }
                            mzs.add(ionMz);
                        }
                    }
                    if (!profileToSiteDeterminingIonsMz.isEmpty()) {
                        ArrayList deltas = new ArrayList(((ArrayList)intensityThresholds).size());
                        int nDeltas = 0;
                        for (int depth = 1; depth <= ((ArrayList)intensityThresholds).size(); ++depth) {
                            double intensityThreshold = (Double)((ArrayList)intensityThresholds).get(depth - 1);
                            int nPeaks = SpectrumUtil.getNPeaksAboveThreshold(filteredSpectrum, windowStartIndex, windowEndIndex, intensityThreshold);
                            TreeSet<Double> bigPs = new TreeSet<Double>();
                            ArrayList<Double> currentDeltas = new ArrayList<Double>(possibleProfileKeys.length);
                            ArrayList<HashSet> scored = new ArrayList<HashSet>(possibleProfileKeys.length);
                            boolean profileWithNoSiteDeterminingIonsScored = false;
                            double currentP = PhosphoRS.getp(nPeaks, 100.0, d, nDecimals);
                            for (int profileKey : possibleProfileKeys) {
                                HashSet tempSiteDeterminingIons = (HashSet)profileToSiteDeterminingIonsMz.get(profileKey);
                                if (tempSiteDeterminingIons == null) {
                                    if (profileWithNoSiteDeterminingIonsScored) continue;
                                    profileWithNoSiteDeterminingIonsScored = true;
                                    IonMatch[] profileFragments = profileMatchedPeptideFragments.get(profileKey);
                                    int k = 0;
                                    for (IonMatch ionMatch : profileFragments) {
                                        if (!(ionMatch.peakMz >= minMz) || !(ionMatch.peakMz < maxMz) || !(ionMatch.peakIntensity >= intensityThreshold)) continue;
                                        ++k;
                                    }
                                    double bigP = PhosphoRS.getPhosphoRsScoreP(k, currentP, nPeaks);
                                    BasicMathFunctions.checkProbabilityRange(bigP);
                                    bigPs.add(bigP);
                                    continue;
                                }
                                boolean alreadyScored = false;
                                for (HashSet scoredIons : scored) {
                                    if (!tempSiteDeterminingIons.equals(scoredIons)) continue;
                                    alreadyScored = true;
                                    break;
                                }
                                if (alreadyScored) continue;
                                IonMatch[] profileFragments = profileMatchedPeptideFragments.get(profileKey);
                                int k = 0;
                                for (IonMatch ionMatch : profileFragments) {
                                    if (!(ionMatch.peakMz >= minMz) || !(ionMatch.peakMz < maxMz) || !(ionMatch.peakIntensity >= intensityThreshold)) continue;
                                    ++k;
                                }
                                double bigP = PhosphoRS.getPhosphoRsScoreP(k, currentP, nPeaks);
                                BasicMathFunctions.checkProbabilityRange(bigP);
                                bigPs.add(bigP);
                                scored.add(tempSiteDeterminingIons);
                            }
                            double[] bigPArray = bigPs.stream().mapToDouble(a -> a).toArray();
                            for (int j = 0; j < bigPArray.length - 1; ++j) {
                                double pJ = bigPArray[j];
                                double pJPlusOne = bigPArray[j + 1];
                                double delta = pJ / pJPlusOne;
                                currentDeltas.add(delta);
                            }
                            if (currentDeltas.size() > nDeltas) {
                                nDeltas = currentDeltas.size();
                            }
                            deltas.add(currentDeltas);
                        }
                        bestI = 0;
                        double largestDelta = 0.0;
                        for (int j = 0; j < nDeltas && largestDelta == 0.0; ++j) {
                            for (int i4 = 0; i4 < deltas.size(); ++i4) {
                                ArrayList tempDeltas = (ArrayList)deltas.get(i4);
                                if (j >= tempDeltas.size() || !((Double)tempDeltas.get(j) > largestDelta)) continue;
                                largestDelta = (Double)tempDeltas.get(j);
                                bestI = i4;
                            }
                        }
                        if (bestI < 1 && 1 < ((ArrayList)intensityThresholds).size()) {
                            bestI = 1;
                        }
                        if (bestI > 7) {
                            bestI = 7;
                        }
                        double bestIntensityThreshold = (Double)((ArrayList)intensityThresholds).get(bestI);
                        int[] windowBestPeaks = IntStream.range(windowStartIndex, windowEndIndex).filter(i -> filteredSpectrum.intensity[i] >= bestIntensityThreshold).toArray();
                        reducedSpectrumIndexes.add(windowBestPeaks);
                        reducedSpectrumLength += windowBestPeaks.length;
                    } else {
                        double bestP = 0.0;
                        bestI = 0;
                        for (int depth = 1; depth <= ((ArrayList)intensityThresholds).size(); ++depth) {
                            double intensityThreshold = (Double)((ArrayList)intensityThresholds).get(depth - 1);
                            int nPeaks = SpectrumUtil.getNPeaksAboveThreshold(filteredSpectrum, windowStartIndex, windowEndIndex, intensityThreshold);
                            double currentP = PhosphoRS.getp(nPeaks, 100.0, d, nDecimals);
                            int k = 0;
                            for (IonMatch ionMatch : ionMatches) {
                                if (!(ionMatch.peakMz >= minMz) || !(ionMatch.peakMz < maxMz) || !(ionMatch.peakIntensity >= intensityThreshold)) continue;
                                ++k;
                            }
                            double bigP = PhosphoRS.getPhosphoRsScoreP(k, currentP, nPeaks);
                            BasicMathFunctions.checkProbabilityRange(bigP);
                            if (!(bigP < bestP)) continue;
                            bestP = bigP;
                            bestI = depth - 1;
                        }
                        double bestIntensityThreshold = (Double)((ArrayList)intensityThresholds).get(bestI);
                        int[] windowBestPeaks = IntStream.range(windowStartIndex, windowEndIndex).filter(i -> filteredSpectrum.intensity[i] >= bestIntensityThreshold).toArray();
                        reducedSpectrumIndexes.add(windowBestPeaks);
                        reducedSpectrumLength += windowBestPeaks.length;
                    }
                }
                minMz = tempMax;
            }
            double[] reducedSpectrumMz = new double[reducedSpectrumLength];
            double[] reducedSpectrumIntensity = new double[reducedSpectrumLength];
            int count = 0;
            intensityThresholds = reducedSpectrumIndexes.iterator();
            while (intensityThresholds.hasNext()) {
                int[] indexes;
                for (int index : indexes = (int[])intensityThresholds.next()) {
                    reducedSpectrumMz[count] = filteredSpectrum.mz[index];
                    reducedSpectrumIntensity[count] = filteredSpectrum.intensity[index];
                    ++count;
                }
            }
            Spectrum phosphoRsSpectrum = new Spectrum(spectrum.getPrecursor(), reducedSpectrumMz, reducedSpectrumIntensity, spectrum.getSpectrumLevel());
            double w = filteredSpectrum.getMaxMz() - filteredSpectrum.getMinMz();
            if (specificAnnotationSettings.isFragmentIonPpm()) {
                double refMz = filteredSpectrum.getMinMz() + w / 2.0;
                d = specificAnnotationSettings.getFragmentIonAccuracyInDa(refMz);
            }
            dOverW = d / w;
            dOverW = -FastMath.log10((double)dOverW);
            nDecimals = (int)dOverW + 1;
            double currentP = PhosphoRS.getp(phosphoRsSpectrum.getNPeaks(), w, d, nDecimals);
            double[] pInvs = new double[possibleProfileKeys.length];
            double pInvTotal = 0.0;
            for (i2 = 0; i2 < possibleProfileKeys.length; ++i2) {
                double pInv;
                int profileKey = possibleProfileKeys[i2];
                Peptide tempPeptide = profileToPeptide.get(profileKey);
                Integer n = profileToN.get(profileKey);
                HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> profilePossibleFragmentIons = profileToPossibleFragments.get(profileKey);
                IonMatch[] profilePhosphoRsMatches = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, scoringAnnotationParameters, "phosphoRsSpectrum", "profile", phosphoRsSpectrum, tempPeptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, profilePossibleFragmentIons, false);
                double bigP = PhosphoRS.getPhosphoRsScoreP(profilePhosphoRsMatches.length, currentP, n);
                BasicMathFunctions.checkProbabilityRange(bigP);
                pInvs[i2] = pInv = 1.0 / bigP;
                pInvTotal += pInv;
            }
            if (pInvTotal <= 0.0) {
                throw new IllegalArgumentException("PhosphoRS probability <= 0.");
            }
            for (i2 = 0; i2 < possibleProfileKeys.length; ++i2) {
                int profileKey = possibleProfileKeys[i2];
                double pInv = pInvs[i2];
                double phosphoRsProbability = pInv / pInvTotal;
                BasicMathFunctions.checkProbabilityRange(phosphoRsProbability);
                profileToScoreMap.put(profileKey, phosphoRsProbability *= 100.0);
            }
        } else if (possibleSites.length == nModification) {
            int profileKey = Arrays.hashCode(possibleSites);
            profileToScoreMap.put(profileKey, 100.0);
            profileToSitesMap.put(profileKey, possibleSites);
        } else {
            throw new IllegalArgumentException("Found less potential modification sites than modifications during PhosphoRS calculation. Peptide key: " + peptide.getKey());
        }
        HashMap<Integer, Double> scores = new HashMap<Integer, Double>(possibleSites.length);
        Iterator iterator = profileToScoreMap.keySet().iterator();
        while (iterator.hasNext()) {
            int[] sites;
            int profileKey = (Integer)iterator.next();
            double score = (Double)profileToScoreMap.get(profileKey);
            for (int site : sites = (int[])profileToSitesMap.get(profileKey)) {
                Double previousScore = scores.get(site);
                if (previousScore == null) {
                    scores.put(site, score);
                    continue;
                }
                double newScore = score + previousScore;
                scores.put(site, newScore);
            }
        }
        for (Object site : (Iterator)possibleSites) {
            if (scores.keySet().contains((int)site)) continue;
            throw new IllegalArgumentException("Site " + (int)site + " not scored for modification " + modificationMass + " in peptide " + peptide.toString() + ".");
        }
        return scores;
    }

    private static double getPhosphoRsScoreP(int k, double p, int n) {
        if (k == 0) {
            return 1.0;
        }
        BinomialDistribution distribution = null;
        HashMap<Integer, BinomialDistribution> distributionsAtP = DISTRIBUTION_CACHE.get(p);
        boolean inCache = true;
        if (distributionsAtP != null) {
            distribution = distributionsAtP.get(n);
        }
        if (distribution == null) {
            distribution = new BinomialDistribution(n, p);
            inCache = false;
        }
        double result = distribution.getDescendingCumulativeProbabilityAt(k);
        if (!inCache && !distribution.isCacheEmpty()) {
            PhosphoRS.addDistributionToCache(p, n, distribution);
        }
        return result;
    }

    private static synchronized void addDistributionToCache(double p, int n, BinomialDistribution binomialDistribution) {
        HashMap<Integer, BinomialDistribution> distributionsAtP;
        if (DISTRIBUTION_CACHE.size() >= 1000) {
            HashSet<Double> keys = new HashSet<Double>(DISTRIBUTION_CACHE.keySet());
            for (Double key : keys) {
                DISTRIBUTION_CACHE.remove(key);
                if (DISTRIBUTION_CACHE.size() >= 1000) continue;
                break;
            }
        }
        if ((distributionsAtP = DISTRIBUTION_CACHE.get(p)) == null) {
            distributionsAtP = new HashMap(2);
            DISTRIBUTION_CACHE.put(p, distributionsAtP);
        }
        distributionsAtP.put(n, binomialDistribution);
    }

    private static double getp(int n, double w, double d, int nDecimals) {
        if (w == 0.0) {
            return 1.0;
        }
        if (n <= 1) {
            return 1.0;
        }
        double p = d * (double)n / w;
        if (p > 1.0) {
            p = 1.0;
        }
        return Util.floorDouble(p, nDecimals);
    }

    private static HashMap<Integer, Peptide> getPossiblePeptidesMap(Peptide peptide, HashSet<String> modNames, int[] profileKeys, ArrayList<int[]> possibleProfiles) {
        String representativeModification = (String)modNames.stream().findAny().get();
        HashMap<Integer, Peptide> result = new HashMap<Integer, Peptide>(possibleProfiles.size());
        for (int i = 0; i < profileKeys.length; ++i) {
            int profileKey = profileKeys[i];
            int[] profile = possibleProfiles.get(i);
            Peptide tempPeptide = peptide.getNoModPeptide(modNames);
            for (int pos : profile) {
                tempPeptide.addVariableModification(new ModificationMatch(representativeModification, pos));
            }
            result.put(profileKey, tempPeptide);
        }
        return result;
    }

    private static HashMap<Integer, Integer> getPossiblePeptideToN(HashMap<Integer, Peptide> possiblePeptides, HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> possiblePeptideFragments, PeptideSpectrumAnnotator spectrumAnnotator, SpecificAnnotationParameters scoringAnnotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>(possiblePeptides.size());
        for (Map.Entry<Integer, Peptide> entry : possiblePeptides.entrySet()) {
            Peptide peptide = entry.getValue();
            HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> fragmentsForProfile = possiblePeptideFragments.get(entry.getKey());
            HashMap<Integer, ArrayList<Ion>> expectedFragmentIons = spectrumAnnotator.getExpectedIons(scoringAnnotationParameters, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, fragmentsForProfile);
            int n = expectedFragmentIons.values().stream().mapToInt(ArrayList::size).sum();
            result.put(entry.getKey(), n);
        }
        return result;
    }

    private static HashMap<Integer, IonMatch[]> getMatchedFragments(PeptideSpectrumAnnotator spectrumAnnotator, HashMap<Integer, Peptide> possiblePeptides, Spectrum spectrum, HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> possiblePeptideFragments, AnnotationParameters annotationParameters, SpecificAnnotationParameters scoringAnnotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        HashMap<Integer, IonMatch[]> result = new HashMap<Integer, IonMatch[]>(possiblePeptides.size());
        for (Map.Entry<Integer, Peptide> peptideEntry : possiblePeptides.entrySet()) {
            int key = peptideEntry.getKey();
            Peptide peptide = peptideEntry.getValue();
            IonMatch[] ionMatches = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, scoringAnnotationParameters, "PhosphoRS", Integer.toString(key), spectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters, possiblePeptideFragments.get(key), false);
            result.put(key, ionMatches);
        }
        return result;
    }

    private static HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> getPossiblePeptideFragments(HashMap<Integer, Peptide> possiblePeptides, SpecificAnnotationParameters scoringAnnotationSetttings, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>> result = new HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Ion>>>>(possiblePeptides.size());
        IonFactory fragmentFactory = IonFactory.getInstance();
        for (Map.Entry<Integer, Peptide> entry : possiblePeptides.entrySet()) {
            HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> possibleFragmentIons = fragmentFactory.getFragmentIons(entry.getValue(), scoringAnnotationSetttings, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            result.put(entry.getKey(), possibleFragmentIons);
        }
        return result;
    }

    private static ArrayList<int[]> getPossibleModificationProfiles(int[] possibleSites, int nPtms) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (int pos : possibleSites) {
            int[] profile = new int[]{pos};
            result.add(profile);
        }
        for (int i = 2; i <= nPtms; ++i) {
            ArrayList<int[]> resultAtI = new ArrayList<int[]>(result.size());
            for (int[] previousProfile : result) {
                int lastPos = previousProfile[previousProfile.length - 1];
                for (int pos : possibleSites) {
                    if (pos <= lastPos) continue;
                    int[] profile = Arrays.copyOf(previousProfile, previousProfile.length + 1);
                    profile[previousProfile.length] = pos;
                    resultAtI.add(profile);
                }
            }
            result = resultAtI;
        }
        return result;
    }

    private static HashMap<Double, ArrayList<Integer>> getSiteDeterminingIons(HashMap<Integer, Peptide> profileToPeptide, PeptideSpectrumAnnotator spectrumAnnotator, SpecificAnnotationParameters scoringAnnotationParameters, ModificationParameters modificationParameters, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationSequenceMatchingParameters) {
        HashMap<Double, ArrayList<Integer>> siteDeterminingIons = new HashMap<Double, ArrayList<Integer>>();
        HashMap commonIons = new HashMap();
        for (Map.Entry<Integer, Peptide> entry : profileToPeptide.entrySet()) {
            double mz;
            int profileKey = entry.getKey();
            Peptide peptide = entry.getValue();
            HashSet mzs = spectrumAnnotator.getExpectedIons(scoringAnnotationParameters, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters).values().stream().flatMap(Collection::stream).filter(ion -> ion.getType() == Ion.IonType.PEPTIDE_FRAGMENT_ION).flatMap(ion -> scoringAnnotationParameters.getSelectedCharges().stream().map(charge -> ion.getTheoreticMz((Integer)charge))).collect(Collectors.toCollection(HashSet::new));
            Iterator<Object> iterator = mzs.iterator();
            while (iterator.hasNext()) {
                ArrayList<Object> profiles;
                mz = (Double)iterator.next();
                if (commonIons.isEmpty()) {
                    profiles = new ArrayList(2);
                    commonIons.put(mz, profiles);
                    profiles.add(profileKey);
                    continue;
                }
                if (commonIons.containsKey(mz)) continue;
                profiles = siteDeterminingIons.get(mz);
                if (profiles == null) {
                    profiles = new ArrayList(2);
                    siteDeterminingIons.put(mz, profiles);
                }
                profiles.add(profileKey);
            }
            iterator = new HashSet(commonIons.keySet()).iterator();
            while (iterator.hasNext()) {
                mz = (Double)iterator.next();
                if (!mzs.contains(mz)) {
                    siteDeterminingIons.put(mz, (ArrayList)commonIons.get(mz));
                    commonIons.remove(mz);
                    continue;
                }
                ((ArrayList)commonIons.get(mz)).add(profileKey);
            }
        }
        return siteDeterminingIons;
    }

    private static ArrayList<Double> getIntensityThresholds(Spectrum spectrum, int iMin, int iMax) {
        TreeSet<Double> intensities = new TreeSet<Double>();
        for (int i = iMin; i < iMax; ++i) {
            double intensity = spectrum.intensity[i];
            intensities.add(intensity);
        }
        ArrayList<Double> thresholds = new ArrayList<Double>(8);
        int depth = 1;
        Iterator iterator = intensities.descendingSet().iterator();
        while (iterator.hasNext()) {
            double intensity = (Double)iterator.next();
            thresholds.add(intensity);
            if (depth == 8) break;
            ++depth;
        }
        return thresholds;
    }

    private static Spectrum filterSpectrum(Spectrum spectrum, SpecificAnnotationParameters scoringAnnotationSetttings) {
        int maxPeaks;
        double window;
        double ms2Tolerance = scoringAnnotationSetttings.getFragmentIonAccuracyInDa(spectrum.getMaxMz());
        if (ms2Tolerance <= 10.0) {
            window = 10.0 * ms2Tolerance;
            maxPeaks = 10;
        } else {
            window = 100.0;
            maxPeaks = (int)(window / ms2Tolerance);
        }
        if (maxPeaks < 1) {
            throw new IllegalArgumentException("All peaks removed by filtering.");
        }
        HashSet<Integer> toRemove = new HashSet<Integer>(4);
        int refIndex = 0;
        double refMz = spectrum.mz[0];
        for (int i = 0; i < spectrum.getNPeaks(); ++i) {
            double mz = spectrum.mz[i];
            if (!(mz > refMz + window)) continue;
            if (i - refIndex > maxPeaks) {
                TreeMap<Double, Integer> intensityMap = new TreeMap<Double, Integer>();
                for (int j = refIndex; j < i; ++j) {
                    intensityMap.put(spectrum.intensity[j], j);
                }
                int count = 0;
                Iterator iterator = intensityMap.descendingMap().values().iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    if (++count <= maxPeaks) continue;
                    toRemove.add(index);
                }
            }
            refIndex = i;
            refMz += window;
        }
        if (spectrum.getNPeaks() - refIndex > maxPeaks) {
            TreeMap<Double, Integer> intensityMap = new TreeMap<Double, Integer>();
            for (int j = refIndex; j < spectrum.getNPeaks(); ++j) {
                intensityMap.put(spectrum.intensity[j], j);
            }
            int count = 0;
            Iterator iterator = intensityMap.descendingMap().values().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                if (++count <= maxPeaks) continue;
                toRemove.add(index);
            }
        }
        if (toRemove.isEmpty()) {
            return spectrum;
        }
        double[] filteredMz = new double[spectrum.getNPeaks() - toRemove.size()];
        double[] filteredIntensities = new double[spectrum.getNPeaks() - toRemove.size()];
        int count = 0;
        for (int i = 0; i < spectrum.getNPeaks(); ++i) {
            if (toRemove.contains(i)) continue;
            filteredMz[count] = spectrum.mz[i];
            filteredIntensities[count] = spectrum.intensity[i];
            ++count;
        }
        return new Spectrum(spectrum.precursor, filteredMz, filteredIntensities, spectrum.getSpectrumLevel());
    }
}

